<?php

namespace ContentEgg\application\modules\Bolcom;

defined('\ABSPATH') || exit;

use ContentEgg\application\components\AffiliateParserModuleConfig;
use ContentEgg\application\Plugin;

/**
 * BolcomConfig class file
 *
 * @author keywordrush.com <support@keywordrush.com>
 * @link https://www.keywordrush.com
 * @copyright Copyright &copy; 2025 keywordrush.com
 */
class BolcomConfig extends AffiliateParserModuleConfig
{

    public function options()
    {
        $options = array(
            'client_id' => array(
                'title' => 'Client ID <span class="cegg_required">*</span>',
                'description' => sprintf(
                    __('To get your Client ID, visit your Bol.com affiliate account settings <a target="_blank" href="%s">here</a>. For step-by-step instructions, see <a target="_blank" href="%s">this guide</a>.', 'content-egg'),
                    'https://partner.bol.com/account/affiliate/myAccount',
                    'https://ce-docs.keywordrush.com/modules/affiliate/bolcom'
                ),
                'callback' => array($this, 'render_password'),
                'default' => '',
                'validator' => array(
                    'trim',
                    array(
                        'call' => array('\ContentEgg\application\helpers\FormValidator', 'required'),
                        'when' => 'is_active',
                        'message' => sprintf(__('The field "%s" can not be empty.', 'content-egg'), 'Client ID'),
                    ),
                ),
            ),
            'client_secret' => array(
                'title' => 'Client Secret <span class="cegg_required">*</span>',
                'description' => sprintf(
                    __('To get your Client Secret, visit your Bol.com affiliate account settings <a target="_blank" href="%s">here</a>. For step-by-step instructions, see <a target="_blank" href="%s">this guide</a>.', 'content-egg'),
                    'https://partner.bol.com/account/affiliate/myAccount',
                    'https://ce-docs.keywordrush.com/modules/affiliate/bolcom'
                ),
                'callback' => array($this, 'render_password'),
                'default' => '',
                'validator' => array(
                    'trim',
                    array(
                        'call' => array('\ContentEgg\application\helpers\FormValidator', 'required'),
                        'when' => 'is_active',
                        'message' => sprintf(__('The field "%s" can not be empty.', 'content-egg'), 'Client secret'),
                    ),
                ),
            ),
            'SiteId' => array(
                'title' => 'Website Code' . ' <span class="cegg_required">*</span>',
                'description' => sprintf(
                    __('To get your Website Code, visit your Bol.com affiliate account settings <a target="_blank" href="%s">here</a>. For step-by-step instructions, see <a target="_blank" href="%s">this guide</a>.', 'content-egg'),
                    'https://partner.bol.com/account/affiliate/myAccount',
                    'https://ce-docs.keywordrush.com/modules/affiliate/bolcom'
                ),
                'callback' => array($this, 'render_input'),
                'default' => '',
                'validator' => array(
                    'trim',
                    array(
                        'call' => array('\ContentEgg\application\helpers\FormValidator', 'required'),
                        'when' => 'is_active',
                        'message' => sprintf(__('The field "%s" can not be empty.', 'content-egg'), 'Website code'),
                    ),
                ),
            ),
            'entries_per_page' => array(
                'title' => __('Results', 'content-egg'),
                'description' => __('Specify the number of results to display for a single search query.', 'content-egg'),
                'callback' => array($this, 'render_input'),
                'default' => 8,
                'validator' => array(
                    'trim',
                    'absint',
                    array(
                        'call' => array('\ContentEgg\application\helpers\FormValidator', 'less_than_equal_to'),
                        'arg' => 50,
                        'message' => sprintf(__('The field "%s" can not be more than %d.', 'content-egg'), 'Results', 50),
                    ),
                ),
            ),
            'entries_per_page_update' => array(
                'title' => __('Results for updates', 'content-egg'),
                'description' => __('Specify the number of results for automatic updates and autoblogging.', 'content-egg'),
                'callback' => array($this, 'render_input'),
                'default' => 6,
                'validator' => array(
                    'trim',
                    'absint',
                    array(
                        'call' => array('\ContentEgg\application\helpers\FormValidator', 'less_than_equal_to'),
                        'arg' => 50,
                        'message' => sprintf(__('The field "%s" can not be more than %d.', 'content-egg'), 'Results for updates', 50),
                    ),
                ),
            ),
            'subId' => array(
                'title' => 'Sub ID' . ' **',
                'description' => __('SubID is used to track sales separately. You can use the following placeholders: {{post_id}}, {{author_id}}, {{author_login}}, {{item_unique_id}}.', 'content-egg'),
                'callback' => array($this, 'render_input'),
                'default' => '',
                'validator' => array(
                    'trim',
                ),
            ),

            'country' => array(
                'title' => __('Country', 'content-egg') . '**',
                'description' => __('Signifies whether the shopping context is Dutch or Belgium. This can influence search ranking, and whether some products and offers are returned.', 'content-egg'),
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    'NL' => __('Dutch (NL)', 'content-egg'),
                    'BE' => __('Belgium (BE)', 'content-egg'),
                ),
                'default' => 'NL',
            ),
            'language' => array(
                'title' => __('Language', 'content-egg') . '**',
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    'nl' => 'nl',
                    'fr' => 'fr',
                    'nl-NL' => 'nl-NL',
                    'nl-BE' => 'nl-BE',
                    'fr-BE' => 'fr-BE',
                ),
                'default' => 'nl',
            ),
            'ids' => array(
                'title' => __('Category', 'content-egg'),
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    '' => __('All', 'content-egg'),
                    '8299.' => 'Boeken',
                    '3132.' => 'Muziek',
                    '3133.' => 'Films & Series',
                    '3135.' => 'Games',
                    '7934.' => 'Speelgoed',
                    '11271.' => 'Baby',
                    '16947.' => 'Baby- & Kinderkleding',
                    '12382.' => 'Mooi & Gezond',
                    '11764.' => 'Koken, Tafelen en Huishouden',
                    '3136.' => 'Elektronica',
                    '16737.' => 'Sieraden',
                    '12748.' => 'Dieren',
                    '16784.' => 'Horloges & Accessoires',
                    '13155.' => 'Klussen',
                    '16799.' => 'Tassen & Lederwaren',
                    '3134.' => 'Computer',
                    '25897.' => 'Kantoor & School',
                    '14647.' => 'Sport & Vrije tijd',
                    '12974.' => 'Tuin',
                    '14035.' => 'Wonen',
                    '26147.' => 'Modeaccessoires',
                    '20639.' => 'Cadeaubonnen',
                ),
                'default' => '',
            ),
            'sort' => array(
                'title' => __('Sort', 'content-egg'),
                'description' => __('The way the products are sorted', 'content-egg'),
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    'RELEVANCE' => __('Relevance', 'content-egg'),
                    'POPULARITY' => __('Popularity', 'content-egg'),
                    'PRICE_ASC' => __('Price ascending', 'content-egg'),
                    'PRICE_DESC' => __('Price descending', 'content-egg'),
                    'RELEASE_DATE' => __('Realise date', 'content-egg'),
                    'RATING' => __('Rating', 'content-egg'),
                ),
                'default' => 'RELEVANCE',
            ),
            'gallery' => array(
                'title' => __('Gallery images', 'content-egg'),
                'description' => __('Enable to add gallery images. This requires additional API requests, so activate only if necessary.', 'content-egg'),
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    'disabled' => __('Disabled', 'content-egg'),
                    'enabled' => __('Enabled', 'content-egg'),
                ),
                'default' => 'disabled',
            ),
            'category' => array(
                'title' => __('Product category', 'content-egg'),
                'description' => __('Enable to add product categories. This requires additional API requests, so activate only if necessary.', 'content-egg'),
                'callback' => array($this, 'render_dropdown'),
                'dropdown_options' => array(
                    'disabled' => __('Disabled', 'content-egg'),
                    'enabled' => __('Enabled', 'content-egg'),
                ),
                'default' => 'disabled',
            ),
            'description_size' => array(
                'title' => __('Trim description', 'content-egg'),
                'description' => __('Set the maximum number of characters for the product description. Use 0 to disable truncation.', 'content-egg'),
                'callback' => array($this, 'render_input'),
                'default' => '0',
                'validator' => array(
                    'trim',
                    'absint',
                ),
                'section' => 'default',
            ),
            'save_img' => array(
                'title' => __('Save images', 'content-egg'),
                'description' => __('Save images on server', 'content-egg'),
                'callback' => array($this, 'render_checkbox'),
                'default' => false,
                'section' => 'default',
            ),
        );

        $parent = parent::options();
        $parent['update_mode']['validator'][] = array(
            'call' => array($this, 'deleteToken'),
        );
        $options = array_merge($parent, $options);

        return self::moveRequiredUp($options);
    }

    public function deleteToken()
    {
        $id = 'Bolcom';
        $transient_name = Plugin::slug() . '-' . $id . '-access_token';
        \delete_transient($transient_name);
        return true;
    }
}
