<?php /** @noinspection PhpMissingReturnTypeInspection */
/** @noinspection SpellCheckingInspection */

/*
 * Plugin Name: Presto Player Pro Activator
 * Plugin URI:
 * Description: Activates Presto Player Pro license.
 * Version: 1.0
 * Author: Navas
 * Author URI: https://babia.to/members/tomi500.20887/
*/


//***************************************
// PRESTO PLAYER PRO
//***************************************

namespace PrestoPlayerProActivator;

function ppp_interceptor( $preempt, $parsed_args, $url ) {
	if ( ! str_contains( $url, 'my.prestomade.com/index.php' ) ) {
		return $preempt;
	}

	$query_string = parse_url( $url, PHP_URL_QUERY );
	if ( empty( $query_string ) ) {
		return $preempt;
	}

	parse_str( $query_string, $query_params );
	$action = isset( $query_params['woo_sl_action'] ) ? sanitize_text_field( $query_params['woo_sl_action'] ) : '';

	$response_body = null;

	switch ( $action ) {
		case 'activate':
			$response_body = handle_activate_action( $query_params );
			break;
		case 'deactivate':
			$response_body = handle_deactivate_action();
			break;
		case 'plugin_update':
			$response_body = handle_plugin_update_action( $query_params );
			break;
		default:
			return $preempt;
	}

	return build_http_response( $response_body );
}

function handle_activate_action( $query_params ) {
	$host        = wp_parse_url( site_url(), PHP_URL_HOST );
	$licence_key = $query_params['licence_key'] ?? '';
	$status      = $licence_key ? 'success' : 'error';
	$status_code = $licence_key ? 's101' : 'e002';
	$message     = $licence_key
		? 'Licence Key Successfully Activated for ' . $host
		: 'Invalid licence key';

	$payload = array(
		'status'      => $status,
		'status_code' => $status_code,
		'message'     => $message,
	);

	if ( $licence_key ) {
		$payload['licence_status'] = 'active';
	}

	return array( $payload );
}

function handle_deactivate_action() {
	return array(
		array(
			'status'      => 'success',
			'status_code' => 's201',
			'message'     => 'Licence Key Successfully Unassigned',
		)
	);
}

function handle_plugin_update_action( $query_params ) {
	$version = $query_params['version'] ?? '';

	return (object) array(
		'name'     => 'Presto Player Pro',
		'slug'     => 'presto-player-pro',
		'version'  => $version,
		'sections' => array(
			'description' => 'Mocked: always up to date.',
		),
	);
}

function build_http_response( $body ) {
	return array(
		'headers'       => array(),
		'body'          => wp_json_encode( $body ),
		'response'      => array( 'code' => 200, 'message' => 'OK' ),
		'cookies'       => array(),
		'filename'      => null,
		'http_response' => array( 'data' => null, 'headers' => null, 'status' => null ),
	);
}

add_filter( 'pre_http_request', 'PrestoPlayerProActivator\ppp_interceptor', 10, 3 );