/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// ./assets/js/src/admin/config.js
var $ = jQuery;
var changePriceSymbol = function changePriceSymbol(symbolField, value) {
  if ('percentage' === value) {
    symbolField.html(yith_ywdpd_admin.percent_symbol);
  } else {
    symbolField.html(yith_ywdpd_admin.currency_symbol);
  }
};
;// ./assets/js/src/admin/dashboard/index.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var YWDPD_Dashboard = /*#__PURE__*/function () {
  function YWDPD_Dashboard(elementDOM) {
    _classCallCheck(this, YWDPD_Dashboard);
    this.elementDOM = elementDOM;
    this.elementDOM.find('a.page-title-action').on('click', this.openPopup.bind(this));
    this.elementDOM.find('.ywdpd_add_new_dynamic_rule').on('click', this.openPopup.bind(this));
    this.elementDOM.find('.wp-list-table tr td.enable .ywdpd-toggle-enabled input').on('change', this.handleStatusToggle.bind(this));
    this.elementDOM.find('.wp-list-table tr td .yith-plugin-fw__action-button--move-action').on('click', this.disableDragClick.bind(this));
    this.maybeHighlightRow();
  }
  return _createClass(YWDPD_Dashboard, [{
    key: "__initSortableTable",
    value: function __initSortableTable() {
      this.elementDOM.find('table.wp-list-table').sortable({
        items: 'tbody tr:not(.inline-edit-row)',
        cursor: 'move',
        handle: 'td.column-actions .yith-plugin-fw__action-button--move-action',
        axis: 'y',
        forcePlaceholderSize: true,
        helper: 'clone',
        opacity: 0.65,
        start: function start(event, ui) {
          ui.item.css('background-color', '#f6f6f6');
        },
        stop: function stop(event, ui) {
          ui.item.removeAttr('style');
          var fields_ids = $('.post-type-ywdpd_discount table.wp-list-table tbody tr th.check-column input').get(),
            rule_ids = [];
          $.each(fields_ids, function (i, field) {
            rule_ids.push($(field).val());
          });
          rule_ids = rule_ids.join();
          var data = {
            action: yith_ywdpd_admin.actions.sort_discount_rules,
            security: yith_ywdpd_admin.nonces.sort_discount_rules,
            rule_ids: rule_ids
          };
          $.ajax({
            type: 'POST',
            url: yith_ywdpd_admin.ajax_url,
            data: data,
            dataType: 'json',
            success: function success(response) {}
          });
        }
      });
    }
  }, {
    key: "maybeHighlightRow",
    value: function maybeHighlightRow() {
      var url = window.location.search;
      var urlParams = new URLSearchParams(url);
      if (urlParams.has('orderby') && 'date_modified' === urlParams.get('orderby')) {
        this.elementDOM.find('.wp-list-table tbody tr:first-child').addClass('highlight');
      }
    }
  }, {
    key: "handleStatusToggle",
    value: function handleStatusToggle(event) {
      var $this = $(event.target),
        enabled = $this.val() === 'yes' ? 'yes' : 'no',
        container = $this.closest('.ywdpd-toggle-enabled'),
        discountID = container.data('discount-id');
      $.ajax({
        type: 'POST',
        data: {
          action: yith_ywdpd_admin.actions.enable_or_disable_rule,
          security: yith_ywdpd_admin.nonces.enable_or_disable_rule,
          id: discountID,
          enabled: enabled
        },
        url: yith_ywdpd_admin.ajax_url,
        success: function success(response) {
          if (typeof response.error !== 'undefined') {
            alert(response.error);
          } else {
            $this.parents('tr').find('td.status').html(response.formatted_status);
          }
        }
      });
    }
  }, {
    key: "openPopup",
    value: function openPopup(event) {
      event.preventDefault();
      event.stopPropagation();
      yith.ui.modal({
        width: 830,
        title: false,
        content: $('#ywdpd_rule_manger_popup').html(),
        footer: false,
        scrollContent: false,
        classes: {
          title: 'ywdpd_admin_popup_title',
          content: 'ywdpd_admin_popup_content'
        }
      });
    }
  }, {
    key: "disableDragClick",
    value: function disableDragClick(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
    }
  }]);
}();

;// ./assets/js/src/admin/fields/quantity-range-field.js
function quantity_range_field_typeof(o) { "@babel/helpers - typeof"; return quantity_range_field_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, quantity_range_field_typeof(o); }
function quantity_range_field_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function quantity_range_field_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, quantity_range_field_toPropertyKey(o.key), o); } }
function quantity_range_field_createClass(e, r, t) { return r && quantity_range_field_defineProperties(e.prototype, r), t && quantity_range_field_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function quantity_range_field_toPropertyKey(t) { var i = quantity_range_field_toPrimitive(t, "string"); return "symbol" == quantity_range_field_typeof(i) ? i : i + ""; }
function quantity_range_field_toPrimitive(t, r) { if ("object" != quantity_range_field_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != quantity_range_field_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var QuantityRangeField = /*#__PURE__*/function () {
  function QuantityRangeField(element) {
    quantity_range_field_classCallCheck(this, QuantityRangeField);
    this.elementDOM = element;
    this.addRangeButton = this.elementDOM.find('.ywdpd_new_rule');
    this.addRangeButton.on('click', this.addNewRule.bind(this));
    this._initDiscountTypeSelect();
    this._initDeleteRow();
  }
  return quantity_range_field_createClass(QuantityRangeField, [{
    key: "_initDiscountTypeSelect",
    value: function _initDiscountTypeSelect() {
      this.elementDOM.find('select.ywdpd_discount_type').on('change', this.handleChangeDiscountType.bind(this));
    }
  }, {
    key: "_initDeleteRow",
    value: function _initDeleteRow() {
      this.elementDOM.find('.ywdpd-qty-remove-row a').on('click', this.handleDeleteRow.bind(this));
    }
  }, {
    key: "getTemplate",
    value: function getTemplate() {
      return wp.template('ywdpd-quantity-range-discount-row');
    }
  }, {
    key: "addNewRule",
    value: function addNewRule(event) {
      event.preventDefault();
      var maxIndex = 1,
        rows = this.elementDOM.find('.ywdpd_qty_row'),
        template;
      rows.each(function () {
        var index = $(this).data('index');
        if (index > maxIndex) {
          maxIndex = index;
        }
      });
      template = this.getTemplate();
      var new_row = $(template({
        index: maxIndex + 1
      }));
      new_row.appendTo(this.elementDOM.find('.ywdpd-qty-rows'));
      $(document.body).trigger('wc-enhanced-select-init');
      $(document.body).trigger('yith-framework-enhanced-select-init');
      this._initDiscountTypeSelect();
      this._initDeleteRow();
    }
  }, {
    key: "handleChangeDiscountType",
    value: function handleChangeDiscountType(event) {
      var discountType = event.target.value;
      var symbolField = $(event.target).parents('.ywdpd_qty_row').find('.ywdpd_symbol');
      changePriceSymbol(symbolField, discountType);
    }
  }, {
    key: "handleDeleteRow",
    value: function handleDeleteRow(event) {
      event.preventDefault();
      $(event.target).parents('.ywdpd_qty_row').parent().remove();
    }
  }]);
}();

;// ./assets/js/src/admin/fields/schedule-discount.js
function schedule_discount_typeof(o) { "@babel/helpers - typeof"; return schedule_discount_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, schedule_discount_typeof(o); }
function schedule_discount_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function schedule_discount_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, schedule_discount_toPropertyKey(o.key), o); } }
function schedule_discount_createClass(e, r, t) { return r && schedule_discount_defineProperties(e.prototype, r), t && schedule_discount_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function schedule_discount_toPropertyKey(t) { var i = schedule_discount_toPrimitive(t, "string"); return "symbol" == schedule_discount_typeof(i) ? i : i + ""; }
function schedule_discount_toPrimitive(t, r) { if ("object" != schedule_discount_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != schedule_discount_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var ScheduleDiscount = /*#__PURE__*/function () {
  function ScheduleDiscount(element) {
    schedule_discount_classCallCheck(this, ScheduleDiscount);
    this.elementDOM = element;
    this.elementDOM.find('select.ywdpd_schedule_mode').on('change', this.handleChangeScheduleMode.bind(this)).trigger('change');
    this.initDatePicker();
  }
  return schedule_discount_createClass(ScheduleDiscount, [{
    key: "handleChangeScheduleMode",
    value: function handleChangeScheduleMode(event) {
      var value = event.target.value;
      var datesContainer = this.elementDOM.find('.ywdpd-schedule-discount-dates');
      if (value === 'no_schedule') {
        datesContainer.hide();
      } else {
        datesContainer.css({
          display: 'flex'
        });
      }
    }
  }, {
    key: "initDatePicker",
    value: function initDatePicker() {
      var fromField = this.elementDOM.find('.ywdpd_schedule_from input');
      var toField = this.elementDOM.find('.ywdpd_schedule_to input');
      fromField.datetimepicker({
        timeFormat: 'HH:mm',
        minDate: new Date(),
        dateFormat: 'yy-mm-dd',
        controlType: 'select',
        onSelect: function onSelect() {
          toField.datetimepicker('option', 'minDate', $(this).datetimepicker('getDate'));
        },
        beforeShow: function beforeShow(input, instance) {
          instance.dpDiv.addClass(['yith-plugin-fw-datepicker-div', 'ywdpd-date-time-picker-div']);
        },
        onClose: function onClose(selectedDate, instance) {
          instance.dpDiv.removeClass(['yith-plugin-fw-datepicker-div', 'ywdpd-date-time-picker-div']);
        }
      });
      toField.datetimepicker({
        timeFormat: 'HH:mm',
        minDate: new Date(),
        controlType: 'select',
        dateFormat: 'yy-mm-dd',
        onSelect: function onSelect() {
          fromField.datetimepicker('option', 'maxDate', $(this).datetimepicker('getDate'));
        },
        beforeShow: function beforeShow(input, instance) {
          instance.dpDiv.addClass(['yith-plugin-fw-datepicker-div', 'ywdpd-date-time-picker-div']);
        },
        onClose: function onClose(selectedDate, instance) {
          instance.dpDiv.removeClass(['yith-plugin-fw-datepicker-div', 'ywdpd-date-time-picker-div']);
        }
      });
    }
  }]);
}();

;// ./assets/js/src/admin/fields/quantity-fixed-field.js
function quantity_fixed_field_typeof(o) { "@babel/helpers - typeof"; return quantity_fixed_field_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, quantity_fixed_field_typeof(o); }
function quantity_fixed_field_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function quantity_fixed_field_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, quantity_fixed_field_toPropertyKey(o.key), o); } }
function quantity_fixed_field_createClass(e, r, t) { return r && quantity_fixed_field_defineProperties(e.prototype, r), t && quantity_fixed_field_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function quantity_fixed_field_toPropertyKey(t) { var i = quantity_fixed_field_toPrimitive(t, "string"); return "symbol" == quantity_fixed_field_typeof(i) ? i : i + ""; }
function quantity_fixed_field_toPrimitive(t, r) { if ("object" != quantity_fixed_field_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != quantity_fixed_field_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == quantity_fixed_field_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }

var QuantityFixedField = /*#__PURE__*/function (_QuantityRangeField) {
  function QuantityFixedField() {
    quantity_fixed_field_classCallCheck(this, QuantityFixedField);
    return _callSuper(this, QuantityFixedField, arguments);
  }
  _inherits(QuantityFixedField, _QuantityRangeField);
  return quantity_fixed_field_createClass(QuantityFixedField, [{
    key: "getTemplate",
    value: function getTemplate() {
      return wp.template('ywdpd-quantity-fixed-discount-row');
    }
  }]);
}(QuantityRangeField);

;// ./assets/js/src/admin/fields/category-discount-field.js
function category_discount_field_typeof(o) { "@babel/helpers - typeof"; return category_discount_field_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, category_discount_field_typeof(o); }
function category_discount_field_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function category_discount_field_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, category_discount_field_toPropertyKey(o.key), o); } }
function category_discount_field_createClass(e, r, t) { return r && category_discount_field_defineProperties(e.prototype, r), t && category_discount_field_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function category_discount_field_toPropertyKey(t) { var i = category_discount_field_toPrimitive(t, "string"); return "symbol" == category_discount_field_typeof(i) ? i : i + ""; }
function category_discount_field_toPrimitive(t, r) { if ("object" != category_discount_field_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != category_discount_field_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function category_discount_field_callSuper(t, o, e) { return o = category_discount_field_getPrototypeOf(o), category_discount_field_possibleConstructorReturn(t, category_discount_field_isNativeReflectConstruct() ? Reflect.construct(o, e || [], category_discount_field_getPrototypeOf(t).constructor) : o.apply(t, e)); }
function category_discount_field_possibleConstructorReturn(t, e) { if (e && ("object" == category_discount_field_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return category_discount_field_assertThisInitialized(t); }
function category_discount_field_assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function category_discount_field_isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (category_discount_field_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function category_discount_field_getPrototypeOf(t) { return category_discount_field_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, category_discount_field_getPrototypeOf(t); }
function category_discount_field_inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && category_discount_field_setPrototypeOf(t, e); }
function category_discount_field_setPrototypeOf(t, e) { return category_discount_field_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, category_discount_field_setPrototypeOf(t, e); }

var CategoryDiscountField = /*#__PURE__*/function (_QuantityRangeField) {
  function CategoryDiscountField() {
    category_discount_field_classCallCheck(this, CategoryDiscountField);
    return category_discount_field_callSuper(this, CategoryDiscountField, arguments);
  }
  category_discount_field_inherits(CategoryDiscountField, _QuantityRangeField);
  return category_discount_field_createClass(CategoryDiscountField, [{
    key: "getTemplate",
    value: function getTemplate() {
      return wp.template('ywdpd-quantity-category-discount-row');
    }
  }]);
}(QuantityRangeField);
;// ./assets/js/src/admin/fields/simple-discount-field.js
function simple_discount_field_typeof(o) { "@babel/helpers - typeof"; return simple_discount_field_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, simple_discount_field_typeof(o); }
function simple_discount_field_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function simple_discount_field_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, simple_discount_field_toPropertyKey(o.key), o); } }
function simple_discount_field_createClass(e, r, t) { return r && simple_discount_field_defineProperties(e.prototype, r), t && simple_discount_field_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function simple_discount_field_toPropertyKey(t) { var i = simple_discount_field_toPrimitive(t, "string"); return "symbol" == simple_discount_field_typeof(i) ? i : i + ""; }
function simple_discount_field_toPrimitive(t, r) { if ("object" != simple_discount_field_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != simple_discount_field_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var SimpleDiscountField = /*#__PURE__*/function () {
  function SimpleDiscountField(element) {
    simple_discount_field_classCallCheck(this, SimpleDiscountField);
    this.elementDOM = element;
    this.elementDOM.find('select.ywdpd_discount_type').on('change', this.handleChangeDiscountType.bind(this));
  }
  return simple_discount_field_createClass(SimpleDiscountField, [{
    key: "handleChangeDiscountType",
    value: function handleChangeDiscountType(event) {
      var discountType = event.target.value;
      var symbolField = $(event.target).parents('.ywdpd-cart-discount-wrapper').find('.ywdpd_symbol');
      changePriceSymbol(symbolField, discountType);
    }
  }]);
}();

;// ./assets/js/src/admin/field-dependencies/field-dependecies.js


function field_dependecies_typeof(o) { "@babel/helpers - typeof"; return field_dependecies_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, field_dependecies_typeof(o); }
function field_dependecies_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function field_dependecies_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, field_dependecies_toPropertyKey(o.key), o); } }
function field_dependecies_createClass(e, r, t) { return r && field_dependecies_defineProperties(e.prototype, r), t && field_dependecies_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function field_dependecies_toPropertyKey(t) { var i = field_dependecies_toPrimitive(t, "string"); return "symbol" == field_dependecies_typeof(i) ? i : i + ""; }
function field_dependecies_toPrimitive(t, r) { if ("object" != field_dependecies_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != field_dependecies_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var FieldDependencies = /*#__PURE__*/function () {
  function FieldDependencies(containerClass, parentClassField) {
    field_dependecies_classCallCheck(this, FieldDependencies);
    this.containerClass = containerClass;
    this.parentClass = parentClassField;
    this.target_deps = [];
    this.target_deps_id = [];
  }
  return field_dependecies_createClass(FieldDependencies, [{
    key: "init",
    value: function init() {
      this.fields = this._getFields();
      this._initFields();
      this.handleFieldsChange();
    }
  }, {
    key: "_getFields",
    value: function _getFields() {
      return $(this.containerClass).find('[data-ywdpd-deps]');
    }
  }, {
    key: "_initFields",
    value: function _initFields() {
      var self = this;
      this.fields.each(function () {
        var t = $(this);
        self.handleField(t);
      });
      $(document).trigger('ywdpd-init-fields', [self]);
    }
  }, {
    key: "getTargetDep",
    value: function getTargetDep(dep) {
      return $('#' + dep.id);
    }
  }, {
    key: "getDeps",
    value: function getDeps(field) {
      return field.data('ywdpd-deps');
    }
  }, {
    key: "handleField",
    value: function handleField(field) {
      var self = this,
        parent = field.closest(self.parentClass),
        deps = this.getDeps(field),
        show = true;
      $.each(deps, function (i, dep) {
        var target_dep = self.getTargetDep(dep),
          compare = typeof dep.compare === 'undefined' ? '==' : dep.compare,
          property = typeof dep.property === 'undefined' ? false : dep.property,
          current_value;

        // it's a radio button.
        if (target_dep.hasClass('yith-plugin-fw-radio')) {
          current_value = target_dep.find('input[type="radio"]').filter(':checked').val();
        } else if (target_dep.hasClass('yith-plugin-fw-select') || target_dep.hasClass('yith-post-search') || target_dep.hasClass('wc-enhanced-select')) {
          current_value = target_dep.val();
        } else if (target_dep.hasClass('yith-plugin-fw-onoff-container')) {
          current_value = target_dep.find('input[type="checkbox"]').is(':checked') ? 'yes' : 'no';
        } else {
          current_value = target_dep.is(':checked') ? 'yes' : 'no';
        }
        if (self.target_deps_id.indexOf(dep.id) < 0) {
          self.target_deps.push(target_dep);
          self.target_deps_id.push(dep.id);
        }
        if (show) {
          if (property) {
            if (property === 'length') {
              switch (compare) {
                case '==':
                case '===':
                  show = current_value.length == dep.value;
                  break;
                case '>':
                  show = current_value.length > dep.value;
                  break;
                case '<':
                  show = current_value.length < dep.value;
                  break;
                case '>=':
                  show = current_value.length >= dep.value;
                  break;
                case '<=':
                  show = current_value.length <= dep.value;
                  break;
              }
            }
          } else {
            var value = dep.value.split(',');
            switch (compare) {
              case '==':
              case '===':
                show = value.indexOf(current_value) >= 0;
                break;
              case '!=':
              case '!==':
                show = value.indexOf(current_value) < 0;
                break;
            }
          }
        }
      });
      if (show) {
        parent.show();
      } else {
        parent.hide();
      }
    }
  }, {
    key: "handleFieldsChange",
    value: function handleFieldsChange() {
      var self = this;
      $.each(self.target_deps, function (i, field) {
        field.on('change', function () {
          self._initFields();
        });
      });
    }
  }]);
}();

;// ./assets/js/src/admin/field-dependencies/condition-field-dependencies.js


function condition_field_dependencies_typeof(o) { "@babel/helpers - typeof"; return condition_field_dependencies_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, condition_field_dependencies_typeof(o); }
function condition_field_dependencies_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function condition_field_dependencies_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, condition_field_dependencies_toPropertyKey(o.key), o); } }
function condition_field_dependencies_createClass(e, r, t) { return r && condition_field_dependencies_defineProperties(e.prototype, r), t && condition_field_dependencies_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function condition_field_dependencies_toPropertyKey(t) { var i = condition_field_dependencies_toPrimitive(t, "string"); return "symbol" == condition_field_dependencies_typeof(i) ? i : i + ""; }
function condition_field_dependencies_toPrimitive(t, r) { if ("object" != condition_field_dependencies_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != condition_field_dependencies_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function condition_field_dependencies_callSuper(t, o, e) { return o = condition_field_dependencies_getPrototypeOf(o), condition_field_dependencies_possibleConstructorReturn(t, condition_field_dependencies_isNativeReflectConstruct() ? Reflect.construct(o, e || [], condition_field_dependencies_getPrototypeOf(t).constructor) : o.apply(t, e)); }
function condition_field_dependencies_possibleConstructorReturn(t, e) { if (e && ("object" == condition_field_dependencies_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return condition_field_dependencies_assertThisInitialized(t); }
function condition_field_dependencies_assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function condition_field_dependencies_isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (condition_field_dependencies_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function condition_field_dependencies_getPrototypeOf(t) { return condition_field_dependencies_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, condition_field_dependencies_getPrototypeOf(t); }
function condition_field_dependencies_inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && condition_field_dependencies_setPrototypeOf(t, e); }
function condition_field_dependencies_setPrototypeOf(t, e) { return condition_field_dependencies_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, condition_field_dependencies_setPrototypeOf(t, e); }

var ConditionFieldDependencies = /*#__PURE__*/function (_FieldDependencies) {
  function ConditionFieldDependencies(toggle, containerClass, parentClassField) {
    var _this;
    condition_field_dependencies_classCallCheck(this, ConditionFieldDependencies);
    _this = condition_field_dependencies_callSuper(this, ConditionFieldDependencies, [containerClass, parentClassField]);
    _this.toggleElement = toggle;
    return _this;
  }
  condition_field_dependencies_inherits(ConditionFieldDependencies, _FieldDependencies);
  return condition_field_dependencies_createClass(ConditionFieldDependencies, [{
    key: "_getFields",
    value: function _getFields() {
      return this.toggleElement.find('[data-ywdpd-condition-deps]');
    }
  }, {
    key: "getDeps",
    value: function getDeps(field) {
      return field.data('ywdpd-condition-deps');
    }
  }, {
    key: "getTargetDep",
    value: function getTargetDep(dep) {
      return this.toggleElement.find('.' + dep.id);
    }
  }]);
}(FieldDependencies);

;// ./assets/js/src/admin/fields/advanced-conditions.js


function advanced_conditions_typeof(o) { "@babel/helpers - typeof"; return advanced_conditions_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, advanced_conditions_typeof(o); }
function advanced_conditions_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function advanced_conditions_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, advanced_conditions_toPropertyKey(o.key), o); } }
function advanced_conditions_createClass(e, r, t) { return r && advanced_conditions_defineProperties(e.prototype, r), t && advanced_conditions_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function advanced_conditions_toPropertyKey(t) { var i = advanced_conditions_toPrimitive(t, "string"); return "symbol" == advanced_conditions_typeof(i) ? i : i + ""; }
function advanced_conditions_toPrimitive(t, r) { if ("object" != advanced_conditions_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != advanced_conditions_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var AdvancedConditions = /*#__PURE__*/function () {
  function AdvancedConditions(element) {
    advanced_conditions_classCallCheck(this, AdvancedConditions);
    this.elementDOM = element;
    this.addConditionButton = this.elementDOM.find('.yith-add-box-button');
    this.addConditionButton.on('click', this.handleAddCondition.bind(this));
    this.currentModal = false;
    this.addConditionButton.appendTo(this.elementDOM.find('.yith-toggle-elements'));
    this.addConditionButton.addClass('visible');
    this._initToggleDependencies();
  }
  return advanced_conditions_createClass(AdvancedConditions, [{
    key: "_initToggleDependencies",
    value: function _initToggleDependencies() {
      var toggleContent = this.elementDOM.find('.yith-toggle-content');
      toggleContent.each(function () {
        new ConditionFieldDependencies($(this), '', '.yith-toggle-content-row').init();
      });
    }
  }, {
    key: "handleAddCondition",
    value: function handleAddCondition(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      var $this = $(event.target),
        target_id = $this.data('box_id'),
        id = $this.closest('.yith-toggle_wrapper').attr('id'),
        template = wp.template('yith-toggle-element-add-box-content-' + id);
      if ('' !== target_id) {
        var htmlTemplate = template({
          index: 'box_id'
        });
        this.currentModal = yith.ui.modal({
          allowWpMenu: false,
          width: '760px',
          title: yith_ywdpd_admin.new_condition_title,
          content: htmlTemplate,
          classes: {
            wrap: 'ywdpd_advanced_conditions_add_condition'
          }
        });
        var modalContent = $(document).find('.ywdpd_advanced_conditions_add_condition');
        modalContent.find('.yith-add-box-buttons button').removeClass('yith-save-button').addClass('ywdpd-save-button').data('caller_id', this.elementDOM.attr('id')).on('click', this.handleSaveCondition.bind(this));
        // eslint-disable-next-line max-len
        new ConditionFieldDependencies(modalContent, '', '.yith-toggle-content-row').init();
        $(document).trigger('yith_fields_init');
      }
    }
  }, {
    key: "handleSaveCondition",
    value: function handleSaveCondition(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      var button = $(event.target);
      if (this.elementDOM.attr('id') === button.data('caller_id')) {
        var add_box = button.parents('.yith-plugin-fw__modal__content'),
          id = this.elementDOM.attr('id'),
          spinner = add_box.find('.spinner'),
          toggle_element = this.elementDOM.parents('.toggle-element'),
          counter = 0,
          hidden_obj = $('<input type="hidden">'),
          self = this;
        toggle_element.find('.yith-toggle-row').each(function () {
          var key = parseInt($(this).data('item_key'));
          if (counter <= key) {
            counter = key + 1;
          }
        });
        if (add_box.find('#new_condition_name').val() === '') {
          var title = yith_ywdpd_admin.advanced_condition_default_title;
          add_box.find('#new_condition_name').val(title.replace('%s', counter + 1));
        }
        var fields = add_box.find(':input');
        hidden_obj.val(counter);
        $(document).trigger('yith-toggle-change-counter', [hidden_obj, add_box]);
        counter = hidden_obj.val();
        var template = wp.template('yith-toggle-element-item-' + id),
          toggle_el = $(template({
            index: counter
          }));
        spinner.addClass('show');
        $.each(fields, function (i, field) {
          if (typeof $(field).attr('id') !== 'undefined') {
            var _field_id = $(field).attr('id'),
              _field_val = $(field).val();
            if ('radio' === $(field).attr('type')) {
              _field_id = $(field).closest('.yith-plugin-fw-radio').attr('id');
              _field_id = _field_id.replace('new_', '') + '_' + counter;
              _field_id = _field_id + '-' + _field_val;
            } else {
              _field_id = _field_id.replace('new_', '') + '_' + counter;
            }
            if ($(field).is(':checked')) {
              $(toggle_el).find('#' + _field_id).prop('checked', true);
            }
            if ($(field).hasClass('yith-post-search') || $(field).hasClass('yith-term-search')) {
              $(toggle_el).find('#' + _field_id).html($('#' + $(field).attr('id')).html());
            }
            $(toggle_el).find('#' + _field_id).val(_field_val);
          }
        });
        $(toggle_el).formatToggleTitle();
        var form_is_valid = $('<input type="hidden">').val('yes');
        $(document).trigger('yith-toggle-element-item-before-add', [add_box, toggle_el, form_is_valid]);
        var delayInMilliseconds = 1000; //1 second
        setTimeout(function () {
          if (form_is_valid.val() === 'yes') {
            $(toggle_element).find('.yith-toggle-elements').append(toggle_el);
            $(add_box).find('.yith-plugin-fw-datepicker').datepicker('destroy');
            $(add_box).html('');
            $(add_box).prev('.yith-add-box-button').trigger('click');
            toggle_element.saveToggleElement();
            var delayInMillisecondsHight = 2000; //1 second
            setTimeout(function () {
              $(toggle_element).find('.highlight').removeClass('highlight');
            }, delayInMillisecondsHight);
            $(document).trigger('yith_fields_init');
            self._initToggleDependencies();
            self.addConditionButton.appendTo(self.elementDOM.find('.yith-toggle-elements'));
          }
        }, delayInMilliseconds);
        if (this.currentModal) {
          this.currentModal.close();
          this.currentModal = false;
        }
      }
    }
  }]);
}();

;// ./assets/js/src/admin/fields/special-offer.js
function special_offer_typeof(o) { "@babel/helpers - typeof"; return special_offer_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, special_offer_typeof(o); }
function special_offer_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function special_offer_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, special_offer_toPropertyKey(o.key), o); } }
function special_offer_createClass(e, r, t) { return r && special_offer_defineProperties(e.prototype, r), t && special_offer_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function special_offer_toPropertyKey(t) { var i = special_offer_toPrimitive(t, "string"); return "symbol" == special_offer_typeof(i) ? i : i + ""; }
function special_offer_toPrimitive(t, r) { if ("object" != special_offer_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != special_offer_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var SpecialOffer = /*#__PURE__*/function () {
  function SpecialOffer(element) {
    special_offer_classCallCheck(this, SpecialOffer);
    this.elementDOM = element;
    this._initDiscountTypeSelect();
  }
  return special_offer_createClass(SpecialOffer, [{
    key: "_initDiscountTypeSelect",
    value: function _initDiscountTypeSelect() {
      this.elementDOM.find('select.ywdpd_discount_type').on('change', this.handleChangeDiscountType.bind(this)).trigger('change');
    }
  }, {
    key: "handleChangeDiscountType",
    value: function handleChangeDiscountType(event) {
      var discountType = event.target.value;
      var symbolField = $(event.target).parents('.yith-inline-fields').find('.ywdpd_symbol');
      changePriceSymbol(symbolField, discountType);
    }
  }]);
}();

;// ./assets/js/src/admin/metabox/index.js
function metabox_typeof(o) { "@babel/helpers - typeof"; return metabox_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, metabox_typeof(o); }
function metabox_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function metabox_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, metabox_toPropertyKey(o.key), o); } }
function metabox_createClass(e, r, t) { return r && metabox_defineProperties(e.prototype, r), t && metabox_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = metabox_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function metabox_toPropertyKey(t) { var i = metabox_toPrimitive(t, "string"); return "symbol" == metabox_typeof(i) ? i : i + ""; }
function metabox_toPrimitive(t, r) { if ("object" != metabox_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != metabox_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









var YWDPD_Metabox = /*#__PURE__*/function () {
  function YWDPD_Metabox() {
    metabox_classCallCheck(this, YWDPD_Metabox);
    _defineProperty(this, "scrollTo", function (element) {
      $('html,body').animate({
        scrollTop: element.offset().top - 100
      }, 'slow');
    });
    this.elementDOM = $(document).find('.yith-plugin-ui--ywdpd_discount-post_type');
    if (this.elementDOM.length) {
      this.elementDOM.find('form#post').submit(this.checkErrors.bind(this));
      this.elementDOM.find('form#post').find('input,select,checkbox').on('change', this.setHasChanges.bind(this));
      this.elementDOM.find('#yith-plugin-fw__back-to-wp-list').on('click', this.showWaringMessage.bind(this));
      this.initFields();
      this.initFloatingSaveButton();
      new FieldDependencies('.yith-plugin-ui--ywdpd_discount-post_type', '.the-metabox').init();
      this.hasChanges = false;
    }
  }
  return metabox_createClass(YWDPD_Metabox, [{
    key: "initFloatingSaveButton",
    value: function initFloatingSaveButton() {
      if (typeof adminpage !== 'undefined' && ['post-php', 'post-new-php'].indexOf(adminpage) >= 0) {
        var postTypeSaving = {
          dom: {
            actions: $('#ywdpd-post-type__actions'),
            save: $('#ywdpd-post-type__save'),
            floatSave: $('#ywdpd-post-type__float-save')
          },
          init: function init() {
            var self = postTypeSaving;
            if (self.dom.save.length) {
              self.dom.save.on('click', self.onSaveClick);
              self.dom.floatSave.on('click', self.onFloatSaveClick);
              document.addEventListener('scroll', self.handleFloatSaveVisibility, {
                passive: true
              });
              $(window).on('resize', self.handleFloatSaveVisibility);
              self.handleFloatSaveVisibility();
            }
          },
          isInViewport: function isInViewport(el) {
            var rect = el.get(0).getBoundingClientRect(),
              viewport = {
                width: window.innerWidth || document.documentElement.clientWidth,
                height: window.innerHeight || document.documentElement.clientHeight
              };
            return rect.top >= 0 && rect.left >= 0 && rect.top <= viewport.height && rect.left <= viewport.width;
          },
          handleFloatSaveVisibility: function handleFloatSaveVisibility() {
            if (postTypeSaving.isInViewport(postTypeSaving.dom.save)) {
              postTypeSaving.dom.floatSave.removeClass('visible');
            } else {
              postTypeSaving.dom.floatSave.addClass('visible');
            }
          },
          onSaveClick: function onSaveClick(event) {
            $(window).off('beforeunload.edit-post');
            $(event.target).block({
              message: null,
              overlayCSS: {
                background: 'transparent',
                opacity: 0.6
              }
            });
          },
          onFloatSaveClick: function onFloatSaveClick() {
            postTypeSaving.dom.save.trigger('click');
          }
        };
        postTypeSaving.init();
      }
    }
  }, {
    key: "initFields",
    value: function initFields() {
      this.__initQtyField();
      this.__initScheduleField();
      this.__initSimpleDiscountField();
      this.__initAdvancedConditionField();
      this.__initSpecialOfferField();
    }
  }, {
    key: "__initSimpleDiscountField",
    value: function __initSimpleDiscountField() {
      var discountFields = this.elementDOM.find('.ywdpd-cart-discount-wrapper');
      if (discountFields.length) {
        discountFields.each(function () {
          new SimpleDiscountField($(this));
        });
      }
    }
  }, {
    key: "__initScheduleField",
    value: function __initScheduleField() {
      var scheduleFields = this.elementDOM.find('.ywdpd-schedule-discount-wrapper');
      if (scheduleFields.length) {
        scheduleFields.each(function () {
          new ScheduleDiscount($(this));
        });
      }
    }
  }, {
    key: "__initQtyField",
    value: function __initQtyField() {
      var qtyRuleFields = this.elementDOM.find('.ywdpd-qty-discount-wrapper');
      if (qtyRuleFields.length) {
        qtyRuleFields.each(function () {
          if ($(this).hasClass('ywdpd-qty-range')) {
            new QuantityRangeField($(this));
          } else if ($(this).hasClass('ywdpd-qty-fixed')) {
            new QuantityFixedField($(this));
          } else {
            new CategoryDiscountField($(this));
          }
        });
      }
    }
  }, {
    key: "__initAdvancedConditionField",
    value: function __initAdvancedConditionField() {
      var advancedConditions = $(document).find('.ywdpd_advanced_conditions');
      if (advancedConditions.length) {
        advancedConditions.each(function () {
          new AdvancedConditions($(this));
        });
      }
    }
  }, {
    key: "__initSpecialOfferField",
    value: function __initSpecialOfferField() {
      var specialOfferFields = this.elementDOM.find('.ywdpd_special_offer');
      if (specialOfferFields.length) {
        specialOfferFields.each(function () {
          new SpecialOffer($(this));
        });
      }
    }
  }, {
    key: "toggleScheduleElement",
    value: function toggleScheduleElement(event) {
      var value = event.target.value,
        container = $(event.target).parents('.yith-plugin-fw-field-wrapper');
      if ('no_schedule' === value) {
        container.find('.yith-plugin-fw-field-schedule').hide();
      } else {
        container.find('.yith-plugin-fw-field-schedule').show();
        this.__initScheduleField();
      }
    }
  }, {
    key: "checkErrors",
    value: function checkErrors(event) {
      var required_field = this.elementDOM.find('.yith-plugin-fw--required'),
        title = $(document).find('#_rule_name'),
        send = true,
        row = false,
        self = this;
      if ('' === title.val()) {
        send = false;
        row = title;
        title.addClass('ywdpd_required_check');
      } else {
        var postTitle = $(document).find('input[name="post_title"]');
        postTitle.val(title.val());
      }
      if (send) {
        required_field.each(function () {
          var current_row = $(this);
          if (current_row.is(':visible')) {
            var select = current_row.find('select');
            if (select.length) {
              var selected = select.find(':selected');
              if (selected.length === 0) {
                send = false;
                if (!row) {
                  row = current_row;
                }
                current_row.addClass('ywdpd_required_check');
              }
            }
          }
        });
      }
      if (!send) {
        $('#ywdpd-post-type__save').unblock();
        event.preventDefault();
        self.scrollTo(row);
        // eslint-disable-next-line max-len
        var selects = this.elementDOM.find('.yith-plugin-fw--required.ywdpd_required_check select');
        selects.on('select2:open', function (e) {
          $(this).parents('.yith-plugin-fw--required').removeClass('ywdpd_required_check');
          event.stopImmediatePropagation();
        });
        title.on('change', function () {
          title.removeClass('ywdpd_required_check');
        });
      }
    }
  }, {
    key: "setHasChanges",
    value: function setHasChanges() {
      this.hasChanges = true;
    }
  }, {
    key: "showWaringMessage",
    value: function showWaringMessage(event) {
      if (this.hasChanges) {
        event.preventDefault();
        var url = $(event.target).attr('href');
        yith.ui.confirm({
          title: yith_ywdpd_admin.message_alert.title,
          message: yith_ywdpd_admin.message_alert.desc,
          confirmButton: yith_ywdpd_admin.message_alert.confirmButton,
          closeAfterConfirm: false,
          classes: {
            wrap: 'ywdpd-warning-popup'
          },
          onConfirm: function onConfirm() {
            window.location.href = url;
          }
        });
      }
    }
  }]);
}();

;// ./assets/js/src/admin/exclusion-list/index.js
function exclusion_list_typeof(o) { "@babel/helpers - typeof"; return exclusion_list_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, exclusion_list_typeof(o); }
function exclusion_list_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function exclusion_list_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, exclusion_list_toPropertyKey(o.key), o); } }
function exclusion_list_createClass(e, r, t) { return r && exclusion_list_defineProperties(e.prototype, r), t && exclusion_list_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function exclusion_list_toPropertyKey(t) { var i = exclusion_list_toPrimitive(t, "string"); return "symbol" == exclusion_list_typeof(i) ? i : i + ""; }
function exclusion_list_toPrimitive(t, r) { if ("object" != exclusion_list_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != exclusion_list_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var YWDPD_ExclusionList = /*#__PURE__*/function () {
  function YWDPD_ExclusionList(element) {
    exclusion_list_classCallCheck(this, YWDPD_ExclusionList);
    this.elementDOM = element;
    this.elementDOM.find('.ywdpd-add-exclusion').on('click', this.handleOpenExclusionPopup.bind(this));
  }
  return exclusion_list_createClass(YWDPD_ExclusionList, [{
    key: "initDependencies",
    value: function initDependencies() {
      new FieldDependencies('.yith-exclusion-list__popup_wrapper', '.ywdpd-field').init();
    }
  }, {
    key: "handleOpenExclusionPopup",
    value: function handleOpenExclusionPopup(event) {
      event.preventDefault();
      var template = wp.template('ywdpd-exclusion-popup');
      var content = $(template({}));
      var modal = yith.ui.modal({
        title: content.data('title'),
        content: content,
        closeWhenClickingOnOverlay: true,
        footer: false,
        width: 500
      });
      $(document.body).trigger('wc-enhanced-select-init');
      $(document).trigger('yith_fields_init');
      this.initDependencies();
      this.elementDOM.find('.ywdpd-save-exclusion').on('click', function (e) {
        e.preventDefault();
        window.onbeforeunload = null;
        $(document).find('.yith-exclusion-list__popup_wrapper form').submit();
      });
    }
  }]);
}();

;// ./assets/js/src/admin/index.js





jQuery(document).ready(function ($) {
  if ($(document).find('.yith-plugin-ui--ywdpd_discount-post_type').length) {
    new YWDPD_Dashboard($(document).find('.yith-plugin-ui--ywdpd_discount-post_type'));
    new YWDPD_Metabox();
  }
  if ($(document).find('#yith_woocommerce_dynamic_pricing_and_discounts_exclusions').length) {
    new YWDPD_ExclusionList($(document).find('#yith_woocommerce_dynamic_pricing_and_discounts_exclusions'));
  }
  if ($(document).find('#yith_woocommerce_dynamic_pricing_and_discounts_general-quantity-table').length) {
    $('#ywdpd_show_percentage_in_table').on('change', function (e) {
      var discountField = $('.ywdpd_discount_heading');
      if ($(this).is(':checked')) {
        discountField.show();
      } else {
        discountField.hide();
      }
    }).trigger('change');
  }
});
/******/ })()
;
//# sourceMappingURL=admin.js.map