/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// ./assets/js/src/frontend/quantity-table/quantity-table.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var QuantityTable = /*#__PURE__*/function () {
  function QuantityTable(element) {
    _classCallCheck(this, QuantityTable);
    this.elementDOM = element;
    this.mode = 'classic';
    this.table = false;
    this.productDOM = this.elementDOM.parents(ywdpd_qty_args.column_product_info_class);
    this.qtyDOM = this.productDOM.find(ywdpd_qty_args.product_qty_classes);
    this.variationForm = this.productDOM.find(ywdpd_qty_args.variation_form_class);
    this.qtyDOM.on('change', this.handleChangeQuantity.bind(this));
    this.initTable();
    this.defaultTable = this.elementDOM.html();
    if (this.variationForm) {
      this.variationForm.on('show_variation', this.showVariationTable.bind(this));
      this.variationForm.on('reset_data', this.resetVariationTable.bind(this));
    }
  }
  return _createClass(QuantityTable, [{
    key: "initTable",
    value: function initTable() {
      this.table = this.elementDOM.find('#ywdpd-quantity-table');
      if (this.table.length) {
        this.table.on('click', 'td', this.handleTdClickEvent.bind(this));
      } else {
        this.table = this.elementDOM.find('#ywdpd-quantity-boxed');
        if (this.table.length) {
          this.table.on('click', '.ywdpd-boxed-item', this.handleBoxItemClickEvent.bind(this));
          this.table.on('click', '.ywdpd-boxed-item > *', this.handleBoxItemClickEvent.bind(this));
          this.mode = 'boxed';
        }
      }
      this.selectDefaultQty();
    }
  }, {
    key: "handleTdClickEvent",
    value: function handleTdClickEvent(event) {
      event.preventDefault();
      var td = jQuery(event.target);
      this.selectRightInfo(td);
    }
  }, {
    key: "handleBoxItemClickEvent",
    value: function handleBoxItemClickEvent(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      var item = jQuery(event.target);
      if (!item.hasClass('ywdpd-boxed-item')) {
        item = item.parents('.ywdpd-boxed-item');
      }
      this.selectRightInfo(item);
    }
  }, {
    key: "selectDefaultQty",
    value: function selectDefaultQty() {
      if ('yes' === ywdpd_qty_args.is_default_qty_enabled) {
        if ('classic' === this.mode) {
          var td;
          if ('yes' === ywdpd_qty_args.show_minimum_price) {
            td = this.table.find('td.qty-price-info').last();
          } else {
            td = this.table.find('td.qty-price-info').first();
          }
          td.trigger('click');
        } else {
          var item;
          if ('yes' === ywdpd_qty_args.show_minimum_price) {
            item = this.table.find('.ywdpd-boxed-item').last();
          } else {
            item = this.table.find('.ywdpd-boxed-item').first();
          }
          item.trigger('click');
        }
      }
    }
  }, {
    key: "selectRightInfo",
    value: function selectRightInfo(td) {
      var updateQty = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      if (this.mode === 'classic') {
        if (this.table.hasClass('vertical')) {
          var tr = td.parents('tr');
          this.toggleRow(tr, updateQty);
        } else {
          var index = td.index();
          this.toggleColumn(index, updateQty);
        }
      } else {
        this.toggleItem(td, updateQty);
      }
    }
  }, {
    key: "toggleRow",
    value: function toggleRow(tr, updateQty) {
      this.table.find('td').removeClass('ywdpd_active');
      tr.find('td').addClass('ywdpd_active');
      var tdQty = tr.find('td.qty-info');
      if (updateQty) {
        this.updateQuantityField(tdQty);
      }
      this.updatePriceField(tdQty);
    }
  }, {
    key: "toggleItem",
    value: function toggleItem(item, updateQty) {
      this.table.find('.ywdpd-boxed-item').removeClass('ywdpd_active');
      item.addClass('ywdpd_active');
      if (updateQty) {
        this.updateQuantityField(item);
      }
      this.updatePriceField(item);
    }
  }, {
    key: "toggleColumn",
    value: function toggleColumn(columnIndex, updateQty) {
      this.table.find('td').removeClass('ywdpd_active');
      this.table.find('tr td:nth-of-type(' + columnIndex + ')').addClass('ywdpd_active');
      var td = this.table.find('tr td.qty-info:nth-of-type(' + columnIndex + ')');
      if (updateQty) {
        this.updateQuantityField(td);
      }
      this.updatePriceField(td);
    }
  }, {
    key: "handleChangeQuantity",
    value: function handleChangeQuantity(event) {
      event.stopImmediatePropagation();
      var qty = parseInt(event.target.value);
      if ('yes' === ywdpd_qty_args.is_change_qty_enabled && qty > 0) {
        var classToCheck = 'classic' === this.mode ? 'td.qty-info' : '.ywdpd-boxed-item';
        var td = this.table.find(classToCheck).filter(function () {
          var max = jQuery(this).data('qtymax');
          if (max !== '*') {
            return jQuery(this).data('qtymin') <= qty && jQuery(this).data('qtymax') >= qty;
          }
          return jQuery(this).data('qtymin') <= qty;
        });
        if (td) {
          this.selectRightInfo(td, false);
        }
      }
    }
  }, {
    key: "updateQuantityField",
    value: function updateQuantityField(tdQuantity) {
      var newQty = '*' !== tdQuantity.data('qtymax') && !ywdpd_qty_args.select_minimum_quantity ? tdQuantity.data('qtymax') : tdQuantity.data('qtymin');
      this.qtyDOM.val(newQty);
    }
  }, {
    key: "updatePriceField",
    value: function updatePriceField(tdQuantity) {
      var productType = this.table.data('product_type');
      if ('variable' !== productType) {
        var newPrice = '';
        if (tdQuantity.length) {
          newPrice = tdQuantity.data('formatted_price');
        } else {
          jQuery(document).trigger('ywdpd_pre_update_price_html', [this.table, this.mode, tdQuantity]);
          newPrice = this.table.data('price_html');
        }
        var rawPrice = tdQuantity.data('unformatted_price');
        this.updatePriceHtml(newPrice, rawPrice, tdQuantity);
      }
    }
  }, {
    key: "updatePriceHtml",
    value: function updatePriceHtml(newPrice, rawPrice, tdQuantity) {
      var extra_class = '';
      if ('' !== newPrice) {
        if (this.productDOM.parents('.yith-quick-view-content').length) {
          extra_class = '.yith-quick-view-content ';
        }
        var product_container = jQuery(extra_class + ywdpd_qty_args.column_product_info_class);
        if (!product_container.find('.woocommerce-variation-price').length) {
          product_container.find(ywdpd_qty_args.product_price_classes).html(newPrice);
        } else {
          var variations_price = product_container.find('.woocommerce-variation-price .price');
          variations_price.html(newPrice);
        }
        jQuery(document).trigger('ywdpd_price_html_updated', [newPrice, rawPrice, tdQuantity]);
      }
    }
  }, {
    key: "showVariationTable",
    value: function showVariationTable(event, variation) {
      if (variation.table_price) {
        var variationTableWrapper = jQuery(variation.table_price);
        var idField = this.mode === 'classic' ? '#ywdpd-quantity-table' : '#ywdpd-quantity-boxed';
        if (variationTableWrapper.find(idField).length) {
          this.elementDOM.html(variationTableWrapper.html());
          this.elementDOM.show();
          if ('yes' !== ywdpd_qty_args.is_default_qty_enabled) {
            this.updatePriceHtml(variation.price_html, '');
          }
        } else {
          this.elementDOM.html('').hide();
          this.updatePriceHtml(variation.price_html, '');
        }
        this.initTable();
      }
    }
  }, {
    key: "resetVariationTable",
    value: function resetVariationTable() {
      if ('yes' === ywdpd_qty_args.show_variable_table) {
        this.elementDOM.html(this.defaultTable);
        this.initTable();
      } else {
        this.elementDOM.hide();
      }
    }
  }]);
}();

;// ./assets/js/src/frontend/product-notices/product-notices.js
function product_notices_typeof(o) { "@babel/helpers - typeof"; return product_notices_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, product_notices_typeof(o); }
function product_notices_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function product_notices_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, product_notices_toPropertyKey(o.key), o); } }
function product_notices_createClass(e, r, t) { return r && product_notices_defineProperties(e.prototype, r), t && product_notices_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function product_notices_toPropertyKey(t) { var i = product_notices_toPrimitive(t, "string"); return "symbol" == product_notices_typeof(i) ? i : i + ""; }
function product_notices_toPrimitive(t, r) { if ("object" != product_notices_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != product_notices_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ProductNotices = /*#__PURE__*/function () {
  function ProductNotices(element) {
    product_notices_classCallCheck(this, ProductNotices);
    this.elementDOM = element;
    this.productNoticeWrapper = element.html();
    this.productDOM = this.elementDOM.parents(ywdpd_qty_args.column_product_info_class);
    this.variationForm = this.productDOM.find(ywdpd_qty_args.variation_form_class);
    if (this.variationForm) {
      this.variationForm.on('show_variation', this.showVariationNotices.bind(this));
      this.variationForm.on('reset_data', this.resetVariationNotices.bind(this));
    }
  }
  return product_notices_createClass(ProductNotices, [{
    key: "showVariationNotices",
    value: function showVariationNotices(event, variation) {
      if (variation.ywdpd_notices) {
        var newNoticesWrapper = jQuery(variation.ywdpd_notices);
        if (newNoticesWrapper.length) {
          this.elementDOM.html(newNoticesWrapper.html()).show();
        } else {
          this.elementDOM.hide();
        }
      }
    }
  }, {
    key: "resetVariationNotices",
    value: function resetVariationNotices() {
      this.elementDOM.html(this.productNoticeWrapper).show();
    }
  }]);
}();

;// ./assets/js/src/frontend/points-integration/points-integration.js
function points_integration_typeof(o) { "@babel/helpers - typeof"; return points_integration_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, points_integration_typeof(o); }
function points_integration_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function points_integration_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, points_integration_toPropertyKey(o.key), o); } }
function points_integration_createClass(e, r, t) { return r && points_integration_defineProperties(e.prototype, r), t && points_integration_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function points_integration_toPropertyKey(t) { var i = points_integration_toPrimitive(t, "string"); return "symbol" == points_integration_typeof(i) ? i : i + ""; }
function points_integration_toPrimitive(t, r) { if ("object" != points_integration_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != points_integration_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var PointsIntegration = /*#__PURE__*/function () {
  function PointsIntegration() {
    points_integration_classCallCheck(this, PointsIntegration);
    var productWrapper = jQuery(document).find(ywdpd_qty_args.column_product_info_class);
    this.pointMessageDiv = productWrapper.find('.yith-par-message-product');
    this.defaultMessage = this.pointMessageDiv.length ? this.pointMessageDiv : '';
    jQuery(document).on('ywdpd_price_html_updated', this.updatePointsMessage.bind(this));
  }
  return points_integration_createClass(PointsIntegration, [{
    key: "updatePointsMessage",
    value: function updatePointsMessage(event, rawPrice, price, tdQuantity) {
      if (typeof tdQuantity !== 'undefined' && tdQuantity.length > 0) {
        var type = tdQuantity.parents('table').data('product_type');
        var currentMessageDiv = '';
        if ('variation' === type) {
          currentMessageDiv = jQuery(document).find(ywdpd_qty_args.column_product_info_class).find('.yith-par-message-variation');
        } else {
          currentMessageDiv = this.pointMessageDiv;
        }
        if (currentMessageDiv.length) {
          if (typeof price === 'undefined') {
            currentMessageDiv.html(this.defaultMessage);
          } else {
            var data = {
              action: ywdpd_qty_args.integrations.actions.update_product_points_message,
              security: ywdpd_qty_args.integrations.nonces.update_product_points_message,
              product_id: tdQuantity.parents('table').data('product_id'),
              dynamic_price: price,
              qty: jQuery('form.cart .qty').val()
            };
            jQuery.ajax({
              type: 'POST',
              url: ywdpd_qty_args.ajax_url,
              data: data,
              dataType: 'json',
              beforeSend: function beforeSend() {},
              success: function success(response) {
                if (response !== null && response !== void 0 && response.data) {
                  if (response.data.show) {
                    currentMessageDiv.show();
                  } else {
                    currentMessageDiv.hide();
                  }
                  currentMessageDiv.html(response.data.message);
                }
              },
              complete: function complete() {}
            });
          }
        }
      }
    }
  }]);
}();

;// ./assets/js/src/frontend/role-based-integration/role-based-integration.js
function role_based_integration_typeof(o) { "@babel/helpers - typeof"; return role_based_integration_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, role_based_integration_typeof(o); }
function role_based_integration_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function role_based_integration_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, role_based_integration_toPropertyKey(o.key), o); } }
function role_based_integration_createClass(e, r, t) { return r && role_based_integration_defineProperties(e.prototype, r), t && role_based_integration_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function role_based_integration_toPropertyKey(t) { var i = role_based_integration_toPrimitive(t, "string"); return "symbol" == role_based_integration_typeof(i) ? i : i + ""; }
function role_based_integration_toPrimitive(t, r) { if ("object" != role_based_integration_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != role_based_integration_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var RoleBasedIntegration = /*#__PURE__*/function () {
  function RoleBasedIntegration() {
    role_based_integration_classCallCheck(this, RoleBasedIntegration);
    jQuery(document).on('ywdpd_pre_update_price_html', this.syncRoleBasedPriceHTML.bind(this));
  }
  return role_based_integration_createClass(RoleBasedIntegration, [{
    key: "syncRoleBasedPriceHTML",
    value: function syncRoleBasedPriceHTML(event, table, mode, td) {
      var priceHTML = jQuery(table.data('price_html'));
      if (priceHTML.find('.ywcrbp-role-price-rule').length) {
        var newPrice = priceHTML.find('.ywcrbp-role-price-rule .role-price .price').html();
        table.data('price_html', newPrice);
      }
    }
  }]);
}();

;// ./assets/js/src/frontend/index.js






jQuery(document).ready(function ($) {
  var tables = $(document).find('.ywdpd-table-discounts-wrapper');
  var notices = $(document).find('.ywdpd-notices-wrapper');
  tables.each(function () {
    new QuantityTable($(this));
  });
  notices.each(function () {
    new ProductNotices($(this));
  });
  $(document.body).on('payment_method_selected', function (e) {
    var selectedPaymentMethod = $('.woocommerce-checkout input[name="payment_method"]:checked').attr('id');
    var data = {
      action: ywdpd_popup_args.actions.valid_rule_in_checkout,
      security: ywdpd_popup_args.nonces.valid_rule_in_checkout,
      payment_method: selectedPaymentMethod,
      context: 'frontend'
    };
    jQuery.ajax({
      type: 'POST',
      url: ywdpd_popup_args.ajax_url,
      data: data,
      dataType: 'json',
      beforeSend: function beforeSend() {},
      success: function success(response) {
        $(document.body).trigger('update_checkout');
      },
      complete: function complete() {}
    });
  });
  if ('yes' === ywdpd_qty_args.has_points_installed) {
    new PointsIntegration();
  }
  if ('yes' === ywdpd_qty_args.has_rolebased_installed) {
    new RoleBasedIntegration();
  }
});
/******/ })()
;
//# sourceMappingURL=frontend.js.map