/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 436:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* module decorator */ module = __webpack_require__.nmd(module);


const wrapAnsi16 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${code + offset}m`;
};

const wrapAnsi256 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${38 + offset};5;${code}m`;
};

const wrapAnsi16m = (fn, offset) => (...args) => {
	const rgb = fn(...args);
	return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
};

const ansi2ansi = n => n;
const rgb2rgb = (r, g, b) => [r, g, b];

const setLazyProperty = (object, property, get) => {
	Object.defineProperty(object, property, {
		get: () => {
			const value = get();

			Object.defineProperty(object, property, {
				value,
				enumerable: true,
				configurable: true
			});

			return value;
		},
		enumerable: true,
		configurable: true
	});
};

/** @type {typeof import('color-convert')} */
let colorConvert;
const makeDynamicStyles = (wrap, targetSpace, identity, isBackground) => {
	if (colorConvert === undefined) {
		colorConvert = __webpack_require__(734);
	}

	const offset = isBackground ? 10 : 0;
	const styles = {};

	for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
		const name = sourceSpace === 'ansi16' ? 'ansi' : sourceSpace;
		if (sourceSpace === targetSpace) {
			styles[name] = wrap(identity, offset);
		} else if (typeof suite === 'object') {
			styles[name] = wrap(suite[targetSpace], offset);
		}
	}

	return styles;
};

function assembleStyles() {
	const codes = new Map();
	const styles = {
		modifier: {
			reset: [0, 0],
			// 21 isn't widely supported and 22 does the same thing
			bold: [1, 22],
			dim: [2, 22],
			italic: [3, 23],
			underline: [4, 24],
			inverse: [7, 27],
			hidden: [8, 28],
			strikethrough: [9, 29]
		},
		color: {
			black: [30, 39],
			red: [31, 39],
			green: [32, 39],
			yellow: [33, 39],
			blue: [34, 39],
			magenta: [35, 39],
			cyan: [36, 39],
			white: [37, 39],

			// Bright color
			blackBright: [90, 39],
			redBright: [91, 39],
			greenBright: [92, 39],
			yellowBright: [93, 39],
			blueBright: [94, 39],
			magentaBright: [95, 39],
			cyanBright: [96, 39],
			whiteBright: [97, 39]
		},
		bgColor: {
			bgBlack: [40, 49],
			bgRed: [41, 49],
			bgGreen: [42, 49],
			bgYellow: [43, 49],
			bgBlue: [44, 49],
			bgMagenta: [45, 49],
			bgCyan: [46, 49],
			bgWhite: [47, 49],

			// Bright color
			bgBlackBright: [100, 49],
			bgRedBright: [101, 49],
			bgGreenBright: [102, 49],
			bgYellowBright: [103, 49],
			bgBlueBright: [104, 49],
			bgMagentaBright: [105, 49],
			bgCyanBright: [106, 49],
			bgWhiteBright: [107, 49]
		}
	};

	// Alias bright black as gray (and grey)
	styles.color.gray = styles.color.blackBright;
	styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
	styles.color.grey = styles.color.blackBright;
	styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;

	for (const [groupName, group] of Object.entries(styles)) {
		for (const [styleName, style] of Object.entries(group)) {
			styles[styleName] = {
				open: `\u001B[${style[0]}m`,
				close: `\u001B[${style[1]}m`
			};

			group[styleName] = styles[styleName];

			codes.set(style[0], style[1]);
		}

		Object.defineProperty(styles, groupName, {
			value: group,
			enumerable: false
		});
	}

	Object.defineProperty(styles, 'codes', {
		value: codes,
		enumerable: false
	});

	styles.color.close = '\u001B[39m';
	styles.bgColor.close = '\u001B[49m';

	setLazyProperty(styles.color, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, false));
	setLazyProperty(styles.bgColor, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, true));

	return styles;
}

// Make the export immutable
Object.defineProperty(module, 'exports', {
	enumerable: true,
	get: assembleStyles
});


/***/ }),

/***/ 248:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const ansiStyles = __webpack_require__(436);
const {stdout: stdoutColor, stderr: stderrColor} = __webpack_require__(747);
const {
	stringReplaceAll,
	stringEncaseCRLFWithFirstIndex
} = __webpack_require__(58);

const {isArray} = Array;

// `supportsColor.level` → `ansiStyles.color[name]` mapping
const levelMapping = [
	'ansi',
	'ansi',
	'ansi256',
	'ansi16m'
];

const styles = Object.create(null);

const applyOptions = (object, options = {}) => {
	if (options.level && !(Number.isInteger(options.level) && options.level >= 0 && options.level <= 3)) {
		throw new Error('The `level` option should be an integer from 0 to 3');
	}

	// Detect level if not set manually
	const colorLevel = stdoutColor ? stdoutColor.level : 0;
	object.level = options.level === undefined ? colorLevel : options.level;
};

class ChalkClass {
	constructor(options) {
		// eslint-disable-next-line no-constructor-return
		return chalkFactory(options);
	}
}

const chalkFactory = options => {
	const chalk = {};
	applyOptions(chalk, options);

	chalk.template = (...arguments_) => chalkTag(chalk.template, ...arguments_);

	Object.setPrototypeOf(chalk, Chalk.prototype);
	Object.setPrototypeOf(chalk.template, chalk);

	chalk.template.constructor = () => {
		throw new Error('`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.');
	};

	chalk.template.Instance = ChalkClass;

	return chalk.template;
};

function Chalk(options) {
	return chalkFactory(options);
}

for (const [styleName, style] of Object.entries(ansiStyles)) {
	styles[styleName] = {
		get() {
			const builder = createBuilder(this, createStyler(style.open, style.close, this._styler), this._isEmpty);
			Object.defineProperty(this, styleName, {value: builder});
			return builder;
		}
	};
}

styles.visible = {
	get() {
		const builder = createBuilder(this, this._styler, true);
		Object.defineProperty(this, 'visible', {value: builder});
		return builder;
	}
};

const usedModels = ['rgb', 'hex', 'keyword', 'hsl', 'hsv', 'hwb', 'ansi', 'ansi256'];

for (const model of usedModels) {
	styles[model] = {
		get() {
			const {level} = this;
			return function (...arguments_) {
				const styler = createStyler(ansiStyles.color[levelMapping[level]][model](...arguments_), ansiStyles.color.close, this._styler);
				return createBuilder(this, styler, this._isEmpty);
			};
		}
	};
}

for (const model of usedModels) {
	const bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
	styles[bgModel] = {
		get() {
			const {level} = this;
			return function (...arguments_) {
				const styler = createStyler(ansiStyles.bgColor[levelMapping[level]][model](...arguments_), ansiStyles.bgColor.close, this._styler);
				return createBuilder(this, styler, this._isEmpty);
			};
		}
	};
}

const proto = Object.defineProperties(() => {}, {
	...styles,
	level: {
		enumerable: true,
		get() {
			return this._generator.level;
		},
		set(level) {
			this._generator.level = level;
		}
	}
});

const createStyler = (open, close, parent) => {
	let openAll;
	let closeAll;
	if (parent === undefined) {
		openAll = open;
		closeAll = close;
	} else {
		openAll = parent.openAll + open;
		closeAll = close + parent.closeAll;
	}

	return {
		open,
		close,
		openAll,
		closeAll,
		parent
	};
};

const createBuilder = (self, _styler, _isEmpty) => {
	const builder = (...arguments_) => {
		if (isArray(arguments_[0]) && isArray(arguments_[0].raw)) {
			// Called as a template literal, for example: chalk.red`2 + 3 = {bold ${2+3}}`
			return applyStyle(builder, chalkTag(builder, ...arguments_));
		}

		// Single argument is hot path, implicit coercion is faster than anything
		// eslint-disable-next-line no-implicit-coercion
		return applyStyle(builder, (arguments_.length === 1) ? ('' + arguments_[0]) : arguments_.join(' '));
	};

	// We alter the prototype because we must return a function, but there is
	// no way to create a function with a different prototype
	Object.setPrototypeOf(builder, proto);

	builder._generator = self;
	builder._styler = _styler;
	builder._isEmpty = _isEmpty;

	return builder;
};

const applyStyle = (self, string) => {
	if (self.level <= 0 || !string) {
		return self._isEmpty ? '' : string;
	}

	let styler = self._styler;

	if (styler === undefined) {
		return string;
	}

	const {openAll, closeAll} = styler;
	if (string.indexOf('\u001B') !== -1) {
		while (styler !== undefined) {
			// Replace any instances already present with a re-opening code
			// otherwise only the part of the string until said closing code
			// will be colored, and the rest will simply be 'plain'.
			string = stringReplaceAll(string, styler.close, styler.open);

			styler = styler.parent;
		}
	}

	// We can move both next actions out of loop, because remaining actions in loop won't have
	// any/visible effect on parts we add here. Close the styling before a linebreak and reopen
	// after next line to fix a bleed issue on macOS: https://github.com/chalk/chalk/pull/92
	const lfIndex = string.indexOf('\n');
	if (lfIndex !== -1) {
		string = stringEncaseCRLFWithFirstIndex(string, closeAll, openAll, lfIndex);
	}

	return openAll + string + closeAll;
};

let template;
const chalkTag = (chalk, ...strings) => {
	const [firstString] = strings;

	if (!isArray(firstString) || !isArray(firstString.raw)) {
		// If chalk() was called by itself or with a string,
		// return the string itself as a string.
		return strings.join(' ');
	}

	const arguments_ = strings.slice(1);
	const parts = [firstString.raw[0]];

	for (let i = 1; i < firstString.length; i++) {
		parts.push(
			String(arguments_[i - 1]).replace(/[{}\\]/g, '\\$&'),
			String(firstString.raw[i])
		);
	}

	if (template === undefined) {
		template = __webpack_require__(991);
	}

	return template(chalk, parts.join(''));
};

Object.defineProperties(Chalk.prototype, styles);

const chalk = Chalk(); // eslint-disable-line new-cap
chalk.supportsColor = stdoutColor;
chalk.stderr = Chalk({level: stderrColor ? stderrColor.level : 0}); // eslint-disable-line new-cap
chalk.stderr.supportsColor = stderrColor;

module.exports = chalk;


/***/ }),

/***/ 991:
/***/ ((module) => {

"use strict";

const TEMPLATE_REGEX = /(?:\\(u(?:[a-f\d]{4}|\{[a-f\d]{1,6}\})|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
const STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
const STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
const ESCAPE_REGEX = /\\(u(?:[a-f\d]{4}|{[a-f\d]{1,6}})|x[a-f\d]{2}|.)|([^\\])/gi;

const ESCAPES = new Map([
	['n', '\n'],
	['r', '\r'],
	['t', '\t'],
	['b', '\b'],
	['f', '\f'],
	['v', '\v'],
	['0', '\0'],
	['\\', '\\'],
	['e', '\u001B'],
	['a', '\u0007']
]);

function unescape(c) {
	const u = c[0] === 'u';
	const bracket = c[1] === '{';

	if ((u && !bracket && c.length === 5) || (c[0] === 'x' && c.length === 3)) {
		return String.fromCharCode(parseInt(c.slice(1), 16));
	}

	if (u && bracket) {
		return String.fromCodePoint(parseInt(c.slice(2, -1), 16));
	}

	return ESCAPES.get(c) || c;
}

function parseArguments(name, arguments_) {
	const results = [];
	const chunks = arguments_.trim().split(/\s*,\s*/g);
	let matches;

	for (const chunk of chunks) {
		const number = Number(chunk);
		if (!Number.isNaN(number)) {
			results.push(number);
		} else if ((matches = chunk.match(STRING_REGEX))) {
			results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, character) => escape ? unescape(escape) : character));
		} else {
			throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
		}
	}

	return results;
}

function parseStyle(style) {
	STYLE_REGEX.lastIndex = 0;

	const results = [];
	let matches;

	while ((matches = STYLE_REGEX.exec(style)) !== null) {
		const name = matches[1];

		if (matches[2]) {
			const args = parseArguments(name, matches[2]);
			results.push([name].concat(args));
		} else {
			results.push([name]);
		}
	}

	return results;
}

function buildStyle(chalk, styles) {
	const enabled = {};

	for (const layer of styles) {
		for (const style of layer.styles) {
			enabled[style[0]] = layer.inverse ? null : style.slice(1);
		}
	}

	let current = chalk;
	for (const [styleName, styles] of Object.entries(enabled)) {
		if (!Array.isArray(styles)) {
			continue;
		}

		if (!(styleName in current)) {
			throw new Error(`Unknown Chalk style: ${styleName}`);
		}

		current = styles.length > 0 ? current[styleName](...styles) : current[styleName];
	}

	return current;
}

module.exports = (chalk, temporary) => {
	const styles = [];
	const chunks = [];
	let chunk = [];

	// eslint-disable-next-line max-params
	temporary.replace(TEMPLATE_REGEX, (m, escapeCharacter, inverse, style, close, character) => {
		if (escapeCharacter) {
			chunk.push(unescape(escapeCharacter));
		} else if (style) {
			const string = chunk.join('');
			chunk = [];
			chunks.push(styles.length === 0 ? string : buildStyle(chalk, styles)(string));
			styles.push({inverse, styles: parseStyle(style)});
		} else if (close) {
			if (styles.length === 0) {
				throw new Error('Found extraneous } in Chalk template literal');
			}

			chunks.push(buildStyle(chalk, styles)(chunk.join('')));
			chunk = [];
			styles.pop();
		} else {
			chunk.push(character);
		}
	});

	chunks.push(chunk.join(''));

	if (styles.length > 0) {
		const errMessage = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
		throw new Error(errMessage);
	}

	return chunks.join('');
};


/***/ }),

/***/ 58:
/***/ ((module) => {

"use strict";


const stringReplaceAll = (string, substring, replacer) => {
	let index = string.indexOf(substring);
	if (index === -1) {
		return string;
	}

	const substringLength = substring.length;
	let endIndex = 0;
	let returnValue = '';
	do {
		returnValue += string.substr(endIndex, index - endIndex) + substring + replacer;
		endIndex = index + substringLength;
		index = string.indexOf(substring, endIndex);
	} while (index !== -1);

	returnValue += string.substr(endIndex);
	return returnValue;
};

const stringEncaseCRLFWithFirstIndex = (string, prefix, postfix, index) => {
	let endIndex = 0;
	let returnValue = '';
	do {
		const gotCR = string[index - 1] === '\r';
		returnValue += string.substr(endIndex, (gotCR ? index - 1 : index) - endIndex) + prefix + (gotCR ? '\r\n' : '\n') + postfix;
		endIndex = index + 1;
		index = string.indexOf('\n', endIndex);
	} while (index !== -1);

	returnValue += string.substr(endIndex);
	return returnValue;
};

module.exports = {
	stringReplaceAll,
	stringEncaseCRLFWithFirstIndex
};


/***/ }),

/***/ 659:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* MIT license */
/* eslint-disable no-mixed-operators */
const cssKeywords = __webpack_require__(156);

// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

const reverseKeywords = {};
for (const key of Object.keys(cssKeywords)) {
	reverseKeywords[cssKeywords[key]] = key;
}

const convert = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

module.exports = convert;

// Hide .channels and .labels properties
for (const model of Object.keys(convert)) {
	if (!('channels' in convert[model])) {
		throw new Error('missing channels property: ' + model);
	}

	if (!('labels' in convert[model])) {
		throw new Error('missing channel labels property: ' + model);
	}

	if (convert[model].labels.length !== convert[model].channels) {
		throw new Error('channel and label counts mismatch: ' + model);
	}

	const {channels, labels} = convert[model];
	delete convert[model].channels;
	delete convert[model].labels;
	Object.defineProperty(convert[model], 'channels', {value: channels});
	Object.defineProperty(convert[model], 'labels', {value: labels});
}

convert.rgb.hsl = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const min = Math.min(r, g, b);
	const max = Math.max(r, g, b);
	const delta = max - min;
	let h;
	let s;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	const l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	let rdif;
	let gdif;
	let bdif;
	let h;
	let s;

	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const v = Math.max(r, g, b);
	const diff = v - Math.min(r, g, b);
	const diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = 0;
		s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}

		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	const r = rgb[0];
	const g = rgb[1];
	let b = rgb[2];
	const h = convert.rgb.hsl(rgb)[0];
	const w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;

	const k = Math.min(1 - r, 1 - g, 1 - b);
	const c = (1 - r - k) / (1 - k) || 0;
	const m = (1 - g - k) / (1 - k) || 0;
	const y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

function comparativeDistance(x, y) {
	/*
		See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
	*/
	return (
		((x[0] - y[0]) ** 2) +
		((x[1] - y[1]) ** 2) +
		((x[2] - y[2]) ** 2)
	);
}

convert.rgb.keyword = function (rgb) {
	const reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	let currentClosestDistance = Infinity;
	let currentClosestKeyword;

	for (const keyword of Object.keys(cssKeywords)) {
		const value = cssKeywords[keyword];

		// Compute comparative distance
		const distance = comparativeDistance(rgb, value);

		// Check if its less, if so set as closest
		if (distance < currentClosestDistance) {
			currentClosestDistance = distance;
			currentClosestKeyword = keyword;
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return cssKeywords[keyword];
};

convert.rgb.xyz = function (rgb) {
	let r = rgb[0] / 255;
	let g = rgb[1] / 255;
	let b = rgb[2] / 255;

	// Assume sRGB
	r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
	g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
	b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

	const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	const xyz = convert.rgb.xyz(rgb);
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	const h = hsl[0] / 360;
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;
	let t2;
	let t3;
	let val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	const t1 = 2 * l - t2;

	const rgb = [0, 0, 0];
	for (let i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}

		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	const h = hsl[0];
	let s = hsl[1] / 100;
	let l = hsl[2] / 100;
	let smin = s;
	const lmin = Math.max(l, 0.01);

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	const v = (l + s) / 2;
	const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	const h = hsv[0] / 60;
	const s = hsv[1] / 100;
	let v = hsv[2] / 100;
	const hi = Math.floor(h) % 6;

	const f = h - Math.floor(h);
	const p = 255 * v * (1 - s);
	const q = 255 * v * (1 - (s * f));
	const t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	const h = hsv[0];
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;
	const vmin = Math.max(v, 0.01);
	let sl;
	let l;

	l = (2 - s) * v;
	const lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	const h = hwb[0] / 360;
	let wh = hwb[1] / 100;
	let bl = hwb[2] / 100;
	const ratio = wh + bl;
	let f;

	// Wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	const i = Math.floor(6 * h);
	const v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	const n = wh + f * (v - wh); // Linear interpolation

	let r;
	let g;
	let b;
	/* eslint-disable max-statements-per-line,no-multi-spaces */
	switch (i) {
		default:
		case 6:
		case 0: r = v;  g = n;  b = wh; break;
		case 1: r = n;  g = v;  b = wh; break;
		case 2: r = wh; g = v;  b = n; break;
		case 3: r = wh; g = n;  b = v; break;
		case 4: r = n;  g = wh; b = v; break;
		case 5: r = v;  g = wh; b = n; break;
	}
	/* eslint-enable max-statements-per-line,no-multi-spaces */

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	const c = cmyk[0] / 100;
	const m = cmyk[1] / 100;
	const y = cmyk[2] / 100;
	const k = cmyk[3] / 100;

	const r = 1 - Math.min(1, c * (1 - k) + k);
	const g = 1 - Math.min(1, m * (1 - k) + k);
	const b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	const x = xyz[0] / 100;
	const y = xyz[1] / 100;
	const z = xyz[2] / 100;
	let r;
	let g;
	let b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// Assume sRGB
	r = r > 0.0031308
		? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let x;
	let y;
	let z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	const y2 = y ** 3;
	const x2 = x ** 3;
	const z2 = z ** 3;
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let h;

	const hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	const c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	const l = lch[0];
	const c = lch[1];
	const h = lch[2];

	const hr = h / 360 * 2 * Math.PI;
	const a = c * Math.cos(hr);
	const b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args, saturation = null) {
	const [r, g, b] = args;
	let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	let ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// Optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	const r = args[0];
	const g = args[1];
	const b = args[2];

	// We use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	const ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	let color = args % 10;

	// Handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	const mult = (~~(args > 50) + 1) * 0.5;
	const r = ((color & 1) * mult) * 255;
	const g = (((color >> 1) & 1) * mult) * 255;
	const b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// Handle greyscale
	if (args >= 232) {
		const c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	let rem;
	const r = Math.floor(args / 36) / 5 * 255;
	const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	const b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	const integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	let colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(char => {
			return char + char;
		}).join('');
	}

	const integer = parseInt(colorString, 16);
	const r = (integer >> 16) & 0xFF;
	const g = (integer >> 8) & 0xFF;
	const b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const max = Math.max(Math.max(r, g), b);
	const min = Math.min(Math.min(r, g), b);
	const chroma = (max - min);
	let grayscale;
	let hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;

	const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

	let f = 0;
	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;

	const c = s * v;
	let f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	const h = hcg[0] / 360;
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	const pure = [0, 0, 0];
	const hi = (h % 1) * 6;
	const v = hi % 1;
	const w = 1 - v;
	let mg = 0;

	/* eslint-disable max-statements-per-line */
	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}
	/* eslint-enable max-statements-per-line */

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const v = c + g * (1.0 - c);
	let f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const l = g * (1.0 - c) + 0.5 * c;
	let s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;
	const v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	const w = hwb[1] / 100;
	const b = hwb[2] / 100;
	const v = 1 - b;
	const c = v - w;
	let g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hsv = convert.gray.hsl;

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	const val = Math.round(gray[0] / 100 * 255) & 0xFF;
	const integer = (val << 16) + (val << 8) + val;

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};


/***/ }),

/***/ 734:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const conversions = __webpack_require__(659);
const route = __webpack_require__(507);

const convert = {};

const models = Object.keys(conversions);

function wrapRaw(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];
		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		return fn(args);
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];

		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		const result = fn(args);

		// We're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (let len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(fromModel => {
	convert[fromModel] = {};

	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

	const routes = route(fromModel);
	const routeModels = Object.keys(routes);

	routeModels.forEach(toModel => {
		const fn = routes[toModel];

		convert[fromModel][toModel] = wrapRounded(fn);
		convert[fromModel][toModel].raw = wrapRaw(fn);
	});
});

module.exports = convert;


/***/ }),

/***/ 507:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const conversions = __webpack_require__(659);

/*
	This function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	const graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	const models = Object.keys(conversions);

	for (let len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	const graph = buildGraph();
	const queue = [fromModel]; // Unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		const current = queue.pop();
		const adjacents = Object.keys(conversions[current]);

		for (let len = adjacents.length, i = 0; i < len; i++) {
			const adjacent = adjacents[i];
			const node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	const path = [graph[toModel].parent, toModel];
	let fn = conversions[graph[toModel].parent][toModel];

	let cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	const graph = deriveBFS(fromModel);
	const conversion = {};

	const models = Object.keys(graph);
	for (let len = models.length, i = 0; i < len; i++) {
		const toModel = models[i];
		const node = graph[toModel];

		if (node.parent === null) {
			// No possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};



/***/ }),

/***/ 156:
/***/ ((module) => {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ 747:
/***/ ((module) => {

"use strict";

module.exports = {
	stdout: false,
	stderr: false
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			loaded: false,
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/node module decorator */
/******/ 	(() => {
/******/ 		__webpack_require__.nmd = (module) => {
/******/ 			module.paths = [];
/******/ 			if (!module.children) module.children = [];
/******/ 			return module;
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
// This entry needs to be wrapped in an IIFE because it needs to be in strict mode.
(() => {
"use strict";

;// ./assets/js/src/modals/quantity-input.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var QuantityInput = /*#__PURE__*/function () {
  /**
   * The constructor
   *
   * @param {Object}                element
   * @param {string}                id
   * @param {string}                min
   * @param {string}                max
   * @param {YWDPD_AbstractProduct} product The product.
   * @param {boolean}               show    Show or not the field.
   */
  function QuantityInput(element, id) {
    var min = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    var max = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
    var product = arguments.length > 4 ? arguments[4] : undefined;
    var show = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
    _classCallCheck(this, QuantityInput);
    this.elementDOM = element;
    this.product = product;
    this.showByDefault = show;
    this.min = min;
    this.hasMax = max !== '';
    this.max = this.hasMax ? parseInt(max) : -1;
    this.plus = this.elementDOM.find('.ywdpd_qty_increase');
    this.minus = this.elementDOM.find('.ywdpd_qty_decrease');
    this.trash = this.elementDOM.find('.ywdpd_qty_remove');
    this.value = this.elementDOM.find('.ywdpd_qty');
    this.plus.on('click', this.handleClickPlus.bind(this));
    this.minus.on('click', this.handleClickMinus.bind(this));
    this.trash.on('click', this.handleClickTrash.bind(this));
    this.setId(id);
    this.handleShowMinus(false);
    this.handleShowPlus(true);
    this.handleShowTrash(true);
    this.toggleShowField(this.showByDefault);
  }
  return _createClass(QuantityInput, [{
    key: "handleClickPlus",
    value: function handleClickPlus(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      var currentValue = parseInt(this.value.html());
      var newValue = currentValue + 1;
      if (this.max === -1 || newValue <= this.max) {
        this.value.html(newValue);
        this.handleShowPlus(true);
        if (newValue > 1) {
          this.handleShowTrash(false);
          this.handleShowMinus(true);
        }
        this.product.globalList.updateProductInList(this.getId(), newValue);
      }
      if (newValue === this.max) {
        this.toggleDisablePlusButton(true);
        this.toggleDisableMinusButton(false);
      }
    }
  }, {
    key: "handleClickMinus",
    value: function handleClickMinus(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      var currentValue = parseInt(this.value.html());
      var newValue = currentValue - 1;
      if (newValue >= this.min) {
        this.value.html(newValue);
        this.product.globalList.updateProductInList(this.getId(), newValue);
      }
      if (newValue === this.min) {
        this.toggleDisablePlusButton(false);
        this.toggleDisableMinusButton(false);
        this.handleShowMinus(false);
        this.handleShowTrash(true);
      }
    }
  }, {
    key: "toggleDisablePlusButton",
    value: function toggleDisablePlusButton(disable) {
      if (disable) {
        this.plus.addClass('ywdpd_button_disabled');
      } else {
        this.plus.removeClass('ywdpd_button_disabled');
      }
    }
  }, {
    key: "toggleDisableMinusButton",
    value: function toggleDisableMinusButton(disable) {
      if (disable) {
        this.minus.addClass('ywdpd_button_disabled');
      } else {
        this.minus.removeClass('ywdpd_button_disabled');
      }
    }
  }, {
    key: "handleClickTrash",
    value: function handleClickTrash(event) {
      event.preventDefault();
      var id = this.value.attr('id');
      this.value.html(0);
      this.toggleShowField(false);
      this.product.removeProductFromCart(id);
    }
  }, {
    key: "toggleShowField",
    value: function toggleShowField(show) {
      if (show) {
        this.elementDOM.show();
      } else {
        this.elementDOM.hide();
      }
    }
  }, {
    key: "handleShowPlus",
    value: function handleShowPlus(show) {
      if (show) {
        this.plus.addClass('visible');
      } else {
        this.plus.removeClass('visible');
      }
    }
  }, {
    key: "handleShowMinus",
    value: function handleShowMinus(show) {
      if (show) {
        this.minus.addClass('visible');
      } else {
        this.minus.removeClass('visible');
      }
    }
  }, {
    key: "handleShowTrash",
    value: function handleShowTrash(show) {
      if (show) {
        this.trash.addClass('visible');
      } else {
        this.trash.removeClass('visible');
      }
    }
  }, {
    key: "setId",
    value: function setId(id) {
      this.value.attr('id', id);
    }
  }, {
    key: "getId",
    value: function getId() {
      return this.value.attr('id');
    }
  }]);
}();

;// ./assets/js/src/modals/abstract-product.js
function abstract_product_typeof(o) { "@babel/helpers - typeof"; return abstract_product_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, abstract_product_typeof(o); }
function abstract_product_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function abstract_product_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, abstract_product_toPropertyKey(o.key), o); } }
function abstract_product_createClass(e, r, t) { return r && abstract_product_defineProperties(e.prototype, r), t && abstract_product_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function abstract_product_toPropertyKey(t) { var i = abstract_product_toPrimitive(t, "string"); return "symbol" == abstract_product_typeof(i) ? i : i + ""; }
function abstract_product_toPrimitive(t, r) { if ("object" != abstract_product_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != abstract_product_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var YWDPD_AbstractProduct = /*#__PURE__*/function () {
  function YWDPD_AbstractProduct(element, globalList) {
    abstract_product_classCallCheck(this, YWDPD_AbstractProduct);
    /**
     *  Properties get from dom
     *
     * @type {*|jQuery}
     */
    this.elementDOM = element;
    this.globalList = globalList;
    this.productID = this.elementDOM.data('product_id');
    this.variationID = 0;
    this.variations = {};
    this.type = this.elementDOM.data('product_type');
    this.discountType = this.elementDOM.data('discount_type');
    this.discountValue = this.elementDOM.data('discount_amount');
    this.totalToAdd = this.elementDOM.data('total_to_add');
    this.addToCartButton = this.elementDOM.find('.single_add_to_cart_button');
    this.badge = this.elementDOM.find('.ywdpd_image_badge');
    this.qtyInputFields = [];
    this._initQtyInput();

    // Events
    this.addToCartButton.on('click', this.handleAddToCart.bind(this));
  }
  return abstract_product_createClass(YWDPD_AbstractProduct, [{
    key: "_initQtyInput",
    value: function _initQtyInput() {
      var fields = this.elementDOM.find('.ywdpd_qty_field'),
        min = this.elementDOM.find('.ywdpd_qty_fields_container').data('min'),
        max = this.elementDOM.find('.ywdpd_qty_fields_container').data('max'),
        self = this;
      fields.each(function () {
        var key = self.globalList.generateKey(self.productID, 1, self.variationID, self.variations);
        self.qtyInputFields.push(new QuantityInput(jQuery(this), key, min, max, self, false));
      });
    }
  }, {
    key: "setAddedToCart",
    value: function setAddedToCart(value) {
      this.addedToCart = value;
      this.elementDOM.trigger('ywdpd-added-to-cart');
    }
  }, {
    key: "showQtyField",
    value: function showQtyField(key) {
      if ('variable' !== this.type) {
        this.addToCartButton.hide();
      }
      var qty = false;
      jQuery.each(this.qtyInputFields, function (index, qtyInputField) {
        if ('' + qtyInputField.getId() === '' + key) {
          qty = qtyInputField;
          return false;
        }
      });
      if (qty) {
        qty.toggleShowField(true);
        qty.plus.trigger('click');
      }
    }
  }, {
    key: "removeProductFromCart",
    value: function removeProductFromCart(key) {
      this.addToCartButton.show();
      this.hideBadge();
      this.globalList.removeProductInList(key);
      this.globalList.disableAllAddToCart(false);
      this.globalList.disableAllPlusButton(false);
      this.globalList.maybeHideConfirmButton();
    }
  }, {
    key: "hideBadge",
    value: function hideBadge() {
      this.badge.hide();
    }
  }, {
    key: "handleAddToCart",
    value: function handleAddToCart(event) {
      event.preventDefault();
      this.badge.show();
    }
  }]);
}();

;// ./assets/js/src/modals/simple-product.js
function simple_product_typeof(o) { "@babel/helpers - typeof"; return simple_product_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, simple_product_typeof(o); }
function simple_product_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function simple_product_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, simple_product_toPropertyKey(o.key), o); } }
function simple_product_createClass(e, r, t) { return r && simple_product_defineProperties(e.prototype, r), t && simple_product_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function simple_product_toPropertyKey(t) { var i = simple_product_toPrimitive(t, "string"); return "symbol" == simple_product_typeof(i) ? i : i + ""; }
function simple_product_toPrimitive(t, r) { if ("object" != simple_product_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != simple_product_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == simple_product_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }

var YWDPD_SimpleProduct = /*#__PURE__*/function (_YWDPD_AbstractProduc) {
  function YWDPD_SimpleProduct() {
    simple_product_classCallCheck(this, YWDPD_SimpleProduct);
    return _callSuper(this, YWDPD_SimpleProduct, arguments);
  }
  _inherits(YWDPD_SimpleProduct, _YWDPD_AbstractProduc);
  return simple_product_createClass(YWDPD_SimpleProduct, [{
    key: "handleAddToCart",
    value: function handleAddToCart(event) {
      var key = this.globalList.addProductInList(this.productID);
      if (this.globalList.canShowQtyFields()) {
        this.showQtyField(key);
        this.globalList.showConfirmButton(true);
      } else {
        this.globalList.confirmButton.click();
      }
      _superPropGet(YWDPD_SimpleProduct, "handleAddToCart", this, 3)([event]);
    }
  }]);
}(YWDPD_AbstractProduct);

;// ./assets/js/src/modals/variable-product.js
function variable_product_typeof(o) { "@babel/helpers - typeof"; return variable_product_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, variable_product_typeof(o); }
function variable_product_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function variable_product_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, variable_product_toPropertyKey(o.key), o); } }
function variable_product_createClass(e, r, t) { return r && variable_product_defineProperties(e.prototype, r), t && variable_product_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function variable_product_toPropertyKey(t) { var i = variable_product_toPrimitive(t, "string"); return "symbol" == variable_product_typeof(i) ? i : i + ""; }
function variable_product_toPrimitive(t, r) { if ("object" != variable_product_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != variable_product_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function variable_product_callSuper(t, o, e) { return o = variable_product_getPrototypeOf(o), variable_product_possibleConstructorReturn(t, variable_product_isNativeReflectConstruct() ? Reflect.construct(o, e || [], variable_product_getPrototypeOf(t).constructor) : o.apply(t, e)); }
function variable_product_possibleConstructorReturn(t, e) { if (e && ("object" == variable_product_typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return variable_product_assertThisInitialized(t); }
function variable_product_assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function variable_product_isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (variable_product_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function variable_product_superPropGet(t, o, e, r) { var p = variable_product_get(variable_product_getPrototypeOf(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
function variable_product_get() { return variable_product_get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = variable_product_superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, variable_product_get.apply(null, arguments); }
function variable_product_superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = variable_product_getPrototypeOf(t));); return t; }
function variable_product_getPrototypeOf(t) { return variable_product_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, variable_product_getPrototypeOf(t); }
function variable_product_inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && variable_product_setPrototypeOf(t, e); }
function variable_product_setPrototypeOf(t, e) { return variable_product_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, variable_product_setPrototypeOf(t, e); }


var YWDPD_VariableProduct = /*#__PURE__*/function (_YWDPD_AbstractProduc) {
  function YWDPD_VariableProduct(element, globalList) {
    var _this;
    variable_product_classCallCheck(this, YWDPD_VariableProduct);
    _this = variable_product_callSuper(this, YWDPD_VariableProduct, [element, globalList]);
    _this.variationID = 0;
    _this.elementDOM.on('ywdpd_step2_initialized', _this.initializeVariationForm.bind(_this));
    return _this;
  }
  variable_product_inherits(YWDPD_VariableProduct, _YWDPD_AbstractProduc);
  return variable_product_createClass(YWDPD_VariableProduct, [{
    key: "handleAddToCart",
    value: function handleAddToCart(event) {
      event.preventDefault();
      var ruleType = this.addToCartButton.data('ywdpd_action');
      var data = {
        product_id: this.productID,
        rule_id: this.globalList.modal.ruleID,
        rule_type: ruleType,
        action: ywdpd_popup_args.actions.show_second_step,
        security: ywdpd_popup_args.nonces.show_second_step
      };
      var self = this;
      jQuery.ajax({
        type: 'POST',
        url: ywdpd_popup_args.ajax_url,
        data: data,
        dataType: 'json',
        beforeSend: function beforeSend() {
          self.elementDOM.parents('.ywdpd_single_rule_container').block(self.globalList.block_params);
        },
        success: function success(response) {
          if (response.template !== '') {
            // go_to_step2( response.template );
            self.globalList.goToStepTwo(response.template, self);
          }
        },
        complete: function complete() {
          self.elementDOM.parents('.ywdpd_single_rule_container').unblock();
        }
      });
    }
  }, {
    key: "hideBadge",
    value: function hideBadge() {
      if (this.elementDOM.find('.ywdpd_qty_fields_container .ywdpd_qty_field').length === 0) {
        variable_product_superPropGet(YWDPD_VariableProduct, "hideBadge", this, 3)([]);
      }
    }
  }, {
    key: "resetQtyInput",
    value: function resetQtyInput(qtyInputDOM, qtyInput) {
      qtyInputDOM.remove();
    }
  }, {
    key: "initializeVariationForm",
    value: function initializeVariationForm(event) {
      event.stopImmediatePropagation();
      var variationForm = this.globalList.elementDOM.find('.variations_form.cart');
      var self = this;
      variationForm.on('found_variation', function (e, variation) {
        var form = jQuery(this);
        var data = {
          ywdp_check_rule_id: self.ruleID,
          product_id: self.productID,
          rule_type: self.globalList.elementDOM.find('input.ywdpd_rule_type').val(),
          type_discount: self.discountType,
          amount_discount: self.discountValue,
          tot_to_add: self.totalToAdd,
          action: ywdpd_popup_args.actions.check_variable,
          security: ywdpd_popup_args.nonces.check_variable
        };
        jQuery.ajax({
          type: 'POST',
          url: ywdpd_popup_args.ajax_url,
          data: data,
          dataType: 'json',
          beforeSend: function beforeSend() {
            form.block(self.globalList.block_params);
          },
          success: function success(response) {
            if (!response.variation_found) {
              self.variationID = variation.variation_id;
              if (variation.is_in_stock) {
                self.globalList.elementDOM.find('.ywdpd_add_to_gift').removeClass('disabled');
                self.globalList.elementDOM.find('.ywdpdp_single_product p.stock.out-of-stock').remove();
              } else {
                // eslint-disable-next-line max-len
                self.globalList.elementDOM.find('.ywdpdp_single_product .variations_form.cart').append(variation.availability_html);
                self.globalList.elementDOM.find('.ywdpd_add_to_gift').addClass('disabled');
              }
            } else {
              self.variationID = 0;
              self.variations = {};
              self.globalList.elementDOM.find('.ywdpd_add_to_gift').addClass('disabled');
            }
            self.globalList.elementDOM.find('.ywdpd_step2 .price').html(response.price);
            self.globalList.elementDOM.find('.ywdpd_step2 .price').show();
          },
          complete: function complete() {
            form.unblock();
          }
        });
      }).on('reset_data', function () {
        self.globalList.elementDOM.find('.ywdpd_add_to_gift').addClass('disabled');
        self.globalList.elementDOM.find('.ywdpdp_single_product p.stock.out-of-stock').remove();
        self.globalList.elementDOM.find('.ywdpd_step2 .price').hide();
      });
      self.globalList.elementDOM.find('.ywdpd_add_to_gift').on('click', self.handleSaveOptions.bind(self));
    }
  }, {
    key: "getVariations",
    value: function getVariations() {
      var button = this.globalList.elementDOM.find('.ywdpd_add_to_gift'),
        container = button.closest('.ywdpd_single_product_right'),
        variations = container.find('[name^="attribute"]'),
        var_items = {};
      variations.each(function () {
        var t = jQuery(this),
          name = t.attr('name');
        var_items[name] = t.val();
      });
      return var_items;
    }
  }, {
    key: "getVariationHtml",
    value: function getVariationHtml(variations) {
      var button = this.globalList.elementDOM.find('.ywdpd_add_to_gift'),
        html = '',
        container = button.closest('.ywdpd_single_product_right');
      jQuery.each(variations, function (name, value) {
        var field = container.find('[name ="' + name + '"]'),
          label = container.find('label[for="' + field.attr('id') + '"]');
        html += '<div class="ywdpd_single_attribute">';
        html += "<span class='attribute_name'>" + label.html() + ':</span>';
        html += "<span class='attribute_value'>" + value + '</span>';
        html += '</div>';
      });
      return html;
    }
  }, {
    key: "addNewQtyField",
    value: function addNewQtyField(productContainer, key, variations) {
      var qtyTemplate = wp.template('ywdpd-popup-quantity-field');
      var variations_html = this.getVariationHtml(variations);
      var newQtyField = jQuery(qtyTemplate());
      var divAttributes = jQuery('<div class="ywdpd_attribute_fields"></div>');
      var qtyContainer = productContainer.find('.ywdpd_qty_fields_container');
      divAttributes.html(variations_html);
      divAttributes.insertAfter(newQtyField.find('.ywdpd_qty_label'));
      newQtyField.appendTo(qtyContainer).show();
      this.qtyInputFields.push(new QuantityInput(newQtyField, key, qtyContainer.data('min'), qtyContainer.data('max'), this, true));
      this.showQtyField(key);
    }
  }, {
    key: "handleSaveOptions",
    value: function handleSaveOptions(event) {
      event.preventDefault();
      if (!jQuery(event.target).hasClass('disabled')) {
        var productContainer = this.globalList.elementDOM.find("li.item[data-product_id='" + this.productID + "']"),
          variations = this.getVariations(),
          key = this.globalList.addProductInList(this.productID, 1, this.variationID, variations),
          qty_field = this.elementDOM.find('#' + key + '.ywdpd_qty');
        if (!qty_field.length) {
          //Create new list
          this.addNewQtyField(productContainer, key, variations);
          this.globalList.showConfirmButton(true);
          this.badge.show();
        } else {
          qty_field.parent().find('.ywdpd_qty_increase').click();
        }
        this.globalList.backToStepOne();
      }
    }
  }]);
}(YWDPD_AbstractProduct);

;// ./assets/js/src/modals/gift-products.js
function gift_products_typeof(o) { "@babel/helpers - typeof"; return gift_products_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, gift_products_typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = gift_products_toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function gift_products_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function gift_products_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, gift_products_toPropertyKey(o.key), o); } }
function gift_products_createClass(e, r, t) { return r && gift_products_defineProperties(e.prototype, r), t && gift_products_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function gift_products_toPropertyKey(t) { var i = gift_products_toPrimitive(t, "string"); return "symbol" == gift_products_typeof(i) ? i : i + ""; }
function gift_products_toPrimitive(t, r) { if ("object" != gift_products_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != gift_products_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var YWDPD_GiftProducts = /*#__PURE__*/function () {
  function YWDPD_GiftProducts(element, modal) {
    gift_products_classCallCheck(this, YWDPD_GiftProducts);
    this.elementDOM = element;
    this.modal = modal;
    this.itemsAllowed = this.elementDOM.find('.ywdpd_single_rule_container').data('allowed_items');
    this.maxUnits = this.elementDOM.find('.ywdpd_single_rule_container').data('max_units');
    this.confirmButton = this.elementDOM.find('.ywdpd_btn_container');
    this.products = this._initProducts();
    this.block_params = {
      message: null,
      overlayCSS: {
        background: '#fff',
        opacity: 0.6
      },
      ignoreIfBlocked: true
    };
    this.productInList = [];
    this.elementDOM.find('.ywdpd_step2').on('select2:open', function () {
      jQuery('.select2-container').addClass('ywcdd_select2');
    }).on('select2:closing', function () {
      jQuery('.select2-container').removeClass('ywcdd_select2');
    });
    jQuery(document).find('.ywdpd_qty_arrows, .single_add_to_cart_button').on('touchstart mousedown', function (e) {
      // Prevent carousel swipe.

      e.stopImmediatePropagation();
    });
    this.confirmButton.on('click', this.handleConfirmClick.bind(this));
  }
  return gift_products_createClass(YWDPD_GiftProducts, [{
    key: "_initProducts",
    value: function _initProducts() {
      var productsObj = [];
      var products = this.elementDOM.find('.ywdpd_popup_items li.product');
      var globalList = this;
      products.each(function (index) {
        var productID = jQuery(this).data('product_id');
        var productType = jQuery(this).data('product_type');
        if (productType !== 'variable') {
          productsObj[productID] = new YWDPD_SimpleProduct(jQuery(this), globalList);
        } else {
          productsObj[productID] = new YWDPD_VariableProduct(jQuery(this), globalList);
        }
      });
      return productsObj;
    }
  }, {
    key: "_hashCode",
    value: function _hashCode(s) {
      var h = 0,
        i = s.length;
      while (i > 0) {
        // eslint-disable-next-line no-bitwise
        h = (h << 5) - h + s.charCodeAt(--i) | 0;
      }
      return h;
    }
  }, {
    key: "getTotalAdded",
    value: function getTotalAdded() {
      var qty_fields = this.elementDOM.find('li.product.item .ywdpd_qty');
      var total = 0;
      qty_fields.each(function () {
        var qty = jQuery(this).html();
        qty = '' === qty ? 0 : parseInt(qty);
        total = total + qty;
      });
      return total;
    }
  }, {
    key: "itemsAllowed",
    get: function get() {
      return this._itemsAllowed;
    },
    set: function set(items) {
      this._itemsAllowed = items;
    }
  }, {
    key: "disableAllAddToCart",
    value: function disableAllAddToCart(disabled) {
      if (disabled) {
        this.elementDOM.find('.single_add_to_cart_button').addClass('ywdpd_button_disabled');
      } else {
        this.elementDOM.find('.single_add_to_cart_button').removeClass('ywdpd_button_disabled');
      }
    }
  }, {
    key: "disableAllPlusButton",
    value: function disableAllPlusButton(disabled) {
      if (disabled) {
        this.elementDOM.find('.ywdpd_qty_increase').addClass('ywdpd_button_disabled');
      } else {
        this.elementDOM.find('.ywdpd_qty_increase').removeClass('ywdpd_button_disabled');
      }
    }
  }, {
    key: "disableAllMinusButton",
    value: function disableAllMinusButton(disabled) {
      if (disabled) {
        this.elementDOM.find('.ywdpd_qty_decrease').addClass('ywdpd_button_disabled');
      } else {
        this.elementDOM.find('.ywdpd_qty_decrease').removeClass('ywdpd_button_disabled');
      }
    }
  }, {
    key: "showConfirmButton",
    value: function showConfirmButton(show) {
      if (show) {
        this.confirmButton.show();
      } else {
        this.confirmButton.hide();
      }
    }
  }, {
    key: "maybeHideConfirmButton",
    value: function maybeHideConfirmButton() {
      if (this.getTotalAdded() === 0) {
        this.showConfirmButton(false);
      }
    }
  }, {
    key: "isProductInList",
    value: function isProductInList(key) {
      var productFound = this.productInList.filter(function (product) {
        return '' + product.key === '' + key;
      }).shift();
      return productFound;
    }
  }, {
    key: "addProductInList",
    value: function addProductInList(productID) {
      var qty = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var variationID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var variations = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var key = this.generateKey(productID, qty, variationID, variations);
      if (!this.isProductInList(key)) {
        var obj = {
          key: key,
          product_id: productID,
          variation_id: variationID,
          variations: variations,
          quantity: qty
        };
        this.productInList.push(obj);
      }
      this.maybeDisableMoreAdd();
      return key;
    }
  }, {
    key: "generateKey",
    value: function generateKey(productID) {
      var qty = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var variationID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
      var variations = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      return this._hashCode("".concat(productID, "_").concat(variationID, "_").concat(JSON.stringify(variations)));
    }
  }, {
    key: "updateProductInList",
    value: function updateProductInList(key, qty) {
      var newList = this.productInList.map(function (product) {
        var newProduct = _objectSpread({}, product);
        if ('' + newProduct.key === key) {
          newProduct.quantity = qty;
        }
        return newProduct;
      });
      this.productInList = newList;
      this.maybeDisableMoreAdd();
    }
  }, {
    key: "maybeDisableMoreAdd",
    value: function maybeDisableMoreAdd() {
      if (this.modal.mode === 'total_product') {
        var disabled = this.getTotalAdded() >= this.itemsAllowed;
        this.disableAllAddToCart(disabled);
        this.disableAllPlusButton(disabled);
      } else {
        var totalProductInList = this.productInList.length;
        var _disabled = totalProductInList === this.itemsAllowed;
        this.disableAllAddToCart(_disabled);
      }
    }
  }, {
    key: "canShowQtyFields",
    value: function canShowQtyFields() {
      return this.modal.mode === 'total_product' && this.itemsAllowed > 1 || this.modal.mode === 'unit_product';
    }
  }, {
    key: "removeProductInList",
    value: function removeProductInList(key) {
      var newList = this.productInList.filter(function (product) {
        return '' + product.key !== key;
      });
      this.productInList = newList;
    }
  }, {
    key: "handleBackButton",
    value: function handleBackButton(event) {
      event.preventDefault();
      this.backToStepOne();
    }
  }, {
    key: "backToStepOne",
    value: function backToStepOne() {
      var self = this;
      self.elementDOM.find('.ywdpd_step2').fadeOut(300, function () {
        self.elementDOM.find('.ywdpd_step1').fadeIn(300);
        self.elementDOM.find('.ywdpd_step2').html('');
      });
    }
  }, {
    key: "goToStepTwo",
    value: function goToStepTwo(template, caller) {
      var self = this;
      this.elementDOM.find('.ywdpd_step1').fadeOut(300, function () {
        self.elementDOM.find('.ywdpd_step2').html(template);
        self.elementDOM.find('.ywdpd_step2 .variations_form').each(function () {
          jQuery(this).wc_variation_form();
        });
        self.elementDOM.find('.ywdpd_step2').fadeIn(300, function () {
          var backButton = self.elementDOM.find('.ywdpd_back');
          backButton.on('click', self.handleBackButton.bind(self));
          caller.elementDOM.trigger('ywdpd_step2_initialized');
        });
      });
    }
  }, {
    key: "handleConfirmClick",
    value: function handleConfirmClick(event) {
      event.preventDefault();
      var container = this.elementDOM.find('.ywdpd_single_rule_container');
      var product_added_with_qty_by_rule = {};
      product_added_with_qty_by_rule[this.modal.ruleID] = this.productInList;
      var ajaxAction,
        ajaxNonces = '';
      if (container.hasClass('gift_products')) {
        ajaxAction = ywdpd_popup_args.actions.add_gift_to_cart;
        ajaxNonces = ywdpd_popup_args.nonces.add_gift_to_cart;
      } else if (container.hasClass('special_offer')) {
        ajaxAction = ywdpd_popup_args.actions.add_special_to_cart;
        ajaxNonces = ywdpd_popup_args.nonces.add_special_to_cart;
      } else if (container.hasClass('last_deals')) {
        ajaxAction = ywdpd_popup_args.actions.add_last_deals;
        ajaxNonces = ywdpd_popup_args.nonces.add_last_deals;
      }
      if (ajaxAction !== '') {
        var data = {
          rules_to_apply: product_added_with_qty_by_rule,
          action: ajaxAction,
          security: ajaxNonces
        };
        var self = this;
        jQuery.ajax({
          type: 'POST',
          url: ywdpd_popup_args.ajax_url,
          data: data,
          dataType: 'json',
          beforeSend: function beforeSend() {
            self.elementDOM.block(self.block_params);
          },
          success: function success(response) {
            setTimeout(function () {
              if (typeof response.fragments !== 'undefined') {
                jQuery(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash]);
              }
            }, 1000);
          },
          complete: function complete() {
            self.elementDOM.unblock();
            self.modal.close(true);
            jQuery(document.body).trigger('gift_added_to_cart');
          }
        });
      }
    }
  }]);
}();

// EXTERNAL MODULE: ./node_modules/chalk/source/index.js
var source = __webpack_require__(248);
;// ./assets/js/src/modals/ywdpd-modal.js
function ywdpd_modal_typeof(o) { "@babel/helpers - typeof"; return ywdpd_modal_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ywdpd_modal_typeof(o); }
function ywdpd_modal_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function ywdpd_modal_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, ywdpd_modal_toPropertyKey(o.key), o); } }
function ywdpd_modal_createClass(e, r, t) { return r && ywdpd_modal_defineProperties(e.prototype, r), t && ywdpd_modal_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function ywdpd_modal_toPropertyKey(t) { var i = ywdpd_modal_toPrimitive(t, "string"); return "symbol" == ywdpd_modal_typeof(i) ? i : i + ""; }
function ywdpd_modal_toPrimitive(t, r) { if ("object" != ywdpd_modal_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != ywdpd_modal_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var YWDPD_MODAL = /*#__PURE__*/function () {
  function YWDPD_MODAL(popupContainer) {
    ywdpd_modal_classCallCheck(this, YWDPD_MODAL);
    this.elementDOM = popupContainer;
    this.noThanksButton = this.elementDOM.find('.ywdpd_footer a');
    this.closeButton = this.elementDOM.find('.ywdpd_close');
    this.countdown = '';
    this._initModal();
    this.noThanksButton.on('click', this.handleNoThanks.bind(this));
    this.closeButton.on('click', this.handleClose.bind(this));
    jQuery(window).on('resize', this.handleCenterModal.bind(this));
  }
  return ywdpd_modal_createClass(YWDPD_MODAL, [{
    key: "_initModal",
    value: function _initModal() {
      var container = this.elementDOM.find('.ywdpd_single_rule_container');
      var wrapper = this.elementDOM.find('.ywdpd_popup_wrapper');
      this.ruleID = wrapper.data('rule_id');
      this.mode = wrapper.data('mode');
      this.countdown = container.data('countdown');
      this._initSlider();
      this._initElements();
      if (this.countdown !== '') {
        this._initCountdown();
      }
    }
  }, {
    key: "_initSlider",
    value: function _initSlider() {
      var max_items = 3,
        sliders = this.elementDOM.find('.ywdpd_popup_stage');
      sliders.each(function () {
        var slider = jQuery(this).find('.owl-carousel'),
          item = parseInt(slider.find('li').length),
          autoWidth = true,
          margin = 30,
          center = false,
          nav = true,
          ul = jQuery(this).find('ul.ywdpd_popup_items');
        item = item > max_items ? max_items : item;
        if (item > 1) {
          if (item >= 3) {
            ul.css({
              'padding-left': '5px'
            });
          } else {
            ul.css({
              'padding-left': '30px'
            });
          }
          slider.owlCarousel({
            loop: false,
            margin: margin,
            center: center,
            autoWidth: autoWidth,
            nav: nav,
            rtl: false,
            navText: ['<span></span>', '<span></span>'],
            responsiveClass: true,
            onInitialized: function onInitialized(e) {
              var count = e.item.count;
              if (count > 1) {
                ul.find('.owl-stage').css({
                  margin: '0 auto'
                });
              }
            },
            responsive: {
              0: {
                items: ywdpd_popup_args.number_of_items_slider_mobile > 0 ? ywdpd_popup_args.number_of_items_slider_mobile : 1,
                autoWidth: false,
                margin: 10
              },
              721: {
                items: item
              },
              1000: {
                items: item
              }
            }
          });
        } else {
          ul.addClass('ywdpd_one_item');
        }
      });
    }
  }, {
    key: "_initElements",
    value: function _initElements() {
      new YWDPD_GiftProducts(this.elementDOM.find('.ywdpd_popup_content'), this);
    }
  }, {
    key: "_center",
    value: function _center() {
      var popup_wrapper = this.elementDOM.find('.ywdpd_popup_wrapper');
      var rules = popup_wrapper.find('.ywdpd_single_rule_container'),
        max_width = 715,
        current_width = popup_wrapper.css('width'),
        w,
        h = popup_wrapper.outerHeight(),
        W = this.elementDOM.width(),
        H = this.elementDOM.height(),
        screen_width = this.elementDOM.width();
      var top, left;
      if (!popup_wrapper.hasClass('full')) {
        if (screen_width > 720) {
          rules.each(function () {
            var li = jQuery(this).find('ul li'),
              amount_li = li.length;
            if (amount_li >= 3) {
              current_width = max_width;
            } else {
              current_width = 438;
            }
          });
        } else {
          current_width = current_width.replace('px', '');
          current_width = parseFloat(current_width);
        }
        w = current_width;
        if (jQuery('#wpadminbar').length) {
          h = h - jQuery('#wpadminbar').height() - 10;
        }
        top = (H - h) / 2;
        left = (W - w) / 2;
      } else {
        top = 0;
        left = 0;
        popup_wrapper.find('.ywdpd_popup_general_content').css({
          height: 'calc( ' + h + 'px - 60px )'
        });
      }
      popup_wrapper.css({
        position: 'fixed',
        top: top + 'px',
        // '15%',
        left: left + 'px'
      });
    }
  }, {
    key: "_initCountdown",
    value: function _initCountdown() {
      var container = this.elementDOM.find('.ywdpd_single_rule_container');
      if (this.countdown !== '') {
        var config = this.countdown.split(',');
        var minutes = config[1] === 'minutes' ? config[0] : 0;
        var seconds = config[1] === 'seconds' ? config[0] : 0;
        minutes = minutes >= 10 ? minutes : '0' + minutes;
        seconds = seconds >= 10 ? seconds : '0' + seconds;
        var countdownDiv = jQuery('<div class="ywdpd_countdown"><i class="ywdpd-icon-time-check"></i><div class="ywdpd_timer"></div>');
        countdownDiv.insertAfter(container.find('.ywdpd_rule_title'));
        this.elementDOM.find('.ywdpd_timer').html(minutes + ':' + seconds);
        this.elementDOM.find('.ywdpd_countdown').css('display', 'flex');
      }
    }
  }, {
    key: "show",
    value: function show() {
      var element = this;
      setTimeout(function () {
        element.elementDOM.fadeIn(300);
        element._center();
        element.startCountDown();
        jQuery(document).trigger('ywdpd_popup_ready', [element]);
      }, 900);
    }
  }, {
    key: "startCountDown",
    value: function startCountDown() {
      if (this.countdown !== '') {
        var config = this.countdown.split(',');
        var countDownMinutes = config[1] === 'seconds' ? 0 : parseInt(config[0]);
        var countDownSeconds = config[1] === 'seconds' ? parseInt(config[0]) : 0;
        var countDownDate = false;
        var self = this;
        if ('minutes' === config[1]) {
          countDownDate = new Date(new Date().getTime() + countDownMinutes * 60000);
        } else {
          countDownDate = new Date(new Date().getTime() + countDownSeconds * 1000);
        }
        var x = setInterval(function () {
          var now = new Date().getTime();
          // Find the distance between now and the countdown date
          var distance = countDownDate.getTime() - now;
          var minutes = Math.floor(distance % (1000 * 60 * 60) / (1000 * 60));
          var seconds = Math.floor(distance % (1000 * 60) / 1000);
          minutes = minutes >= 10 ? minutes : '0' + minutes;
          seconds = seconds >= 10 ? seconds : '0' + seconds;
          self.elementDOM.find('.ywdpd_timer').html(minutes + ':' + seconds);
          if (distance < 0) {
            clearInterval(x);
            self.close();
          }
        }, 1000);
      }
    }
  }, {
    key: "close",
    value: function close(with_changes) {
      with_changes = typeof with_changes !== 'undefined' ? with_changes : false;
      this.elementDOM.fadeOut(300).remove();
      if (with_changes) {
        if (this.elementDOM.hasClass('cart')) {
          jQuery(document).trigger('wc_update_cart');
        } else if (this.elementDOM.hasClass('checkout')) {
          jQuery(document.body).trigger('update_checkout');
        }
      }
      if ('yes' === ywdpd_popup_args.reload_after_ajax_add_to_cart) {
        location.reload(true);
      }
      jQuery(document).trigger('ywdpd_popup_closed');
    }
  }, {
    key: "handleNoThanks",
    value: function handleNoThanks(event) {
      event.preventDefault();
      this.close();
    }
  }, {
    key: "handleClose",
    value: function handleClose(event) {
      event.preventDefault();
      this.close();
    }
  }, {
    key: "handleCenterModal",
    value: function handleCenterModal() {
      this._center();
    }
  }]);
}();

;// ./node_modules/js-cookie/dist/js.cookie.mjs
/*! js-cookie v3.0.5 | MIT */
/* eslint-disable no-var */
function js_cookie_assign (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];
    for (var key in source) {
      target[key] = source[key];
    }
  }
  return target
}
/* eslint-enable no-var */

/* eslint-disable no-var */
var defaultConverter = {
  read: function (value) {
    if (value[0] === '"') {
      value = value.slice(1, -1);
    }
    return value.replace(/(%[\dA-F]{2})+/gi, decodeURIComponent)
  },
  write: function (value) {
    return encodeURIComponent(value).replace(
      /%(2[346BF]|3[AC-F]|40|5[BDE]|60|7[BCD])/g,
      decodeURIComponent
    )
  }
};
/* eslint-enable no-var */

/* eslint-disable no-var */

function init (converter, defaultAttributes) {
  function set (name, value, attributes) {
    if (typeof document === 'undefined') {
      return
    }

    attributes = js_cookie_assign({}, defaultAttributes, attributes);

    if (typeof attributes.expires === 'number') {
      attributes.expires = new Date(Date.now() + attributes.expires * 864e5);
    }
    if (attributes.expires) {
      attributes.expires = attributes.expires.toUTCString();
    }

    name = encodeURIComponent(name)
      .replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent)
      .replace(/[()]/g, escape);

    var stringifiedAttributes = '';
    for (var attributeName in attributes) {
      if (!attributes[attributeName]) {
        continue
      }

      stringifiedAttributes += '; ' + attributeName;

      if (attributes[attributeName] === true) {
        continue
      }

      // Considers RFC 6265 section 5.2:
      // ...
      // 3.  If the remaining unparsed-attributes contains a %x3B (";")
      //     character:
      // Consume the characters of the unparsed-attributes up to,
      // not including, the first %x3B (";") character.
      // ...
      stringifiedAttributes += '=' + attributes[attributeName].split(';')[0];
    }

    return (document.cookie =
      name + '=' + converter.write(value, name) + stringifiedAttributes)
  }

  function get (name) {
    if (typeof document === 'undefined' || (arguments.length && !name)) {
      return
    }

    // To prevent the for loop in the first place assign an empty array
    // in case there are no cookies at all.
    var cookies = document.cookie ? document.cookie.split('; ') : [];
    var jar = {};
    for (var i = 0; i < cookies.length; i++) {
      var parts = cookies[i].split('=');
      var value = parts.slice(1).join('=');

      try {
        var found = decodeURIComponent(parts[0]);
        jar[found] = converter.read(value, found);

        if (name === found) {
          break
        }
      } catch (e) {}
    }

    return name ? jar[name] : jar
  }

  return Object.create(
    {
      set,
      get,
      remove: function (name, attributes) {
        set(
          name,
          '',
          js_cookie_assign({}, attributes, {
            expires: -1
          })
        );
      },
      withAttributes: function (attributes) {
        return init(this.converter, js_cookie_assign({}, this.attributes, attributes))
      },
      withConverter: function (converter) {
        return init(js_cookie_assign({}, this.converter, converter), this.attributes)
      }
    },
    {
      attributes: { value: Object.freeze(defaultAttributes) },
      converter: { value: Object.freeze(converter) }
    }
  )
}

var api = init(defaultConverter, { path: '/' });
/* eslint-enable no-var */



;// ./assets/js/src/modals/modal-manager.js
function modal_manager_typeof(o) { "@babel/helpers - typeof"; return modal_manager_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, modal_manager_typeof(o); }
function modal_manager_classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function modal_manager_defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, modal_manager_toPropertyKey(o.key), o); } }
function modal_manager_createClass(e, r, t) { return r && modal_manager_defineProperties(e.prototype, r), t && modal_manager_defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function modal_manager_toPropertyKey(t) { var i = modal_manager_toPrimitive(t, "string"); return "symbol" == modal_manager_typeof(i) ? i : i + ""; }
function modal_manager_toPrimitive(t, r) { if ("object" != modal_manager_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != modal_manager_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

// eslint-disable-next-line import/no-extraneous-dependencies

var YWDPD_Modal_Manager = /*#__PURE__*/function () {
  function YWDPD_Modal_Manager() {
    modal_manager_classCallCheck(this, YWDPD_Modal_Manager);
    this._initModals();
    this.showModal();
    jQuery(document).on('ywdpd_popup_ready', this.setModalAsVisited.bind(this));
    jQuery(document).on('ywdpd_popup_closed', this.showModal.bind(this));
    jQuery(document.body).on('updated_wc_div', this.getNewCartModals.bind(this));
    jQuery(document.body).on('added_to_cart', this.getNewShopModals.bind(this));
  }
  return modal_manager_createClass(YWDPD_Modal_Manager, [{
    key: "_initModals",
    value: function _initModals() {
      var modals = jQuery(document).find('.ywdpd_popup');
      var modalsObj = [];
      modals.each(function () {
        modalsObj.push(new YWDPD_MODAL(jQuery(this)));
      });
      this.modalsObj = modalsObj.reverse();
    }
  }, {
    key: "setModalAsVisited",
    value: function setModalAsVisited(e, modal) {
      var oldValues = api.get('yith_ywdpd_modal_rule');
      if (typeof oldValues === 'undefined') {
        oldValues = [];
      } else {
        oldValues = JSON.parse(oldValues);
      }
      oldValues.push(modal.ruleID);
      api.set('yith_ywdpd_modal_rule', JSON.stringify(oldValues), {
        path: '/',
        expires: 1
      });
    }
  }, {
    key: "showModal",
    value: function showModal() {
      if (this.modalsObj.length) {
        var currentModal = this.modalsObj.pop();
        setTimeout(function () {
          currentModal.show();
        }, 500);
      }
    }
  }, {
    key: "getNewCartModals",
    value: function getNewCartModals() {
      var data = {
        action: ywdpd_popup_args.actions.update_gift_popup,
        security: ywdpd_popup_args.nonces.update_gift_popup
      };
      var self = this;
      jQuery.ajax({
        type: 'POST',
        url: ywdpd_popup_args.ajax_url,
        data: data,
        dataType: 'json',
        success: function success(response) {
          if ('' !== response.popup) {
            jQuery(document.body).append(jQuery(response.popup));
            self._initModals();
            self.showModal();
          }
        }
      });
    }
  }, {
    key: "getNewShopModals",
    value: function getNewShopModals() {
      var data = {
        action: ywdpd_popup_args.actions.show_popup_on_shop,
        security: ywdpd_popup_args.nonces.show_popup_on_shop
      };
      var self = this;
      jQuery.ajax({
        type: 'POST',
        url: ywdpd_popup_args.ajax_url,
        data: data,
        dataType: 'json',
        success: function success(response) {
          if ('' !== response.popup) {
            jQuery(document.body).append(jQuery(response.popup));
            self._initModals();
            self.showModal();
          }
        },
        error: function error(a, b, c) {
          // eslint-disable-next-line no-console
          console.log(a, b, c);
        }
      });
    }
  }]);
}();

;// ./assets/js/src/modals/index.js

jQuery(document).ready(function () {
  new YWDPD_Modal_Manager();
});
})();

/******/ })()
;
//# sourceMappingURL=modals.js.map