/******/ (() => { // webpackBootstrap
/******/ 	"use strict";

;// external ["wc","blocksCheckout"]
const external_wc_blocksCheckout_namespaceObject = window["wc"]["blocksCheckout"];
;// external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// external ["wp","plugins"]
const external_wp_plugins_namespaceObject = window["wp"]["plugins"];
;// ./includes/wc-blocks/assets/js/badge-discount/index.js




var modifyCartItemClass = function modifyCartItemClass(defaultValue, extensions, args) {
  var _args$cartItem;
  var campaignsData = (_args$cartItem = args.cartItem) !== null && _args$cartItem !== void 0 && _args$cartItem.item_data ? args.cartItem.item_data.filter(function (data) {
    return data.name === 'ywdpd-rules-applied';
  }) : [];
  if (campaignsData.length > 0) {
    return defaultValue + ' ywdpd-item-width-badge--' + args.cartItem.id;
  }
  return defaultValue;
};
(0,external_wc_blocksCheckout_namespaceObject.registerCheckoutFilters)('ywdpd-add-cart-item-class', {
  cartItemClass: modifyCartItemClass
});
var render = function render() {
  var cartItems = (0,external_wp_data_namespaceObject.useSelect)(function (select) {
    return select('wc/store/cart').getCartData().items;
  });
  (0,external_wp_element_namespaceObject.useEffect)(function () {
    setTimeout(function () {
      var cartHtml = document.querySelector('.wc-block-cart__main') || document.querySelector('.wc-block-components-order-summary__content');
      if (cartHtml !== null) {
        var oldBadges = cartHtml.querySelectorAll('.ywdpd-sale-badge');
        oldBadges.forEach(function (oldBadge) {
          oldBadge.remove();
        });
        var elementsWithBadge = document.querySelectorAll('[class*=ywdpd-item-width-badge]');
        elementsWithBadge.forEach(function (elementWithBadge) {
          var classList = Array.from(elementWithBadge.classList);
          var className = classList.filter(function (classList) {
            return classList.includes('ywdpd-item-width-badge');
          }).shift();
          var itemID = className.split('--')[1];
          var items = cartItems.filter(function (cartItem) {
            return cartItem.id === parseInt(itemID);
          });
          var item = false;
          if (items.length > 1) {
            item = items.filter(function (item) {
              return item.item_data.filter(function (data) {
                return data.name === 'ywdpd-rules-applied';
              }).length === 1;
            }).shift();
          } else {
            item = items.shift();
          }
          var campaignsData = item ? item.item_data.filter(function (data) {
            return data.name === 'ywdpd-rules-applied';
          }) : [];
          if (campaignsData.length > 0) {
            var names = campaignsData[0].value.split(',');
            names.forEach(function (name) {
              var id = name.toLowerCase().replaceAll(' ', '-');
              if (!elementWithBadge.querySelector('#' + id)) {
                var badgeHtml = document.createElement('div');
                badgeHtml.id = id;
                badgeHtml.className = 'ywdpd-sale-badge wc-block-components-product-badge wc-block-components-sale-badge';
                badgeHtml.innerHTML = "<span>" + name + "</span>";
                badgeHtml.style = 'margin-right:5px';
                if (Array.from(cartHtml.classList).includes('wc-block-components-order-summary__content')) {
                  elementWithBadge.querySelector('.wc-block-components-order-summary-item__description').insertBefore(badgeHtml, elementWithBadge.querySelector('.wc-block-components-order-summary-item__description').children[1]);
                } else {
                  elementWithBadge.querySelector('.wc-block-cart-item__wrap').insertBefore(badgeHtml, elementWithBadge.querySelector('.wc-block-cart-item__wrap').children[2]);
                }
              }
            });
          }
        });
      }
    }, 500);
  }, [cartItems]);
};
(0,external_wp_plugins_namespaceObject.registerPlugin)('ywdpd-badge-discount', {
  render: render,
  scope: 'woocommerce-checkout'
});
/******/ })()
;
//# sourceMappingURL=index.js.map