<?php
/**
 * Template for displaying the category discount field
 *
 * @var array $field The field.
 * @package YITH\Dynamic\PricingAndDiscounts\CustomFields
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
global $post;
list ( $field_id, $name, $value, $class, $data ) = yith_plugin_fw_extract( $field, 'id', 'name', 'value', 'class', 'data' );

$default = array(
	array(
		'product_cat'     => '',
		'type_discount'   => 'percentage',
		'discount_amount' => 10,
	),
);

$value      = ! is_array( $value ) || count( $value ) === 0 ? $default : $value;
$trash_icon = '<span class="ywdpd-qty-remove-row"><a href="#" rel="nofollow"><span class="yith-icon yith-icon-trash"></span></a></span>'
?>
<div
	class="ywdpd-qty-discount-wrapper ywdpd-category-discount" <?php yith_plugin_fw_html_data_to_string( $data, true ); ?>>
	<div class="ywdpd-qty-rows">
		<?php
		$key = 1;
		foreach ( $value as $discount ) {
			$symbol     = 'percentage' === $discount['type_discount'] ? '%' : get_woocommerce_currency_symbol();
			$field_args = array(
				'type'   => 'inline-fields',
				'class'  => 'ywdpd_qty_row',
				'name'   => $name . "[$key]",
				'value'  => $discount,
				'fields' => array(
					'html2'           => array(
						'type' => 'html',
						'html' => _x( 'Apply', '[PART OF:] Apply a discount of 10% on all products in Accessories', 'ywdpd' ),
					),
					'type_discount'   => array(
						'type'    => 'select',
						'class'   => 'yith-plugin-fw-select ywdpd_discount_type',
						'options' => array(
							'percentage'  => __( 'a % discount of', 'ywdpd' ),
							'price'       => __( 'a price discount of', 'ywdpd' ),
							'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
						),
						'std'     => 'percentage',
					),
					'discount_amount' => array(
						'type' => 'text',
					),
					'html4'           => array(
						'type' => 'html',
						'html' => '<span class="ywdpd_symbol">' . $symbol . '</span>',
					),
					'html5'           => array(
						'type' => 'html',
						'html' => _x( 'on all products of', '[PART OF:] Apply a discount of 10% on all products in Accessories', 'ywdpd' ),
					),
					'product_cat'     => array(
						'type'     => 'ajax-terms',
						'data'     => array(
							'taxonomy' => 'product_cat',
						),
						'multiple' => false,
					),
					'html6'           => array(
						'type' => 'html',
						'html' => 1 !== $key ? $trash_icon : '',
					),
				),
				'data'   => array(
					'index' => $key,
				),
			);

			yith_plugin_fw_get_field( $field_args, true );
			$key ++;
		}
		?>
	</div>
	<div class="discount_new_rule">
		<a href="#" class="ywdpd_new_rule"><?php esc_html_e( '+ Add rule', 'ywdpd' ); ?></a>
	</div>
</div>
<script type="text/template" id="tmpl-ywdpd-quantity-category-discount-row">
	<?php
	$field_args = array(
		'type'   => 'inline-fields',
		'class'  => 'ywdpd_qty_row',
		'name'   => $name . '[{{{data.index}}}]',
		'data'   => array(
			'index' => '{{{data.index}}}',
		),
		'value'  => current( $default ),
		'fields' => array(
			'html2'           => array(
				'type' => 'html',
				'html' => _x( 'Apply', '[PART OF:] Apply a discount of 10% on all products in Accessories', 'ywdpd' ),
			),
			'type_discount'   => array(
				'type'    => 'select',
				'class'   => 'yith-plugin-fw-select ywdpd_discount_type',
				'options' => array(
					'percentage'  => __( 'a % discount of', 'ywdpd' ),
					'price'       => __( 'a price discount of', 'ywdpd' ),
					'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
				),
				'std'     => 'percentage',
			),
			'discount_amount' => array(
				'type' => 'text',
			),
			'html4'           => array(
				'type' => 'html',
				'html' => '<span class="ywdpd_symbol">' . $symbol . '</span>',
			),
			'html5'           => array(
				'type' => 'html',
				'html' => _x( 'on all products of', '[PART OF:] Apply a discount of 10% on all products in Accessories', 'ywdpd' ),
			),
			'product_cat'     => array(
				'type'     => 'ajax-terms',
				'data'     => array(
					'taxonomy' => 'product_cat',
				),
				'multiple' => false,
			),
			'html6'           => array(
				'type' => 'html',
				'html' => $trash_icon,
			),
		),
	);
	yith_plugin_fw_get_field( $field_args, true );
	?>
</script>
