<?php
/**
 * Template for displaying the min-max field
 *
 * @var array $field The field.
 * @package YITH\Dynamic\PricingAndDiscounts\CustomFields
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
list ( $field_id, $name, $value, $headers, $rows, $class, $data, $value ) = yith_plugin_fw_extract( $field, 'id', 'name', 'value', 'headers', 'rows', 'class', 'data', 'value' );
$class = ! ! $class ? $class : '';
?>
<div class="ywdpd-grid-field <?php echo esc_attr( $class ); ?>" <?php yith_plugin_fw_html_data_to_string( $data, true ); ?>>
	<table>
		<thead>
		<?php
		foreach ( $headers as $header ) :
			?>
			<th><?php echo esc_html( $header ); ?></th>
			<?php
		endforeach;
		?>
		</thead>
		<tbody>
		<?php
		foreach ( $rows as $row ) :
			?>
			<tr>
				<?php
				foreach ( $row as $element_id => $element ) :
					$element['id']    = $element_id.'_'.$field_id;
					$element['name']  = $name . '[' . $element_id . ']';
					$element_value    = $value[ $element_id ] ?? $element['default'];
					$element['value'] = $element_value;
					?>
					<td><?php yith_plugin_fw_get_field( $element, true ); ?></td>
					<?php
				endforeach;
				?>
			</tr>
			<?php
		endforeach;
		?>
		</tbody>
	</table>
</div>
