<?php
/**
 * Template for displaying the quantity range field
 *
 * @var array $field The field.
 * @package YITH\Dynamic\PricingAndDiscounts\CustomFields
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
global $post;
list ( $field_id, $name, $value, $class, $data ) = yith_plugin_fw_extract( $field, 'id', 'name', 'value', 'class', 'data' );

$default = array(
	array(
		'min_quantity'    => 1,
		'max_quantity'    => '',
		'type_discount'   => 'percentage',
		'discount_amount' => 10,
	),
);

$value = ! is_array( $value ) || count( $value ) === 0 ? $default : $value;

/**
 * APPLY_FILTERS: yith_ywdpd_quantity_pattern
 *
 * Allow to change the input number pattern.
 *
 * @param string $pattern The pattern.
 *
 * @return string
 */
$qty_input_number_pattern = apply_filters( 'yith_ywdpd_quantity_pattern', 'pattern="(\d*|\*)$" title="Only number or *"' );
$trash_icon               = '<span class="ywdpd-qty-remove-row"><a href="#" rel="nofollow"><span class="yith-icon yith-icon-trash"></span></a></span>'
?>

<div class="ywdpd-qty-discount-wrapper ywdpd-qty-range" <?php yith_plugin_fw_html_data_to_string( $data, true ); ?> >
	<div class="ywdpd-qty-rows">
		<?php
		$key = 1;
		foreach ( $value as $discount ) {
			$symbol     = 'percentage' === $discount['type_discount'] ? '%' : get_woocommerce_currency_symbol();
			$field_args = array(
				'type'   => 'inline-fields',
				'class'  => 'ywdpd_qty_row',
				'name'   => $name . "[$key]",
				'value'  => $discount,
				'fields' => array(
					'html1'           => array(
						'type' => 'html',
						'html' => _x( 'From', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
					),
					'min_quantity'    => array(
						'type'              => 'text',
						'custom_attributes' => $qty_input_number_pattern,
					),
					'html2'           => array(
						'type' => 'html',
						'html' => _x( 'to', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
					),
					'max_quantity'    => array(
						'type'              => 'text',
						'custom_attributes' => $qty_input_number_pattern,
					),
					'html3'           => array(
						'type' => 'html',
						'html' => _x( 'apply', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
					),
					'type_discount'   => array(
						'type'    => 'select',
						'class'   => 'yith-plugin-fw-select ywdpd_discount_type',
						'options' => array(
							'percentage'  => __( 'a % discount of', 'ywdpd' ),
							'price'       => __( 'a price discount of', 'ywdpd' ),
							'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
						),
						'std'     => 'percentage',
					),
					'discount_amount' => array(
						'type' => 'text',
					),
					'html4'           => array(
						'type' => 'html',
						'html' => '<span class="ywdpd_symbol">' . $symbol . '</span>',
					),
					'html5'           => array(
						'type' => 'html',
						'html' => 1 !== $key ? $trash_icon : '',
					),
				),
				'data'   => array(
					'index' => $key,
				),
			);

			yith_plugin_fw_get_field( $field_args, true );
			$key ++;
		}
		?>
	</div>
	<div class="discount_new_rule">
		<a href="#" class="ywdpd_new_rule"><?php esc_html_e( '+ Add rule', 'ywdpd' ); ?></a>
	</div>
</div>
<script type="text/template" id="tmpl-ywdpd-quantity-range-discount-row">
	<?php
	$field_args = array(
		'type'   => 'inline-fields',
		'class'  => 'ywdpd_qty_row',
		'name'   => $name . '[{{{data.index}}}]',
		'data'   => array(
			'index' => '{{{data.index}}}',
		),
		'value'  => current( $default ),
		'fields' => array(
			'html1'           => array(
				'type' => 'html',
				'html' => _x( 'From', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
			),
			'min_quantity'    => array(
				'type'              => 'text',
				'custom_attributes' => $qty_input_number_pattern,
			),
			'html2'           => array(
				'type' => 'html',
				'html' => _x( 'to', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
			),
			'max_quantity'    => array(
				'type'              => 'text',
				'custom_attributes' => $qty_input_number_pattern,
			),
			'html3'           => array(
				'type' => 'html',
				'html' => _x( 'apply', '[PART OF: From 1 to 10 apply a discount of 10%', 'ywdpd' ),
			),
			'type_discount'   => array(
				'type'    => 'select',
				'class'   => 'yith-plugin-fw-select ywdpd_discount_type',
				'options' => array(
					'percentage'  => __( 'a % discount of', 'ywdpd' ),
					'price'       => __( 'a price discount of', 'ywdpd' ),
					'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
				),
				'std'     => 'percentage',
			),
			'discount_amount' => array(
				'type' => 'text',
			),
			'html4'           => array(
				'type' => 'html',
				'html' => '<span class="ywdpd_symbol">%</span>',
			),
			'html5'           => array(
				'type' => 'html',
				'html' => $trash_icon,
			),
		),
	);
	yith_plugin_fw_get_field( $field_args, true );
	?>
</script>
