<?php // phpcs:ignore WordPress.Files.FileName
/**
 * Schedule rule field.
 *
 * @package YITH\Dynamic\PricingAndDiscounts\CustomFields
 * @since   4.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var array $field
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post;
list ( $field_id, $name, $value, $class, $data ) = yith_plugin_fw_extract( $field, 'id', 'name', 'value', 'class', 'data' );

$radio_args = array(
	'type'    => 'select',
	'id'      => 'schedule_mode',
	'name'    => $name . '[schedule_type]',
	'class'   => 'ywdpd_schedule_mode wc-enhanced-select',
	'options' => array(
		'no_schedule'    => __( 'Start now and end it manually', 'ywdpd' ),
		'schedule_dates' => __( 'Schedule a start and end time', 'ywdpd' ),
	),
	'value'   => isset( $value['schedule_type'] ) ? $value['schedule_type'] : 'no_schedule',
);

$date_from = isset( $value['schedule_from'] ) ? $value['schedule_from'] : '';
$date_to   = isset( $value['schedule_to'] ) ? $value['schedule_to'] : '';
?>
<div class="ywdpd-schedule-discount-wrapper" <?php yith_plugin_fw_html_data_to_string( $data, true ); ?> >
	<div class="ywdpdp-schedule-discount-options">
		<?php
		yith_plugin_fw_get_field( $radio_args, true );
		?>
	</div>
	<div class="ywdpd-schedule-discount-dates">
		<span class="ywdpd_schedule_from">
			<label for="_schedule_from"><?php esc_html_e( 'From', 'ywdpd' ); ?></label>
			<input type="text" autocomplete="off" class="yith-plugin-fw-text-input datepicker"
			       placeholder="YYYY-MM-DD HH:mm"
				   value="<?php echo esc_attr( $date_from ); ?>"
				   name="<?php echo esc_attr( $name ); ?>[schedule_from]"/>
			<span class="yith-icon yith-icon-calendar"></span>
		</span>
		<span class="ywdpd_schedule_to">
			<label for="_schedule_to"><?php esc_html_e( 'To', 'ywdpd' ); ?></label>
			<input type="text" autocomplete="off" class="yith-plugin-fw-text-input datepicker"
			       placeholder="YYYY-MM-DD HH:mm"
				   value="<?php echo esc_attr( $date_to ); ?>"
				   name="<?php echo esc_attr( $name ); ?>[schedule_to]"/>
			<span class="yith-icon yith-icon-calendar"></span>
		</span>
	</div>
</div>

