<?php
/**
 * Template for displaying the category discount field
 *
 * @var array $field The field.
 * @package YITH\Dynamic\PricingAndDiscounts\CustomFields
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
global $post;
list ( $field_id, $name, $value, $class, $data ) = yith_plugin_fw_extract( $field, 'id', 'name', 'value', 'class', 'data' );
$default    = array(
	'discount_type'   => 'percentage',
	'discount_amount' => 10,
);
$value      = ! is_array( $value ) ? $default : $value;
$symbol     = 'percentage' === $value['discount_type'] ? '%' : get_woocommerce_currency_symbol();
$main_class = $class . ' ywdpd_discount_field';
$field_args = array(
	'type'   => 'inline-fields',
	'value'  => $value,
	'fields' => array(
		'discount_type'   => array(
			'label'   => '',
			'class'   => 'ywdpd_discount_type',
			'type'    => 'select',
			'options' => array(
				'percentage'  => __( 'a % discount of', 'ywdpd' ),
				'price'       => __( 'a price discount of', 'ywdpd' ),
				'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
			),
			'std'     => 'percentage',
		),
		'discount_amount' => array(
			'label' => '',
			'type'  => 'text',
		),
		'sub_html'        => array(
			'type' => 'html',
			'html' => sprintf( '<span class="ywdpd_symbol">%s</span>', $symbol ),
		),
	),
	'class'  => $main_class,
	'name'   => $name,
	'data'   => $data,
);
?>
<div class="ywdpd-cart-discount-wrapper" <?php yith_plugin_fw_html_data_to_string( $data, true ); ?> >
	<?php
	yith_plugin_fw_get_field( $field_args, true );
	?>

</div>
