<?php
/**
 * This file contain all options for the BOGO rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$apply_to     = ywdpd_get_apply_to_options( $rule_type );
$user_options = ywdpd_get_user_options( $rule_type );
$schedule     = ywdpd_get_schedule_options( $rule_type );
$table_note   = ywdpd_get_note_to_apply_options( $rule_type );
$extra        = ywdpd_get_extra_options();
$trigger_options  = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$apply_to,
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);
$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);

$customization = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$table_note,
);

return array_merge(
	$trigger_options,
	$rule_application,
	$customization
);
