<?php
/**
 * This file contain all options for the Quantity Table rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$apply_to          = ywdpd_get_apply_to_options( $rule_type );
$adjustment_to     = ywdpd_get_adjustment_to_options( $rule_type );
$qty_rule          = array(
	'qty_type'    => array(
		'label'   => __( 'Create Qty/Price table with', 'ywdpd' ),
		'type'    => 'select',
		'class'   => 'wc-enhanced-select',
		'options' => array(
			'range' => __( 'Price set for interval of units (e.g From 5 to 10 = $10)', 'ywdpd' ),
			'fixed' => __( 'Price set for fixed units (e.g 5=$10, 20=$30)', 'ywdpd' ),
		),
		'std'     => 'range',
	),
	'rules'       => array(
		'id'         => 'rules',
		'label'      => __( 'Discount Rules', 'ywdpd' ),
		'desc'       => '',
		'type'       => 'custom',
		'ywdpd_type' => 'qty-range-discount',
		'action'     => 'ywdpd_show_custom_field',
		'data'       => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_qty_type',
						'value' => 'range',
					),
				)
			),
		),
	),
	'fixed_rules' => array(
		'label'      => __( 'Qty/Price table', 'ywdpd' ),
		'desc'       => '',
		'type'       => 'custom',
		'ywdpd_type' => 'qty-fixed-discount',
		'action'     => 'ywdpd_show_custom_field',
		'data'       => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_qty_type',
						'value' => 'fixed',
					),
				)
			),
		),
	),
);
$qty_mode          = ywdpd_get_quantity_mode_options( $rule_type );
$show_table        = array(
	'show_table_price' => array(
		'label' => __( 'Show quantity & prices in a table', 'ywdpd' ),
		'desc'  => __( 'Enable if you want to show the quantity and the prices in a table in the product pages', 'ywdpd' ),
		'type'  => 'onoff',
		'std'   => 'no',
	),
	'table_style' => array(
		'label' => __('Table style', 'ywdpd'),
		'desc' => __('Select how to display the rule: choose between a classic table or a boxed style.', 'ywdpd'),
		'type' => 'radio',
		'options' => array(
			'classic' => __('Classic table', 'ywdpd'),
			'boxed' => __('Boxed', 'ywdpd')
		),
		'std' => 'classic',
		'data' => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_show_table_price',
						'value' => 'yes',
					),
				)
			),
		)
	)
);
$user_options      = ywdpd_get_user_options( $rule_type );
$schedule          = ywdpd_get_schedule_options( $rule_type );
$extra             = ywdpd_get_extra_options();
$loop              = ywdpd_get_show_in_loop_option();
$table_note        = ywdpd_get_note_to_apply_options( $rule_type );
$table_note_adjust = ywdpd_get_note_adjustment_to_options();
$table_extra_note  = array(
	'show_extra_note' => array(
		'label' => __( 'Add extra notice under quantity table', 'ywdpd' ),
		'desc'  => __( 'Enable to show a custom text under the quantity table', 'ywdpd' ),
		'type'  => 'onoff',
		'std'   => 'no',
	),
	'table_note'      => array(
		'label'   => __( 'Add extra notice for the quantity table', 'ywdpd' ),
		'desc'    => __( 'Enter a custom text to show under the quantity table', 'ywdpd' ) . ywdpd_get_extra_desc_for_wpml(),
		'type'    => 'textarea-editor',
		'wpautop' => false,
		'data'    => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_show_extra_note',
						'value' => 'yes',
					),
				)
			),
		),
	),
);
$trigger_options   = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Trigger Options', 'ywdpd' ),
		),
	),
	$apply_to,
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);

$rule_config = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$qty_rule,
	$qty_mode,
	$adjustment_to,
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);

$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);

$customization = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$loop,
	$show_table,
	$table_note,
	$table_note_adjust,
	$table_extra_note
);

return array_merge(
	$trigger_options,
	$rule_config,
	$rule_application,
	$customization,
);
