<?php
/**
 * This file contain all option for the Cart discount
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$advanced_conditions = ywdpd_get_advanced_conditions_options(
	array(
		'customers',
		'num_of_orders',
		'past_expense',
		'product',
		'cart_items',
		'cart_subtotal',
		'payment_method',
	)
);
$schedule            = ywdpd_get_schedule_options( 'cart' );
$trigger_options     = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Trigger Options', 'ywdpd' ),
		),
	),
	array(
		'apply_discount_mode' => array(
			'label'   => __( 'Apply discount', 'ywdpd' ),
			'type'    => 'radio',
			'options' => array(
				'always'     => __( 'Always', 'ywdpd' ),
				'conditions' => __( 'Only when specific conditions are met', 'ywdpd' ),
			),
			'std'     => 'always',
			'desc'    => __( 'Choose if the cart discount will be added to the cart automatically or under specific conditions', 'ywdpd' ),
		),
		'cart_discount_rules' => array(
			'id'               => '_cart_discount_rules',
			'wrapper_class'    => 'ywdpd_advanced_conditions yith-plugin-fw-metabox-field-row',
			'label'            => __( 'Discount conditions', 'ywdpd' ),
			'type'             => 'toggle-element',
			'add_button'       => __( 'Add condition', 'ywdpd' ),
			'title'            => '%%condition_name%%',
			'yith-display-row' => false,
			'elements'         => $advanced_conditions,
			'save_button'      => array(
				'id'   => 'ywdpd_save_condition',
				'name' => __( 'Save condition', 'ywdpd' ),
			),
			'delete_button'    => array(
				'id'   => 'ywdpd_delete_condition',
				'name' => __( 'Delete condition', 'ywdpd' ),
			),
			'data'             => array(
				'ywdpd-deps' => wp_json_encode(
					array(
						array(
							'id'    => '_apply_discount_mode',
							'value' => 'conditions',
						),
					),
				),
			),
		),
	),
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);
$rule_config         = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	array(
		'apply_discount' => array(
			'label' => __( 'Apply coupon', 'ywdpd' ),
			'type'  => 'onoff',
			'std'   => 'no',
			'desc'  => __( 'Enable to set a discount as coupon in cart', 'ywdpd' ),
		),
		'discount_rule'  => array(
			'label'      => __( 'Coupon to apply', 'ywdpd' ),
			'type'       => 'custom',
			'action'     => 'ywdpd_show_custom_field',
			'ywdpd_type' => 'simple-discount',
			'desc'       => __( 'Set the value of the coupon to apply', 'ywdpd' ),
			'deps'       => array(
				'id'    => '_apply_discount',
				'value' => 'yes',
			),
		),
	),
	array(
		'allow_free_shipping' => array(
			'label' => __( 'Allow free shipping', 'ywdpd' ),
			'type'  => 'onoff',
			'std'   => 'no',
			'desc'  => __( "Enable to offer 'free shipping' when this rule applies", 'ywdpd' ),
		),
	),
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);
$rule_application    = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$schedule,
	array(
		'discount_combined' => array(
			'label' => __( 'Disable when a coupon has been applied', 'ywdpd' ),
			'desc'  => __( 'Enable if you want to disable this rule if the user has applied a coupon code', 'ywdpd' ),
			'type'  => 'onoff',
			'std'   => 'no',
		),
	),
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);
$customization       = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	array(
		'show_notice_cart' => array(
			'label' => __( 'Show a notice in the cart', 'ywdpd' ),
			'type'  => 'onoff',
			'std'   => 'no',
			'desc'  => __( 'Enable to show a notice above the cart', 'ywdpd' ),
		),
		'cart_notice'      => array(
			'label'   => __( 'Cart notice', 'ywdpd' ),
			'type'    => 'textarea-editor',
			'wpautop' => true,
			'desc'    => __( 'Set the text to show above the cart. Use <code> %remaining_amount%</code> to show the remaining amount and <code>%amount_discount%</code> to show the discount.', 'ywdpd' ) . ywdpd_get_extra_desc_for_wpml(),
			'std'     => '<p>' . __( 'Spend another %remaining_amount% to get a <strong>%amount_discount% discount</strong> on this order', 'ywdpd' ) . '</p>',
			'deps'    => array(
				'id'    => '_show_notice_cart',
				'value' => 'yes',
			),
		),
		'cart_notice_bg'   => array(
			'label' => __( 'Cart notice background color', 'ywdpd' ),
			'type'  => 'colorpicker',
			'std'   => '#ffd9bc',
			'desc'  => __( 'Set the background color of the notice', 'ywdpd' ),
			'deps'  => array(
				'id'    => '_show_notice_cart',
				'value' => 'yes',
			),
		),
	)
);

return array_merge(
	$trigger_options,
	$rule_config,
	$rule_application,
	$customization
);
