<?php
/**
 * This file contain all options for the Category discount rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$category_mode    = array(
	'quantity_category_discount' => array(
		'label'      => __( 'Set a category discount', 'ywdpd' ),
		'type'       => 'custom',
		'action'     => 'ywdpd_show_custom_field',
		'ywdpd_type' => 'category-discount',
		'desc'       => __( 'Set the discount to apply to product categories from this rule', 'ywdpd' ),
	),
);
$exclude_apply    = ywdpd_get_apply_to_options( $rule_type, true );
$user_options     = ywdpd_get_user_options( $rule_type );
$schedule         = ywdpd_get_schedule_options( $rule_type );
$extra            = ywdpd_get_extra_options();
$loop             = ywdpd_get_show_in_loop_option();
$table_note       = ywdpd_get_note_to_apply_options( $rule_type );
$trigger_options  = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$category_mode,
	$exclude_apply,
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);
$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);
$customization    = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$loop,
	$table_note,
);

return array_merge(
	$trigger_options,
	$rule_application,
	$customization
);
