<?php
/**
 * This file contain all options for the Discount on shop rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$discount_mode    = array(
	'simple_whole_discount' => array(
		'label'  => __( 'Discount to apply to entire shop', 'ywdpd' ),
		'type'   => 'inline-fields',
		'desc'   => __( 'Set the discount to apply to products from this rule', 'ywdpd' ),
		'class'  => 'ywdpd-cart-discount-wrapper',
		'fields' => array(
			'sub_html1'      => array(
				'type' => 'html',
				'html' => _x( 'Apply', 'Apply a %discount of 20% on all products', 'ywdpd' ),
			),
			'discount_mode'  => array(
				'label'   => '',
				'type'    => 'select',
				'class'   => 'ywdpd_discount_type',
				'options' => array(
					'percentage'  => __( 'a % discount of', 'ywdpd' ),
					'price'       => __( 'a price discount of', 'ywdpd' ),
					'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
				),
				'std'     => 'percentage',
			),
			'discount_value' => array(
				'label' => '',
				'type'  => 'number',
				'min'   => 1,
				'step'  => 'any',
				'std'   => 10,
			),
			'sub_html3'      => array(
				'type' => 'html',
				'html' => sprintf( '<span class="ywdpd_symbol">%s</span>%s', '%', _x( ' on all products', 'Apply a %discount of 20% on all products', 'ywdpd' ) ),
			),
		),
	),
);
$exclude_apply    = ywdpd_get_apply_to_options( $rule_type, true );
$user_options     = ywdpd_get_user_options( $rule_type );
$schedule         = ywdpd_get_schedule_options( $rule_type );
$extra            = ywdpd_get_extra_options();
$loop             = ywdpd_get_show_in_loop_option();
$table_note       = ywdpd_get_note_to_apply_options( $rule_type );
$rule_config      = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$discount_mode,
	$exclude_apply,
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);
$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);

$customization = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$loop,
	$table_note,
);

return array_merge(
	$rule_config,
	$rule_application,
	$customization
);
