<?php // phpcs:ignore WordPress.Files.FileName
/**
 * Pricing discount metabox options
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH <plugins@yithemes.com>
 * @var int $post_rule_id
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

$key = uniqid();

$last_priority = ywdpd_get_last_priority() + 1;

$rule_type = get_post_meta( $post_rule_id, '_discount_mode', true );

$rule_configuration = array();
$rule_slug          = str_replace( '_', '-', $rule_type );
$file_name          = $rule_slug . '-metabox.php';
if ( file_exists( YITH_YWDPD_INC . '/admin/metaboxes/' . $file_name ) ) {
	$rule_configuration = include_once YITH_YWDPD_INC . '/admin/metaboxes/' . $file_name;
}

$basic_conf = array(
	'section_start' => array(
		'desc' => __( 'General Options', 'ywdpd' ),
		'type' => 'title',
		'id'   => 'ywdpd_section_start',
	),
	'rule_name'     => array(
		'label'             => __( 'Rule name', 'ywdpd' ),
		'type'              => 'text',
		'class'             => 'yith-plugin-fw-text-input ywdpd_rule_name',
		'custom_attributes' => array(
			'placeholder' => _x( 'Add name', 'placeholder for new rule title', 'ywdpd' ),
		),
		'required'          => true,
		'desc'              => __( 'Enter a name to identify this rule', 'ywdpd' ),
	),
	'key'           => array(
		'type' => 'hidden',
		'std'  => $key,
		'val'  => $key,
	),
	'priority'      => array(
		'label' => __( 'Priority', 'ywdpd' ),
		'desc'  => __( 'Set the priority to assign to this rule. Priority is important to overwrite rules. 1 is the highest priority', 'ywdpd' ),
		'type'  => 'number',
		'std'   => $last_priority,
		'min'   => 1,
	),
	'sep_gen'       => array(
		'type' => 'sep',
	),
);


$fields = array_merge_recursive(
	$basic_conf,
	$rule_configuration
);

/**
 * APPLY_FILTERS: ywdpd_dynamic_discount_metabox_options
 *
 * Allow change the meta box options.
 *
 * @param array $options The options
 *
 * @return array
 */
return apply_filters(
	'ywdpd_dynamic_discount_metabox_options',
	array(
		'label'    => __( 'Pricing Discount Settings', 'ywdpd' ),
		'pages'    => 'ywdpd_discount',
		'context'  => 'normal',
		'priority' => 'default',
		'class'    => yith_set_wrapper_class() . ' ywdpd_metabox',
		'tabs'     => array(
			'settings' => array(
				'label'  => __( 'Settings', 'ywdpd' ),
				'fields' => apply_filters(
					'ywdpd_' . $rule_slug . '_metabox',
					$fields
				),
			),
		),
	)
);
