<?php
/**
 * This file contain all options for the Gift products rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$gift_options = array(
	'gift_product_selection'      => array(
		'label'    => __( 'Choose which products to offer as a gift', 'ywdpd' ),
		'type'     => 'ajax-products',
		'desc'     => __( 'Select the products to offer as a gift', 'ywdpd' ),
		'multiple' => true,
		'data'     => array(
			'action'   => 'woocommerce_json_search_products_and_variations',
			'security' => wp_create_nonce( 'search-products' ),
		),
		'required' => true,
	),
	'add_gift_automatically'      => array(
		'label' => __( 'Add the gift product automatically', 'ywdpd' ),
		'type'  => 'onoff',
		'std'   => 'no',
		'desc'  => sprintf(
			'%s<br/>%s',
			__( 'Enable to add the gift product to the cart.', 'ywdpd' ),
			__( 'Note: This option is only valid for simple products. If you selected a variation or a variable product, the popup will be shown', 'ywdpd' )
		),
		'data'  => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'       => '_gift_product_selection',
						'value'    => 1,
						'property' => 'length',
					),
				),
			),
		),
	),
	'amount_gift_product_allowed' => array(
		'label' => __( 'How many gift products can the user select?', 'ywdpd' ),
		'desc'  => __( 'Choose how many gift products can be selected as gifts by the user', 'ywdpd' ),
		'type'  => 'number',
		'min'   => 1,
		'std'   => 1,
		'step'  => 1,
	),
);
$apply_to     = ywdpd_get_apply_to_options( $rule_type );
$gift_mode    = array(
	'gift_mode'       => array(
		'label'   => __( 'Offer gift if', 'ywdpd' ),
		'type'    => 'radio',
		'options' => array(
			'cart_item'     => __( 'In cart there is a minimum number of items', 'ywdpd' ),
			'cart_subtotal' => __( 'In cart there are items for a minimum subtotal', 'ywdpd' ),
		),
		'std'     => 'cart_item',
		'desc'    => __( 'Choose if you want to offer a gift when the cart has a minimum number of items or a minimum subtotal amount', 'ywdpd' ),
	),
	'n_items_in_cart' => array(
		'label'  => __( 'Offer gifts if total items in cart:', 'ywdpd' ),
		'type'   => 'inline-fields',
		'fields' => array(
			'condition' => array(
				'type'    => 'select',
				'class'   => 'wc-enhanced-select ywdpd_condition',
				'options' => array(
					'>'   => __( 'is greater than', 'ywdpd' ),
					'<'   => __( 'is less than', 'ywdpd' ),
					'=='  => __( 'is equal to', 'ywdpd' ),
					'!==' => __( 'is not equal to ', 'ywdpd' ),
				),
			),
			'n_items'   => array(
				'type' => 'number',
				'min'  => 0,
				'step' => 1,
			),
		),
		'desc'   => __( 'Set how many items the user has to have in the cart in order to see the gift products', 'ywdpd' ),
		'data'   => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_gift_mode',
						'value' => 'cart_item',
					),
				)
			),
		),
		'std'    => array(
			'condition' => '>',
			'n_items'   => 1,
		),
	),
	'gift_subtotal'   => array(
		/* translators: %s is the WooCommerce currency symbol */
		'label' => sprintf( _x( 'Offer gifts if subtotal is higher than (%s)', 'Offer gifts if subtotal is higher than $', 'ywdpd' ), get_woocommerce_currency_symbol() ),
		'type'  => 'number',
		'min'   => 1,
		'std'   => 100,
		'desc'  => __( 'Set the minimum subtotal required to offer this gift in cart', 'ywdpd' ),
		'data'  => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_gift_mode',
						'value' => 'cart_subtotal',
					),
				)
			),
		),
	),
);
$user_options = ywdpd_get_user_options( $rule_type );
$schedule     = ywdpd_get_schedule_options( $rule_type );
$table_note   = ywdpd_get_note_to_apply_options( $rule_type );
$extra        = ywdpd_get_extra_options();

$extra_gift       = array_merge(
	array(
		'text_in_modal_gift' => array(
			'label' => __( 'Text to show in modal window', 'ywdpd' ),
			/* translators: %s is the placeholder to use, to display the amount of product that is possible add with this discount */
			'desc'  => sprintf( __( 'Enter a custom text that will be shown in the modal window to describe this offer. Use %s to show the number of products dynamically.', 'ywdpd' ) . ' %s', '<code>{{total_to_add}}</code>', ywdpd_get_extra_desc_for_wpml() ),
			'type'  => 'textarea',
			'std'   => __( 'You can add {{total_to_add}} product(s) for free!', 'ywdpd' ),
		),
	),
	$table_note,
	array(
		'show_gift_adjustment_note'     => array(
			'label' => __( 'Show a message in products offered as gift', 'ywdpd' ),
			'desc'  => __( 'Enable to set a custom notice to show in all products in which this rule is applied', 'ywdpd' ),
			'type'  => 'onoff',
			'std'   => 'no',
		),
		'table_note_gift_adjustment_to' => array(
			'label'   => __( 'Add a custom message in products offered as gift', 'ywdpd' ),
			// @since 3.0.0
			'desc'    => __( 'Enter a custom text to show in the products offered as gift. Use the placeholder <code>%required_items%</code> to show products, categories, or tags that users must add to the cart to apply the gift rule on the product for which it has been created. Use the placeholder <code>%subtotal%</code> to show the minimum subtotal needed to add the product as gift.', 'ywdpd' ) . ywdpd_get_extra_desc_for_wpml(),
			'type'    => 'textarea-editor',
			'wpautop' => false,
			'data'    => array(
				'ywdpd-deps' => wp_json_encode(
					array(
						array(
							'id'    => '_show_gift_adjustment_note',
							'value' => 'yes',
						),
					)
				),
			),
		),
	)
);
$trigger_options  = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Trigger Options', 'ywdpd' ),
		),
	),
	$apply_to,
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);
$rule_config      = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$gift_options,
	$gift_mode,
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);
$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);
$customization    = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$extra_gift
);

return array_merge_recursive(
	$trigger_options,
	$rule_config,
	$rule_application,
	$customization,
);
