<?php
/**
 * This file contain all options for the Last deals rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$advanced_conditions = ywdpd_get_advanced_conditions_options(
	array(
		'product',
		'cart_subtotal',
		'country',
	)
);
$deals_config_start  = array(
	'show_deal'                    => array(
		'label'   => __( 'Show deal', 'ywdpd' ),
		'type'    => 'radio',
		'options' => array(
			'always'     => __( 'Always', 'ywdpd' ),
			'conditions' => __( 'Only when specific conditions are met', 'ywdpd' ),
		),
		'std'     => 'always',
	),
	'deal_conditions'              => array(
		'label'            => __( 'Conditions', 'ywdpd' ),
		'type'             => 'toggle-element',
		'add_button'       => __( 'Add condition', 'ywdpd' ),
		'wrapper_class'    => 'ywdpd_advanced_conditions yith-plugin-fw-metabox-field-row',
		'title'            => '%%condition_name%%',
		'yith-display-row' => false,
		'elements'         => $advanced_conditions,
		'data'             => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_show_deal',
						'value' => 'conditions',
					),
				),
			),
		),
		'save_button'      => array(
			'id'   => 'ywdpd_save_condition',
			'name' => __( 'Save condition', 'ywdpd' ),
		),
		'delete_button'    => array(
			'id'   => 'ywdpd_delete_condition',
			'name' => __( 'Delete condition', 'ywdpd' ),
		),
	),
	'deal_product_selection'       => array(
		'label'    => __( 'Product(s) to offer as last deal', 'ywdpd' ),
		'type'     => 'ajax-products',
		'desc'     => __( 'Select the product(s) to include in the rule', 'ywdpd' ),
		'multiple' => true,
		'data'     => array(
			'action'   => 'woocommerce_json_search_products_and_variations',
			'security' => wp_create_nonce( 'search-products' ),
		),
		'required' => true,
	),
	'deal_set_limits'              => array(
		'label'   => __( 'Set limits in product selection as deals', 'ywdpd' ),
		'desc'    => __( 'Enable to set limits on how many products the user can purchase through this promotion', 'ywdpd' ),
		'type'    => 'onoff',
		'default' => 'no',
	),
	'deal_total_product_to_add'    => array(
		'label'  => __( 'The user can pick max:', 'ywdpd' ),
		'class'  => 'ywdpd_product_limits',
		'type'   => 'inline-fields',
		'fields' => array(
			'deal_total_product_to_add' => array(
				'type'         => 'number',
				'min'          => 1,
				'std'          => 1,
				'step'         => 1,
				'inline-label' => __( 'product(s)', 'ywdpd' ),
			),
		),
		'data'   => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'       => '_deal_product_selection',
						'value'    => 1,
						'compare'  => '>',
						'property' => 'length',
					),
					array(
						'id'    => '_deal_set_limits',
						'value' => 'yes',
					),
				),
			),
		),
	),
	'deal_max_unit_product_to_add' => array(
		'label'  => __( 'For each product offered in this deal, the user can buy max:', 'ywdpd' ),
		'class'  => 'ywdpd_product_limits',
		'type'   => 'inline-fields',
		'fields' => array(
			'deal_max_unit_product_to_add' => array(
				'type'         => 'number',
				'min'          => 1,
				'std'          => 1,
				'step'         => 1,
				'inline-label' => __( 'unit(s)', 'ywdpd' ),
			),
		),
		'data'   => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_deal_set_limits',
						'value' => 'yes',
					),
				),
			),
		),
	),
	'apply_deal_discount'          => array(
		'label' => __( 'Apply discount', 'ywdpd' ),
		'type'  => 'onoff',
		'std'   => 'no',
	),
	'deal_discount'                => array(
		'label'      => __( 'Discount to apply', 'ywdpd' ),
		'type'       => 'custom',
		'action'     => 'ywdpd_show_custom_field',
		'ywdpd_type' => 'simple-discount',
		'data'       => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_apply_deal_discount',
						'value' => 'yes',
					),
				),
			),
		),
	),
);

$user_options     = ywdpd_get_user_options( $rule_type );
$schedule         = ywdpd_get_schedule_options( $rule_type );
$deals_config_end = array(
	'deal_layout'           => array(
		'label'   => __( 'Deal layout', 'ywdpd' ),
		'desc'    => __( 'Choose how to show the deal on the checkout page', 'ywdpd' ),
		'type'    => 'select',
		'class'   => 'yith-plugin-fw-select wc-enhanced-select',
		'options' => array(
			'modal' => __( 'Modal window', 'ywdpd' ),
			'full'  => __( 'Modal full size', 'ywdpd' ),
		),
		'std'     => 'modal',
	),
	'deal_note'             => array(
		// @since 3.0.0
		'label'   => __( 'Deal content', 'ywdpd' ),
		'desc'    => __( 'Enter a custom text to show in the last deal modal', 'ywdpd' ) . ywdpd_get_extra_desc_for_wpml(),
		'type'    => 'textarea-editor',
		'wpautop' => false,
	),
	'deal_enable_countdown' => array(
		'label' => __( 'Show countdown', 'ywdpd' ),
		'desc'  => __('Enable to set and show a countdown for this deal', 'ywdpd'),
		'type'  => 'onoff',
		'std'   => 'no',
	),
	'deal_countdown'        => array(
		'label'  => __( 'Countdown', 'ywdpd' ),
		'desc'   => '',
		'type'   => 'inline-fields',
		'fields' => array(
			'countdown_value' => array(
				'type'    => 'number',
				'max'     => 60,
				'min'     => 0,
				'step'    => 1,
				'default' => 30,
			),
			'countdown_type'  => array(
				'type'              => 'select',
				'options'           => array(
					'minutes' => __( 'Minutes', 'ywdpd' ),
					'seconds' => __( 'Seconds', 'ywdpd' ),
				),
				'default'           => 'seconds',
				'custom_attributes' => 'style="width:200px!important;"',
			),
		),
		'data'   => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_deal_enable_countdown',
						'value' => 'yes',
					),
				),
			),
		),
	),
);

$rule_config      = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$deals_config_start,
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);
$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);
$customization    = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$deals_config_end
);

return array_merge_recursive(
	$rule_config,
	$rule_application,
	$customization,
);
