<?php
/**
 * This file contain all options for the Special offer rule
 *
 * @since   4.0
 * @package YITH\Dynamic\PricingAndDiscounts\Metaboxes
 * @var string $rule_type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$apply_to          = ywdpd_get_apply_to_options( $rule_type );
$adjustment_to     = ywdpd_get_adjustment_to_options( $rule_type );
$qty_mode          = ywdpd_get_quantity_mode_options( $rule_type );
$user_options      = ywdpd_get_user_options( $rule_type );
$schedule          = ywdpd_get_schedule_options( $rule_type );
$extra             = ywdpd_get_extra_options();
$table_note        = ywdpd_get_note_to_apply_options( $rule_type );
$table_note_adjust = ywdpd_get_note_adjustment_to_options();
$so_rule           = array(
	'so-rule'   => array(
		'id'     => 'so-rule',
		'label'  => __( 'Set offer rules', 'ywdpd' ),
		'class'  => 'ywdpd_special_offer',
		'desc'   => __( 'Create the special offer rule for the products you selected', 'ywdpd' ),
		'type'   => 'inline-fields',
		'fields' => array(
			'html1'           => array(
				'type' => 'html',
				'html' => _x( 'If user purchases', '[PART OF] If user purchases 3 item(s) gets 1 item(s) with a discount of 10$', 'ywdpd' ),
			),
			'purchase'        => array(
				'type' => 'number',
				'id'   => 'special_offer_purchase_from',
				'min'  => 1,
				'step' => 1,
			),
			'html2'           => array(
				'type' => 'html',
				'html' => _x( 'item(s) gets', '[PART OF] If user purchases 3 item(s) gets 1 item(s) with a discount of 10$', 'ywdpd' ),
			),
			'receive'         => array(
				'type' => 'number',
				'id'   => 'special_offer_purchase_to',
				'min'  => 1,
				'step' => 1,
			),
			'html3'           => array(
				'type' => 'html',
				'html' => _x( 'item(s) with', '[PART OF] If user purchases 3 item(s) gets 1 item(s) with a discount of 10$', 'ywdpd' ),
			),
			'type_discount'   => array(
				'type'    => 'select',
				'class'   => 'yith-plugin-fw-select ywdpd_discount_type',
				'options' => array(
					'percentage'  => __( 'a % discount of', 'ywdpd' ),
					'price'       => __( 'a price discount of', 'ywdpd' ),
					'fixed-price' => __( 'a fixed price of', 'ywdpd' ),
				),
				'std'     => 'percentage',
			),
			'discount_amount' => array(
				'type'  => 'text',
				'class' => 'ywdpd_special_offer_amount',
			),
			'html4'           => array(
				'type' => 'html',
				'html' => '<span class="ywdpd_symbol">%</span>',
			),
		),
		'std'    => array(
			'purchase'        => 1,
			'receive'         => '',
			'type_discount'   => 'percentage',
			'discount_amount' => 10,
		),
	),
	'so-repeat' => array(
		'label' => __( 'Repeat', 'ywdpd' ),
		'type'  => 'onoff',
		'desc'  => __( 'Enable this option to repeat the rule. For example, if you offer a 50% discount when purchasing a second product, when the user purchases four products, the rule is applied twice and the user gets a 50% discount on two of the four purchased products.', 'ywdpd' ),
		'std'   => 'no',
	),
);
$promote_modal     = array(
	'can_special_offer_in_popup'  => array(
		'label' => __( 'Promote offer in modal window', 'ywdpd' ),
		'type'  => 'onoff',
		'std'   => 'no',
		'desc'  => __( 'Enable to show a modal window after the user adds the product to the cart (from product page only). The modal window will display the other products linked to the offer and will only appear if there\'s at least one special offer set up for the current product.', 'ywdpd' ),
		'data'  => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_active_apply_discount_to',
						'value' => 'yes',
					),
				)
			),
		),
	),
	'text_in_modal_special_offer' => array(
		'label' => __( 'Text to show in modal window', 'ywdpd' ),
		/* translators: %s is the placeholder to use, to display the amount of product that is possible add with this discount */
		'desc'  => sprintf( __( 'Enter a custom text that will be shown in the modal window to describe this offer. Use %s to show the number of products dynamically.', 'ywdpd' ) . ' %s', '<code>{{total_to_add}}</code>', ywdpd_get_extra_desc_for_wpml() ),
		'type'  => 'textarea',
		'std'   => __( 'Get a special discount if you add {{total_to_add}} product(s) to your order.', 'ywdpd' ),
		'data'  => array(
			'ywdpd-deps' => wp_json_encode(
				array(
					array(
						'id'    => '_can_special_offer_in_popup',
						'value' => 'yes',
					),
					array(
						'id'    => '_active_apply_discount_to',
						'value' => 'yes',
					),
				)
			),
		),
	),
);

$trigger_options = array_merge(
	array(
		'section_trigger' => array(
			'type' => 'title',
			'desc' => __( 'Trigger Options', 'ywdpd' ),
		),
	),
	$apply_to,
	array(
		'sep_trigg' => array(
			'type' => 'sep',
		),
	),
);
$rule_config     = array_merge(
	array(
		'section_config' => array(
			'type' => 'title',
			'desc' => __( 'Rule Configuration', 'ywdpd' ),
		),
	),
	$so_rule,
	$qty_mode,
	$adjustment_to,
	array(
		'sep_conf' => array(
			'type' => 'sep',
		),
	),
);

$rule_application = array_merge(
	array(
		'section_app' => array(
			'type' => 'title',
			'desc' => __( 'Rule Application', 'ywdpd' ),
		),
	),
	$user_options,
	$schedule,
	$extra,
	array(
		'sep_app' => array(
			'type' => 'sep',
		),
	),
);

$customization = array_merge(
	array(
		'section_custom' => array(
			'type' => 'title',
			'desc' => __( 'Customization', 'ywdpd' ),
		),
	),
	$promote_modal,
	$table_note,
	$table_note_adjust,
);

return array_merge_recursive(
	$trigger_options,
	$rule_config,
	$rule_application,
	$customization
);
