<?php
/**
 * Handle Page Builders.
 *
 * @package YITH\DynamicPricingAndDiscounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Builders class
 * handle Page Builders
 *
 * @since 4.0.0
 */
class YWDPD_Builders {
	use YWDPD_Singleton_Trait;

	/**
	 * The Gutenberg class instance.
	 *
	 * @var YWDPD_Gutenberg
	 */
	public $gutenberg;

	/**
	 * YITH_WCBK_Builders constructor.
	 */
	private function __construct() {
		$this->load();
	}

	/**
	 * Load classes.
	 */
	private function load() {
		require_once YITH_YWDPD_INC . '/builders/gutenberg/class-ywdpd-gutenberg.php';

		$this->gutenberg = YWDPD_Gutenberg::get_instance();
	}
}
