<?php // phpcs:ignore WordPress.Files.FileName
/**
 * The Class that check if a taxonomy is in the cart.
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts\Classes\
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Class that check if a taxonomy is in the cart.
 */
class YWDPD_Taxonomy {
	/**
	 * The cached category ids
	 *
	 * @var array
	 */
	private static $cached_category_ids = array();
	/**
	 * The cached tag ids
	 *
	 * @var array
	 */
	private static $cached_tag_ids = array();


	/**
	 * Return the category ids of this products.
	 *
	 * @param WC_Product $product The product.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public static function get_product_category_ids( $product ) {

		$product_id = 'variation' === $product->get_type() ? $product->get_parent_id() : $product->get_id();

		if ( ! isset( self::$cached_category_ids[ $product_id ] ) ) {
			self::$cached_category_ids[ $product_id ] = array_unique( self::get_product_term_ids( $product, 'product_cat' ) );
			
		}

		return self::$cached_category_ids[ $product_id ];
	}

	/**
	 * Return the tag ids of this products.
	 *
	 * @param WC_Product $product The product.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public static function get_product_tag_ids( $product ) {

		$product_id = 'variation' === $product->get_type() ? $product->get_parent_id() : $product->get_id();

		if ( ! isset( self::$cached_tag_ids[ $product_id ] ) ) {
			self::$cached_tag_ids[ $product_id ] = self::get_product_term_ids( $product );
		}

		return self::$cached_tag_ids[ $product_id ];
	}

	/**
	 * Return the custom term ids of this products.
	 *
	 * @param WC_Product $product The product.
	 * @param string     $taxonomy_name the taxonomy.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public static function get_product_term_ids( $product, $taxonomy_name = 'product_tag' ) {
		$product_id = 'variation' === $product->get_type() ? $product->get_parent_id() : $product->get_id();

		if ( 'product_cat' === $taxonomy_name ) {
 			return wc_get_product_cat_ids( $product_id );
		}
		
		return wc_get_product_term_ids( $product_id, $taxonomy_name );
	}
}
