<?php
/**
 * The class that manage all plugin assets
 *
 * @package YITH\DynamicPricingAndDiscounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class YWDPD_Assets
 */
class YWDPD_Assets {

	/**
	 * Contain all ajax frontend actions
	 *
	 * @var array
	 */
	protected static $ajax_frontend_actions;
	/**
	 * Contain all ajax backend actions
	 *
	 * @var array
	 */
	protected static $ajax_backend_actions;

	/**
	 * Init the Assets class
	 *
	 * @author YITH <plugins@yithemes.com>
	 * @since  3.0.0
	 */
	public static function init() {
		self::$ajax_frontend_actions = array(
			'popup_action'   => array(
				'add_gift_to_cart',
				'add_bogo_to_cart',
				'add_special_to_cart',
				'add_last_deals',
				'show_second_step',
				'check_variable',
				'update_gift_popup',
				'show_popup_on_shop',
				'valid_rule_in_checkout',
			),
			'product_action' => array(
				'update_product_price'
			),
			'integrations'   => array(
				'update_product_points_message'
			)
		);

		self::$ajax_backend_actions = array(
			'table_rule' => array(
				'sort_discount_rules',
				'enable_or_disable_rule',
			),
		);
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_frontend_scripts' ), 20 );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_admin_scripts' ), 20 );
	}

	/**
	 * Register the frontend scripts
	 *
	 * @since  3.0.0
	 */
	public static function register_frontend_scripts() {

		// Register the popup scripts .
		wp_register_script( 'ywdpd_owl', YITH_YWDPD_ASSETS_URL . '/js/owl/owl.carousel.min.js', array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_style( 'ywdpd_owl', YITH_YWDPD_ASSETS_URL . '/css/owl/owl.carousel.min.css', array(), YITH_YWDPD_VERSION );
		/**
		 * APPLY_FILTERS: ywdpd_reload_after_ajax_add_to_cart
		 *
		 * Reload or not the page after an add to cart
		 *
		 * @param string $reload yes or no.
		 *
		 * @return string
		 */
		$popup_args = array(
			'ajax_url'                      => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
			'actions'                       => self::get_actions( 'popup_action', 'frontend' ),
			'nonces'                        => self::get_nonce( 'popup_action', 'frontend' ),
			'i18n_qty_field_label'          => esc_html__( 'Qty in cart', 'ywdpd' ),
			'rtl'                           => is_rtl() ? 'true' : 'false',
			'reload_after_ajax_add_to_cart' => apply_filters( 'ywdpd_reload_after_ajax_add_to_cart', 'no' ),
			'number_of_items_slider_mobile' => apply_filters( 'ywdpd_n_items_slider_mobile', 1 ),
		);

		// End popup scripts.

		// Register the frontend scripts and style.

		$show_minimum_price = 'max' === YITH_WC_Dynamic_Options::get_default_price();
		$template           = YITH_WC_Dynamic_Options::get_quantity_table_layout();
		$change_qty         = YITH_WC_Dynamic_Options::update_price_on_qty_changes();
		$default_qty        = YITH_WC_Dynamic_Options::is_default_qty_selected();
		$args               = array(
			'show_minimum_price'             => yith_plugin_fw_is_true( $show_minimum_price ) ? 'yes' : 'no',
			/**
			 * APPLY_FILTERS: ywdpd_table_orientation.
			 *
			 * Change table orientation.
			 *
			 * @param string $template The template.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_column_product_info_class
			 *
			 * Change product css class.
			 *
			 * @param string $class The product css class.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_product_price_classes
			 *
			 * Change product price css class.
			 *
			 * @param string $class The product price css class.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_product_qty_classes
			 *
			 * Change product qty css class.
			 *
			 * @param string $class The product qty css class.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_variation_form_class
			 *
			 * Change product variation form css class.
			 *
			 * @param string $class The product variation form css class.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_minimum_quantity
			 *
			 * Show min quantity in the table.
			 *
			 * @param bool $show_min Show the min or not.
			 *
			 * @return bool
			 */
			/**
			 * APPLY_FILTERS: ywdpd_update_prices_in_ajax
			 *
			 * Can update prices via ajax.
			 *
			 * @param string $can_update Yes or no.
			 *
			 * @return string
			 */
			/**
			 * APPLY_FILTERS: ywdpd_show_variable_table
			 *
			 * Can show the table on variable product.
			 *
			 * @param string $can_show Yes or no.
			 *
			 * @return string
			 */
			'template'                       => apply_filters( 'ywdpd_table_orientation', $template ),
			'is_change_qty_enabled'          => $change_qty ? 'yes' : 'no',
			'is_default_qty_enabled'         => $default_qty ? 'yes' : 'no',
			'refresh_after_payment_selected' => apply_filters( 'ywdpd_refresh_after_payment_selected', 'yes' ),
			'column_product_info_class'      => apply_filters( 'ywdpd_column_product_info_class', '.single-product .summary, .elementor.product.type-product' ),
			'product_price_classes'          => apply_filters( 'ywdpd_product_price_classes', '.price, .wpb_wrapper .price, .elementor-widget-woocommerce-product-price .price,.wc-block-grid__product-price' ),
			'product_qty_classes'            => apply_filters( 'ywdpd_product_qty_classes', ' .qty, .elementor-add-to-cart .qty, .w-post-elm .qty' ),
			'variation_form_class'           => apply_filters( 'ywdpd_variation_form_class', 'form.variations_form.cart' ),
			'select_minimum_quantity'        => apply_filters( 'ywdpd_minimum_quantity', false ),
			'update_prices_in_ajax'          => apply_filters( 'ywdpd_update_prices_in_ajax', 'yes' ),
			'show_variable_table'            => apply_filters( 'ywdpd_show_variable_table', 'yes' ),
			'ajax_url'                       => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
			'actions'                        => self::get_actions( 'product_action', 'frontend' ),
			'nonces'                         => self::get_nonce( 'product_action', 'frontend' ),
			'has_points_installed'           => defined( 'YITH_YWPAR_PREMIUM' ) ? 'yes' : 'no',
			'has_rolebased_installed'        => defined( 'YWCRBP_PREMIUM' ) ? 'yes' : 'no',
			'integrations'                   => array(
				'actions' => self::get_actions( 'integrations', 'frontend' ),
				'nonces'  => self::get_nonce( 'integrations', 'frontend' ),
			)
		);
		wp_register_script( 'ywdpd_frontend', YITH_YWDPD_ASSETS_URL . '/js/build/' . yit_load_js_file( 'frontend.js' ), array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_style( 'yith_ywdpd_frontend', YITH_YWDPD_ASSETS_URL . '/css/frontend.css', false, YITH_YWDPD_VERSION );

		wp_localize_script( 'ywdpd_frontend', 'ywdpd_qty_args', $args );
		wp_register_script( 'ywdpd_modals', YITH_YWDPD_ASSETS_URL . '/js/build/' . yit_load_js_file( 'modals.js' ), array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_localize_script( 'ywdpd_modals', 'ywdpd_popup_args', $popup_args );
	}

	/**
	 * Register style and script in admin
	 *
	 * @since  3.0.0
	 */
	public static function register_admin_scripts() {

		wp_register_style( 'yith_ywdpd_backend', YITH_YWDPD_ASSETS_URL . '/css/backend.css', array( 'woocommerce_admin_styles' ), YITH_YWDPD_VERSION );
		wp_register_script( 'yith_ywdpd_timepicker', YITH_YWDPD_ASSETS_URL . '/js/jquery-ui-timepicker-addon.min.js', array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_script(
			'yith_ywdpd_admin',
			YITH_YWDPD_ASSETS_URL . '/js/build/' . yit_load_js_file( 'admin.js' ),
			array(
				'jquery',
				'jquery-ui-sortable',
				'jquery-ui-dialog',
				'jquery-blockui',
			),
			YITH_YWDPD_VERSION,
			true
		);
		/**
		 * APPLY_FILTERS: yith_ywdpd_admin_localize
		 *
		 * Can add args for the script.
		 *
		 * @param array $script_args The args.
		 *
		 * @return array
		 */
		wp_localize_script(
			'yith_ywdpd_admin',
			'yith_ywdpd_admin',
			apply_filters(
				'yith_ywdpd_admin_localize',
				array(
					'ajax_url'                         => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
					'actions'                          => self::get_actions( 'table_rule', 'admin' ),
					'nonces'                           => self::get_nonce( 'table_rule', 'admin' ),
					'del_msg'                          => apply_filters( 'yith_ywdpd_delete_msg_admin', __( 'Do you really want to delete this rule?', 'ywdpd' ) ),
					'message_alert'                    => array(
						'title'         => __( 'Are you sure?', 'ywdpd' ),
						'desc'          => __( 'Do you want to go back to the plugin dashboard? The changes made may not be saved.', 'ywdpd' ),
						'confirmButton' => __( 'Yes, proceed without saving', 'ywdpd' ),
					),
					/* translators: %s is the condition number */
					'advanced_condition_default_title' => _x( 'Condition %s', 'Condition 1', 'ywdpd' ),
					'new_condition_title'              => __( 'Add condition', 'ywdpd' ),
					'percent_symbol'                   => '%',
					'currency_symbol'                  => get_woocommerce_currency_symbol( get_option( 'woocommerce_currency' ) ),
				)
			)
		);
	}

	/**
	 * Build the actions array for the scripts
	 *
	 * @param string $type The type of the actions.
	 * @param string $context Admin or frontend.
	 *
	 * @return array
	 * @since  3.0.0
	 *
	 */
	public static function get_actions( $type, $context = 'admin' ) {
		$actions = array();
		if ( 'admin' === $context ) {
			$type_actions = isset( self::$ajax_backend_actions[ $type ] ) ? self::$ajax_backend_actions[ $type ] : array();
		} else {
			$type_actions = isset( self::$ajax_frontend_actions[ $type ] ) ? self::$ajax_frontend_actions[ $type ] : array();
		}

		foreach ( $type_actions as $action ) {
			$actions[ $action ] = 'ywdpd_' . $action;
		}

		return $actions;
	}

	/**
	 * Create the nonce for the the script
	 *
	 * @param string $type The type of the actions.
	 * @param string $context Admin or frontend.
	 *
	 * @return array
	 * @since  3.0.0
	 */
	public static function get_nonce( $type, $context = 'admin' ) {
		$nonces = array();
		if ( 'admin' === $context ) {
			$type_actions = isset( self::$ajax_backend_actions[ $type ] ) ? self::$ajax_backend_actions[ $type ] : array();
		} else {
			$type_actions = isset( self::$ajax_frontend_actions[ $type ] ) ? self::$ajax_frontend_actions[ $type ] : array();
		}

		foreach ( $type_actions as $action ) {
			$nonces[ $action ] = wp_create_nonce( str_replace( '_', '-', $action ) );
		}

		return $nonces;
	}

	/**
	 * Enqueue the frontend scripts
	 *
	 * @since  3.0.0
	 */
	public static function enqueue_frontend_scripts() {

		self::register_frontend_scripts();
		// Enqueue the popup script only on cart or single product page.
		wp_enqueue_script( 'ywdpd_owl' );
		wp_enqueue_script( 'ywdpd_frontend' );
		wp_enqueue_style( 'ywdpd_owl' );
		wp_enqueue_style( 'yith_ywdpd_frontend' );
		wp_enqueue_script( 'ywdpd_modals' );
		if ( ! wp_script_is( 'wc-add-to-cart-variation' ) ) {
			wp_enqueue_script( 'wc-add-to-cart-variation' );
		}
	}

	/**
	 * Enqueue the admin script and style
	 *
	 * @since  3.0.0
	 */
	public static function enqueue_admin_scripts() {

		self::register_admin_scripts();
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';

		if ( 'edit-ywdpd_discount' === $screen_id ) {
			wp_enqueue_script( 'yith-plugin-fw-fields' );
		}
		if ( ywdpd_check_valid_admin_page( 'ywdpd_discount' ) || ( isset( $_GET['page'] ) && 'yith_woocommerce_dynamic_pricing_and_discounts' === sanitize_text_field( wp_unslash( $_GET['page'] ) ) ) ) {  // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_style( 'yith_ywdpd_backend' );
			wp_enqueue_script( 'yith_ywdpd_timepicker' );
			wp_enqueue_script( 'yith_ywdpd_admin' );

			if ( ! wp_script_is( 'selectWoo' ) ) {
				wp_enqueue_script( 'selectWoo' );
				wp_enqueue_script( 'wc-enhanced-select' );
			}

			if ( isset( $_GET['tab'] ) && 'exclusions' === sanitize_text_field( wp_unslash( $_GET['tab'] ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
				wp_enqueue_script( 'yith-plugin-fw-wp-pages' );
			}
		}
	}
}

YWDPD_Assets::init();
