<?php
/**
 * This class create the data store for the dynamic product block
 *
 * @package YITH\DynamicPricingAndDiscounts\Classes
 * @since   4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The class
 */
class YWDPD_Install {

	/**
	 * Install the tables and add the data store
	 *
	 * @return void
	 * @since 4.0
	 */
	public static function init() {
		self::install_tables();
		self::install_data_stores();
	}

	/**
	 * Create the plugin tables
	 *
	 * @author YITH <plugins@yithemes.com>
	 * @since  4.0.0
	 */
	public static function install_tables() {
		global $wpdb;

		$wpdb->yith_ywdpd_rules                = $wpdb->prefix . 'ywdpd_rules';
		$wpdb->yith_ywdpd_rule_products        = $wpdb->prefix . 'ywdpd_rule_products';
		$wpdb->yith_ywdpd_exclusion_list_table = $wpdb->prefix . 'ywdpd_exclusion_list_table';

		$current_db_version = get_option( 'yith_ywdpd_table_version', '' );

		if ( version_compare( $current_db_version, '3.0.0', '>=' ) ) {
			return;
		}

		// assure dbDelta function is defined.
		if ( ! function_exists( 'dbDelta' ) ) {
			require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		}

		// retrieve table charset.
		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE $wpdb->yith_ywdpd_rules (
				ID bigint(20) NOT NULL AUTO_INCREMENT,
				rule_id int(11) NOT NULL,
				enabled varchar(3) NOT NULL DEFAULT 'yes',
				type varchar(50) NOT NULL  DEFAULT '',
				all_product varchar(3) NOT NULL,
                PRIMARY KEY (ID)
                ) $charset_collate;";

		dbDelta( $sql );
		$sql = "CREATE TABLE $wpdb->yith_ywdpd_rule_products (
				ID bigint(20) NOT NULL AUTO_INCREMENT,
    			rule_id int(11) NOT NULL,
    			product_id int(11) NOT NULL,
                PRIMARY KEY (ID)
                ) $charset_collate;";

		dbDelta( $sql );

		$sql = "CREATE TABLE $wpdb->yith_ywdpd_exclusion_list_table (
    			 ID BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			    term_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
			    term_type varchar(50) NOT NULL DEFAULT  '',
			    PRIMARY KEY ( ID )
                ) $charset_collate;";

		dbDelta( $sql );

		$wpdb->query( "CREATE INDEX index_type_enabled ON $wpdb->yith_ywdpd_rules (type,enabled)" );
		$wpdb->query( "CREATE INDEX index_rule_id ON $wpdb->yith_ywdpd_rules (rule_id)" );
		$wpdb->query( "CREATE INDEX index_rule_id_product_id ON $wpdb->yith_ywdpd_rule_products (rule_id,product_id)" );
		$wpdb->query( "CREATE INDEX index_term_type ON $wpdb->yith_ywdpd_exclusion_list_table (term_type)" );
		$wpdb->query( "CREATE INDEX index_term_id_term_type ON $wpdb->yith_ywdpd_exclusion_list_table (term_id,term_type)" );

		update_option( 'yith_ywdpd_table_version', '3.0.0' );
	}

	/**
	 * Install data stores for the plugin
	 *
	 * @return void.
	 */
	protected static function install_data_stores() {
		add_filter( 'woocommerce_data_stores', array( self::class, 'add_data_stores' ) );
	}

	/**
	 * Add plugin's data stores to list of available ones
	 *
	 * @param array $data_stores Available Data Stores.
	 *
	 * @return array Filtered array of Data Stores
	 */
	public static function add_data_stores( $data_stores ) {
		return array_merge(
			$data_stores,
			array(
				'ywdpd_dynamic_rules' => 'YWDPD_Dynamic_Rules_Data_Store',
			)
		);
	}
}