<?php
/**
 * The class that register the post type
 *
 * @package  YITH WooCommerce Dynamic Pricing & Discounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Post type class
 */
class YWDPD_Post_Type {

	use YWDPD_Singleton_Trait;

	/**
	 * This function init the hook for register post type
	 *
	 * @author YITH <plugins@yithemes.com>
	 * @since  3.0.0
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_post_type' ), 10 );
		add_filter( 'rest_ywdpd_discount_collection_params', array( $this, 'add_collection_params' ) );
		add_filter( 'rest_ywdpd_discount_query', array( $this, 'add_query_args' ), 10, 2 );
	}

	/**
	 * Register the plugin post type
	 *
	 * @since  3.0.0
	 */
	public function register_post_type() {
		$name          = _x( 'Dynamic Rules', 'Post Type General Name', 'ywdpd' );
		$singular_name = _x( 'Dynamic Rule', 'Post Type General Name', 'ywdpd' );

		$labels = array(
			'name'               => $name,
			'singular_name'      => $singular_name,
			'menu_name'          => $singular_name,
			'parent_item_colon'  => __( 'Parent Item:', 'ywdpd' ),
			'all_items'          => __( 'All Discount Rules', 'ywdpd' ),
			'view_item'          => __( 'View Discount Rules', 'ywdpd' ),
			'add_new_item'       => __( '+ Add Rule', 'ywdpd' ),
			'add_new'            => __( '+ Add Rule', 'ywdpd' ),
			'edit_item'          => $singular_name,
			'update_item'        => __( 'Update Discount Rule', 'ywdpd' ),
			'search_items'       => __( 'Search rule', 'ywdpd' ),
			'not_found'          => __( 'Not found', 'ywdpd' ),
			'not_found_in_trash' => __( 'Not found in Trash', 'ywdpd' ),
		);
		$args   = array(
			'label'               => __( 'ywdpd_discount', 'ywdpd' ),
			'labels'              => $labels,
			'supports'            => array( 'title' ),
			'hierarchical'        => false,
			'public'              => false,
			'show_ui'             => true,
			'show_in_rest'        => true,
			'show_in_menu'        => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
		);

		register_post_type( 'ywdpd_discount', $args );
	}

	/**
	 * Add in the custom post type , specific params
	 *
	 * @param array $query_params The query params.
	 *
	 * @return array
	 */
	public function add_collection_params( $query_params ) {
		$query_params['orderby']['enum'][] = 'meta_value_num';

		return $query_params;
	}

	/**
	 * Change the query args with custom args
	 *
	 * @param array           $query_args The query args.
	 * @param WP_REST_Request $request    The request.
	 *
	 * @return array
	 */
	public function add_query_args( $query_args, $request ) {
		$query_args['meta_query']   = array( 'relation' => 'AND' ); // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
		$query_args['meta_query'][] = array(
			'key'     => '_active',
			'value'   => 'yes',
			'compare' => '==',
		);
		if ( isset( $request['orderby'] ) && 'meta_value_num' === $request['orderby'] && ! empty( $request['meta_key'] ) ) {
			$query_args['meta_key'] = $request['meta_key']; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
			$query_args['orderby']  = 'meta_value_num';
		}

		if ( ! empty( $request['ruleType'] ) ) {
			$query_args['meta_query'][] = array(
				'key'     => '_discount_mode',
				'value'   => $request['ruleType'],
				'compare' => '==',
			);
		}

		return $query_args;
	}
}

YWDPD_Post_Type::get_instance();
