<?php
/**
 * Register the plugin shortcodes
 *
 * @package YITH\DyanmicPricingDiscounts\Shortcodes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class YWDPD_Shortcodes
 */
class YWDPD_Shortcodes {

	/**
	 * Init the plugin shortcodes
	 *
	 * @author YITH <plugins@yithemes.com>
	 * @since  3.0.0
	 */
	public static function init() {

		$shortcodes = array(
			'yith_ywdpd_quantity_table' => __CLASS__ . '::quantity_table',
			'yith_ywdpd_product_note'   => __CLASS__ . '::show_notices',
			'yith_ywdpd_cart_notice'    => __CLASS__ . '::show_cart_notices',
		);

		foreach ( $shortcodes as $shortcode => $function ) {
			add_shortcode( $shortcode, $function );
		}
	}

	/**
	 * Show the quantity table
	 *
	 * @param array $atts The args.
	 *
	 * @return string
	 * @since  3.0.0
	 */
	public static function quantity_table( $atts ) {
		$atts = shortcode_atts(
			array(
				'product'  => false,
				'template' => YITH_WC_Dynamic_Options::get_quantity_table_layout(),
			),
			$atts
		);

		if ( ! $atts['product'] ) {
			global $product, $post;
			if ( ( ! $product instanceof WC_Product ) && ( $post && 'product' === get_post_type( $post ) ) ) {
				$product = wc_get_product( $post->ID );
			}
		} else {
			$product = wc_get_product( $atts['product'] );
		}


		ob_start();
		// @codingStandardsIgnoreStart
		echo '<div class="ywdpd-table-discounts-wrapper">';
		/**
		 * APPLY_FILTERS: ywdpd_show_shortcode_quantity_table
		 *
		 * Show the quantity table in the product.
		 *
		 * @param bool $show Show or not.
		 * @param WC_Product $product The product.
		 *
		 * @return bool
		 */
		if ( $product instanceof WC_Product && apply_filters( 'ywdpd_show_shortcode_quantity_table', true, $product ) ) {
			$product_manager = YWDPD_Frontend::get_instance();
			$price_rule      = $product_manager->get_valid_bulk_rule_for_product( $product );

			if ( $price_rule instanceof YWDPD_Quantity_Table ) {

				if ( $price_rule->can_show_table_price() ) {
					$show_quantity_table_schedule = YITH_WC_Dynamic_Options::show_quantity_table_schedule();
					$table_label                  = YITH_WC_Dynamic_Options::get_quantity_columns_table_title();
					$scheduled                    = $price_rule->get_schedule_discount_mode();
					$label_discount               = isset( $table_label['discount'] ) ? $table_label['discount'] : __( '% Discount', 'ywdpd' );
					$until                        = '';
					if ( 'schedule_dates' === $scheduled['schedule_type'] && yith_plugin_fw_is_true( $show_quantity_table_schedule ) && $price_rule->is_scheduled() ) {
						$schedule_to = $scheduled['schedule_to'];
						$until       = sprintf( __( 'Offer ends: %s', 'ywdpd' ), date_i18n( wc_date_format() . ' ' . wc_time_format(), strtotime( $schedule_to ) ) );
					}
					$args          = array(
						'product'        => $product,
						'note'           => $price_rule->can_show_extra_notice() ? ywdpd_get_note( $price_rule->get_table_note() ) : '',
						'label_table'    => YITH_WC_Dynamic_Options::get_quantity_table_title(),
						'label_quantity' => $table_label['quantity'],
						'label_discount' => YITH_WC_Dynamic_Options::can_show_discount_column() ? $label_discount : '',
						'label_price'    => $table_label['price'],
						'until'          => $until,
						'rule'           => $price_rule,
						'template'       => $atts['template'],
						'table'          => YWDPD_Utils::build_quantity_table_args( $product, $price_rule, $atts['template'] ),
					);

					if( 'classic' === $price_rule->get_table_style() ) {
						$template_name = "woocommerce/single-product/ywdpd-quantity-table.php";
					}else{
						$template_name = "woocommerce/single-product/ywdpd-boxed.php";
					}
					wc_get_template( $template_name, $args, '', YITH_YWDPD_TEMPLATE_PATH );
				}
			}
		}
		echo '</div>';

		// @codingStandardsIgnoreEnd
		return ob_get_clean();
	}

	/**
	 * Show all notices
	 *
	 * @param array $atts The shortcode atts.
	 *
	 * @since  3.0.0
	 */
	public static function show_notices( $atts ) {
		$atts = shortcode_atts(
			array(
				'product' => false,
			),
			$atts
		);
		if ( ! $atts['product'] ) {
			global $product, $post;
			if ( ( ! $product instanceof WC_Product ) && ( $post && 'product' === get_post_type( $post ) ) ) {
				$product = wc_get_product( $post->ID );
			}
		} else {
			$product = wc_get_product( $atts['product'] );
		}
		ob_start();

		// @codingStandardsIgnoreStart
		echo '<div class="ywdpd-notices-wrapper">';
		/**
		 * APPLY_FILTERS: ywdpd_show_notices
		 *
		 * Show the notice in the product.
		 *
		 * @param bool $show Show or not.
		 * @param WC_Product $product The product.
		 *
		 * @return bool
		 */
		if ( $product instanceof WC_Product && apply_filters( 'ywdpd_show_notices', true, $product ) ) {
			$all_rules             = ywdpd_get_price_rules_by_type( array(
				'bulk',
				'discount_whole',
				'category_discount',
				'bogo',
				'gift_products',
				'special_offer'
			) );
			$notices               = array(
				'apply_notices'  => array(),
				'adjust_notices' => array(),
			);
			$found_notice_for_bulk = false;
			$is_on_sale            = $product->is_on_sale();
			$notice                = '';

			foreach ( $all_rules as $rule ) {
				/**
				 * The current rule
				 *
				 * @var YWDPD_Price_Rule $rule
				 */

				if ( $rule->is_valid() ) {
					$is_enabled_for_on_sale_products = ! ( $is_on_sale && $rule->is_disabled_on_sale() );
					$is_valid                        = $is_enabled_for_on_sale_products && $rule->is_valid_to_apply( $product, true );
					$is_valid_adjust                 = $rule->is_valid_to_adjust( $product, true );
					$is_bulk                         = in_array( $rule->get_discount_mode(), array(
						'bulk',
						'discount_whole',
						'category_discount'
					) );

					if ( $is_valid && ( ! $is_bulk || $is_bulk && ! $found_notice_for_bulk ) ) {

						if ( $rule->can_show_notice() ) {
							$notice = ywdpd_get_note( $rule->get_table_note_apply_to() );
							if ( false !== strpos( $notice, '%items_with_rule_applied%' ) ) {
								$items_involved = YWDPD_Utils::get_involved_items_by_rule( $rule );

								$notice = str_replace( '%items_with_rule_applied%', wc_get_template_html( 'woocommerce/single-product/ywdpd-involved-items.php', array(
									'items'                 => $items_involved,
									'rule'                  => $rule,
									'show_discounted_price' => true
								), '', YITH_YWDPD_TEMPLATE_PATH ), $notice );

							}
							$notices['apply_notices'][] = $notice;
						}
					}

					if ( $is_valid_adjust && ( ! $is_bulk || $is_bulk && ! $found_notice_for_bulk ) ) {

						if ( $rule->can_show_adjustment_notice() ) {

							$notice = ywdpd_get_note( $rule->get_table_note_adjustment_to() );
							if ( false !== strpos( $notice, '%required_items%' ) ) {
								$items_involved = YWDPD_Utils::get_involved_items( $rule );
								$notice         = str_replace( '%required_items%', wc_get_template_html( 'woocommerce/single-product/ywdpd-involved-items.php', array(
									'items'                 => $items_involved,
									'rule'                  => $rule,
									'show_discounted_price' => false
								), '', YITH_YWDPD_TEMPLATE_PATH ), $notice );
							}
							$notices['adjust_notices'][] = $notice;
						}
					}

					if ( $is_valid || $is_valid_adjust ) {
						if ( in_array( $rule->get_discount_mode(), array(
							'bulk',
							'discount_whole',
							'category_discount'
						) ) ) {
							$found_notice_for_bulk = true;
						}

						if ( ! $rule->is_possible_apply_other_rules() ) {
							break;
						}
					}
				}

			}
			$args = array(
				'product' => $product,
				'notices' => $notices,
			);

			wc_get_template( 'woocommerce/single-product/ywdpd-notices.php', $args, '', YITH_YWDPD_TEMPLATE_PATH );

		}
		echo '</div>';

		// @codingStandardsIgnoreEnd
		return ob_get_clean();

	}

	/**
	 * Show the cart notice
	 *
	 * @since  3.0.0
	 */
	public static function show_cart_notices() {
		ob_start();


		// @codingStandardsIgnoreStart
		echo '<div class="ywdpd-cart-notices-wrapper">';
		$cart_rules = ywdpd_get_cart_rules();
		$notices    = array();

		/**
		 * The cart rule
		 *
		 * @var YWDPD_Cart_Rule $cart_rule
		 */
		foreach ( $cart_rules as $cart_rule ) {
			if ( $cart_rule->can_show_notice() ) {
				$notices = array_merge( $notices, $cart_rule->get_cart_notices() );
			}
		}
		$args = array(
			'notices' => $notices,
		);

		wc_get_template( 'woocommerce/cart/ywdpd-cart-notices.php', $args, '', YITH_YWDPD_TEMPLATE_PATH );

		echo '</div>';

		// @codingStandardsIgnoreEnd
		return ob_get_clean();
	}

}

YWDPD_Shortcodes::init();
