<?php
/**
 * The BOGO rule class.
 *
 * @class YWDPD_BOGO
 * @version 3.0.0
 * @package YITH WooCommerce Dynamic Prcing and Discounts\Classes\Price Rules
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Bogo Class.
 */
class YWDPD_BOGO extends YWDPD_Price_Rule {
	/**
	 * Stores price rule data.
	 *
	 * @var array the common data
	 */
	protected $extra_data = array(
		'text_in_modal_bogo' => '',
	);


	/**
	 * Get the rule if the ID is passed, otherwise the rule is new and empty.
	 *
	 * @param int|YWDPD_BOGO|object $obj ID to load from the DB (optional) or already queried data.
	 *
	 * @throws Exception The exception.
	 */
	public function __construct( $obj = 0 ) {

		parent::__construct( $obj );

		$this->read();
	}


	/**
	 * Set the text in popup
	 *
	 * @param string $text The text.
	 *
	 * @since 3.0.0
	 */
	public function set_text_in_modal_bogo( $text ) {
		$this->set_prop( 'text_in_modal_bogo', $text );
	}


	/**
	 * Set the text in popup
	 *
	 * @param string $context What the value is for. Valid values are view and edit.
	 *
	 * @return string
	 *
	 * @since 3.0.0
	 */
	public function get_text_in_modal_bogo( $context = 'view' ) {
		return $this->get_prop( 'text_in_modal_bogo', $context );
	}

	/**
	 * Return the new price for the specific quantity
	 *
	 * @param float      $price_to_discount The price to discount.
	 * @param int        $quantity The quantity to check.
	 * @param WC_Product $product The product object.
	 *
	 * @return float
	 * @since 3.0.0
	 */
	public function get_discounted_price( $price_to_discount, $quantity, $product ) {
		return 0;
	}

	/**
	 * Add the rule in the cart
	 *
	 * @param string $cart_item_key_to_apply The item key that allow the apply.
	 * @param string $cart_item_key_to_adjust the cart The item key where add the rule.
	 *
	 * @return bool
	 * @since 3.0.0
	 */
	public function apply_rule_in_cart( $cart_item_key_to_apply, $cart_item_key_to_adjust ) {
		$cart_item = WC()->cart->cart_contents[ $cart_item_key_to_apply ];

		$cart_item_key_to_adjust = YWDPD_Counter::is_bogo_product_in_list( $cart_item_key_to_apply );

		if ( $cart_item_key_to_adjust  ) {
			$price = $cart_item['data']->get_price( 'edit' );

			return $this->save_discount_in_cart( $cart_item_key_to_adjust, $price, 0 );
		}

		return false;
	}

	/**
	 * Return the quantity to check
	 *
	 * @param array $cart_item The cart item.
	 *
	 * @return int;
	 * @since 3.0.0
	 */
	public function get_quantity( $cart_item ) {
		$q = intval( $cart_item['quantity'] );

		return $q;
	}

	/**
	 * Check if the rule is valid for adjustment discount.
	 *
	 * @param WC_Product $product The product object.
	 * @param bool       $check_also_variation Check also the variation or not.
	 *
	 * @return bool
	 * @since 3.0.0
	 */
	public function is_valid_to_adjust( $product, $check_also_variation = false ) {
		return false;
	}

	/**
	 * Check if the rule is valid for apply discount.
	 *
	 * @param WC_Product $product The product object.
	 * @param bool       $check_also_variation Check also the variation or not.
	 *
	 * @return bool
	 * @since 3.0.0
	 */
	public function is_valid_to_apply( $product, $check_also_variation = false ) {
		$type     = $this->get_rule_for();
		$is_valid = false;
		$list_ids = array();
		if ( ! $this->is_product_excluded_from_apply( $product ) ) {
			if ( 'all_products' === $type ) {
				$is_valid = true;
			} elseif ( 'specific_products' === $type ) {
				$list_ids = $this->get_rule_for_product_list();
				$is_valid = $this->is_product_in_list( $product, $list_ids, 'product', $check_also_variation );

			} elseif ( 'specific_categories' === $type ) {
				$list_ids = $this->get_rule_for_categories_list();
				$is_valid = $this->is_product_in_list( $product, $list_ids, 'product_cat' );
			} elseif ( 'specific_tag' === $type ) {
				$list_ids = $this->get_rule_for_tags_list();
				$is_valid = $this->is_product_in_list( $product, $list_ids, 'product_tag' );
			}
			/**
			 * APPLY_FILTERS: ywdpd_is_valid_to_apply
			 *
			 * Set if rule is valid.
			 *
			 * @param bool       $is_valid True or false.
			 * @param string     $type The condition type.
			 * @param WC_Product $product The  product.
			 * @param YWDPD_BOGO $rule The  rule.
			 *
			 * @return bool
			 */
			$is_valid = apply_filters( 'ywdpd_is_valid_to_apply', $is_valid, $type, $product, $this );
		}

		return $is_valid;
	}

	/**
	 * Check if this rule is enabled the adjustment to mode
	 *
	 * @param string $context What the value is for. Valid values are view and edit.
	 *
	 * @return bool
	 * @since 3.0.0
	 */
	public function is_enabled_apply_adjustment_to( $context = 'view' ) {

		if ( 'view' === $context ) {
			/**
			 * APPLY_FILTERS: ywdpd_is_enabled_apply_adjustment_to
			 *
			 * Set if rule is enabled for adjustment.
			 *
			 * @param bool       $is_enabled True or false.
			 * @param YWDPD_BOGO $rule The  rule.
			 *
			 * @return bool
			 */
			$value = apply_filters( 'ywdpd_is_enabled_apply_adjustment_to', false, $this );
		}

		return $value;
	}
}
