<?php
/**
 * This file contain the deprecated function
 *
 * @package YITH\DynamicPricingAndDiscounts\Functions
 */

! defined( 'ABSPATH' ) && exit;

/**
 * Wrapper for deprecated functions so we can apply some extra logic.
 *
 * @param string $function Function used.
 * @param string $version Version the message was added in.
 * @param string $replacement Replacement for the called function.
 *
 * @since 3.0.0
 * @author YITH <plugins@yithemes.com>
 */
function yith_ywdpd_deprecated_function( $function, $version, $replacement = null ) {

	$check_debug_log = defined( 'WP_DEBUG' ) && WP_DEBUG;
	// @codingStandardsIgnoreStart
	if ( is_ajax() || $check_debug_log ) {
		do_action( 'deprecated_function_run', $function, $replacement, $version );
		$log_string = "The {$function} function is deprecated since version {$version}.";
		$log_string .= $replacement ? " Replace with {$replacement}." : '';
		error_log( $log_string );
	} else {
		_deprecated_function( $function, $version, $replacement );
	}
	// @codingStandardsIgnoreEnd
}
