<?php
/**
 * Compatibility with YITH_YWDPD_Added_To_Cart_Popup_Integration Premium
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   3.5.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * YITH_YWDPD_Added_To_Cart_Popup_Integration class to add compatibility with YITH_YWDPD_Added_To_Cart_Popup_Integration Premium
 *
 * @class   YITH_YWDPD_Added_To_Cart_Popup_Integration
 * @package YITH WooCommerce Dynamic Pricing & Discounts
 * @since   3.5.0
 */
if ( ! class_exists( 'YITH_YWDPD_Added_To_Cart_Popup_Integration' ) ) {

	/**
	 * Class YITH_YWDPD_Added_To_Cart_Popup_Integration
	 */
	class YITH_YWDPD_Added_To_Cart_Popup_Integration {

		/**
		 * Constructor
		 *
		 * Initialize class and registers actions and filters to be used
		 *
		 * @since  1.1.7
		 */
		public function __construct() {
			add_action( 'woocommerce_add_to_cart', array( $this, 'remove_show_popup_action' ), 35, 1 );
		}

		/**
		 * Check if there is the added to cart popup action and remove dynamic popup
		 *
		 * @param string $cart_item_key The cart item key.
		 *
		 * @since 3.5.0
		 */
		public function remove_show_popup_action( $cart_item_key ) {
			$action             = isset( $_REQUEST['action'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['action'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$add_to_cart_action = isset( $_REQUEST['add-to-cart'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['add-to-cart'] ) ) : false; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

			if ( 'yith_wacp_add_item_cart' === $action && $add_to_cart_action ) {
				$price_manager = ywdpd_dynamic_pricing_discounts()->get_price_rules_manager();
				remove_action( 'woocommerce_add_to_cart', array( $price_manager, 'print_popup_for_special_offer' ), 200 );
			}
		}

	}
}
