<?php
/**
 * Compatibility with YITH WooCommerce Frequently Bought Together Premium
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   3.1.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * YWDPD_Brands class to add compatibility with YITH WooCommerce Brands Add-on Premium
 *
 * @class   YWDPD_Brands
 * @package YITH WooCommerce Dynamic Pricing & Discounts
 * @since   1.1.7
 */
if ( ! class_exists( 'YITH_YWDPD_Frequently_Bought_Together_Integration' ) ) {

	/**
	 * Class YITH_YWDPD_Frequently_Bought_Together_Integration
	 */
	class YITH_YWDPD_Frequently_Bought_Together_Integration {
		/**
		 * Constructor
		 *
		 * Initialize class and registers actions and filters to be used
		 *
		 * @since  1.1.7
		 */
		public function __construct() {

			add_filter( 'yith_wfbt_price_to_display', array( $this, 'fix_product_price' ), 20, 3 );
		}

		/**
		 * Return the right dynamic price
		 *
		 * @param float                $price The product price.
		 * @param WC_Product           $product The product.
		 * @param WC_Product_Variation $variation The variation.
		 *
		 * @return float
		 * @since 3.1.0
		 */
		public function fix_product_price( $price, $product, $variation ) {
			$prod  = is_null( $variation ) ? $product : $variation;
			$price = ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->get_dynamic_price( $price, $prod );

			return $price;
		}
	}
}
