<?php
/**
 * This class manage the integration with YITH Points And Rewards plugin
 *
 * @package YITH\DynamicPricingAndDiscount\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The class
 */
class YITH_YWDPD_Points_And_Rewards_Integration {

	public function __construct() {
		add_filter( 'ywpar_get_product_points_cache', '__return_false', 999 );
		add_filter( 'ywpar_get_product_price', array( $this, 'get_dynamic_price' ), 10, 6 );
		add_filter( 'ywpar_calculate_cart_item_points_on_cart', array( $this, 'calculate_cart_item_points' ), 10, 2 );
		add_action( 'wp_ajax_nopriv_ywdpd_update_product_points_message', array( $this, 'update_product_message' ) );
		add_action( 'wp_ajax_ywdpd_update_product_points_message', array( $this, 'update_product_message' ) );
	}


	/**
	 * Calculate the points with the dynamic price
	 *
	 * @param float      $display_price The display price.
	 * @param string     $action The action.
	 * @param string     $currency The currency.
	 * @param int        $qty The quantity.
	 * @param float      $price The price.
	 * @param WC_Product $product The product.
	 *
	 * @return float
	 */
	public function get_dynamic_price( $display_price, $action, $currency, $qty, $price, $product ) {
		remove_filter( 'ywpar_get_product_price', array( $this, 'get_dynamic_price' ), 10 );
		if ( !$product->get_meta( 'has_dynamic_price' ) ) {
			$frontend = ywdpd_dynamic_pricing_discounts()->get_frontend_manager();

			$dynamic_price = wc_get_price_to_display( $product, array( 'price' => $frontend->get_dynamic_price( $price, $product ) ) );

			if ( $display_price !== $dynamic_price ) {
				$display_price = ywpar_get_product_price( $product, $action, $currency, $qty, $dynamic_price );
			}
		}else{
			$display_price = wc_get_price_to_display( $product, array( 'price' => $display_price ) );
		}
		add_filter( 'ywpar_get_product_price', array( $this, 'get_dynamic_price' ), 10, 6 );

		return $display_price;
	}

	/**
	 * @param $points
	 * @param $cart_item
	 *
	 * @return float
	 */
	public function calculate_cart_item_points( $points, $cart_item ) {
		if ( $points > 0 && isset( $cart_item['ywdpd_discounts'] ) ) {
			remove_filter( 'ywpar_get_product_price', array( $this, 'get_dynamic_price' ), 10 );
			$currency      = ywpar_get_currency();
			$dynamic_price = $cart_item['ywdpd_discounts']['price_adjusted'];
			$points        = yith_points()->earning->get_points_earned_from_price( $dynamic_price, $currency, true );
			$points        = yith_points()->earning->add_points_for_rules( $points, $cart_item['data'], null, $currency );
			add_filter( 'ywpar_get_product_price', array( $this, 'get_dynamic_price' ), 10, 6 );
		}

		return $points;
	}

	public function update_product_message() {
		check_ajax_referer( 'update-product-points-message', 'security' );
		if ( isset( $_REQUEST['product_id'] ) && isset( $_REQUEST['dynamic_price'] ) ) {
			$product_id = sanitize_text_field( wp_unslash( $_REQUEST['product_id'] ) );
			/**
			 * APPLY_FILTERS: ywpar_update_product_message_on_qty_change
			 *
			 * Update the points product message on quantity change
			 *
			 * @param bool $update default false;
			 */
			if ( apply_filters( 'ywpar_update_product_message_on_qty_change', false ) ) {
				$price = sanitize_text_field( wp_unslash( $_REQUEST['dynamic_price'] ) ) * sanitize_text_field( wp_unslash( $_REQUEST['qty'] ) );
			} else {
				$price = sanitize_text_field( wp_unslash( $_REQUEST['dynamic_price'] ) );
			}
			
			$product    = wc_get_product( $product_id );
			$currency   = ywpar_get_currency();
			$points     = yith_points()->earning->get_points_earned_from_price( $price, $currency, true );
			$points     = yith_points()->earning->add_points_for_rules( $points, $product, null, $currency );
			$message    = ywpar_get_option( 'single_product_message' );
			$message    = ywpar_replace_placeholder_on_product_message( $product, $message, $points );
			$response   = array(
				'message' => $message,
				'show'    => $points > 0
			);
			wp_send_json_success( $response );
		}
	}
}