<?php
/**
 * Compatibility with WOOCS WooCommerce Currency Switcher
 *
 * @package YITH\DynamicPricingAndDiscount\Classes
 */

! defined( 'ABSPATH' ) && exit; // Exit if accessed directly.

/**
 * Class that manange the compatibility with Multi Currency Switcher
 */
class YITH_YWDPD_WOOCS_Multi_Currency_Integration {
	/**
	 * Single instance of the class
	 *
	 * @var YITH_YWDPD_WOOCS_Multi_Currency_Integration
	 */
	protected static $instance;

	/**
	 * Returns single instance of the class
	 *
	 * @return YITH_YWDPD_WOOCS_Multi_Currency_Integration
	 * @since 3.3.0
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor
	 *
	 * Initialize class and registers actions and filters to be used
	 *
	 * @since  3.3.0
	 * @author YITH <plugins@yithemes.com>
	 */
	public function __construct() {
		add_filter( 'ywdpd_price_rule_get_gift_subtotal', array( $this, 'convert_amount' ) );
		add_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'ywdpd_get_discounted_price', array( $this, 'convert_default_currency' ), 99, 1 );
		add_filter( 'ywdpd_cart_item_adjusted_price', array( $this, 'convert_amount' ), 99, 1 );
		add_action( 'ywdpd_before_calculate_discounts', array( $this, 'remove_filters' ), 1 );
		add_action( 'ywdpd_before_get_price_to_discount', array( $this, 'remove_filters' ), 1 );
		add_action( 'ywdpd_after_calculate_discounts', array( $this, 'add_filters' ), 1 );
		add_action( 'ywdpd_after_get_price_to_discount', array( $this, 'add_filters' ), 1 );
		add_filter( 'ywdpd_cart_rule_get_minimum_subtotal', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'ywdpd_cart_rule_get_maximum_subtotal', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'yith_wcmcs_apply_currency_filters', array( $this, 'apply_currency_filter' ), 20 );
		add_filter( 'ywdpd_set_price_base', array( $this, 'set_the_right_price' ), 10, 2 );
		add_filter( 'ywdpd_cart_item_display_price', array( $this, 'set_the_right_cart_item_price' ), 10, 2 );
	}

	/**
	 * Remove the filters to avoid wrong conversion
	 *
	 * @since 3.3.0
	 */
	public function remove_filters() {
		// phpcs:disable
		global $WOOCS;

		remove_filter( 'woocommerce_product_get_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999 );
		remove_filter( 'woocommerce_product_variation_get_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999 );
		remove_filter( 'woocommerce_product_variation_get_regular_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999 );
		remove_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99 );
		// phpcs:enable
	}

	/**
	 * Add the filters to avoid wrong conversion
	 *
	 * @since 3.3.0
	 */
	public function add_filters() {
		// phpcs:disable
		global $WOOCS;

		add_filter( 'woocommerce_product_get_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999, 2 );
		add_filter( 'woocommerce_product_variation_get_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999, 2 );
		add_filter( 'woocommerce_product_variation_get_regular_price', array( $WOOCS, 'raw_woocommerce_price' ), 9999, 2 );
		add_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99, 1 );
		// phpcs:enable

	}

	/**
	 * Check if there is an ajax action to apply the conversion
	 *
	 * @param bool $apply Apply conversions.
	 *
	 * @return bool
	 * @since 3.3.0
	 */
	public function apply_currency_filter( $apply ) {
		$dynamic_ajax_actions = array(
			'ywdpd_add_gift_to_cart',
			'ywdpd_update_gift_popup',
			'ywdpd_add_special_to_cart',
		);
		$apply                = $apply || isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], $dynamic_ajax_actions, true ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

		return $apply;
	}

	/**
	 * Convert the price to base currency
	 *
	 * @param float $amount the amount to convert.
	 *
	 * @return float
	 * @since 3.3.0
	 */
	public function convert_amount( $amount ) {
		global $WOOCS; //phpcs:ignore

		if ( $WOOCS->is_multiple_allowed ) { //phpcs:ignore
			$current = $WOOCS->current_currency; //phpcs:ignore

			if ( $current != $WOOCS->default_currency ) { //phpcs:ignore
				$currencies = $WOOCS->get_currencies(); //phpcs:ignore
				$rate       = $currencies[ $current ]['rate'];
				$amount     = $amount * ( $rate );
			}
		}


		return $amount;
	}

	/**
	 * Get the base amount
	 *
	 * @since 3.8.0
	 * @param float $amount The amount to convert.
	 *
	 * @return float
	 */
	public function convert_default_currency( $amount ) {
		global $WOOCS; //phpcs:ignore

		if ( $WOOCS->is_multiple_allowed ) { //phpcs:ignore

			$current = $WOOCS->current_currency; //phpcs:ignore

			$currencies = $WOOCS->get_currencies(); //phpcs:ignore
			$rate       = $currencies[ $current ]['rate'];

			$amount = $amount / ( $rate );
		}


		return $amount;
	}

	/**
	 * Set the right product price
	 *
	 * @param float $price The price.
	 * @param array $cart_item The cart item.
	 *
	 * @return float
	 * @since 3.0.0
	 */
	public function set_the_right_price( $price, $cart_item ) {
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->remove_price_filters();
		$price = (float) wc_get_product( $cart_item['data'] )->get_price();
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->add_price_filters();

		return $price;
	}

	public function set_the_right_cart_item_price( $display_price, $cart_item ){
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->remove_price_filters();
		$price = (float) wc_get_product( $cart_item['data'] )->get_price();
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->add_price_filters();

		return $price;
	}
}
