<?php
/**
 * Compatibility with WPML
 *
 * @package YITH\DynamicPricingAndDiscount\Classes
 */

! defined( 'ABSPATH' ) && exit; // Exit if accessed directly.

/**
 * WPML integration
 */
class YITH_YWDPD_Wpml_Integration {
	/**
	 * Constructor
	 *
	 * Initialize class and registers actions and filters to be used
	 *
	 * @since  1.0.0
	 * @author YITH <plugins@yithemes.com>
	 */
	public function __construct() {

		if ( YITH_WC_Dynamic_Options::can_wpml_extend_to_translated_object() ) {

			add_action( 'init', array( $this, 'remove_wpml_admin_language_switcher' ), 5 );
			add_filter( 'ywdpd_price_rule_get_rule_for_products_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_exclude_rule_for_products_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_products_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_products_list_excluded', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_gift_product_selection', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_required_product_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_excluded_product_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_disable_product_list', array( $this, 'add_translated_product_id' ), 99, 1 );
			add_filter( 'ywdpd_get_exclusion_product_ids', array( $this, 'add_translated_product_id' ), 99, 1 );

			add_filter( 'ywdpd_price_rule_get_rule_for_categories_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_exclude_rule_for_categories_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_categories_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_categories_list_excluded', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_single_category_discount', array( $this, 'add_single_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_required_product_category_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_excluded_product_categories_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_disable_product_categories_list', array( $this, 'add_translated_category_id' ), 99, 1 );
			add_filter( 'ywdpd_get_exclusion_category_ids', array( $this, 'add_translated_category_id' ), 99, 1 );

			add_filter( 'ywdpd_price_rule_get_rule_for_tags_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_exclude_rule_for_tags_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_tags_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_price_rule_get_apply_adjustment_tags_list_excluded', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_required_product_tag_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_excluded_product_tag_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_disable_product_tag_list', array( $this, 'add_translated_tag_id' ), 99, 1 );
			add_filter( 'ywdpd_get_exclusion_tag_ids', array( $this, 'add_translated_tag_id' ), 99, 1 );

			add_filter( 'ywdpd_set_price_base', array( $this, 'set_the_right_wpml_price' ), 10, 2 );

			add_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_minimum_subtotal', array( $this, 'convert_amount' ), 99, 1 );
			add_filter( 'ywdpd_advanced_conditions_get_maximum_subtotal', array( $this, 'convert_amount' ), 99, 1 );

			// AJAX ACTIONS.
			add_filter( 'wcml_multi_currency_ajax_actions', array( $this, 'add_ajax_actions' ), 30, 1 );
		}
	}

	/**
	 * Remove the wpml admin language switcher in dynamic admin pages
	 *
	 * @since 3.3.0
	 */
	public function remove_wpml_admin_language_switcher() {
		$is_dynamic_page = isset( $_GET['page'] ) && 'yith_woocommerce_dynamic_pricing_and_discounts' === $_GET['page']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$is_post_type    = isset( $_GET['post_type'] ) && 'ywdpd_discount' === $_GET['post_type']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$is_edit_post    = isset( $_GET['post'] ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if ( $is_dynamic_page || $is_post_type || $is_edit_post ) {
			global $sitepress;
			remove_action( 'wp_before_admin_bar_render', array( $sitepress, 'admin_language_switcher' ) );
		}
	}

	/**
	 * Add in the array the translated product id.
	 *
	 * @param array $product_ids The original product ids.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public function add_translated_product_id( $product_ids ) {
		$translated_ids   = array();
		$current_language = apply_filters( 'wpml_current_language', null );
		foreach ( $product_ids as $product_id ) {
			$translated_id = intval( yit_wpml_object_id( $product_id, 'product', true, $current_language ) );
			if ( intval( $product_id ) !== $translated_id && ! in_array( $translated_id, $translated_ids, true ) ) {
				$translated_ids[] = $translated_id;
			}
		}

		return count( $translated_ids ) > 0 ? $translated_ids : $product_ids;
	}

	/**
	 * Add in the array the translated category id.
	 *
	 * @param array $category_ids The original category ids.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public function add_translated_category_id( $category_ids ) {
		$translated_ids = array();

		foreach ( $category_ids as $category_id ) {

			$translated_id = intval( yit_wpml_object_id( $category_id, 'product_cat', true ) );

			if ( intval( $category_id ) !== $translated_id && ! in_array( $translated_id, $translated_ids, true ) ) {
				$translated_ids[] = $translated_id;
			}
		}

		return count( $translated_ids ) > 0 ? $translated_ids : $category_ids;
	}

	/**
	 * Translate the category
	 *
	 * @param int $category_id The category id to translate.
	 *
	 * @return int
	 * @since 3.0.0
	 */
	public function add_single_translated_category_id( $category_id ) {
		$translated_id = intval( yit_wpml_object_id( $category_id, 'product_cat', true ) );

		return $translated_id;
	}

	/**
	 * Add in the array the translated tag id.
	 *
	 * @param array $tag_ids The original category ids.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public function add_translated_tag_id( $tag_ids ) {
		$translated_ids = array();

		foreach ( $tag_ids as $tag_id ) {

			$translated_id = intval( yit_wpml_object_id( $tag_id, 'product_tag', true ) );

			if ( intval( $tag_id ) !== $translated_id && ! in_array( $translated_id, $translated_ids, true ) ) {
				$translated_ids[] = $translated_id;
			}
		}

		return count( $translated_ids ) > 0 ? $translated_ids : $tag_ids;
	}

	/**
	 * Set the right product price
	 *
	 * @param float $price The price.
	 * @param array $cart_item The cart item.
	 *
	 * @return float
	 * @since 3.0.0
	 */
	public function set_the_right_wpml_price( $price, $cart_item ) {
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->remove_price_filters();
		$price = (float) wc_get_product( $cart_item['data'] )->get_price();
		ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->add_price_filters();

		return $price;
	}

	/**
	 * Convert the amount
	 *
	 * @param float $amount Amount to convert in the right currency.
	 *
	 * @since 3.0.0
	 */
	public function convert_amount( $amount ) {
		global $woocommerce_wpml;
		if ( ! is_null( $woocommerce_wpml ) && ! is_null( $woocommerce_wpml->multi_currency ) && ! is_null( $woocommerce_wpml->multi_currency->prices ) ) {
			$amount = $woocommerce_wpml->multi_currency->prices->convert_price_amount( $amount );
		}
		return $amount;
	}

	/**
	 * Add plugin ajax action to convert the price in ajax
	 *
	 * @param array $actions ajax actions.
	 *
	 * @return array
	 * @since 3.0.0
	 */
	public function add_ajax_actions( $actions ) {
		$actions[] = 'ywdpd_update_product_price';

		return $actions;
	}
}

