<?php
/**
 * Frontend class.
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Implements frontend features of YITH WooCommerce Dynamic Pricing & Discounts
 *
 * @class   YITH_WC_Dynamic_Pricing_Frontend
 * @package YITH WooCommerce Dynamic Pricing & Discounts
 * @since   1.0.0
 */
if ( ! class_exists( 'YITH_WC_Dynamic_Pricing_Frontend' ) ) {

	/**
	 * Class YITH_WC_Dynamic_Pricing_Frontend
	 */
	class YITH_WC_Dynamic_Pricing_Frontend {


		/**
		 * Single instance of the class
		 *
		 * @var YITH_WC_Dynamic_Pricing_Frontend
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_WC_Dynamic_Pricing_Frontend
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}
		/**
		 * Show table quantity in the single product if there's a pricing rule
		 *
		 * @param false|WC_Product $product The product.
		 */
		public function show_note_on_products( $product = false ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Frontend::show_note_on_products', '3.0', 'use YWDPD_Frontend::show_note_on_products instead' );
			YWDPD_Frontend::get_instance()->show_note_on_products( $product );
		}


		/**
		 * Show table quantity in the single product if there's a pricing rule
		 *
		 * @param WC_Product|bool $product Product.
		 * @param bool            $sh Boolean.
		 *
		 * @since  1.0.0
		 */
		public function show_table_quantity( $product = false, $sh = false ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Frontend::show_table_quantity', '3.0', 'use YWDPD_Frontend::show_table_quantity instead' );
			YWDPD_Frontend::get_instance()->show_table_quantity( $product );
		}

		/**
		 * Table quantity.
		 *
		 * @param WC_Product $product Product.
		 *
		 * @return string
		 */
		public function table_quantity( $product ) {
			ob_start();
			$this->show_table_quantity( $product );

			return ob_get_clean();

		}
	}

}

/**
 * Unique access to instance of YITH_WC_Dynamic_Pricing_Frontend class
 *
 * @return YITH_WC_Dynamic_Pricing_Frontend
 */
function YITH_WC_Dynamic_Pricing_Frontend() { //phpcs:ignore
	return YITH_WC_Dynamic_Pricing_Frontend::get_instance();
}
