<?php
/**
 * Helper function for YITH WooCommerce Dynamic Pricing & Discounts
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Helper function for YITH WooCommerce Dynamic Pricing & Discounts
 *
 * @class   YITH_WC_Dynamic_Pricing
 * @package YITH WooCommerce Dynamic Pricing & Discounts
 * @since   1.0.0
 */
if ( ! class_exists( 'YITH_WC_Dynamic_Pricing_Helper' ) ) {

	/**
	 * Class YITH_WC_Dynamic_Pricing_Helper
	 */
	class YITH_WC_Dynamic_Pricing_Helper {

		/**
		 * Single instance of the class
		 *
		 * @var YITH_WC_Dynamic_Pricing_Helper
		 */
		protected static $instance;
		/**
		 * Product counters.
		 *
		 * @var array
		 */
		public $product_counters = array();
		/**
		 * Variation counters.
		 *
		 * @var array
		 */
		public $variation_counters = array();
		/**
		 * Categories counter.
		 *
		 * @var array
		 */
		public $categories_counter = array();
		/**
		 * Categories on cart.
		 *
		 * @var array
		 */
		public $cart_categories = array();
		/**
		 * Tags counters.
		 *
		 * @var array
		 */
		public $tags_counter = array();
		/**
		 * Tags on cart.
		 *
		 * @var array
		 */
		public $cart_tags = array();
		/**
		 * Discount to apply.
		 *
		 * @var array
		 */
		public $discounts_to_apply = array();
		/**
		 * Product to apply.
		 *
		 * @var array
		 */
		private $valid_product_to_apply = array();
		/**
		 * Gift product to apply.
		 *
		 * @var array
		 */
		private $valid_gift_product_to_apply = array();
		/**
		 * Valid product to adjustment.
		 *
		 * @var array
		 */
		private $valid_product_to_adjustment = array();

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_WC_Dynamic_Pricing_Helper
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}


		/**
		 * Check valid product to adjustment.
		 *
		 * @param array      $rule Rule.
		 * @param WC_Product $product Product.
		 * @param bool       $other_variations Variations.
		 *
		 * @return bool
		 */
		public function valid_product_to_adjustment( $rule, $product, $other_variations = false ) {

			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Helper::valid_product_to_adjustment', '3.0', 'create a specific YWDPD_Price_Rule object and check with YWDPD_Price_Rule::is_valid_to_adjust($product)' );

			$rule_object = ywdpd_get_rule( $rule['id'] );

			return $rule_object->is_valid_to_adjust( $product );
		}

		/**
		 * Check if the product is a valid product to apply the rule
		 *
		 * @param array                          $rule Rule.
		 * @param WC_Product|WC_Product_Variable $product Product.
		 * @param bool                           $other_variations Variations.
		 *
		 * @return bool
		 */
		public function valid_product_to_apply( $rule, $product, $other_variations = false ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Helper::valid_product_to_apply', '3.0', 'create a specific YWDPD_Price_Rule object and check with YWDPD_Price_Rule::is_valid_to_apply($product)' );

			$rule_object = ywdpd_get_rule( $rule['id'] );

			return ! $rule_object->is_product_excluded_from_apply( $product ) && $rule_object->is_valid_to_apply( $product );
		}

		/**
		 * Check if the product is a valid product to apply the bulk rule
		 *
		 * @param array      $rule Rule.
		 * @param WC_Product $product Product.
		 * @param bool       $other_variations Variations.
		 *
		 * @return bool
		 */
		public function valid_product_to_apply_bulk( $rule, $product, $other_variations = false ) {

			return isset( $rule['discount_mode'] ) && 'bulk' === $rule['discount_mode'] && $this->valid_product_to_apply( $rule, $product, $other_variations );
		}

		/**
		 * Check if the product is a valid product to adjustment the bulk rule
		 *
		 * @param array      $rule Rule.
		 * @param WC_Product $product Product.
		 * @param bool       $other_variations Variations.
		 *
		 * @return bool
		 */
		public function valid_product_to_adjustment_bulk( $rule, $product, $other_variations = false ) {
			return isset( $rule['discount_mode'] ) && 'bulk' === $rule['discount_mode'] && $this->valid_product_to_adjustment( $rule, $product, $other_variations );
		}


		/**
		 * Check taxonomy.
		 *
		 * @param array  $list List.
		 * @param string $item Product id.
		 * @param string $taxonomy_name Taxonomy.
		 * @param bool   $in Bool.
		 *
		 * @return bool
		 */
		public function check_taxonomy( $list, $item, $taxonomy_name, $in = true ) {

			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Helper::check_taxonomy', '3.0', 'use YWDPD_Utils::check_taxonomy instead' );

			return YWDPD_Utils::check_taxonomy( $list, $item, $taxonomy_name, $in );
		}

		/**
		 * Check if product is excluded
		 *
		 * @param array $cart_item The item.
		 *
		 * @return bool
		 */
		public function is_in_exclusion_rule( $cart_item ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing_Helper::is_in_exclusion_rule', '3.0', 'use YITH_WC_Dynamic_Exclusion_Manager::is_in_exclusion_rule instead' );
			$product = wc_get_product( $cart_item['product_id'] );

			return YITH_WC_Dynamic_Exclusion_Manager::get_instance()->is_in_exclusion_rule( $product );

		}
	}
}


/**
 * Unique access to instance of YITH_WC_Dynamic_Pricing_Helper class
 *
 * @return YITH_WC_Dynamic_Pricing_Helper
 */
function YITH_WC_Dynamic_Pricing_Helper() { // phpcs:ignore WordPress.NamingConventions.ValidFunctionName
	return YITH_WC_Dynamic_Pricing_Helper::get_instance();
}


