<?php
/**
 * Main class.
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * Implements features of YITH WooCommerce Dynamic Pricing & Discounts
 *
 * @class   YITH_WC_Dynamic_Pricing
 * @package YITH WooCommerce Dynamic Pricing & Discounts
 * @since   1.0.0
 */
if ( ! class_exists( 'YITH_WC_Dynamic_Pricing' ) ) {

	/**
	 * Class YITH_WC_Dynamic_Pricing
	 */
	class YITH_WC_Dynamic_Pricing {

		/**
		 * Single instance of the class
		 *
		 * @var YITH_WC_Dynamic_Pricing
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_WC_Dynamic_Pricing
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}


		/**
		 * Return pricing rules filtered and validates
		 *
		 * Initialize plugin and registers actions and filters to be used
		 *
		 * @since  1.0.0
		 */
		public function get_pricing_rules() {

			$pricing_rules = (array) $this->filter_valid_rules( $this->recover_pricing_rules() );

			return $pricing_rules;
		}

		/**
		 * Recover pricing rules
		 *
		 * @return array
		 */
		public function recover_pricing_rules() {

			$pricing_rules = ywdpd_recover_rules( '' );

			return $pricing_rules;
		}

		/**
		 * Return pricing rules validates
		 *
		 * Initialize plugin and registers actions and filters to be used
		 *
		 * @param array $pricing_rules Pricing rules.
		 *
		 * @return array
		 * @since  1.0.0
		 */
		public function filter_valid_rules( $pricing_rules ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing::filter_valid_rules', '3.0', 'use ywdpd_get_price_rules instead' );
			$valid_rules = array();

			foreach ( $pricing_rules as $pricing_rule ) {

				$rule = ywdpd_get_rule( $pricing_rule['id'] );

				if ( $rule->is_valid() ) {
					$valid_rules[ $rule->get_key() ] = $rule->get_data();
				}
			}

			return $valid_rules;
		}

		/**
		 * Return the discounted price
		 *
		 * @param float      $default_price Default price.
		 * @param WC_Product $product Product.
		 *
		 * @return float
		 */
		public function get_discount_price( $default_price, $product ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing::get_discount_price', '3.0', 'use YWDPD_Frontend::get_dynamic_price instead' );

			$discount_price = YWDPD_Frontend::get_instance()->get_dynamic_price( $default_price, $product, 1 );

			return $discount_price;
		}

		/**
		 * Check if a product has discount
		 *
		 * @param WC_Product $product The product.
		 *
		 * @return bool
		 * @since 1.1.0
		 */
		public function check_discount( $product ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Pricing::check_discount', '3.0', 'use YWDPD_Frontend::get_valid_bulk_rule_for_product instead' );

			return false !== YWDPD_Frontend::get_instance()->get_valid_bulk_rule_for_product( $product );
		}
	}
}

/**
 * Unique access to instance of YITH_WC_Dynamic_Pricing class
 *
 * @return YITH_WC_Dynamic_Pricing
 */
function YITH_WC_Dynamic_Pricing() { //phpcs:ignore
	return YITH_WC_Dynamic_Pricing::get_instance();
}

