<?php
/**
 * Plugin Name: YITH WooCommerce Dynamic Pricing & Discounts Premium
 * Plugin URI: https://yithemes.com/themes/plugins/yith-woocommerce-dynamic-pricing-and-discounts/
 * Description: <code><strong>YITH WooCommerce Dynamic Pricing & Discounts</code></strong> allows editing prices and enabling dynamic discounts in a simple, quick, and intuitive way. Having a store without these features would be a serious mistake! <a href="https://yithemes.com/" target="_blank">Get more plugins for your e-commerce shop on <strong>YITH</strong></a>.
 * Version: 4.21.0
 * Author: YITH
 * Author URI: https://yithemes.com/
 * Text Domain: ywdpd
 * Domain Path: /languages/
 * WC requires at least: 9.7
 * WC tested up to: 9.9
 * Requires Plugins: woocommerce
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! function_exists( 'is_plugin_active' ) ) {
	require_once ABSPATH . 'wp-admin/includes/plugin.php';
}


if ( ! defined( 'YITH_YWDPD_DIR' ) ) {
	define( 'YITH_YWDPD_DIR', plugin_dir_path( __FILE__ ) );
}

// Plugin Framework Loader.
if ( file_exists( plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'plugin-fw/init.php';
}
if( ! function_exists('yith_plugin_fw_wc_is_using_block_template_in_single_product') && file_exists( YITH_YWDPD_DIR . 'plugin-fw/yit-woocommerce-compatibility.php' )){
	require_once YITH_YWDPD_DIR . 'plugin-fw/yit-woocommerce-compatibility.php';
}

if ( ! function_exists( 'yith_plugin_onboarding_registration_hook' ) ) {
	include_once 'plugin-upgrade/functions-yith-licence.php';
}
register_activation_hook( __FILE__, 'yith_plugin_onboarding_registration_hook' );

// Define constants ________________________________________.
if ( defined( 'YITH_YWDPD_VERSION' ) ) {
	return;
} else {
	define( 'YITH_YWDPD_VERSION', '4.21.0' );
}

if ( ! defined( 'YITH_YWDPD_PREMIUM' ) ) {
	define( 'YITH_YWDPD_PREMIUM', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YITH_YWDPD_INIT' ) ) {
	define( 'YITH_YWDPD_INIT', plugin_basename( __FILE__ ) );
}

if ( ! defined( 'YITH_YWDPD_FILE' ) ) {
	define( 'YITH_YWDPD_FILE', __FILE__ );
}

if ( ! defined( 'YITH_YWDPD_URL' ) ) {
	define( 'YITH_YWDPD_URL', plugins_url( '/', __FILE__ ) );
}

if ( ! defined( 'YITH_YWDPD_ASSETS_URL' ) ) {
	define( 'YITH_YWDPD_ASSETS_URL', YITH_YWDPD_URL . 'assets' );
}

if ( ! defined( 'YITH_YWDPD_TEMPLATE_PATH' ) ) {
	define( 'YITH_YWDPD_TEMPLATE_PATH', YITH_YWDPD_DIR . 'templates/' );
}

if ( ! defined( 'YITH_YWDPD_INC' ) ) {
	define( 'YITH_YWDPD_INC', YITH_YWDPD_DIR . '/includes/' );
}

if ( ! defined( 'YITH_YWDPD_SUFFIX' ) ) {
	$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	define( 'YITH_YWDPD_SUFFIX', $suffix );
}


if ( ! defined( 'YITH_YWDPD_SLUG' ) ) {
	define( 'YITH_YWDPD_SLUG', 'yith-woocommerce-dynamic-pricing-and-discounts' );
}

if ( ! defined( 'YITH_YWDPD_SECRET_KEY' ) ) {
	define( 'YITH_YWDPD_SECRET_KEY', '' );
}

if ( ! defined( 'YITH_YWDPD_DEBUG' ) ) {
	define( 'YITH_YWDPD_DEBUG', false );
}

! defined( 'YITH_YWDPD_VIEW_PATH' ) && define( 'YITH_YWDPD_VIEW_PATH', YITH_YWDPD_DIR . 'views' );
if ( ! function_exists( 'yith_ywdpd_install_woocommerce_admin_notice' ) ) {
	/**
	 * Trigger a notice if WooCommerce is not installed.
	 */
	function yith_ywdpd_install_woocommerce_admin_notice() {
		?>
        <div class="error">
            <p><?php esc_html_e( 'YITH WooCommerce Dynamic Pricing & Discounts Premium is enabled but not effective. It requires WooCommerce in order to work.', 'ywdpd' ); ?></p>
        </div>
		<?php
	}
}

if ( ! function_exists( 'yith_ywdpd_install' ) ) {
	/**
	 * Install the plugin.
	 */
	function yith_ywdpd_install() {

		if ( ! function_exists( 'WC' ) ) {
			add_action( 'admin_notices', 'yith_ywdpd_install_woocommerce_admin_notice' );
		} else {
			add_action( 'before_woocommerce_init', 'yith_ywdpd_add_support_hpos_system' );
			/**
			 * DO_ACTION: yith_ywdpd_init
			 *
			 * Triggered to install the plugin.
			 */
			do_action( 'yith_ywdpd_init' );
		}
	}

	add_action( 'plugins_loaded', 'yith_ywdpd_install', 11 );
}
if ( ! function_exists( 'yith_ywdpd_add_support_hpos_system' ) ) {
	/**
	 * Add support with HPOS system for WooCommerce 8
	 *
	 * @return void
	 */
	function yith_ywdpd_add_support_hpos_system() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {

			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', YITH_YWDPD_INIT );
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', YITH_YWDPD_INIT );
		}
	}
}

/**
 * Load the plugin.
 */
function yith_ywdpd_premium_constructor() {
	if ( function_exists( 'yith_plugin_fw_load_plugin_textdomain' ) ) {
		yith_plugin_fw_load_plugin_textdomain( 'ywdpd', dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	require_once YITH_YWDPD_INC . 'traits/trait-ywdpd-singleton-trait.php';
	require_once YITH_YWDPD_INC . 'class-yith-wc-dynamic-pricing-discounts.php';

	// Instance the main class.
	ywdpd_dynamic_pricing_discounts();

	if ( ! class_exists( 'YWDPD_Install' ) ) {
		require_once YITH_YWDPD_INC . 'class-ywdpd-install.php';
	}
	YWDPD_Install::init();
}


/**
 * APPLY_FILTERS: yith_ywdpd_can_init_plugin
 *
 * Allow to init the plugin.
 *
 * @param bool $init_plugin True or false.
 *
 * @return bool
 */
if ( apply_filters( 'yith_ywdpd_can_init_plugin', true ) ) {
	add_action( 'yith_ywdpd_init', 'yith_ywdpd_premium_constructor' );
}

require_once YITH_YWDPD_INC.'wc-blocks/src/class-ywdpd-wc-blocks-register.php';