<?php
/**
 * Pricing rules settings
 *
 * @package YITH WooCommerce Dynamic Pricing & Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH <plugins@yithemes.com>
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

$pricing = array(
	'dynamic-rules' => array(
		'pricing_list' => array(
			'type'          => 'post_type',
			'post_type'     => 'ywdpd_discount',
			'wp-list-style' => 'boxed',
			'wrapper-class' => 'ywdpd_dinamic_rules_table',
		),
	),
);

/**
 * APPLY_FILTERS: ywdpd_panel_price_rules_tab
 *
 * Allow change the rule tab settings options.
 *
 * @param array $pricing The options.
 *
 * @return array
 */
return apply_filters( 'ywdpd_panel_price_rules_tab', $pricing );
