<?php
/**
 * This file contain the plugin options
 *
 * @since   4.0
 * @package YITH\DynamicPricingAndDiscounts\Options
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$cart_settings = array(
	'general-cart-settings' => array(
		'cart_section_start'              => array(
			'type' => 'title',
			'name' => __( 'Cart settings', 'ywdpd' ),
		),
		'cart_how_show_cart_label'        => array(
			'id'        => 'ywdpd_cart_label_mode',
			'name'      => __( 'In the cart page show', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'default_name' => __( 'A single label to identify all of the cart rules applied', 'ywdpd' ),
				'list_of_name' => __( 'The list of all of the cart rules applied', 'ywdpd' ),
			),
			'default'   => 'default_name',
			'desc'      => __( 'Choose how to show the coupon label in the cart', 'ywdpd' ),
		),
		'cart_coupon_setting'             => array(
			'id'        => 'ywdpd_coupon_label',
			'name'      => __( 'Coupon label', 'ywdpd' ),
			'desc'      => __( 'Enter a text to identify the coupon in cart, when a discount is applied', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => _x( 'DISCOUNT', 'Dynamic coupon label', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_cart_label_mode',
				'value' => 'default_name',
				'type'  => 'hide',
			),
		),
		'cart_coupon_calculation_setting' => array(
			'id'        => 'ywdpd_calculate_discounts_tax',
			'name'      => __( 'Calculate cart discount starting from', 'ywdpd' ),
			'desc'      => __( 'Choose to calculate the cart discount including or excluding taxes on the subtotal', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'tax_excluded' => __( 'Subtotal - tax excluded', 'ywdpd' ),
				'tax_included' => __( 'Subtotal - tax included', 'ywdpd' ),
			),
			'default'   => 'tax_excluded',
		),
		'cart_show_subtotal_mode'         => array(
			'id'        => 'ywdp_cart_special_offer_show_subtotal_mode',
			'class'     => 'ywdpd_radio_with_small_desc',
			'name'      => __( 'Show special offers in cart by adapting', 'ywdpd' ),
			'desc'      => __( 'Choose how to show the discounts or special prices in cart', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				/* translators: %s is the field description */
				'unit_price' => __( 'The unit price', 'ywdpd' ) . sprintf( '<small>%s</small>', __( 'The product price will be adapted based on the offer applied', 'ywdpd' ) ),
				/* translators: %s is the field description */
				'subtotal'   => __( 'The subtotal', 'ywdpd' ) . sprintf( '<small>%s</small>', __( 'The product price will not be adapted, the price rule will be applied and shown on the subtotal instead', 'ywdpd' ) ),
			),
			'default'   => 'unit_price',
		),
		'cart_notices'                    => array(
			'id'        => 'ywdpd_enable_cart_notices',
			'name'      => __( 'Show amount discount info on cart', 'ywdpd' ),
			'desc'      => __( 'Enable this option to show a notice when a discount rule is applied', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'discount_message_on_cart'        => array(
			'id'                => 'ywdpd_cart_notice_message',
			'name'              => __( 'Add a custom message in the cart totals', 'ywdpd' ),
			'desc'              => __( 'Enter a custom text to show the total discount for the customer on the cart. Please, note: this applies only to "Cart discount rules". You can use the placeholder %total_discount_percentage% to show the percentage discount and %total_discount_price% to show the discount value', 'ywdpd' ),
			'type'              => 'yith-field',
			'yith-type'         => 'textarea',
			'deps'              => array(
				'id'    => 'ywdpd_enable_cart_notices',
				'value' => 'yes',
				'type'  => 'hide',
			),
			'default'           => __( 'Please note: you\'ve saved %total_discount_percentage% on this order today', 'ywdpd' ),
			'custom_attributes' => 'style="resize:none;"',
		),
		'hide_other_shipping'             => array(
			'id'      => 'ywdpd_hide_other_shipping_method',
			'name'    => __( 'Hide shipping methods', 'ywdpd' ),
			'type'              => 'yith-field',
			'yith-type'    => 'onoff',
			'default' => 'off',
			'desc'    => __( 'Hide other shipping methods if a cart rule with free shipping is applied in cart', 'ywdpd' ),
		),
		'cart_section_end'                => array(
			'type' => 'sectionend',
		),
	),
);

return $cart_settings;
