<?php
/**
 * This file contain the plugin options
 *
 * @since   4.0
 * @package YITH\DynamicPricingAndDiscounts\Options
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$plugin_options = array(
	'general-plugin-settings' => array(
		'plugin_settings_start'          => array(
			'name' => __( 'General settings', 'ywdpd' ),
			'type' => 'title',
		),
		'plugin_enable_shop_manager'     => array(
			'id'        => 'ywdpd_enable_shop_manager',
			'name'      => __( 'Allow shop manager to manage Dynamic Pricing & Discounts', 'ywdpd' ),
			'desc'      => __( 'If enabled, the shop manager will be able to edit the plugin options', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'plugin_price_format'            => array(
			'id'                => 'ywdpd_price_format',
			'name'              => __( 'Price format', 'ywdpd' ),
			'desc'              => sprintf(/* translators: %1$s is the field description %2$s is the description of the placeholders */
				'%1$s <p><strong>%2$s</strong></p><br/>&#37;original_price&#37;,&#37;discounted_price&#37;,&#37;percentual_discount&#37;',
				__( 'Enter the price format to show the original price, the percentual discount, or the discounted price.', 'ywdpd' ),
				__( 'Placeholder available:', 'ywdpd' )
			),
			'type'              => 'yith-field',
			'yith-type'         => 'textarea',
			'custom_attributes' => 'style="resize:none;"',
			'rows'              => 2,
			'default'           => '<del>%original_price%</del> %discounted_price%',
		),
		'plugin_show_price_name_details' => array(
			'id'        => 'ywdpd_show_rule_details',
			'name'      => __( 'Show price rule details in customer emails', 'ywdpd' ),
			'desc'      => __( 'Enable to add the info about the rule applied in the email sent to customers', 'ywdpd' ),
			'yith-type' => 'onoff',
			'type'      => 'yith-field',
			'default'   => 'yes',
		),
		'plugin_settings_end'            => array(
			'type' => 'sectionend',
		),
	),
);
if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
	$plugin_options['general-plugin-settings']['wpml_section_start'] = array(
		'type' => 'title',
		'name' => __( 'WPML settings', 'ywdpd' ),
	);
	$plugin_options['general-plugin-settings']['wpml_extension']     = array(
		'id'        => 'ywdpd_wpml_extend_to_translated_object',
		'name'      => __( 'Extend the rules to translated content', 'ywdpd' ),
		'desc'      => __( 'If enabled, the rules will also be applied to translated products', 'ywdpd' ),
		'type'      => 'yith-field',
		'yith-type' => 'onoff',
		'default'   => 'no',
	);
	$plugin_options['general-plugin-settings']['wpml_section_end']   = array(
		'type' => 'sectionend',
	);
}

return $plugin_options;
