<?php
/**
 * This file contain the plugin options
 *
 * @since   4.0
 * @package YITH\DynamicPricingAndDiscounts\Options
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$product_settings = array(
	'general-product-settings' => array(
		'product_page_section_start'    => array(
			'name' => __( 'Product page settings', 'ywdpd' ),
			'type' => 'title',
		),
		'product_page_show_message'     => array(
			'id'        => 'ywdpd_show_note_on_products',
			'name'      => __( 'Show the discount custom messages', 'ywdpd' ),
			'desc'      => __( 'For each price rule, you can enter a custom message. You can enable this option to show all the custom messages on product pages or keep it disabled to hide them.', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
		),
		'product_page_message_position' => array(
			'id'        => 'ywdpd_show_note_on_products_place',
			'name'      => __( 'Message position', 'ywdpd' ),
			'desc'      => __( 'Choose where to show the discount rules messages', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'before_add_to_cart' => __( 'Before "Add to cart" button', 'ywdpd' ),
				'after_add_to_cart'  => __( 'After "Add to cart" button', 'ywdpd' ),
				'before_excerpt'     => __( 'Before excerpt', 'ywdpd' ),
				'after_excerpt'      => __( 'After excerpt', 'ywdpd' ),
				'after_meta'         => __( 'After product meta', 'ywdpd' ),

			),
			'default'   => 'before_add_to_cart',
			'deps'      => array(
				'id'    => 'ywdpd_show_note_on_products',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_section_end'      => array(
			'type' => 'sectionend',
		),
	)
);

return $product_settings;