<?php
/**
 * Table pricing template.
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/ywdpd-boxed.php
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   5.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var string               $label_table
 * @var string               $until
 * @var string               $label_quantity
 * @var string               $label_price
 * @var string               $note
 * @var string               $template
 * @var array                $table
 * @var YWDPD_Quantity_Table $rule
 * @var WC_Product           $product
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

list ( $heading, $results, $formatted_prices, $unformatted_prices, $allowed_units ) = yith_plugin_fw_extract( $table, 'heading', 'results', 'formatted_prices', 'unformatted_prices', 'allowed_units' );
$allowed_units = count( $allowed_units ) > 0 ? implode( ',', wp_list_pluck( $allowed_units, 'units' ) ) : '{}';
if ( ! empty( $label_table ) ) :
	?>
    <p class="ywdpd-table-discounts-label">
        <strong><?php echo wp_kses_post( $label_table ); ?></strong>
		<?php
		if ( ! empty( $until ) ) {
			echo '<span>' . esc_html( $until ) . '</span>';
		}
		?>
    </p>
<?php
endif;

?>
<div id="ywdpd-quantity-boxed" class="<?php echo esc_attr( $template ); ?>"
     data-rule_id="<?php echo esc_attr( $rule->get_id() ); ?>"
     data-product_id="<?php echo esc_attr( $product->get_id() ); ?>"
     data-product_type="<?php echo esc_attr( $product->get_type() ); ?>"
     data-price_html="<?php echo esc_attr( $product->get_price_html() ); ?>"
     data-allowed_items="<?php echo esc_attr( $allowed_units ); ?>"
>
	<?php
	foreach ( $results as $key => $result ) :
		$info_key = explode( '-', $key );
		/**
		 * APPLY_FILTERS: ywdpd_change_base_price
		 *
		 * Change the base product price.
		 *
		 * @param float      $price The price.
		 * @param WC_Product $product The product.
		 *
		 * @return float
		 */
		$price = apply_filters( 'ywdpd_change_base_price', $product->get_price(), $product );

		if ( $info_key[0] == $info_key[1] ) {
			$label_units = sprintf( _n( '%1$s unit', '%1$s units', $info_key[0], 'ywdpd' ), $info_key[0] );
		} else {
			$label_units = sprintf( _x( '%1$s units', '1-10 units', 'ywdpd' ), $result['quantity_row'] );
		}
		$data = array(
			'qtyMin' => $info_key[0],
			'qtyMax' => $info_key[1],
		);

		if ( isset( $formatted_prices[ $key ] ) ) {
			$data['formatted_price'] = $formatted_prices[ $key ];
		}
		if ( isset( $unformatted_prices[ $key ] ) ) {
			$data['unformatted_price'] = $unformatted_prices[ $key ];
		}
		$data = yith_plugin_fw_html_data_to_string( $data );
		?>
        <div class="ywdpd-boxed-item" <?php echo $data;//phpcs:ignore WordPress.Security.EscapeOutput
		?> >
            <div class="ywdpp-boxed-content">
                <div class="ywdpd-units">
					<?php
					echo esc_html( $label_units );
					?>
                </div>
                <div class="ywdpd-price">
					<?php echo wp_kses_post( sprintf( _x( '%1$s/unit', '$12.50/unit', 'ywdpd' ), $result['price_row'] ) ); ?>
                </div>
				<?php if ( isset( $result['discount_row'] ) ) : ?>
                    <div class="ywdpd-discount">
						<?php
						if ( $result['discount_row'] > 0 ) {
							echo esc_html( sprintf( _x( 'Save %1$s', 'Save 10%', 'ywdpd' ), $result['discount_row'] ) );
						}
						?>
                    </div>
				<?php endif; ?>
            </div>
        </div>
	<?php endforeach;
	?>
</div>
<?php
if ( ! empty( $note ) ) :
    ?>
    <p class="ywdpd-table-discounts-note"><?php echo wp_kses_post( $note ); ?></p>
<?php
endif;
?>