<?php
/**
 * This template show all prices rule notices
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/ywdpd-involved-items.php
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   3.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var array            $items
 * @var YWDPD_Price_Rule $rule
 * @var bool             $show_discounted_price
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$item_type = $items['type'];
$items_ids = $items['item_ids'];
?>
<div class="ywdpd-involved-items-container">
	<ul class="products columns-4">
		<?php
		foreach ( $items_ids as $item_id ) :
			$show_line = true;

			$price_html = '';
			if ( 'product_ids' === $item_type ) {
				$item_id   = yit_wpml_object_id( $item_id, 'product' );
				$object    = wc_get_product( $item_id );
				$show_line = $object && $object->is_visible();
				if ( $show_line ) {
					$image      = $object->get_image();
					$term_link  = $object->get_permalink();
					$term_name  = 'variation' === $object->get_type() ? $object->get_formatted_name() : $object->get_name();
					$price      = $object->get_price();
					$price_html = wc_price( wc_get_price_to_display( $object, array( 'price' => $price ) ) );
					if ( $show_discounted_price && $rule instanceof YWDPD_Special_Offer ) {
						$new_price = $rule->get_discounted_price( $price, 1, $object );
						if ( $new_price > 0 ) {
							$new_price = wc_get_price_to_display( $object, array( 'price' => $new_price ) );
						} else {
							$new_price = __( 'Free', 'ywdpd' );
						}
						$price_html = wc_format_sale_price( wc_get_price_to_display( $object, array( 'price' => $price ) ), $new_price ) . $object->get_price_suffix();
					}
				}
			} else {
				$term_obj  = get_term( $item_id, $item_type );
				$term_name = ! is_wp_error( $term_obj ) ? $term_obj->name : '';
				$term_link = get_term_link( $term_obj );
				ob_start();
				woocommerce_subcategory_thumbnail( $term_obj );
				$image = ob_get_contents();
				ob_end_clean();
			}

			if ( $show_line ) :

				$row = sprintf( '<a href="%s">%s%s</a> %s', $term_link, $image, $term_name, $price_html );
				?>
				<li class="product">
					<?php
					echo $row; //phpcs:ignore WordPress.Security.EscapeOutput
					?>
				</li>
				<?php
			endif;
		endforeach;
		?>
	</ul>
</div>
