<?php
/**
 * Table pricing template.
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/ywdpd-quantity-table.php
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   3.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var string               $label_table
 * @var string               $until
 * @var string               $label_quantity
 * @var string               $label_price
 * @var string               $note
 * @var string               $template
 * @var array                $table
 * @var YWDPD_Quantity_Table $rule
 * @var WC_Product           $product
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

list ( $heading, $results, $formatted_prices, $unformatted_prices, $allowed_units ) = yith_plugin_fw_extract( $table, 'heading', 'results', 'formatted_prices', 'unformatted_prices', 'allowed_units' );

if ( ! empty( $label_table ) ) :
	?>
    <p class="ywdpd-table-discounts-label">
        <strong><?php echo wp_kses_post( $label_table ); ?></strong>
		<?php
		if ( ! empty( $until ) ) {
			echo '<span>' . esc_html( $until ) . '</span>';
		}
		?>
    </p>
<?php
endif;

$class         = $rule->get_qty_type() . ' ' . $template;
$allowed_units = count( $allowed_units ) > 0 ? implode( ',', wp_list_pluck( $allowed_units, 'units' ) ) : '{}';
?>
<table id="ywdpd-quantity-table" class="<?php echo esc_attr( $class ); ?>"
       data-rule_id="<?php echo esc_attr( $rule->get_id() ); ?>"
       data-product_id="<?php echo esc_attr( $product->get_id() ); ?>"
       data-product_type="<?php echo esc_attr( $product->get_type() ); ?>"
       data-price_html="<?php echo esc_attr( $product->get_price_html() ); ?>"
       data-allowed_items="<?php echo esc_attr( $allowed_units ); ?>"
>
	<?php
	if ( 'horizontal' === $template ) :
		foreach ( $results as $type_rs => $result ) :
			?>
            <tr class="<?php echo esc_attr( $type_rs ); ?>">
                <th><?php echo esc_html( $heading[ $type_rs ] ); ?></th>
				<?php
				foreach ( $result as $qty_info_key => $info ) :
					$data = '';
					if ( 'quantity_row' === $type_rs ) {
						$class    = 'qty-info';
						$info_key = explode( '-', $qty_info_key );
						/**
						 * APPLY_FILTERS: ywdpd_change_base_price
						 *
						 * Change the base product price.
						 *
						 * @param float      $price   The price.
						 * @param WC_Product $product The product.
						 *
						 * @return float
						 */
						$price = apply_filters( 'ywdpd_change_base_price', $product->get_price(), $product );

						$data = array(
							'qtyMin' => $info_key[0],
							'qtyMax' => $info_key[1],
						);
						if ( isset( $formatted_prices[ $qty_info_key ] ) ) {
							$data['formatted_price'] = $formatted_prices[ $qty_info_key ];
						}
						if ( isset( $unformatted_prices[ $qty_info_key ] ) ) {
							$data['unformatted_price'] = $unformatted_prices[ $qty_info_key ];
						}
						$data = yith_plugin_fw_html_data_to_string( $data );
					} elseif ( 'price_row' === $type_rs ) {
						$class = 'qty-price-info';
					} else {
						$class = 'qty-discount-info';
					}
					?>
                    <td class="<?php echo esc_attr( $class ); ?>"
						<?php
						echo $data;//phpcs:ignore WordPress.Security.EscapeOutput
						?>
                    >
						<?php echo wp_kses_post( $info ); ?>
                    </td>
				<?php
				endforeach;
				?>
            </tr>
		<?php endforeach; ?>
	<?php
	else :
		?>
        <tr class="ywdpd_header">
			<?php
			foreach ( $heading as $head ) :
				?>
                <th><?php echo wp_kses_post( $head ); ?></th>
			<?php
			endforeach;
			?>
        </tr>
		<?php
		foreach ( $results as $qty_info_key => $info ) :
			?>
            <tr class="ywdpd_row">
				<?php
				foreach ( $info as $key_info => $single_info ) :
					$data = '';
					if ( 'quantity_row' === $key_info ) {
						$class    = 'qty-info';
						$info_key = explode( '-', $qty_info_key );
						/**
						 * APPLY_FILTERS: ywdpd_change_base_price
						 *
						 * Change the base product price.
						 *
						 * @param float      $price   The price.
						 * @param WC_Product $product The product.
						 *
						 * @return float
						 */
						$price = apply_filters( 'ywdpd_change_base_price', $product->get_price(), $product );

						$data = array(
							'qtyMin' => $info_key[0],
							'qtyMax' => $info_key[1],
						);

						if ( isset( $formatted_prices[ $qty_info_key ] ) ) {
							$data['formatted_price'] = $formatted_prices[ $qty_info_key ];
						}
						if ( isset( $unformatted_prices[ $qty_info_key ] ) ) {
							$data['unformatted_price'] = $unformatted_prices[ $qty_info_key ];
						}

						$data = yith_plugin_fw_html_data_to_string( $data );
					} elseif ( 'price_row' === $key_info ) {
						$class = 'qty-price-info';
					} else {
						$class = 'qty-discount-info';
					}
					?>
                    <td class="<?php echo esc_attr( $class ); ?>" <?php echo $data; //phpcs:ignore
					?>
                    >
						<?php echo wp_kses_post( $single_info ); ?>
                    </td>
				<?php
				endforeach;
				?>
            </tr>
		<?php
		endforeach;
	endif;
	?>
</table>
<?php
if ( ! empty( $note ) ) :
	?>
    <p class="ywdpd-table-discounts-note"><?php echo wp_kses_post( $note ); ?></p>
<?php
endif;
?>
