<?php // phpcs:ignore WordPress.Files.FileName
/**
 * Popup gift.
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   2.0.0
 * @version 3.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var int $rule_id
 * @var array $item_to_show
 * @var string $popup_class
 */

if ( ! defined( 'ABSPATH' ) || ! isset( $item_to_show ) ) {
	exit;
}

$general_data = array(
	'rule_id' => $rule_id,
	'mode'    => $item_to_show['mode'],
);

$rule_data       = array(
	'allowed_items' => $item_to_show['allowed_item'],
	'max_units'     => $item_to_show['max_units'] ?? '',
	'countdown'     => $item_to_show['countdown'] ?? array(),
);
$fullwidth_class = isset( $item_to_show['is_full_width'] ) && $item_to_show['is_full_width'] ? 'full' : '';
?>
<div class="ywdpd_popup <?php echo esc_attr( $popup_class ); ?>" style="display:none">
    <div class="ywdpd_popup_wrapper <?php echo esc_attr( $fullwidth_class ); ?>" <?php yith_plugin_fw_html_data_to_string( $general_data, true ); ?> >
        <div class="ywdpd_popup_general_content">
            <span class="ywdpd_close"></span>
            <div class="ywdpd_popup_content">
                <div class="ywdpd_step1">
                    <div class="ywdpd_single_rule_container <?php echo esc_attr( $item_to_show['type'] ); ?>"
						<?php yith_plugin_fw_html_data_to_string( $rule_data, true ); ?> >
                        <div class="ywdpd_rule_title">
							<?php
							$qty_label = sprintf( '<span class="ywdpd_quantity">%s</span>', $item_to_show['allowed_item'] );
							echo wp_kses_post( str_replace( '{{total_to_add}}', $qty_label, $item_to_show['text'] ) );
							?>
                        </div>
                        <div class="ywdpd_popup_stage">
							<?php
							/**
							 * DO_ACTION: ywdpd_show_popup_items
							 *
							 * Triggered to print the single item in popup.
							 *
							 * @param array $items the items
							 * @param string $rule_id The rule id.
							 * @param string $type The rule type
							 * @param array $item_to_show The item to show.
							 */
							do_action( 'ywdpd_show_popup_items', $item_to_show['items'], $rule_id, $item_to_show['type'], $item_to_show );
							?>
                        </div>
                    </div>
                    <div class="ywdpd_btn_container">
                        <a class="button ywdpd_btn_confirm"><?php esc_html_e( 'Confirm and close window', 'ywdpd' ); ?></a>
                    </div>
                </div>
                <div class="ywdpd_step2"></div>
                <div class="ywdpd_footer">
                    <a href="" rel="nofollow">
						<?php
						/**
						 * APPLY_FILTERS: ywdpd_no_thanks_label
						 *
						 * Allow to change  the no thanks label.
						 *
						 * @param string $label The options.
						 *
						 * @return string
						 */
						echo apply_filters( 'ywdpd_no_thanks_label', esc_html__( 'No, thanks', 'ywdpd' ) ); //phpcs:ignore WordPress.Security.EscapeOutput
						?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/template" id="tmpl-ywdpd-popup-quantity-field">
    <div class="ywdpd_qty_field">
        <div class="ywdpd_qty_input">
            <div class="ywdpd_qty_label">
				<?php esc_html_e( 'Qty in cart', 'ywdpd' ); ?>
            </div>
            <span class="ywdpd_qty">0</span>
            <span class="ywdpd_qty_arrows">
									<span class="ywdpd_qty_remove button">
										<span></span>
									</span>
									<span class="ywdpd_qty_decrease button">
										<span></span>
									</span>
									<span class="ywdpd_qty_increase button">
										<span></span>
									</span>
								</span>
        </div>
    </div>
</script>