<?php // phpcs:ignore WordPress.Files.FileName
/**
 * Show product items in popup.
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   4.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var array $item_ids
 * @var array $discount
 * @var string $item_class
 * @var string $list_class
 * @var string $rule_key
 * @var int $total_to_add
 * @var int $max_units
 */
if ( ! defined( 'ABSPATH' ) || empty( $item_ids ) ) {
	exit;
}
/**
 * The rule
 *
 * @var YWDPD_Gift_Products $rule
 */
$rule = ywdpd_get_rule( $rule_key );
?>
<ul class="ywdpd_popup_items products owl-carousel owl-theme <?php echo esc_attr( $list_class ); ?>">
	<?php
	foreach ( $item_ids as $item_id ) :
		$product = wc_get_product( $item_id );
		if ( $product && $product->is_purchasable() && $product->is_in_stock() ) {
			$max = $product->get_max_purchase_quantity();
			if ( $max_units > 0 ) {
				$max = $max > 0 ? min( $max_units, $max ) : $max_units;
			}
			$image            = $product->get_image();
			$add_to_cart_text = $product->add_to_cart_text();
			$product_name     = 'variation' === $product->get_type() ? $product->get_formatted_name() : $product->get_name();
			$new_price_html   = $rule->get_discounted_price_html( $product );
			$button_class     = $product->get_type();
			$can_show_qty     = 'variable' !== $product->get_type();

			if ( 'variation' === $product->get_type() && ! yith_dynamic_is_variation_attributes_set( $product ) ) {
				$parent_id        = $product->get_parent_id();
				$parent_product   = wc_get_product( $parent_id );
				$button_class     = 'variable';
				$add_to_cart_text = $parent_product->add_to_cart_text();
				$can_show_qty     = false;
			}

			?>
            <li class="<?php echo esc_attr( $item_class ); ?> item"
                data-product_id="<?php echo esc_attr( $product->get_id() ); ?>"
                data-product_type="<?php echo esc_attr( $product->get_type() ); ?>">
                <div class="ywdpd_single_product">
                    <div class="ywdpd_product_details">
					<span class="ywdpd_image_badge">
						<span class="ywdp_check_icon"></span>
					</span>
                        <div class="ywdpd_image_container">
							<?php echo wp_kses_post( $image ); ?>
                        </div>
                    </div>
                    <h5><?php echo wp_kses_post( $product_name ); ?></h5>
                    <span class="price"><?php echo wp_kses_post( $new_price_html ); ?></span>
                    <div class="ywdpd_qty_fields_container" data-min="1" data-max="<?php echo esc_attr( $max ); ?>">
						<?php
						if ( $can_show_qty ) :
						?>
                        <div class="ywdpd_qty_field">
                            <div class="ywdpd_qty_input">
                                <div class="ywdpd_qty_label">
									<?php esc_html_e( 'Qty in cart', 'ywdpd' ); ?>
                                </div>
                                <span class="ywdpd_qty">0</span>
                                <span class="ywdpd_qty_arrows">
									<span class="ywdpd_qty_remove button">
										<span></span>
									</span>
									<span class="ywdpd_qty_decrease button">
										<span></span>
									</span>
									<span class="ywdpd_qty_increase button">
										<span></span>
									</span>
								</span>
                            </div>
                        </div>

					<?php
					endif;
					?>
                    <span
                            class="single_add_to_cart_button button wp-element-button <?php echo esc_attr( $button_class ); ?>">
						<?php
						echo wp_kses_post( $add_to_cart_text );
						?>
				</span>
                    </div>
                </div>
            </li>
			<?php
		}
	endforeach;
	?>
</ul>
