<?php
/**
 * Show product taxonomy items in popup.
 *
 * @package YITH\DynamicPricingAndDiscounts\Templates
 * @since   4.0.0
 * @version 1.0.0
 * @author  YITH <plugins@yithemes.com>
 *
 * @var array  $item_ids
 * @var string $taxonomy_name
 * @var string $item_class
 * @var string $list_class
 */

if ( ! defined( 'ABSPATH' ) || empty( $item_ids ) ) {
	exit;
}

?>
<ul class="ywdpd_popup_items products owl-carousel owl-theme <?php echo esc_attr( $list_class ); ?>">
	<?php
	foreach ( $item_ids as $item_id ) :
		$term_obj = get_term( $item_id, $taxonomy_name );

		$term_name = ! is_wp_error( $term_obj ) ? $term_obj->name : false;
		$term_link = get_term_link( $term_obj );
		if ( $term_name ) :
			?>
		<li class="<?php echo esc_attr( $item_class ); ?> item">
			<?php woocommerce_subcategory_thumbnail( $term_obj ); ?>
			<h5><?php echo wp_kses_post( $term_name ); ?></h5>
			<a href="<?php echo esc_url( $term_link ); ?>" class="product_taxonomy button"><?php esc_html_e( 'Browse the products ', 'ywdpd' ); ?></a>
		</li>
			<?php
		endif;
	endforeach;
	?>
</ul>
