<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * WPBakery WPBakery Page Builder section
 *
 * @package WPBakeryPageBuilder
 *
 */
class WPBakeryShortCode_Vc_Section extends WPBakeryShortCodesContainer {
	/**
	 * @param $width
	 * @param $i
	 * @return string
	 */
	public function containerHtmlBlockParams( $width, $i ) {
		return 'class="vc_section_container vc_container_for_children"';
	}

	/**
	 * @param $settings
	 */
	public function __construct( $settings ) {
		parent::__construct( $settings );
		$this->shortcodeScripts();
	}

	protected function shortcodeScripts() {
		wp_register_script( 'vc_jquery_skrollr_js', vc_asset_url( 'lib/vendor/node_modules/skrollr/dist/skrollr.min.js' ), array( 'jquery-core' ), WPB_VC_VERSION, true );
		wp_register_script( 'vc_youtube_iframe_api_js', 'https://www.youtube.com/iframe_api', array(), WPB_VC_VERSION, true );
	}

	/**
	 * @return string
	 * @throws \Exception
	 */
	public function cssAdminClass() {
		$sortable = ( vc_user_access_check_shortcode_all( $this->shortcode ) ? ' wpb_sortable' : ' ' . $this->nonDraggableClass );

		return 'wpb_' . $this->settings['base'] . $sortable . '' . ( ! empty( $this->settings['class'] ) ? ' ' . $this->settings['class'] : '' );
	}

	/**
	 * @param string $controls
	 * @param string $extended_css
	 * @return string
	 * @throws \Exception
	 */
	public function getColumnControls( $controls = 'full', $extended_css = '' ) {
		$controls_start = '<div class="vc_controls vc_controls-visible controls_column' . ( ! empty( $extended_css ) ? " {$extended_css}" : '' ) . '">';

		$output = '<div class="vc_controls vc_controls-row controls_row vc_clearfix">';
		$controls_end = '</div>';
		// Create columns
		$controls_move = ' <a class="vc_control column_move vc_column-move" href="#" title="' . esc_attr__( 'Drag row to reorder', 'js_composer' ) . '" data-vc-control="move"><i class="vc-composer-icon vc-c-icon-dragndrop"></i></a>';

        // @United
        $controls_move .= ' <a class="vc_control column_move_up vc_column-move-up" href="#" title="' . __( 'Move Section Up', 'js_composer' ) . '" data-vc-control="move-up"><i class="fa fa-angle-up" aria-hidden="true"></i></a>';
        $controls_move .= ' <a class="vc_control column_move_down vc_column-move-down" href="#" title="' . __( 'Move Section Down', 'js_composer' ) . '" data-vc-control="move-down"><i class="fa fa-angle-down" aria-hidden="true"></i></a>';
        $controls_move .= ' <a class="vc_control column_move_up vc_column-move-top" href="#" title="' . __( 'Move Section To Top', 'js_composer' ) . '" data-vc-control="move-up"><i class="fa fa-angle-double-up" aria-hidden="true"></i></a>';
        $controls_move .= ' <a class="vc_control column_move_down vc_column-move-bottom" href="#" title="' . __( 'Move Section To Bottom', 'js_composer' ) . '" data-vc-control="move-down"><i class="fa fa-angle-double-down" aria-hidden="true"></i></a>';

        $moveAccess = vc_user_access()->part( 'dragndrop' )->checkStateAny( true, null )->get();
		if ( ! $moveAccess ) {
			$controls_move = '';
		}
		$controls_add = ' <a class="vc_control column_add vc_column-add" href="#" title="' . esc_attr__( 'Add column', 'js_composer' ) . '" data-vc-control="add"><i class="vc-composer-icon vc-c-icon-add"></i></a>';
		$controls_delete = '<a class="vc_control column_delete vc_column-delete" href="#" title="' . esc_attr__( 'Delete this row', 'js_composer' ) . '" data-vc-control="delete"><i class="vc-composer-icon vc-c-icon-delete_empty"></i></a>';
		$controls_edit = ' <a class="vc_control column_edit vc_column-edit" href="#" title="' . esc_attr__( 'Edit this row', 'js_composer' ) . '" data-vc-control="edit"><i class="vc-composer-icon vc-c-icon-mode_edit"></i></a>';
		$controls_clone = ' <a class="vc_control column_clone vc_column-clone" href="#" title="' . esc_attr__( 'Clone this row', 'js_composer' ) . '" data-vc-control="clone"><i class="vc-composer-icon vc-c-icon-clone"></i></a>';
		$controls_copy = ' <a class="vc_control column_copy vc_column-copy" href="#" title="' . esc_attr__( 'Copy this row', 'js_composer' ) . '" data-vc-control="copy"><i class="vc-composer-icon vc-c-icon-copy"></i></a>';
		$controls_paste = ' <a class="vc_control column_paste vc_column-paste" href="#" title="' . esc_attr__( 'Paste', 'js_composer' ) . '" data-vc-control="paste"><i class="vc-composer-icon vc-c-icon-paste"></i></a>';
        $controls_toggle = ' <a class="vc_control column_toggle vc_column-toggle" href="#" title="' . esc_attr__( 'Toggle section', 'js_composer' ) . '" data-vc-control="toggle"><i class="vc-composer-icon vc-c-icon-arrow_drop_down"></i></a>';
        $editAccess = vc_user_access_check_shortcode_edit( $this->shortcode );
		$allAccess = vc_user_access_check_shortcode_all( $this->shortcode );
		$row_edit_clone_delete = '<span class="vc_row_edit_clone_delete section">';
		if ( 'add' === $controls ) {
			return $controls_start . $controls_add . $controls_end;
		}
		if ( $allAccess ) {
			$row_edit_clone_delete .= '<span class="controls-ac ">' .$controls_clone. $controls_paste . $controls_copy .'</span>' . $controls_edit.$controls_toggle.$controls_delete;
		} elseif ( $editAccess ) {
			$row_edit_clone_delete .= $controls_edit.$controls_toggle;
		}
		$row_edit_clone_delete .= '</span>';

		if ( $allAccess ) {
			$output .= '<div class="controls-move section">' . $controls_move . '</div><div class="control-main">'. $controls_add .'</div>' . $row_edit_clone_delete . $controls_end;
		} elseif ( $editAccess ) {
			$output .= $row_edit_clone_delete . $controls_end;
		} else {
			$output .= $row_edit_clone_delete . $controls_end;
		}

		return $output;
	}

	/**
	 * @param $atts
	 * @param null $content
	 * @return string
	 * @throws \Exception
	 */
	public function contentAdmin( $atts, $content = null ) {
		$width = '';
		$atts = shortcode_atts( $this->predefined_atts, $atts );

		$output = '';

		$column_controls = $this->getColumnControls();

		$output .= '<div data-element_type="' . $this->settings['base'] . '" class="' . $this->cssAdminClass() . '">';
		$output .= str_replace( '%column_size%', 1, $column_controls );
		$output .= '<div class="wpb_element_wrapper">';
		if ( isset( $this->settings['custom_markup'] ) && '' !== $this->settings['custom_markup'] ) {
			$markup = $this->settings['custom_markup'];
			$output .= $this->customMarkup( $markup );
		} else {
			$output .= '<div ' . $this->containerHtmlBlockParams( $width, 1 ) . '>';
			$output .= do_shortcode( shortcode_unautop( $content ) );
			$output .= '</div>';
		}
		if ( isset( $this->settings['params'] ) ) {
			$inner = '';
			foreach ( $this->settings['params'] as $param ) {
				if ( ! isset( $param['param_name'] ) ) {
					continue;
				}
				$param_value = isset( $atts[ $param['param_name'] ] ) ? $atts[ $param['param_name'] ] : '';
				if ( is_array( $param_value ) ) {
					// Get first element from the array
					reset( $param_value );
					$first_key = key( $param_value );
					$param_value = $param_value[ $first_key ];
				}
				$inner .= $this->singleParamHtmlHolder( $param, $param_value );
			}
			$output .= $inner;
		}
		$output .= '</div>';
		if ( $this->backened_editor_prepend_controls ) {
			$output .= $this->getColumnControls( 'add', 'vc_section-bottom-controls bottom-controls' );
		}
		$output .= '</div>';

		return $output;
	}
}
