/*! @svgdotjs/svg.js v3.2.0 MIT*/;
/*!
* @svgdotjs/svg.js - A lightweight library for manipulating and animating SVG.
* @version 3.2.0
* https://svgjs.dev/
*
* @copyright Wout Fierens <wout@mick-wout.com>
* @license MIT
*
* BUILT: Mon Jun 12 2023 10:34:51 GMT+0200 (Central European Summer Time)
*/
var SVG=function(){"use strict";const t={},e=[];function n(e,i){if(Array.isArray(e))for(const t of e)n(t,i);else if("object"!=typeof e)r(Object.getOwnPropertyNames(i)),t[e]=Object.assign(t[e]||{},i);else for(const t in e)n(t,e[t])}function i(e){return t[e]||{}}function r(t){e.push(...t)}function s(t,e){let n;const i=t.length,r=[];for(n=0;n<i;n++)r.push(e(t[n]));return r}function o(t,e){let n;const i=t.length,r=[];for(n=0;n<i;n++)e(t[n])&&r.push(t[n]);return r}function h(t){return t%360*Math.PI/180}function u(t){return t.toLowerCase().replace(/-(.)/g,(function(t,e){return e.toUpperCase()}))}function a(t){return t.replace(/([A-Z])/g,(function(t,e){return"-"+e.toLowerCase()}))}function l(t){return t.charAt(0).toUpperCase()+t.slice(1)}function c(t,e,n,i){return null!=e&&null!=n||(i=i||t.bbox(),null==e?e=i.width/i.height*n:null==n&&(n=i.height/i.width*e)),{width:e,height:n}}function f(t,e){const n=t.origin;let i=null!=t.ox?t.ox:null!=t.originX?t.originX:"center",r=null!=t.oy?t.oy:null!=t.originY?t.originY:"center";null!=n&&([i,r]=Array.isArray(n)?n:"object"==typeof n?[n.x,n.y]:[n,n]);const s="string"==typeof i,o="string"==typeof r;if(s||o){const{height:t,width:n,x:h,y:u}=e.bbox();s&&(i=i.includes("left")?h:i.includes("right")?h+n:h+n/2),o&&(r=r.includes("top")?u:r.includes("bottom")?u+t:u+t/2)}return[i,r]}var d={__proto__:null,map:s,filter:o,radians:h,degrees:function(t){return 180*t/Math.PI%360},camelCase:u,unCamelCase:a,capitalize:l,proportionalSize:c,getOrigin:f};const m="http://www.w3.org/2000/svg",p="http://www.w3.org/1999/xhtml",y="http://www.w3.org/2000/xmlns/",w="http://www.w3.org/1999/xlink",_="http://svgjs.dev/svgjs";var g={__proto__:null,svg:m,html:p,xmlns:y,xlink:w,svgjs:_};const x={window:"undefined"==typeof window?null:window,document:"undefined"==typeof document?null:document};function b(t=null,e=null){x.window=t,x.document=e}const v={};function M(){v.window=x.window,v.document=x.document}function O(){x.window=v.window,x.document=v.document}class k{}const C={},T="___SYMBOL___ROOT___";function N(t,e=m){return x.document.createElementNS(e,t)}function S(t,e=!1){if(t instanceof k)return t;if("object"==typeof t)return D(t);if(null==t)return new C[T];if("string"==typeof t&&"<"!==t.charAt(0))return D(x.document.querySelector(t));const n=e?x.document.createElement("div"):N("svg");return n.innerHTML=t,t=D(n.firstChild),n.removeChild(n.firstChild),t}function E(t,e){return e&&e.ownerDocument&&e instanceof e.ownerDocument.defaultView.Node?e:N(t)}function j(t){if(!t)return null;if(t.instance instanceof k)return t.instance;if("#document-fragment"===t.nodeName)return new C.Fragment(t);let e=l(t.nodeName||"Dom");return"LinearGradient"===e||"RadialGradient"===e?e="Gradient":C[e]||(e="Dom"),new C[e](t)}let D=j;function I(t,e=t.name,n=!1){return C[e]=t,n&&(C[T]=t),r(Object.getOwnPropertyNames(t.prototype)),t}function z(t){return C[t]}let R=1e3;function L(t){return"Svgjs"+l(t)+R++}function P(t){for(let e=t.children.length-1;e>=0;e--)P(t.children[e]);return t.id?(t.id=L(t.nodeName),t):t}function F(t,e){let n,i;for(i=(t=Array.isArray(t)?t:[t]).length-1;i>=0;i--)for(n in e)t[i].prototype[n]=e[n]}function q(t){return function(...e){const n=e[e.length-1];return!n||n.constructor!==Object||n instanceof Array?t.apply(this,e):t.apply(this,e.slice(0,-1)).attr(n)}}n("Dom",{siblings:function(){return this.parent().children()},position:function(){return this.parent().index(this)},next:function(){return this.siblings()[this.position()+1]},prev:function(){return this.siblings()[this.position()-1]},forward:function(){const t=this.position();return this.parent().add(this.remove(),t+1),this},backward:function(){const t=this.position();return this.parent().add(this.remove(),t?t-1:0),this},front:function(){return this.parent().add(this.remove()),this},back:function(){return this.parent().add(this.remove(),0),this},before:function(t){(t=S(t)).remove();const e=this.position();return this.parent().add(t,e),this},after:function(t){(t=S(t)).remove();const e=this.position();return this.parent().add(t,e+1),this},insertBefore:function(t){return(t=S(t)).before(this),this},insertAfter:function(t){return(t=S(t)).after(this),this}});const X=/^([+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?)([a-z%]*)$/i,Y=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,B=/rgb\((\d+),(\d+),(\d+)\)/,H=/(#[a-z_][a-z0-9\-_]*)/i,V=/\)\s*,?\s*/,$=/\s/g,U=/^#[a-f0-9]{3}$|^#[a-f0-9]{6}$/i,W=/^rgb\(/,Q=/^(\s+)?$/,J=/^[+-]?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,Z=/\.(jpg|jpeg|png|gif|svg)(\?[^=]+.*)?/i,K=/[\s,]+/,tt=/[MLHVCSQTAZ]/i;var et={__proto__:null,numberAndUnit:X,hex:Y,rgb:B,reference:H,transforms:V,whitespace:$,isHex:U,isRgb:W,isBlank:Q,isNumber:J,isImage:Z,delimiter:K,isPathLetter:tt};function nt(t){const e=Math.round(t),n=Math.max(0,Math.min(255,e)).toString(16);return 1===n.length?"0"+n:n}function it(t,e){for(let n=e.length;n--;)if(null==t[e[n]])return!1;return!0}function rt(t,e,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?t+6*(e-t)*n:n<.5?e:n<2/3?t+(e-t)*(2/3-n)*6:t}n("Dom",{classes:function(){const t=this.attr("class");return null==t?[]:t.trim().split(K)},hasClass:function(t){return-1!==this.classes().indexOf(t)},addClass:function(t){if(!this.hasClass(t)){const e=this.classes();e.push(t),this.attr("class",e.join(" "))}return this},removeClass:function(t){return this.hasClass(t)&&this.attr("class",this.classes().filter((function(e){return e!==t})).join(" ")),this},toggleClass:function(t){return this.hasClass(t)?this.removeClass(t):this.addClass(t)}}),n("Dom",{css:function(t,e){const n={};if(0===arguments.length)return this.node.style.cssText.split(/\s*;\s*/).filter((function(t){return!!t.length})).forEach((function(t){const e=t.split(/\s*:\s*/);n[e[0]]=e[1]})),n;if(arguments.length<2){if(Array.isArray(t)){for(const e of t){const t=u(e);n[e]=this.node.style[t]}return n}if("string"==typeof t)return this.node.style[u(t)];if("object"==typeof t)for(const e in t)this.node.style[u(e)]=null==t[e]||Q.test(t[e])?"":t[e]}return 2===arguments.length&&(this.node.style[u(t)]=null==e||Q.test(e)?"":e),this},show:function(){return this.css("display","")},hide:function(){return this.css("display","none")},visible:function(){return"none"!==this.css("display")}}),n("Dom",{data:function(t,e,n){if(null==t)return this.data(s(o(this.node.attributes,(t=>0===t.nodeName.indexOf("data-"))),(t=>t.nodeName.slice(5))));if(t instanceof Array){const e={};for(const n of t)e[n]=this.data(n);return e}if("object"==typeof t)for(e in t)this.data(e,t[e]);else if(arguments.length<2)try{return JSON.parse(this.attr("data-"+t))}catch(e){return this.attr("data-"+t)}else this.attr("data-"+t,null===e?null:!0===n||"string"==typeof e||"number"==typeof e?e:JSON.stringify(e));return this}}),n("Dom",{remember:function(t,e){if("object"==typeof arguments[0])for(const e in t)this.remember(e,t[e]);else{if(1===arguments.length)return this.memory()[t];this.memory()[t]=e}return this},forget:function(){if(0===arguments.length)this._memory={};else for(let t=arguments.length-1;t>=0;t--)delete this.memory()[arguments[t]];return this},memory:function(){return this._memory=this._memory||{}}});class st{constructor(...t){this.init(...t)}static isColor(t){return t&&(t instanceof st||this.isRgb(t)||this.test(t))}static isRgb(t){return t&&"number"==typeof t.r&&"number"==typeof t.g&&"number"==typeof t.b}static random(t="vibrant",e,n){const{random:i,round:r,sin:s,PI:o}=Math;if("vibrant"===t){const t=24*i()+57,e=38*i()+45,n=360*i();return new st(t,e,n,"lch")}if("sine"===t){const t=r(80*s(2*o*(e=null==e?i():e)/.5+.01)+150),n=r(50*s(2*o*e/.5+4.6)+200),h=r(100*s(2*o*e/.5+2.3)+150);return new st(t,n,h)}if("pastel"===t){const t=8*i()+86,e=17*i()+9,n=360*i();return new st(t,e,n,"lch")}if("dark"===t){const t=10+10*i(),e=50*i()+86,n=360*i();return new st(t,e,n,"lch")}if("rgb"===t){const t=255*i(),e=255*i(),n=255*i();return new st(t,e,n)}if("lab"===t){const t=100*i(),e=256*i()-128,n=256*i()-128;return new st(t,e,n,"lab")}if("grey"===t){const t=255*i();return new st(t,t,t)}throw new Error("Unsupported random color mode")}static test(t){return"string"==typeof t&&(U.test(t)||W.test(t))}cmyk(){const{_a:t,_b:e,_c:n}=this.rgb(),[i,r,s]=[t,e,n].map((t=>t/255)),o=Math.min(1-i,1-r,1-s);if(1===o)return new st(0,0,0,1,"cmyk");return new st((1-i-o)/(1-o),(1-r-o)/(1-o),(1-s-o)/(1-o),o,"cmyk")}hsl(){const{_a:t,_b:e,_c:n}=this.rgb(),[i,r,s]=[t,e,n].map((t=>t/255)),o=Math.max(i,r,s),h=Math.min(i,r,s),u=(o+h)/2,a=o===h,l=o-h;return new st(360*(a?0:o===i?((r-s)/l+(r<s?6:0))/6:o===r?((s-i)/l+2)/6:o===s?((i-r)/l+4)/6:0),100*(a?0:u>.5?l/(2-o-h):l/(o+h)),100*u,"hsl")}init(t=0,e=0,n=0,i=0,r="rgb"){if(t=t||0,this.space)for(const t in this.space)delete this[this.space[t]];if("number"==typeof t)r="string"==typeof i?i:r,i="string"==typeof i?0:i,Object.assign(this,{_a:t,_b:e,_c:n,_d:i,space:r});else if(t instanceof Array)this.space=e||("string"==typeof t[3]?t[3]:t[4])||"rgb",Object.assign(this,{_a:t[0],_b:t[1],_c:t[2],_d:t[3]||0});else if(t instanceof Object){const n=function(t,e){const n=it(t,"rgb")?{_a:t.r,_b:t.g,_c:t.b,_d:0,space:"rgb"}:it(t,"xyz")?{_a:t.x,_b:t.y,_c:t.z,_d:0,space:"xyz"}:it(t,"hsl")?{_a:t.h,_b:t.s,_c:t.l,_d:0,space:"hsl"}:it(t,"lab")?{_a:t.l,_b:t.a,_c:t.b,_d:0,space:"lab"}:it(t,"lch")?{_a:t.l,_b:t.c,_c:t.h,_d:0,space:"lch"}:it(t,"cmyk")?{_a:t.c,_b:t.m,_c:t.y,_d:t.k,space:"cmyk"}:{_a:0,_b:0,_c:0,space:"rgb"};return n.space=e||n.space,n}(t,e);Object.assign(this,n)}else if("string"==typeof t)if(W.test(t)){const e=t.replace($,""),[n,i,r]=B.exec(e).slice(1,4).map((t=>parseInt(t)));Object.assign(this,{_a:n,_b:i,_c:r,_d:0,space:"rgb"})}else{if(!U.test(t))throw Error("Unsupported string format, can't construct Color");{const e=t=>parseInt(t,16),[,n,i,r]=Y.exec(function(t){return 4===t.length?["#",t.substring(1,2),t.substring(1,2),t.substring(2,3),t.substring(2,3),t.substring(3,4),t.substring(3,4)].join(""):t}(t)).map(e);Object.assign(this,{_a:n,_b:i,_c:r,_d:0,space:"rgb"})}}const{_a:s,_b:o,_c:h,_d:u}=this,a="rgb"===this.space?{r:s,g:o,b:h}:"xyz"===this.space?{x:s,y:o,z:h}:"hsl"===this.space?{h:s,s:o,l:h}:"lab"===this.space?{l:s,a:o,b:h}:"lch"===this.space?{l:s,c:o,h:h}:"cmyk"===this.space?{c:s,m:o,y:h,k:u}:{};Object.assign(this,a)}lab(){const{x:t,y:e,z:n}=this.xyz();return new st(116*e-16,500*(t-e),200*(e-n),"lab")}lch(){const{l:t,a:e,b:n}=this.lab(),i=Math.sqrt(e**2+n**2);let r=180*Math.atan2(n,e)/Math.PI;r<0&&(r*=-1,r=360-r);return new st(t,i,r,"lch")}rgb(){if("rgb"===this.space)return this;if("lab"===(t=this.space)||"xyz"===t||"lch"===t){let{x:t,y:e,z:n}=this;if("lab"===this.space||"lch"===this.space){let{l:i,a:r,b:s}=this;if("lch"===this.space){const{c:t,h:e}=this,n=Math.PI/180;r=t*Math.cos(n*e),s=t*Math.sin(n*e)}const o=(i+16)/116,h=r/500+o,u=o-s/200,a=16/116,l=.008856,c=7.787;t=.95047*(h**3>l?h**3:(h-a)/c),e=1*(o**3>l?o**3:(o-a)/c),n=1.08883*(u**3>l?u**3:(u-a)/c)}const i=3.2406*t+-1.5372*e+-.4986*n,r=-.9689*t+1.8758*e+.0415*n,s=.0557*t+-.204*e+1.057*n,o=Math.pow,h=.0031308,u=i>h?1.055*o(i,1/2.4)-.055:12.92*i,a=r>h?1.055*o(r,1/2.4)-.055:12.92*r,l=s>h?1.055*o(s,1/2.4)-.055:12.92*s;return new st(255*u,255*a,255*l)}if("hsl"===this.space){let{h:t,s:e,l:n}=this;if(t/=360,e/=100,n/=100,0===e){n*=255;return new st(n,n,n)}const i=n<.5?n*(1+e):n+e-n*e,r=2*n-i,s=255*rt(r,i,t+1/3),o=255*rt(r,i,t),h=255*rt(r,i,t-1/3);return new st(s,o,h)}if("cmyk"===this.space){const{c:t,m:e,y:n,k:i}=this,r=255*(1-Math.min(1,t*(1-i)+i)),s=255*(1-Math.min(1,e*(1-i)+i)),o=255*(1-Math.min(1,n*(1-i)+i));return new st(r,s,o)}return this;var t}toArray(){const{_a:t,_b:e,_c:n,_d:i,space:r}=this;return[t,e,n,i,r]}toHex(){const[t,e,n]=this._clamped().map(nt);return`#${t}${e}${n}`}toRgb(){const[t,e,n]=this._clamped();return`rgb(${t},${e},${n})`}toString(){return this.toHex()}xyz(){const{_a:t,_b:e,_c:n}=this.rgb(),[i,r,s]=[t,e,n].map((t=>t/255)),o=i>.04045?Math.pow((i+.055)/1.055,2.4):i/12.92,h=r>.04045?Math.pow((r+.055)/1.055,2.4):r/12.92,u=s>.04045?Math.pow((s+.055)/1.055,2.4):s/12.92,a=(.4124*o+.3576*h+.1805*u)/.95047,l=(.2126*o+.7152*h+.0722*u)/1,c=(.0193*o+.1192*h+.9505*u)/1.08883,f=a>.008856?Math.pow(a,1/3):7.787*a+16/116,d=l>.008856?Math.pow(l,1/3):7.787*l+16/116,m=c>.008856?Math.pow(c,1/3):7.787*c+16/116;return new st(f,d,m,"xyz")}_clamped(){const{_a:t,_b:e,_c:n}=this.rgb(),{max:i,min:r,round:s}=Math;return[t,e,n].map((t=>i(0,r(s(t),255))))}}class ot{constructor(...t){this.init(...t)}clone(){return new ot(this)}init(t,e){const n=0,i=0,r=Array.isArray(t)?{x:t[0],y:t[1]}:"object"==typeof t?{x:t.x,y:t.y}:{x:t,y:e};return this.x=null==r.x?n:r.x,this.y=null==r.y?i:r.y,this}toArray(){return[this.x,this.y]}transform(t){return this.clone().transformO(t)}transformO(t){ut.isMatrixLike(t)||(t=new ut(t));const{x:e,y:n}=this;return this.x=t.a*e+t.c*n+t.e,this.y=t.b*e+t.d*n+t.f,this}}function ht(t,e,n){return Math.abs(e-t)<(n||1e-6)}class ut{constructor(...t){this.init(...t)}static formatTransforms(t){const e="both"===t.flip||!0===t.flip,n=t.flip&&(e||"x"===t.flip)?-1:1,i=t.flip&&(e||"y"===t.flip)?-1:1,r=t.skew&&t.skew.length?t.skew[0]:isFinite(t.skew)?t.skew:isFinite(t.skewX)?t.skewX:0,s=t.skew&&t.skew.length?t.skew[1]:isFinite(t.skew)?t.skew:isFinite(t.skewY)?t.skewY:0,o=t.scale&&t.scale.length?t.scale[0]*n:isFinite(t.scale)?t.scale*n:isFinite(t.scaleX)?t.scaleX*n:n,h=t.scale&&t.scale.length?t.scale[1]*i:isFinite(t.scale)?t.scale*i:isFinite(t.scaleY)?t.scaleY*i:i,u=t.shear||0,a=t.rotate||t.theta||0,l=new ot(t.origin||t.around||t.ox||t.originX,t.oy||t.originY),c=l.x,f=l.y,d=new ot(t.position||t.px||t.positionX||NaN,t.py||t.positionY||NaN),m=d.x,p=d.y,y=new ot(t.translate||t.tx||t.translateX,t.ty||t.translateY),w=y.x,_=y.y,g=new ot(t.relative||t.rx||t.relativeX,t.ry||t.relativeY);return{scaleX:o,scaleY:h,skewX:r,skewY:s,shear:u,theta:a,rx:g.x,ry:g.y,tx:w,ty:_,ox:c,oy:f,px:m,py:p}}static fromArray(t){return{a:t[0],b:t[1],c:t[2],d:t[3],e:t[4],f:t[5]}}static isMatrixLike(t){return null!=t.a||null!=t.b||null!=t.c||null!=t.d||null!=t.e||null!=t.f}static matrixMultiply(t,e,n){const i=t.a*e.a+t.c*e.b,r=t.b*e.a+t.d*e.b,s=t.a*e.c+t.c*e.d,o=t.b*e.c+t.d*e.d,h=t.e+t.a*e.e+t.c*e.f,u=t.f+t.b*e.e+t.d*e.f;return n.a=i,n.b=r,n.c=s,n.d=o,n.e=h,n.f=u,n}around(t,e,n){return this.clone().aroundO(t,e,n)}aroundO(t,e,n){const i=t||0,r=e||0;return this.translateO(-i,-r).lmultiplyO(n).translateO(i,r)}clone(){return new ut(this)}decompose(t=0,e=0){const n=this.a,i=this.b,r=this.c,s=this.d,o=this.e,h=this.f,u=n*s-i*r,a=u>0?1:-1,l=a*Math.sqrt(n*n+i*i),c=Math.atan2(a*i,a*n),f=180/Math.PI*c,d=Math.cos(c),m=Math.sin(c),p=(n*r+i*s)/u,y=r*l/(p*n-i)||s*l/(p*i+n);return{scaleX:l,scaleY:y,shear:p,rotate:f,translateX:o-t+t*d*l+e*(p*d*l-m*y),translateY:h-e+t*m*l+e*(p*m*l+d*y),originX:t,originY:e,a:this.a,b:this.b,c:this.c,d:this.d,e:this.e,f:this.f}}equals(t){if(t===this)return!0;const e=new ut(t);return ht(this.a,e.a)&&ht(this.b,e.b)&&ht(this.c,e.c)&&ht(this.d,e.d)&&ht(this.e,e.e)&&ht(this.f,e.f)}flip(t,e){return this.clone().flipO(t,e)}flipO(t,e){return"x"===t?this.scaleO(-1,1,e,0):"y"===t?this.scaleO(1,-1,0,e):this.scaleO(-1,-1,t,e||t)}init(t){const e=ut.fromArray([1,0,0,1,0,0]);return t=t instanceof Element?t.matrixify():"string"==typeof t?ut.fromArray(t.split(K).map(parseFloat)):Array.isArray(t)?ut.fromArray(t):"object"==typeof t&&ut.isMatrixLike(t)?t:"object"==typeof t?(new ut).transform(t):6===arguments.length?ut.fromArray([].slice.call(arguments)):e,this.a=null!=t.a?t.a:e.a,this.b=null!=t.b?t.b:e.b,this.c=null!=t.c?t.c:e.c,this.d=null!=t.d?t.d:e.d,this.e=null!=t.e?t.e:e.e,this.f=null!=t.f?t.f:e.f,this}inverse(){return this.clone().inverseO()}inverseO(){const t=this.a,e=this.b,n=this.c,i=this.d,r=this.e,s=this.f,o=t*i-e*n;if(!o)throw new Error("Cannot invert "+this);const h=i/o,u=-e/o,a=-n/o,l=t/o,c=-(h*r+a*s),f=-(u*r+l*s);return this.a=h,this.b=u,this.c=a,this.d=l,this.e=c,this.f=f,this}lmultiply(t){return this.clone().lmultiplyO(t)}lmultiplyO(t){const e=t instanceof ut?t:new ut(t);return ut.matrixMultiply(e,this,this)}multiply(t){return this.clone().multiplyO(t)}multiplyO(t){const e=t instanceof ut?t:new ut(t);return ut.matrixMultiply(this,e,this)}rotate(t,e,n){return this.clone().rotateO(t,e,n)}rotateO(t,e=0,n=0){t=h(t);const i=Math.cos(t),r=Math.sin(t),{a:s,b:o,c:u,d:a,e:l,f:c}=this;return this.a=s*i-o*r,this.b=o*i+s*r,this.c=u*i-a*r,this.d=a*i+u*r,this.e=l*i-c*r+n*r-e*i+e,this.f=c*i+l*r-e*r-n*i+n,this}scale(t,e,n,i){return this.clone().scaleO(...arguments)}scaleO(t,e=t,n=0,i=0){3===arguments.length&&(i=n,n=e,e=t);const{a:r,b:s,c:o,d:h,e:u,f:a}=this;return this.a=r*t,this.b=s*e,this.c=o*t,this.d=h*e,this.e=u*t-n*t+n,this.f=a*e-i*e+i,this}shear(t,e,n){return this.clone().shearO(t,e,n)}shearO(t,e=0,n=0){const{a:i,b:r,c:s,d:o,e:h,f:u}=this;return this.a=i+r*t,this.c=s+o*t,this.e=h+u*t-n*t,this}skew(t,e,n,i){return this.clone().skewO(...arguments)}skewO(t,e=t,n=0,i=0){3===arguments.length&&(i=n,n=e,e=t),t=h(t),e=h(e);const r=Math.tan(t),s=Math.tan(e),{a:o,b:u,c:a,d:l,e:c,f:f}=this;return this.a=o+u*r,this.b=u+o*s,this.c=a+l*r,this.d=l+a*s,this.e=c+f*r-i*r,this.f=f+c*s-n*s,this}skewX(t,e,n){return this.skew(t,0,e,n)}skewY(t,e,n){return this.skew(0,t,e,n)}toArray(){return[this.a,this.b,this.c,this.d,this.e,this.f]}toString(){return"matrix("+this.a+","+this.b+","+this.c+","+this.d+","+this.e+","+this.f+")"}transform(t){if(ut.isMatrixLike(t)){return new ut(t).multiplyO(this)}const e=ut.formatTransforms(t),{x:n,y:i}=new ot(e.ox,e.oy).transform(this),r=(new ut).translateO(e.rx,e.ry).lmultiplyO(this).translateO(-n,-i).scaleO(e.scaleX,e.scaleY).skewO(e.skewX,e.skewY).shearO(e.shear).rotateO(e.theta).translateO(n,i);if(isFinite(e.px)||isFinite(e.py)){const t=new ot(n,i).transform(r),s=isFinite(e.px)?e.px-t.x:0,o=isFinite(e.py)?e.py-t.y:0;r.translateO(s,o)}return r.translateO(e.tx,e.ty),r}translate(t,e){return this.clone().translateO(t,e)}translateO(t,e){return this.e+=t||0,this.f+=e||0,this}valueOf(){return{a:this.a,b:this.b,c:this.c,d:this.d,e:this.e,f:this.f}}}function at(){if(!at.nodes){const t=S().size(2,0);t.node.style.cssText=["opacity: 0","position: absolute","left: -100%","top: -100%","overflow: hidden"].join(";"),t.attr("focusable","false"),t.attr("aria-hidden","true");const e=t.path().node;at.nodes={svg:t,path:e}}if(!at.nodes.svg.node.parentNode){const t=x.document.body||x.document.documentElement;at.nodes.svg.addTo(t)}return at.nodes}function lt(t){return!(t.width||t.height||t.x||t.y)}I(ut,"Matrix");class ct{constructor(...t){this.init(...t)}addOffset(){return this.x+=x.window.pageXOffset,this.y+=x.window.pageYOffset,new ct(this)}init(t){return t="string"==typeof t?t.split(K).map(parseFloat):Array.isArray(t)?t:"object"==typeof t?[null!=t.left?t.left:t.x,null!=t.top?t.top:t.y,t.width,t.height]:4===arguments.length?[].slice.call(arguments):[0,0,0,0],this.x=t[0]||0,this.y=t[1]||0,this.width=this.w=t[2]||0,this.height=this.h=t[3]||0,this.x2=this.x+this.w,this.y2=this.y+this.h,this.cx=this.x+this.w/2,this.cy=this.y+this.h/2,this}isNulled(){return lt(this)}merge(t){const e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x+t.width)-e,r=Math.max(this.y+this.height,t.y+t.height)-n;return new ct(e,n,i,r)}toArray(){return[this.x,this.y,this.width,this.height]}toString(){return this.x+" "+this.y+" "+this.width+" "+this.height}transform(t){t instanceof ut||(t=new ut(t));let e=1/0,n=-1/0,i=1/0,r=-1/0;return[new ot(this.x,this.y),new ot(this.x2,this.y),new ot(this.x,this.y2),new ot(this.x2,this.y2)].forEach((function(s){s=s.transform(t),e=Math.min(e,s.x),n=Math.max(n,s.x),i=Math.min(i,s.y),r=Math.max(r,s.y)})),new ct(e,i,n-e,r-i)}}function ft(t,e,n){let i;try{if(i=e(t.node),lt(i)&&((r=t.node)!==x.document&&!(x.document.documentElement.contains||function(t){for(;t.parentNode;)t=t.parentNode;return t===x.document}).call(x.document.documentElement,r)))throw new Error("Element not in the dom")}catch(e){i=n(t)}var r;return i}n({viewbox:{viewbox(t,e,n,i){return null==t?new ct(this.attr("viewBox")):this.attr("viewBox",new ct(t,e,n,i))},zoom(t,e){let{width:n,height:i}=this.attr(["width","height"]);if((n||i)&&"string"!=typeof n&&"string"!=typeof i||(n=this.node.clientWidth,i=this.node.clientHeight),!n||!i)throw new Error("Impossible to get absolute width and height. Please provide an absolute width and height attribute on the zooming element");const r=this.viewbox(),s=n/r.width,o=i/r.height,h=Math.min(s,o);if(null==t)return h;let u=h/t;u===1/0&&(u=Number.MAX_SAFE_INTEGER/100),e=e||new ot(n/2/s+r.x,i/2/o+r.y);const a=new ct(r).transform(new ut({scale:u,origin:e}));return this.viewbox(a)}}}),I(ct,"Box");class dt extends Array{constructor(t=[],...e){if(super(t,...e),"number"==typeof t)return this;this.length=0,this.push(...t)}}F([dt],{each(t,...e){return"function"==typeof t?this.map(((e,n,i)=>t.call(e,e,n,i))):this.map((n=>n[t](...e)))},toArray(){return Array.prototype.concat.apply([],this)}});const mt=["toArray","constructor","each"];function pt(t,e){return new dt(s((e||x.document).querySelectorAll(t),(function(t){return j(t)})))}dt.extend=function(t){t=t.reduce(((t,e)=>(mt.includes(e)||"_"===e[0]||(t[e]=function(...t){return this.each(e,...t)}),t)),{}),F([dt],t)};let yt=0;const wt={};function _t(t){let e=t.getEventHolder();return e===x.window&&(e=wt),e.events||(e.events={}),e.events}function gt(t){return t.getEventTarget()}function xt(t){let e=t.getEventHolder();e===x.window&&(e=wt),e.events&&(e.events={})}function bt(t,e,n,i,r){const s=n.bind(i||t),o=S(t),h=_t(o),u=gt(o);e=Array.isArray(e)?e:e.split(K),n._svgjsListenerId||(n._svgjsListenerId=++yt),e.forEach((function(t){const e=t.split(".")[0],i=t.split(".")[1]||"*";h[e]=h[e]||{},h[e][i]=h[e][i]||{},h[e][i][n._svgjsListenerId]=s,u.addEventListener(e,s,r||!1)}))}function vt(t,e,n,i){const r=S(t),s=_t(r),o=gt(r);("function"!=typeof n||(n=n._svgjsListenerId))&&(e=Array.isArray(e)?e:(e||"").split(K)).forEach((function(t){const e=t&&t.split(".")[0],h=t&&t.split(".")[1];let u,a;if(n)s[e]&&s[e][h||"*"]&&(o.removeEventListener(e,s[e][h||"*"][n],i||!1),delete s[e][h||"*"][n]);else if(e&&h){if(s[e]&&s[e][h]){for(a in s[e][h])vt(o,[e,h].join("."),a);delete s[e][h]}}else if(h)for(t in s)for(u in s[t])h===u&&vt(o,[t,h].join("."));else if(e){if(s[e]){for(u in s[e])vt(o,[e,u].join("."));delete s[e]}}else{for(t in s)vt(o,t);xt(r)}}))}function Mt(t,e,n,i){const r=gt(t);return e instanceof x.window.Event||(e=new x.window.CustomEvent(e,{detail:n,cancelable:!0,...i})),r.dispatchEvent(e),e}class Ot extends k{addEventListener(){}dispatch(t,e,n){return Mt(this,t,e,n)}dispatchEvent(t){const e=this.getEventHolder().events;if(!e)return!0;const n=e[t.type];for(const e in n)for(const i in n[e])n[e][i](t);return!t.defaultPrevented}fire(t,e,n){return this.dispatch(t,e,n),this}getEventHolder(){return this}getEventTarget(){return this}off(t,e,n){return vt(this,t,e,n),this}on(t,e,n,i){return bt(this,t,e,n,i),this}removeEventListener(){}}function At(){}I(Ot,"EventTarget");const kt={duration:400,ease:">",delay:0},Ct={"fill-opacity":1,"stroke-opacity":1,"stroke-width":0,"stroke-linejoin":"miter","stroke-linecap":"butt",fill:"#000000",stroke:"#000000",opacity:1,x:0,y:0,cx:0,cy:0,width:0,height:0,r:0,rx:0,ry:0,offset:0,"stop-opacity":1,"stop-color":"#000000","text-anchor":"start"};var Tt={__proto__:null,noop:At,timeline:kt,attrs:Ct};class Nt extends Array{constructor(...t){super(...t),this.init(...t)}clone(){return new this.constructor(this)}init(t){return"number"==typeof t||(this.length=0,this.push(...this.parse(t))),this}parse(t=[]){return t instanceof Array?t:t.trim().split(K).map(parseFloat)}toArray(){return Array.prototype.concat.apply([],this)}toSet(){return new Set(this)}toString(){return this.join(" ")}valueOf(){const t=[];return t.push(...this),t}}class St{constructor(...t){this.init(...t)}convert(t){return new St(this.value,t)}divide(t){return t=new St(t),new St(this/t,this.unit||t.unit)}init(t,e){return e=Array.isArray(t)?t[1]:e,t=Array.isArray(t)?t[0]:t,this.value=0,this.unit=e||"","number"==typeof t?this.value=isNaN(t)?0:isFinite(t)?t:t<0?-34e37:34e37:"string"==typeof t?(e=t.match(X))&&(this.value=parseFloat(e[1]),"%"===e[5]?this.value/=100:"s"===e[5]&&(this.value*=1e3),this.unit=e[5]):t instanceof St&&(this.value=t.valueOf(),this.unit=t.unit),this}minus(t){return t=new St(t),new St(this-t,this.unit||t.unit)}plus(t){return t=new St(t),new St(this+t,this.unit||t.unit)}times(t){return t=new St(t),new St(this*t,this.unit||t.unit)}toArray(){return[this.value,this.unit]}toJSON(){return this.toString()}toString(){return("%"===this.unit?~~(1e8*this.value)/1e6:"s"===this.unit?this.value/1e3:this.value)+this.unit}valueOf(){return this.value}}const Et=[];class Dom extends Ot{constructor(t,e){super(),this.node=t,this.type=t.nodeName,e&&t!==e&&this.attr(e)}add(t,e){return(t=S(t)).removeNamespace&&this.node instanceof x.window.SVGElement&&t.removeNamespace(),null==e?this.node.appendChild(t.node):t.node!==this.node.childNodes[e]&&this.node.insertBefore(t.node,this.node.childNodes[e]),this}addTo(t,e){return S(t).put(this,e)}children(){return new dt(s(this.node.children,(function(t){return j(t)})))}clear(){for(;this.node.hasChildNodes();)this.node.removeChild(this.node.lastChild);return this}clone(t=!0,e=!0){this.writeDataToDom();let n=this.node.cloneNode(t);return e&&(n=P(n)),new this.constructor(n)}each(t,e){const n=this.children();let i,r;for(i=0,r=n.length;i<r;i++)t.apply(n[i],[i,n]),e&&n[i].each(t,e);return this}element(t,e){return this.put(new Dom(N(t),e))}first(){return j(this.node.firstChild)}get(t){return j(this.node.childNodes[t])}getEventHolder(){return this.node}getEventTarget(){return this.node}has(t){return this.index(t)>=0}html(t,e){return this.xml(t,e,p)}id(t){return void 0!==t||this.node.id||(this.node.id=L(this.type)),this.attr("id",t)}index(t){return[].slice.call(this.node.childNodes).indexOf(t.node)}last(){return j(this.node.lastChild)}matches(t){const e=this.node,n=e.matches||e.matchesSelector||e.msMatchesSelector||e.mozMatchesSelector||e.webkitMatchesSelector||e.oMatchesSelector||null;return n&&n.call(e,t)}parent(t){let e=this;if(!e.node.parentNode)return null;if(e=j(e.node.parentNode),!t)return e;do{if("string"==typeof t?e.matches(t):e instanceof t)return e}while(e=j(e.node.parentNode));return e}put(t,e){return t=S(t),this.add(t,e),t}putIn(t,e){return S(t).add(this,e)}remove(){return this.parent()&&this.parent().removeElement(this),this}removeElement(t){return this.node.removeChild(t.node),this}replace(t){return t=S(t),this.node.parentNode&&this.node.parentNode.replaceChild(t.node,this.node),t}round(t=2,e=null){const n=10**t,i=this.attr(e);for(const t in i)"number"==typeof i[t]&&(i[t]=Math.round(i[t]*n)/n);return this.attr(i),this}svg(t,e){return this.xml(t,e,m)}toString(){return this.id()}words(t){return this.node.textContent=t,this}wrap(t){const e=this.parent();if(!e)return this.addTo(t);const n=e.index(this);return e.put(t,n).put(this)}writeDataToDom(){return this.each((function(){this.writeDataToDom()})),this}xml(t,e,n){if("boolean"==typeof t&&(n=e,e=t,t=null),null==t||"function"==typeof t){e=null==e||e,this.writeDataToDom();let n=this;if(null!=t){if(n=j(n.node.cloneNode(!0)),e){const e=t(n);if(n=e||n,!1===e)return""}n.each((function(){const e=t(this),n=e||this;!1===e?this.remove():e&&this!==n&&this.replace(n)}),!0)}return e?n.node.outerHTML:n.node.innerHTML}e=null!=e&&e;const i=N("wrapper",n),r=x.document.createDocumentFragment();i.innerHTML=t;for(let t=i.children.length;t--;)r.appendChild(i.firstElementChild);const s=this.parent();return e?this.replace(r)&&s:this.add(r)}}F(Dom,{attr:function(t,e,n){if(null==t){t={},e=this.node.attributes;for(const n of e)t[n.nodeName]=J.test(n.nodeValue)?parseFloat(n.nodeValue):n.nodeValue;return t}if(t instanceof Array)return t.reduce(((t,e)=>(t[e]=this.attr(e),t)),{});if("object"==typeof t&&t.constructor===Object)for(e in t)this.attr(e,t[e]);else if(null===e)this.node.removeAttribute(t);else{if(null==e)return null==(e=this.node.getAttribute(t))?Ct[t]:J.test(e)?parseFloat(e):e;"number"==typeof(e=Et.reduce(((e,n)=>n(t,e,this)),e))?e=new St(e):st.isColor(e)?e=new st(e):e.constructor===Array&&(e=new Nt(e)),"leading"===t?this.leading&&this.leading(e):"string"==typeof n?this.node.setAttributeNS(n,t,e.toString()):this.node.setAttribute(t,e.toString()),!this.rebuild||"font-size"!==t&&"x"!==t||this.rebuild()}return this},find:function(t){return pt(t,this.node)},findOne:function(t){return j(this.node.querySelector(t))}}),I(Dom,"Dom");class Element extends Dom{constructor(t,e){super(t,e),this.dom={},this.node.instance=this,t.hasAttribute("svgjs:data")&&this.setData(JSON.parse(t.getAttribute("svgjs:data"))||{})}center(t,e){return this.cx(t).cy(e)}cx(t){return null==t?this.x()+this.width()/2:this.x(t-this.width()/2)}cy(t){return null==t?this.y()+this.height()/2:this.y(t-this.height()/2)}defs(){const t=this.root();return t&&t.defs()}dmove(t,e){return this.dx(t).dy(e)}dx(t=0){return this.x(new St(t).plus(this.x()))}dy(t=0){return this.y(new St(t).plus(this.y()))}getEventHolder(){return this}height(t){return this.attr("height",t)}move(t,e){return this.x(t).y(e)}parents(t=this.root()){const e="string"==typeof t;e||(t=S(t));const n=new dt;let i=this;for(;(i=i.parent())&&i.node!==x.document&&"#document-fragment"!==i.nodeName&&(n.push(i),e||i.node!==t.node)&&(!e||!i.matches(t));)if(i.node===this.root().node)return null;return n}reference(t){if(!(t=this.attr(t)))return null;const e=(t+"").match(H);return e?S(e[1]):null}root(){const t=this.parent(z(T));return t&&t.root()}setData(t){return this.dom=t,this}size(t,e){const n=c(this,t,e);return this.width(new St(n.width)).height(new St(n.height))}width(t){return this.attr("width",t)}writeDataToDom(){return this.node.removeAttribute("svgjs:data"),Object.keys(this.dom).length&&this.node.setAttribute("svgjs:data",JSON.stringify(this.dom)),super.writeDataToDom()}x(t){return this.attr("x",t)}y(t){return this.attr("y",t)}}F(Element,{bbox:function(){const t=ft(this,(t=>t.getBBox()),(t=>{try{const e=t.clone().addTo(at().svg).show(),n=e.node.getBBox();return e.remove(),n}catch(e){throw new Error(`Getting bbox of element "${t.node.nodeName}" is not possible: ${e.toString()}`)}}));return new ct(t)},rbox:function(t){const e=ft(this,(t=>t.getBoundingClientRect()),(t=>{throw new Error(`Getting rbox of element "${t.node.nodeName}" is not possible`)})),n=new ct(e);return t?n.transform(t.screenCTM().inverseO()):n.addOffset()},inside:function(t,e){const n=this.bbox();return t>n.x&&e>n.y&&t<n.x+n.width&&e<n.y+n.height},point:function(t,e){return new ot(t,e).transformO(this.screenCTM().inverseO())},ctm:function(){return new ut(this.node.getCTM())},screenCTM:function(){if("function"==typeof this.isRoot&&!this.isRoot()){const t=this.rect(1,1),e=t.node.getScreenCTM();return t.remove(),new ut(e)}return new ut(this.node.getScreenCTM())}}),I(Element,"Element");const jt={stroke:["color","width","opacity","linecap","linejoin","miterlimit","dasharray","dashoffset"],fill:["color","opacity","rule"],prefix:function(t,e){return"color"===e?t:t+"-"+e}};["fill","stroke"].forEach((function(t){const e={};let i;e[t]=function(e){if(void 0===e)return this.attr(t);if("string"==typeof e||e instanceof st||st.isRgb(e)||e instanceof Element)this.attr(t,e);else for(i=jt[t].length-1;i>=0;i--)null!=e[jt[t][i]]&&this.attr(jt.prefix(t,jt[t][i]),e[jt[t][i]]);return this},n(["Element","Runner"],e)})),n(["Element","Runner"],{matrix:function(t,e,n,i,r,s){return null==t?new ut(this):this.attr("transform",new ut(t,e,n,i,r,s))},rotate:function(t,e,n){return this.transform({rotate:t,ox:e,oy:n},!0)},skew:function(t,e,n,i){return 1===arguments.length||3===arguments.length?this.transform({skew:t,ox:e,oy:n},!0):this.transform({skew:[t,e],ox:n,oy:i},!0)},shear:function(t,e,n){return this.transform({shear:t,ox:e,oy:n},!0)},scale:function(t,e,n,i){return 1===arguments.length||3===arguments.length?this.transform({scale:t,ox:e,oy:n},!0):this.transform({scale:[t,e],ox:n,oy:i},!0)},translate:function(t,e){return this.transform({translate:[t,e]},!0)},relative:function(t,e){return this.transform({relative:[t,e]},!0)},flip:function(t="both",e="center"){return-1==="xybothtrue".indexOf(t)&&(e=t,t="both"),this.transform({flip:t,origin:e},!0)},opacity:function(t){return this.attr("opacity",t)}}),n("radius",{radius:function(t,e=t){return"radialGradient"===(this._element||this).type?this.attr("r",new St(t)):this.rx(t).ry(e)}}),n("Path",{length:function(){return this.node.getTotalLength()},pointAt:function(t){return new ot(this.node.getPointAtLength(t))}}),n(["Element","Runner"],{font:function(t,e){if("object"==typeof t){for(e in t)this.font(e,t[e]);return this}return"leading"===t?this.leading(e):"anchor"===t?this.attr("text-anchor",e):"size"===t||"family"===t||"weight"===t||"stretch"===t||"variant"===t||"style"===t?this.attr("font-"+t,e):this.attr(t,e)}});n("Element",["click","dblclick","mousedown","mouseup","mouseover","mouseout","mousemove","mouseenter","mouseleave","touchstart","touchmove","touchleave","touchend","touchcancel"].reduce((function(t,e){return t[e]=function(t){return null===t?this.off(e):this.on(e,t),this},t}),{})),n("Element",{untransform:function(){return this.attr("transform",null)},matrixify:function(){const t=(this.attr("transform")||"").split(V).slice(0,-1).map((function(t){const e=t.trim().split("(");return[e[0],e[1].split(K).map((function(t){return parseFloat(t)}))]})).reverse().reduce((function(t,e){return"matrix"===e[0]?t.lmultiply(ut.fromArray(e[1])):t[e[0]].apply(t,e[1])}),new ut);return t},toParent:function(t,e){if(this===t)return this;const n=this.screenCTM(),i=t.screenCTM().inverse();return this.addTo(t,e).untransform().transform(i.multiply(n)),this},toRoot:function(t){return this.toParent(this.root(),t)},transform:function(t,e){if(null==t||"string"==typeof t){const e=new ut(this).decompose();return null==t?e:e[t]}ut.isMatrixLike(t)||(t={...t,origin:f(t,this)});const n=new ut(!0===e?this:e||!1).transform(t);return this.attr("transform",n)}});class Container extends Element{flatten(t=this,e){return this.each((function(){if(this instanceof Container)return this.flatten().ungroup()})),this}ungroup(t=this.parent(),e=t.index(this)){return e=-1===e?t.children().length:e,this.each((function(n,i){return i[i.length-n-1].toParent(t,e)})),this.remove()}}I(Container,"Container");class Defs extends Container{constructor(t,e=t){super(E("defs",t),e)}flatten(){return this}ungroup(){return this}}I(Defs,"Defs");class Shape extends Element{}function Dt(t){return this.attr("rx",t)}function It(t){return this.attr("ry",t)}function zt(t){return null==t?this.cx()-this.rx():this.cx(t+this.rx())}function Rt(t){return null==t?this.cy()-this.ry():this.cy(t+this.ry())}function Lt(t){return this.attr("cx",t)}function Pt(t){return this.attr("cy",t)}function Ft(t){return null==t?2*this.rx():this.rx(new St(t).divide(2))}function qt(t){return null==t?2*this.ry():this.ry(new St(t).divide(2))}I(Shape,"Shape");var Xt={__proto__:null,rx:Dt,ry:It,x:zt,y:Rt,cx:Lt,cy:Pt,width:Ft,height:qt};class Ellipse extends Shape{constructor(t,e=t){super(E("ellipse",t),e)}size(t,e){const n=c(this,t,e);return this.rx(new St(n.width).divide(2)).ry(new St(n.height).divide(2))}}F(Ellipse,Xt),n("Container",{ellipse:q((function(t=0,e=t){return this.put(new Ellipse).size(t,e).move(0,0)}))}),I(Ellipse,"Ellipse");class Yt extends Dom{constructor(t=x.document.createDocumentFragment()){super(t)}xml(t,e,n){if("boolean"==typeof t&&(n=e,e=t,t=null),null==t||"function"==typeof t){const t=new Dom(N("wrapper",n));return t.add(this.node.cloneNode(!0)),t.xml(!1,n)}return super.xml(t,!1,n)}}function Bt(t,e){return"radialGradient"===(this._element||this).type?this.attr({fx:new St(t),fy:new St(e)}):this.attr({x1:new St(t),y1:new St(e)})}function Ht(t,e){return"radialGradient"===(this._element||this).type?this.attr({cx:new St(t),cy:new St(e)}):this.attr({x2:new St(t),y2:new St(e)})}I(Yt,"Fragment");var Gt,Vt={__proto__:null,from:Bt,to:Ht};class Gradient extends Container{constructor(t,e){super(E(t+"Gradient","string"==typeof t?null:t),e)}attr(t,e,n){return"transform"===t&&(t="gradientTransform"),super.attr(t,e,n)}bbox(){return new ct}targets(){return pt("svg [fill*="+this.id()+"]")}toString(){return this.url()}update(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}url(){return"url(#"+this.id()+")"}}F(Gradient,Vt),n({Container:{gradient(...t){return this.defs().gradient(...t)}},Defs:{gradient:q((function(t,e){return this.put(new Gradient(t)).update(e)}))}}),I(Gradient,"Gradient");class Pattern extends Container{constructor(t,e=t){super(E("pattern",t),e)}attr(t,e,n){return"transform"===t&&(t="patternTransform"),super.attr(t,e,n)}bbox(){return new ct}targets(){return pt("svg [fill*="+this.id()+"]")}toString(){return this.url()}update(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}url(){return"url(#"+this.id()+")"}}n({Container:{pattern(...t){return this.defs().pattern(...t)}},Defs:{pattern:q((function(t,e,n){return this.put(new Pattern).update(n).attr({x:0,y:0,width:t,height:e,patternUnits:"userSpaceOnUse"})}))}}),I(Pattern,"Pattern");class Image extends Shape{constructor(t,e=t){super(E("image",t),e)}load(t,e){if(!t)return this;const n=new x.window.Image;return bt(n,"load",(function(t){const i=this.parent(Pattern);0===this.width()&&0===this.height()&&this.size(n.width,n.height),i instanceof Pattern&&0===i.width()&&0===i.height()&&i.size(this.width(),this.height()),"function"==typeof e&&e.call(this,t)}),this),bt(n,"load error",(function(){vt(n)})),this.attr("href",n.src=t,w)}}Gt=function(t,e,n){return"fill"!==t&&"stroke"!==t||Z.test(e)&&(e=n.root().defs().image(e)),e instanceof Image&&(e=n.root().defs().pattern(0,0,(t=>{t.add(e)}))),e},Et.push(Gt),n({Container:{image:q((function(t,e){return this.put(new Image).size(0,0).load(t,e)}))}}),I(Image,"Image");class $t extends Nt{bbox(){let t=-1/0,e=-1/0,n=1/0,i=1/0;return this.forEach((function(r){t=Math.max(r[0],t),e=Math.max(r[1],e),n=Math.min(r[0],n),i=Math.min(r[1],i)})),new ct(n,i,t-n,e-i)}move(t,e){const n=this.bbox();if(t-=n.x,e-=n.y,!isNaN(t)&&!isNaN(e))for(let n=this.length-1;n>=0;n--)this[n]=[this[n][0]+t,this[n][1]+e];return this}parse(t=[0,0]){const e=[];(t=t instanceof Array?Array.prototype.concat.apply([],t):t.trim().split(K).map(parseFloat)).length%2!=0&&t.pop();for(let n=0,i=t.length;n<i;n+=2)e.push([t[n],t[n+1]]);return e}size(t,e){let n;const i=this.bbox();for(n=this.length-1;n>=0;n--)i.width&&(this[n][0]=(this[n][0]-i.x)*t/i.width+i.x),i.height&&(this[n][1]=(this[n][1]-i.y)*e/i.height+i.y);return this}toLine(){return{x1:this[0][0],y1:this[0][1],x2:this[1][0],y2:this[1][1]}}toString(){const t=[];for(let e=0,n=this.length;e<n;e++)t.push(this[e].join(","));return t.join(" ")}transform(t){return this.clone().transformO(t)}transformO(t){ut.isMatrixLike(t)||(t=new ut(t));for(let e=this.length;e--;){const[n,i]=this[e];this[e][0]=t.a*n+t.c*i+t.e,this[e][1]=t.b*n+t.d*i+t.f}return this}}var Ut={__proto__:null,MorphArray:$t,x:function(t){return null==t?this.bbox().x:this.move(t,this.bbox().y)},y:function(t){return null==t?this.bbox().y:this.move(this.bbox().x,t)},width:function(t){const e=this.bbox();return null==t?e.width:this.size(t,e.height)},height:function(t){const e=this.bbox();return null==t?e.height:this.size(e.width,t)}};class Line extends Shape{constructor(t,e=t){super(E("line",t),e)}array(){return new $t([[this.attr("x1"),this.attr("y1")],[this.attr("x2"),this.attr("y2")]])}move(t,e){return this.attr(this.array().move(t,e).toLine())}plot(t,e,n,i){return null==t?this.array():(t=void 0!==e?{x1:t,y1:e,x2:n,y2:i}:new $t(t).toLine(),this.attr(t))}size(t,e){const n=c(this,t,e);return this.attr(this.array().size(n.width,n.height).toLine())}}F(Line,Ut),n({Container:{line:q((function(...t){return Line.prototype.plot.apply(this.put(new Line),null!=t[0]?t:[0,0,0,0])}))}}),I(Line,"Line");class Marker extends Container{constructor(t,e=t){super(E("marker",t),e)}height(t){return this.attr("markerHeight",t)}orient(t){return this.attr("orient",t)}ref(t,e){return this.attr("refX",t).attr("refY",e)}toString(){return"url(#"+this.id()+")"}update(t){return this.clear(),"function"==typeof t&&t.call(this,this),this}width(t){return this.attr("markerWidth",t)}}function Wt(t,e){return function(n){return null==n?this[t]:(this[t]=n,e&&e.call(this),this)}}n({Container:{marker(...t){return this.defs().marker(...t)}},Defs:{marker:q((function(t,e,n){return this.put(new Marker).size(t,e).ref(t/2,e/2).viewbox(0,0,t,e).attr("orient","auto").update(n)}))},marker:{marker(t,e,n,i){let r=["marker"];return"all"!==t&&r.push(t),r=r.join("-"),t=arguments[1]instanceof Marker?arguments[1]:this.defs().marker(e,n,i),this.attr(r,t)}}}),I(Marker,"Marker");const Qt={"-":function(t){return t},"<>":function(t){return-Math.cos(t*Math.PI)/2+.5},">":function(t){return Math.sin(t*Math.PI/2)},"<":function(t){return 1-Math.cos(t*Math.PI/2)},bezier:function(t,e,n,i){return function(r){return r<0?t>0?e/t*r:n>0?i/n*r:0:r>1?n<1?(1-i)/(1-n)*r+(i-n)/(1-n):t<1?(1-e)/(1-t)*r+(e-t)/(1-t):1:3*r*(1-r)**2*e+3*r**2*(1-r)*i+r**3}},steps:function(t,e="end"){e=e.split("-").reverse()[0];let n=t;return"none"===e?--n:"both"===e&&++n,(i,r=!1)=>{let s=Math.floor(i*t);const o=i*s%1==0;return"start"!==e&&"both"!==e||++s,r&&o&&--s,i>=0&&s<0&&(s=0),i<=1&&s>n&&(s=n),s/n}}};class Jt{done(){return!1}}class Zt extends Jt{constructor(t=kt.ease){super(),this.ease=Qt[t]||t}step(t,e,n){return"number"!=typeof t?n<1?t:e:t+(e-t)*this.ease(n)}}class Kt extends Jt{constructor(t){super(),this.stepper=t}done(t){return t.done}step(t,e,n,i){return this.stepper(t,e,n,i)}}function te(){const t=(this._duration||500)/1e3,e=this._overshoot||0,n=Math.PI,i=Math.log(e/100+1e-10),r=-i/Math.sqrt(n*n+i*i),s=3.9/(r*t);this.d=2*r*s,this.k=s*s}class ee extends Kt{constructor(t=500,e=0){super(),this.duration(t).overshoot(e)}step(t,e,n,i){if("string"==typeof t)return t;if(i.done=n===1/0,n===1/0)return e;if(0===n)return t;n>100&&(n=16),n/=1e3;const r=i.velocity||0,s=-this.d*r-this.k*(t-e),o=t+r*n+s*n*n/2;return i.velocity=r+s*n,i.done=Math.abs(e-o)+Math.abs(r)<.002,i.done?e:o}}F(ee,{duration:Wt("_duration",te),overshoot:Wt("_overshoot",te)});class ne extends Kt{constructor(t=.1,e=.01,n=0,i=1e3){super(),this.p(t).i(e).d(n).windup(i)}step(t,e,n,i){if("string"==typeof t)return t;if(i.done=n===1/0,n===1/0)return e;if(0===n)return t;const r=e-t;let s=(i.integral||0)+r*n;const o=(r-(i.error||0))/n,h=this._windup;return!1!==h&&(s=Math.max(-h,Math.min(s,h))),i.error=r,i.integral=s,i.done=Math.abs(r)<.001,i.done?e:t+(this.P*r+this.I*s+this.D*o)}}F(ne,{windup:Wt("_windup"),p:Wt("P"),i:Wt("I"),d:Wt("D")});const ie={M:2,L:2,H:1,V:1,C:6,S:4,Q:4,T:2,A:7,Z:0},re={M:function(t,e,n){return e.x=n.x=t[0],e.y=n.y=t[1],["M",e.x,e.y]},L:function(t,e){return e.x=t[0],e.y=t[1],["L",t[0],t[1]]},H:function(t,e){return e.x=t[0],["H",t[0]]},V:function(t,e){return e.y=t[0],["V",t[0]]},C:function(t,e){return e.x=t[4],e.y=t[5],["C",t[0],t[1],t[2],t[3],t[4],t[5]]},S:function(t,e){return e.x=t[2],e.y=t[3],["S",t[0],t[1],t[2],t[3]]},Q:function(t,e){return e.x=t[2],e.y=t[3],["Q",t[0],t[1],t[2],t[3]]},T:function(t,e){return e.x=t[0],e.y=t[1],["T",t[0],t[1]]},Z:function(t,e,n){return e.x=n.x,e.y=n.y,["Z"]},A:function(t,e){return e.x=t[5],e.y=t[6],["A",t[0],t[1],t[2],t[3],t[4],t[5],t[6]]}},se="mlhvqtcsaz".split("");for(let t=0,e=se.length;t<e;++t)re[se[t]]=function(t){return function(e,n,i){if("H"===t)e[0]=e[0]+n.x;else if("V"===t)e[0]=e[0]+n.y;else if("A"===t)e[5]=e[5]+n.x,e[6]=e[6]+n.y;else for(let t=0,i=e.length;t<i;++t)e[t]=e[t]+(t%2?n.y:n.x);return re[t](e,n,i)}}(se[t].toUpperCase());function oe(t){return t.segment.length&&t.segment.length-1===ie[t.segment[0].toUpperCase()]}function he(t,e){t.inNumber&&ue(t,!1);const n=tt.test(e);if(n)t.segment=[e];else{const e=t.lastCommand,n=e.toLowerCase(),i=e===n;t.segment=["m"===n?i?"l":"L":e]}return t.inSegment=!0,t.lastCommand=t.segment[0],n}function ue(t,e){if(!t.inNumber)throw new Error("Parser Error");t.number&&t.segment.push(parseFloat(t.number)),t.inNumber=e,t.number="",t.pointSeen=!1,t.hasExponent=!1,oe(t)&&ae(t)}function ae(t){t.inSegment=!1,t.absolute&&(t.segment=function(t){const e=t.segment[0];return re[e](t.segment.slice(1),t.p,t.p0)}(t)),t.segments.push(t.segment)}function le(t){if(!t.segment.length)return!1;const e="A"===t.segment[0].toUpperCase(),n=t.segment.length;return e&&(4===n||5===n)}function ce(t){return"E"===t.lastToken.toUpperCase()}class fe extends Nt{bbox(){return at().path.setAttribute("d",this.toString()),new ct(at.nodes.path.getBBox())}move(t,e){const n=this.bbox();if(t-=n.x,e-=n.y,!isNaN(t)&&!isNaN(e))for(let n,i=this.length-1;i>=0;i--)n=this[i][0],"M"===n||"L"===n||"T"===n?(this[i][1]+=t,this[i][2]+=e):"H"===n?this[i][1]+=t:"V"===n?this[i][1]+=e:"C"===n||"S"===n||"Q"===n?(this[i][1]+=t,this[i][2]+=e,this[i][3]+=t,this[i][4]+=e,"C"===n&&(this[i][5]+=t,this[i][6]+=e)):"A"===n&&(this[i][6]+=t,this[i][7]+=e);return this}parse(t="M0 0"){return Array.isArray(t)&&(t=Array.prototype.concat.apply([],t).toString()),function(t,e=!0){let n=0,i="";const r={segment:[],inNumber:!1,number:"",lastToken:"",inSegment:!1,segments:[],pointSeen:!1,hasExponent:!1,absolute:e,p0:new ot,p:new ot};for(;r.lastToken=i,i=t.charAt(n++);)if(r.inSegment||!he(r,i))if("."!==i)if(isNaN(parseInt(i)))if(" "!==i&&","!==i)if("-"!==i)if("E"!==i.toUpperCase()){if(tt.test(i)){if(r.inNumber)ue(r,!1);else{if(!oe(r))throw new Error("parser Error");ae(r)}--n}}else r.number+=i,r.hasExponent=!0;else{if(r.inNumber&&!ce(r)){ue(r,!1),--n;continue}r.number+=i,r.inNumber=!0}else r.inNumber&&ue(r,!1);else{if("0"===r.number||le(r)){r.inNumber=!0,r.number=i,ue(r,!0);continue}r.inNumber=!0,r.number+=i}else{if(r.pointSeen||r.hasExponent){ue(r,!1),--n;continue}r.inNumber=!0,r.pointSeen=!0,r.number+=i}return r.inNumber&&ue(r,!1),r.inSegment&&oe(r)&&ae(r),r.segments}(t)}size(t,e){const n=this.bbox();let i,r;for(n.width=0===n.width?1:n.width,n.height=0===n.height?1:n.height,i=this.length-1;i>=0;i--)r=this[i][0],"M"===r||"L"===r||"T"===r?(this[i][1]=(this[i][1]-n.x)*t/n.width+n.x,this[i][2]=(this[i][2]-n.y)*e/n.height+n.y):"H"===r?this[i][1]=(this[i][1]-n.x)*t/n.width+n.x:"V"===r?this[i][1]=(this[i][1]-n.y)*e/n.height+n.y:"C"===r||"S"===r||"Q"===r?(this[i][1]=(this[i][1]-n.x)*t/n.width+n.x,this[i][2]=(this[i][2]-n.y)*e/n.height+n.y,this[i][3]=(this[i][3]-n.x)*t/n.width+n.x,this[i][4]=(this[i][4]-n.y)*e/n.height+n.y,"C"===r&&(this[i][5]=(this[i][5]-n.x)*t/n.width+n.x,this[i][6]=(this[i][6]-n.y)*e/n.height+n.y)):"A"===r&&(this[i][1]=this[i][1]*t/n.width,this[i][2]=this[i][2]*e/n.height,this[i][6]=(this[i][6]-n.x)*t/n.width+n.x,this[i][7]=(this[i][7]-n.y)*e/n.height+n.y);return this}toString(){return function(t){let e="";for(let n=0,i=t.length;n<i;n++)e+=t[n][0],null!=t[n][1]&&(e+=t[n][1],null!=t[n][2]&&(e+=" ",e+=t[n][2],null!=t[n][3]&&(e+=" ",e+=t[n][3],e+=" ",e+=t[n][4],null!=t[n][5]&&(e+=" ",e+=t[n][5],e+=" ",e+=t[n][6],null!=t[n][7]&&(e+=" ",e+=t[n][7])))));return e+" "}(this)}}const de=t=>{const e=typeof t;return"number"===e?St:"string"===e?st.isColor(t)?st:K.test(t)?tt.test(t)?fe:Nt:X.test(t)?St:pe:ge.indexOf(t.constructor)>-1?t.constructor:Array.isArray(t)?Nt:"object"===e?_e:pe};class me{constructor(t){this._stepper=t||new Zt("-"),this._from=null,this._to=null,this._type=null,this._context=null,this._morphObj=null}at(t){return this._morphObj.morph(this._from,this._to,t,this._stepper,this._context)}done(){return this._context.map(this._stepper.done).reduce((function(t,e){return t&&e}),!0)}from(t){return null==t?this._from:(this._from=this._set(t),this)}stepper(t){return null==t?this._stepper:(this._stepper=t,this)}to(t){return null==t?this._to:(this._to=this._set(t),this)}type(t){return null==t?this._type:(this._type=t,this)}_set(t){this._type||this.type(de(t));let e=new this._type(t);return this._type===st&&(e=this._to?e[this._to[4]]():this._from?e[this._from[4]]():e),this._type===_e&&(e=this._to?e.align(this._to):this._from?e.align(this._from):e),e=e.toConsumable(),this._morphObj=this._morphObj||new this._type,this._context=this._context||Array.apply(null,Array(e.length)).map(Object).map((function(t){return t.done=!0,t})),e}}class pe{constructor(...t){this.init(...t)}init(t){return t=Array.isArray(t)?t[0]:t,this.value=t,this}toArray(){return[this.value]}valueOf(){return this.value}}class ye{constructor(...t){this.init(...t)}init(t){return Array.isArray(t)&&(t={scaleX:t[0],scaleY:t[1],shear:t[2],rotate:t[3],translateX:t[4],translateY:t[5],originX:t[6],originY:t[7]}),Object.assign(this,ye.defaults,t),this}toArray(){const t=this;return[t.scaleX,t.scaleY,t.shear,t.rotate,t.translateX,t.translateY,t.originX,t.originY]}}ye.defaults={scaleX:1,scaleY:1,shear:0,rotate:0,translateX:0,translateY:0,originX:0,originY:0};const we=(t,e)=>t[0]<e[0]?-1:t[0]>e[0]?1:0;class _e{constructor(...t){this.init(...t)}align(t){const e=this.values;for(let n=0,i=e.length;n<i;++n){if(e[n+1]===t[n+1]){if(e[n+1]===st&&t[n+7]!==e[n+7]){const e=t[n+7],i=new st(this.values.splice(n+3,5))[e]().toArray();this.values.splice(n+3,0,...i)}n+=e[n+2]+2;continue}if(!t[n+1])return this;const i=(new t[n+1]).toArray(),r=e[n+2]+3;e.splice(n,r,t[n],t[n+1],t[n+2],...i),n+=e[n+2]+2}return this}init(t){if(this.values=[],Array.isArray(t))return void(this.values=t.slice());t=t||{};const e=[];for(const n in t){const i=de(t[n]),r=new i(t[n]).toArray();e.push([n,i,r.length,...r])}return e.sort(we),this.values=e.reduce(((t,e)=>t.concat(e)),[]),this}toArray(){return this.values}valueOf(){const t={},e=this.values;for(;e.length;){const n=e.shift(),i=e.shift(),r=e.shift(),s=e.splice(0,r);t[n]=new i(s)}return t}}const ge=[pe,ye,_e];function xe(t=[]){ge.push(...[].concat(t))}function be(){F(ge,{to(t){return(new me).type(this.constructor).from(this.toArray()).to(t)},fromArray(t){return this.init(t),this},toConsumable(){return this.toArray()},morph(t,e,n,i,r){return this.fromArray(t.map((function(t,s){return i.step(t,e[s],n,r[s],r)})))}})}class Path extends Shape{constructor(t,e=t){super(E("path",t),e)}array(){return this._array||(this._array=new fe(this.attr("d")))}clear(){return delete this._array,this}height(t){return null==t?this.bbox().height:this.size(this.bbox().width,t)}move(t,e){return this.attr("d",this.array().move(t,e))}plot(t){return null==t?this.array():this.clear().attr("d","string"==typeof t?t:this._array=new fe(t))}size(t,e){const n=c(this,t,e);return this.attr("d",this.array().size(n.width,n.height))}width(t){return null==t?this.bbox().width:this.size(t,this.bbox().height)}x(t){return null==t?this.bbox().x:this.move(t,this.bbox().y)}y(t){return null==t?this.bbox().y:this.move(this.bbox().x,t)}}Path.prototype.MorphArray=fe,n({Container:{path:q((function(t){return this.put(new Path).plot(t||new fe)}))}}),I(Path,"Path");var ve={__proto__:null,array:function(){return this._array||(this._array=new $t(this.attr("points")))},clear:function(){return delete this._array,this},move:function(t,e){return this.attr("points",this.array().move(t,e))},plot:function(t){return null==t?this.array():this.clear().attr("points","string"==typeof t?t:this._array=new $t(t))},size:function(t,e){const n=c(this,t,e);return this.attr("points",this.array().size(n.width,n.height))}};class Polygon extends Shape{constructor(t,e=t){super(E("polygon",t),e)}}n({Container:{polygon:q((function(t){return this.put(new Polygon).plot(t||new $t)}))}}),F(Polygon,Ut),F(Polygon,ve),I(Polygon,"Polygon");class Polyline extends Shape{constructor(t,e=t){super(E("polyline",t),e)}}n({Container:{polyline:q((function(t){return this.put(new Polyline).plot(t||new $t)}))}}),F(Polyline,Ut),F(Polyline,ve),I(Polyline,"Polyline");class Rect extends Shape{constructor(t,e=t){super(E("rect",t),e)}}F(Rect,{rx:Dt,ry:It}),n({Container:{rect:q((function(t,e){return this.put(new Rect).size(t,e)}))}}),I(Rect,"Rect");class Me{constructor(){this._first=null,this._last=null}first(){return this._first&&this._first.value}last(){return this._last&&this._last.value}push(t){const e=void 0!==t.next?t:{value:t,next:null,prev:null};return this._last?(e.prev=this._last,this._last.next=e,this._last=e):(this._last=e,this._first=e),e}remove(t){t.prev&&(t.prev.next=t.next),t.next&&(t.next.prev=t.prev),t===this._last&&(this._last=t.prev),t===this._first&&(this._first=t.next),t.prev=null,t.next=null}shift(){const t=this._first;return t?(this._first=t.next,this._first&&(this._first.prev=null),this._last=this._first?this._last:null,t.value):null}}const Oe={nextDraw:null,frames:new Me,timeouts:new Me,immediates:new Me,timer:()=>x.window.performance||x.window.Date,transforms:[],frame(t){const e=Oe.frames.push({run:t});return null===Oe.nextDraw&&(Oe.nextDraw=x.window.requestAnimationFrame(Oe._draw)),e},timeout(t,e){e=e||0;const n=Oe.timer().now()+e,i=Oe.timeouts.push({run:t,time:n});return null===Oe.nextDraw&&(Oe.nextDraw=x.window.requestAnimationFrame(Oe._draw)),i},immediate(t){const e=Oe.immediates.push(t);return null===Oe.nextDraw&&(Oe.nextDraw=x.window.requestAnimationFrame(Oe._draw)),e},cancelFrame(t){null!=t&&Oe.frames.remove(t)},clearTimeout(t){null!=t&&Oe.timeouts.remove(t)},cancelImmediate(t){null!=t&&Oe.immediates.remove(t)},_draw(t){let e=null;const n=Oe.timeouts.last();for(;(e=Oe.timeouts.shift())&&(t>=e.time?e.run():Oe.timeouts.push(e),e!==n););let i=null;const r=Oe.frames.last();for(;i!==r&&(i=Oe.frames.shift());)i.run(t);let s=null;for(;s=Oe.immediates.shift();)s();Oe.nextDraw=Oe.timeouts.first()||Oe.frames.first()?x.window.requestAnimationFrame(Oe._draw):null}},Ae=function(t){const e=t.start,n=t.runner.duration();return{start:e,duration:n,end:e+n,runner:t.runner}},ke=function(){const t=x.window;return(t.performance||t.Date).now()};class Ce extends Ot{constructor(t=ke){super(),this._timeSource=t,this._startTime=0,this._speed=1,this._persist=0,this._nextFrame=null,this._paused=!0,this._runners=[],this._runnerIds=[],this._lastRunnerId=-1,this._time=0,this._lastSourceTime=0,this._lastStepTime=0,this._step=this._stepFn.bind(this,!1),this._stepImmediate=this._stepFn.bind(this,!0)}active(){return!!this._nextFrame}finish(){return this.time(this.getEndTimeOfTimeline()+1),this.pause()}getEndTime(){const t=this.getLastRunnerInfo(),e=t?t.runner.duration():0;return(t?t.start:this._time)+e}getEndTimeOfTimeline(){const t=this._runners.map((t=>t.start+t.runner.duration()));return Math.max(0,...t)}getLastRunnerInfo(){return this.getRunnerInfoById(this._lastRunnerId)}getRunnerInfoById(t){return this._runners[this._runnerIds.indexOf(t)]||null}pause(){return this._paused=!0,this._continue()}persist(t){return null==t?this._persist:(this._persist=t,this)}play(){return this._paused=!1,this.updateTime()._continue()}reverse(t){const e=this.speed();if(null==t)return this.speed(-e);const n=Math.abs(e);return this.speed(t?-n:n)}schedule(t,e,n){if(null==t)return this._runners.map(Ae);let i=0;const r=this.getEndTime();if(e=e||0,null==n||"last"===n||"after"===n)i=r;else if("absolute"===n||"start"===n)i=e,e=0;else if("now"===n)i=this._time;else if("relative"===n){const n=this.getRunnerInfoById(t.id);n&&(i=n.start+e,e=0)}else{if("with-last"!==n)throw new Error('Invalid value for the "when" parameter');{const t=this.getLastRunnerInfo();i=t?t.start:this._time}}t.unschedule(),t.timeline(this);const s=t.persist(),o={persist:null===s?this._persist:s,start:i+e,runner:t};return this._lastRunnerId=t.id,this._runners.push(o),this._runners.sort(((t,e)=>t.start-e.start)),this._runnerIds=this._runners.map((t=>t.runner.id)),this.updateTime()._continue(),this}seek(t){return this.time(this._time+t)}source(t){return null==t?this._timeSource:(this._timeSource=t,this)}speed(t){return null==t?this._speed:(this._speed=t,this)}stop(){return this.time(0),this.pause()}time(t){return null==t?this._time:(this._time=t,this._continue(!0))}unschedule(t){const e=this._runnerIds.indexOf(t.id);return e<0||(this._runners.splice(e,1),this._runnerIds.splice(e,1),t.timeline(null)),this}updateTime(){return this.active()||(this._lastSourceTime=this._timeSource()),this}_continue(t=!1){return Oe.cancelFrame(this._nextFrame),this._nextFrame=null,t?this._stepImmediate():(this._paused||(this._nextFrame=Oe.frame(this._step)),this)}_stepFn(t=!1){const e=this._timeSource();let n=e-this._lastSourceTime;t&&(n=0);const i=this._speed*n+(this._time-this._lastStepTime);this._lastSourceTime=e,t||(this._time+=i,this._time=this._time<0?0:this._time),this._lastStepTime=this._time,this.fire("time",this._time);for(let t=this._runners.length;t--;){const e=this._runners[t],n=e.runner;this._time-e.start<=0&&n.reset()}let r=!1;for(let t=0,e=this._runners.length;t<e;t++){const n=this._runners[t],s=n.runner;let o=i;const h=this._time-n.start;if(h<=0){r=!0;continue}if(h<o&&(o=h),!s.active())continue;if(s.step(o).done){if(!0!==n.persist){s.duration()-s.time()+this._time+n.persist<this._time&&(s.unschedule(),--t,--e)}}else r=!0}return r&&!(this._speed<0&&0===this._time)||this._runnerIds.length&&this._speed<0&&this._time>0?this._continue():(this.pause(),this.fire("finished")),this}}n({Element:{timeline:function(t){return null==t?(this._timeline=this._timeline||new Ce,this._timeline):(this._timeline=t,this)}}});class Te extends Ot{constructor(t){super(),this.id=Te.id++,t="function"==typeof(t=null==t?kt.duration:t)?new Kt(t):t,this._element=null,this._timeline=null,this.done=!1,this._queue=[],this._duration="number"==typeof t&&t,this._isDeclarative=t instanceof Kt,this._stepper=this._isDeclarative?t:new Zt,this._history={},this.enabled=!0,this._time=0,this._lastTime=0,this._reseted=!0,this.transforms=new ut,this.transformId=1,this._haveReversed=!1,this._reverse=!1,this._loopsDone=0,this._swing=!1,this._wait=0,this._times=1,this._frameId=null,this._persist=!!this._isDeclarative||null}static sanitise(t,e,n){let i=1,r=!1,s=0;return e=e||kt.delay,n=n||"last","object"!=typeof(t=t||kt.duration)||t instanceof Jt||(e=t.delay||e,n=t.when||n,r=t.swing||r,i=t.times||i,s=t.wait||s,t=t.duration||kt.duration),{duration:t,delay:e,swing:r,times:i,wait:s,when:n}}active(t){return null==t?this.enabled:(this.enabled=t,this)}addTransform(t,e){return this.transforms.lmultiplyO(t),this}after(t){return this.on("finished",t)}animate(t,e,n){const i=Te.sanitise(t,e,n),r=new Te(i.duration);return this._timeline&&r.timeline(this._timeline),this._element&&r.element(this._element),r.loop(i).schedule(i.delay,i.when)}clearTransform(){return this.transforms=new ut,this}clearTransformsFromQueue(){this.done&&this._timeline&&this._timeline._runnerIds.includes(this.id)||(this._queue=this._queue.filter((t=>!t.isTransform)))}delay(t){return this.animate(0,t)}duration(){return this._times*(this._wait+this._duration)-this._wait}during(t){return this.queue(null,t)}ease(t){return this._stepper=new Zt(t),this}element(t){return null==t?this._element:(this._element=t,t._prepareRunner(),this)}finish(){return this.step(1/0)}loop(t,e,n){return"object"==typeof t&&(e=t.swing,n=t.wait,t=t.times),this._times=t||1/0,this._swing=e||!1,this._wait=n||0,!0===this._times&&(this._times=1/0),this}loops(t){const e=this._duration+this._wait;if(null==t){const t=Math.floor(this._time/e),n=(this._time-t*e)/this._duration;return Math.min(t+n,this._times)}const n=t%1,i=e*Math.floor(t)+this._duration*n;return this.time(i)}persist(t){return null==t?this._persist:(this._persist=t,this)}position(t){const e=this._time,n=this._duration,i=this._wait,r=this._times,s=this._swing,o=this._reverse;let h;if(null==t){const t=function(t){const e=s*Math.floor(t%(2*(i+n))/(i+n)),r=e&&!o||!e&&o,h=Math.pow(-1,r)*(t%(i+n))/n+r;return Math.max(Math.min(h,1),0)},u=r*(i+n)-i;return h=e<=0?Math.round(t(1e-5)):e<u?t(e):Math.round(t(u-1e-5)),h}const u=Math.floor(this.loops()),a=s&&u%2==0;return h=u+(a&&!o||o&&a?t:1-t),this.loops(h)}progress(t){return null==t?Math.min(1,this._time/this.duration()):this.time(t*this.duration())}queue(t,e,n,i){this._queue.push({initialiser:t||At,runner:e||At,retarget:n,isTransform:i,initialised:!1,finished:!1});return this.timeline()&&this.timeline()._continue(),this}reset(){return this._reseted||(this.time(0),this._reseted=!0),this}reverse(t){return this._reverse=null==t?!this._reverse:t,this}schedule(t,e,n){if(t instanceof Ce||(n=e,e=t,t=this.timeline()),!t)throw Error("Runner cannot be scheduled without timeline");return t.schedule(this,e,n),this}step(t){if(!this.enabled)return this;t=null==t?16:t,this._time+=t;const e=this.position(),n=this._lastPosition!==e&&this._time>=0;this._lastPosition=e;const i=this.duration(),r=this._lastTime<=0&&this._time>0,s=this._lastTime<i&&this._time>=i;this._lastTime=this._time,r&&this.fire("start",this);const o=this._isDeclarative;this.done=!o&&!s&&this._time>=i,this._reseted=!1;let h=!1;return(n||o)&&(this._initialise(n),this.transforms=new ut,h=this._run(o?t:e),this.fire("step",this)),this.done=this.done||h&&o,s&&this.fire("finished",this),this}time(t){if(null==t)return this._time;const e=t-this._time;return this.step(e),this}timeline(t){return void 0===t?this._timeline:(this._timeline=t,this)}unschedule(){const t=this.timeline();return t&&t.unschedule(this),this}_initialise(t){if(t||this._isDeclarative)for(let e=0,n=this._queue.length;e<n;++e){const n=this._queue[e],i=this._isDeclarative||!n.initialised&&t;t=!n.finished,i&&t&&(n.initialiser.call(this),n.initialised=!0)}}_rememberMorpher(t,e){if(this._history[t]={morpher:e,caller:this._queue[this._queue.length-1]},this._isDeclarative){const t=this.timeline();t&&t.play()}}_run(t){let e=!0;for(let n=0,i=this._queue.length;n<i;++n){const i=this._queue[n],r=i.runner.call(this,t);i.finished=i.finished||!0===r,e=e&&i.finished}return e}_tryRetarget(t,e,n){if(this._history[t]){if(!this._history[t].caller.initialised){const e=this._queue.indexOf(this._history[t].caller);return this._queue.splice(e,1),!1}this._history[t].caller.retarget?this._history[t].caller.retarget.call(this,e,n):this._history[t].morpher.to(e),this._history[t].caller.finished=!1;const i=this.timeline();return i&&i.play(),!0}return!1}}Te.id=0;class Ne{constructor(t=new ut,e=-1,n=!0){this.transforms=t,this.id=e,this.done=n}clearTransformsFromQueue(){}}F([Te,Ne],{mergeWith(t){return new Ne(t.transforms.lmultiply(this.transforms),t.id)}});const Se=(t,e)=>t.lmultiplyO(e),Ee=t=>t.transforms;function je(){const t=this._transformationRunners.runners.map(Ee).reduce(Se,new ut);this.transform(t),this._transformationRunners.merge(),1===this._transformationRunners.length()&&(this._frameId=null)}class De{constructor(){this.runners=[],this.ids=[]}add(t){if(this.runners.includes(t))return;const e=t.id+1;return this.runners.push(t),this.ids.push(e),this}clearBefore(t){const e=this.ids.indexOf(t+1)||1;return this.ids.splice(0,e,0),this.runners.splice(0,e,new Ne).forEach((t=>t.clearTransformsFromQueue())),this}edit(t,e){const n=this.ids.indexOf(t+1);return this.ids.splice(n,1,t+1),this.runners.splice(n,1,e),this}getByID(t){return this.runners[this.ids.indexOf(t+1)]}length(){return this.ids.length}merge(){let t=null;for(let e=0;e<this.runners.length;++e){const n=this.runners[e];if(t&&n.done&&t.done&&(!n._timeline||!n._timeline._runnerIds.includes(n.id))&&(!t._timeline||!t._timeline._runnerIds.includes(t.id))){this.remove(n.id);const i=n.mergeWith(t);this.edit(t.id,i),t=i,--e}else t=n}return this}remove(t){const e=this.ids.indexOf(t+1);return this.ids.splice(e,1),this.runners.splice(e,1),this}}n({Element:{animate(t,e,n){const i=Te.sanitise(t,e,n),r=this.timeline();return new Te(i.duration).loop(i).element(this).timeline(r.play()).schedule(i.delay,i.when)},delay(t,e){return this.animate(0,t,e)},_clearTransformRunnersBefore(t){this._transformationRunners.clearBefore(t.id)},_currentTransform(t){return this._transformationRunners.runners.filter((e=>e.id<=t.id)).map(Ee).reduce(Se,new ut)},_addRunner(t){this._transformationRunners.add(t),Oe.cancelImmediate(this._frameId),this._frameId=Oe.immediate(je.bind(this))},_prepareRunner(){null==this._frameId&&(this._transformationRunners=(new De).add(new Ne(new ut(this))))}}});F(Te,{attr(t,e){return this.styleAttr("attr",t,e)},css(t,e){return this.styleAttr("css",t,e)},styleAttr(t,e,n){if("string"==typeof e)return this.styleAttr(t,{[e]:n});let i=e;if(this._tryRetarget(t,i))return this;let r=new me(this._stepper).to(i),s=Object.keys(i);return this.queue((function(){r=r.from(this.element()[t](s))}),(function(e){return this.element()[t](r.at(e).valueOf()),r.done()}),(function(e){const n=Object.keys(e),o=(h=s,n.filter((t=>!h.includes(t))));var h;if(o.length){const e=this.element()[t](o),n=new _e(r.from()).valueOf();Object.assign(n,e),r.from(n)}const u=new _e(r.to()).valueOf();Object.assign(u,e),r.to(u),s=n,i=e})),this._rememberMorpher(t,r),this},zoom(t,e){if(this._tryRetarget("zoom",t,e))return this;let n=new me(this._stepper).to(new St(t));return this.queue((function(){n=n.from(this.element().zoom())}),(function(t){return this.element().zoom(n.at(t),e),n.done()}),(function(t,i){e=i,n.to(t)})),this._rememberMorpher("zoom",n),this},transform(t,e,n){if(e=t.relative||e,this._isDeclarative&&!e&&this._tryRetarget("transform",t))return this;const i=ut.isMatrixLike(t);n=null!=t.affine?t.affine:null!=n?n:!i;const r=new me(this._stepper).type(n?ye:ut);let s,o,h,u,a;return this.queue((function(){o=o||this.element(),s=s||f(t,o),a=new ut(e?void 0:o),o._addRunner(this),e||o._clearTransformRunnersBefore(this)}),(function(l){e||this.clearTransform();const{x:c,y:f}=new ot(s).transform(o._currentTransform(this));let d=new ut({...t,origin:[c,f]}),m=this._isDeclarative&&h?h:a;if(n){d=d.decompose(c,f),m=m.decompose(c,f);const t=d.rotate,e=m.rotate,n=[t-360,t,t+360],i=n.map((t=>Math.abs(t-e))),r=Math.min(...i),s=i.indexOf(r);d.rotate=n[s]}e&&(i||(d.rotate=t.rotate||0),this._isDeclarative&&u&&(m.rotate=u)),r.from(m),r.to(d);const p=r.at(l);return u=p.rotate,h=new ut(p),this.addTransform(h),o._addRunner(this),r.done()}),(function(e){(e.origin||"center").toString()!==(t.origin||"center").toString()&&(s=f(e,o)),t={...e,origin:s}}),!0),this._isDeclarative&&this._rememberMorpher("transform",r),this},x(t,e){return this._queueNumber("x",t)},y(t){return this._queueNumber("y",t)},dx(t=0){return this._queueNumberDelta("x",t)},dy(t=0){return this._queueNumberDelta("y",t)},dmove(t,e){return this.dx(t).dy(e)},_queueNumberDelta(t,e){if(e=new St(e),this._tryRetarget(t,e))return this;const n=new me(this._stepper).to(e);let i=null;return this.queue((function(){i=this.element()[t](),n.from(i),n.to(i+e)}),(function(e){return this.element()[t](n.at(e)),n.done()}),(function(t){n.to(i+new St(t))})),this._rememberMorpher(t,n),this},_queueObject(t,e){if(this._tryRetarget(t,e))return this;const n=new me(this._stepper).to(e);return this.queue((function(){n.from(this.element()[t]())}),(function(e){return this.element()[t](n.at(e)),n.done()})),this._rememberMorpher(t,n),this},_queueNumber(t,e){return this._queueObject(t,new St(e))},cx(t){return this._queueNumber("cx",t)},cy(t){return this._queueNumber("cy",t)},move(t,e){return this.x(t).y(e)},center(t,e){return this.cx(t).cy(e)},size(t,e){let n;return t&&e||(n=this._element.bbox()),t||(t=n.width/n.height*e),e||(e=n.height/n.width*t),this.width(t).height(e)},width(t){return this._queueNumber("width",t)},height(t){return this._queueNumber("height",t)},plot(t,e,n,i){if(4===arguments.length)return this.plot([t,e,n,i]);if(this._tryRetarget("plot",t))return this;const r=new me(this._stepper).type(this._element.MorphArray).to(t);return this.queue((function(){r.from(this._element.array())}),(function(t){return this._element.plot(r.at(t)),r.done()})),this._rememberMorpher("plot",r),this},leading(t){return this._queueNumber("leading",t)},viewbox(t,e,n,i){return this._queueObject("viewbox",new ct(t,e,n,i))},update(t){return"object"!=typeof t?this.update({offset:arguments[0],color:arguments[1],opacity:arguments[2]}):(null!=t.opacity&&this.attr("stop-opacity",t.opacity),null!=t.color&&this.attr("stop-color",t.color),null!=t.offset&&this.attr("offset",t.offset),this)}}),F(Te,{rx:Dt,ry:It,from:Bt,to:Ht}),I(Te,"Runner");class Svg extends Container{constructor(t,e=t){super(E("svg",t),e),this.namespace()}defs(){return this.isRoot()?j(this.node.querySelector("defs"))||this.put(new Defs):this.root().defs()}isRoot(){return!this.node.parentNode||!(this.node.parentNode instanceof x.window.SVGElement)&&"#document-fragment"!==this.node.parentNode.nodeName}namespace(){return this.isRoot()?this.attr({xmlns:m,version:"1.1"}).attr("xmlns:xlink",w,y).attr("xmlns:svgjs",_,y):this.root().namespace()}removeNamespace(){return this.attr({xmlns:null,version:null}).attr("xmlns:xlink",null,y).attr("xmlns:svgjs",null,y)}root(){return this.isRoot()?this:super.root()}}n({Container:{nested:q((function(){return this.put(new Svg)}))}}),I(Svg,"Svg",!0);class Symbol extends Container{constructor(t,e=t){super(E("symbol",t),e)}}n({Container:{symbol:q((function(){return this.put(new Symbol)}))}}),I(Symbol,"Symbol");var Ie={__proto__:null,plain:function(t){return!1===this._build&&this.clear(),this.node.appendChild(x.document.createTextNode(t)),this},length:function(){return this.node.getComputedTextLength()},x:function(t,e=this.bbox()){return null==t?e.x:this.attr("x",this.attr("x")+t-e.x)},y:function(t,e=this.bbox()){return null==t?e.y:this.attr("y",this.attr("y")+t-e.y)},move:function(t,e,n=this.bbox()){return this.x(t,n).y(e,n)},cx:function(t,e=this.bbox()){return null==t?e.cx:this.attr("x",this.attr("x")+t-e.cx)},cy:function(t,e=this.bbox()){return null==t?e.cy:this.attr("y",this.attr("y")+t-e.cy)},center:function(t,e,n=this.bbox()){return this.cx(t,n).cy(e,n)},ax:function(t){return this.attr("x",t)},ay:function(t){return this.attr("y",t)},amove:function(t,e){return this.ax(t).ay(e)},build:function(t){return this._build=!!t,this}};class Text extends Shape{constructor(t,e=t){super(E("text",t),e),this.dom.leading=new St(1.3),this._rebuild=!0,this._build=!1}leading(t){return null==t?this.dom.leading:(this.dom.leading=new St(t),this.rebuild())}rebuild(t){if("boolean"==typeof t&&(this._rebuild=t),this._rebuild){const t=this;let e=0;const n=this.dom.leading;this.each((function(i){const r=x.window.getComputedStyle(this.node).getPropertyValue("font-size"),s=n*new St(r);this.dom.newLined&&(this.attr("x",t.attr("x")),"\n"===this.text()?e+=s:(this.attr("dy",i?s+e:0),e=0))})),this.fire("rebuild")}return this}setData(t){return this.dom=t,this.dom.leading=new St(t.leading||1.3),this}text(t){if(void 0===t){const e=this.node.childNodes;let n=0;t="";for(let i=0,r=e.length;i<r;++i)"textPath"!==e[i].nodeName?(i!==n&&3!==e[i].nodeType&&!0===j(e[i]).dom.newLined&&(t+="\n"),t+=e[i].textContent):0===i&&(n=1);return t}if(this.clear().build(!0),"function"==typeof t)t.call(this,this);else for(let e=0,n=(t=(t+"").split("\n")).length;e<n;e++)this.newLine(t[e]);return this.build(!1).rebuild()}}F(Text,Ie),n({Container:{text:q((function(t=""){return this.put(new Text).text(t)})),plain:q((function(t=""){return this.put(new Text).plain(t)}))}}),I(Text,"Text");class Tspan extends Shape{constructor(t,e=t){super(E("tspan",t),e),this._build=!1}dx(t){return this.attr("dx",t)}dy(t){return this.attr("dy",t)}newLine(){this.dom.newLined=!0;const t=this.parent();if(!(t instanceof Text))return this;const e=t.index(this),n=x.window.getComputedStyle(this.node).getPropertyValue("font-size"),i=t.dom.leading*new St(n);return this.dy(e?i:0).attr("x",t.x())}text(t){return null==t?this.node.textContent+(this.dom.newLined?"\n":""):("function"==typeof t?(this.clear().build(!0),t.call(this,this),this.build(!1)):this.plain(t),this)}}F(Tspan,Ie),n({Tspan:{tspan:q((function(t=""){const e=new Tspan;return this._build||this.clear(),this.put(e).text(t)}))},Text:{newLine:function(t=""){return this.tspan(t).newLine()}}}),I(Tspan,"Tspan");class Circle extends Shape{constructor(t,e=t){super(E("circle",t),e)}radius(t){return this.attr("r",t)}rx(t){return this.attr("r",t)}ry(t){return this.rx(t)}size(t){return this.radius(new St(t).divide(2))}}F(Circle,{x:zt,y:Rt,cx:Lt,cy:Pt,width:Ft,height:qt}),n({Container:{circle:q((function(t=0){return this.put(new Circle).size(t).move(0,0)}))}}),I(Circle,"Circle");class ClipPath extends Container{constructor(t,e=t){super(E("clipPath",t),e)}remove(){return this.targets().forEach((function(t){t.unclip()})),super.remove()}targets(){return pt("svg [clip-path*="+this.id()+"]")}}n({Container:{clip:q((function(){return this.defs().put(new ClipPath)}))},Element:{clipper(){return this.reference("clip-path")},clipWith(t){const e=t instanceof ClipPath?t:this.parent().clip().add(t);return this.attr("clip-path","url(#"+e.id()+")")},unclip(){return this.attr("clip-path",null)}}}),I(ClipPath,"ClipPath");class ze extends Element{constructor(t,e=t){super(E("foreignObject",t),e)}}n({Container:{foreignObject:q((function(t,e){return this.put(new ze).size(t,e)}))}}),I(ze,"ForeignObject");var Re={__proto__:null,dmove:function(t,e){return this.children().forEach(((n,i)=>{let r;try{r=n.bbox()}catch(t){return}const s=new ut(n),o=s.translate(t,e).transform(s.inverse()),h=new ot(r.x,r.y).transform(o);n.move(h.x,h.y)})),this},dx:function(t){return this.dmove(t,0)},dy:function(t){return this.dmove(0,t)},height:function(t,e=this.bbox()){return null==t?e.height:this.size(e.width,t,e)},move:function(t=0,e=0,n=this.bbox()){const i=t-n.x,r=e-n.y;return this.dmove(i,r)},size:function(t,e,n=this.bbox()){const i=c(this,t,e,n),r=i.width/n.width,s=i.height/n.height;return this.children().forEach(((t,e)=>{const i=new ot(n).transform(new ut(t).inverse());t.scale(r,s,i.x,i.y)})),this},width:function(t,e=this.bbox()){return null==t?e.width:this.size(t,e.height,e)},x:function(t,e=this.bbox()){return null==t?e.x:this.move(t,e.y,e)},y:function(t,e=this.bbox()){return null==t?e.y:this.move(e.x,t,e)}};class G extends Container{constructor(t,e=t){super(E("g",t),e)}}F(G,Re),n({Container:{group:q((function(){return this.put(new G)}))}}),I(G,"G");class A extends Container{constructor(t,e=t){super(E("a",t),e)}target(t){return this.attr("target",t)}to(t){return this.attr("href",t,w)}}F(A,Re),n({Container:{link:q((function(t){return this.put(new A).to(t)}))},Element:{unlink(){const t=this.linker();if(!t)return this;const e=t.parent();if(!e)return this.remove();const n=e.index(t);return e.add(this,n),t.remove(),this},linkTo(t){let e=this.linker();return e||(e=new A,this.wrap(e)),"function"==typeof t?t.call(e,e):e.to(t),this},linker(){const t=this.parent();return t&&"a"===t.node.nodeName.toLowerCase()?t:null}}}),I(A,"A");class Mask extends Container{constructor(t,e=t){super(E("mask",t),e)}remove(){return this.targets().forEach((function(t){t.unmask()})),super.remove()}targets(){return pt("svg [mask*="+this.id()+"]")}}n({Container:{mask:q((function(){return this.defs().put(new Mask)}))},Element:{masker(){return this.reference("mask")},maskWith(t){const e=t instanceof Mask?t:this.parent().mask().add(t);return this.attr("mask","url(#"+e.id()+")")},unmask(){return this.attr("mask",null)}}}),I(Mask,"Mask");class Stop extends Element{constructor(t,e=t){super(E("stop",t),e)}update(t){return("number"==typeof t||t instanceof St)&&(t={offset:arguments[0],color:arguments[1],opacity:arguments[2]}),null!=t.opacity&&this.attr("stop-opacity",t.opacity),null!=t.color&&this.attr("stop-color",t.color),null!=t.offset&&this.attr("offset",new St(t.offset)),this}}n({Gradient:{stop:function(t,e,n){return this.put(new Stop).update(t,e,n)}}}),I(Stop,"Stop");class Style extends Element{constructor(t,e=t){super(E("style",t),e)}addText(t=""){return this.node.textContent+=t,this}font(t,e,n={}){return this.rule("@font-face",{fontFamily:t,src:e,...n})}rule(t,e){return this.addText(function(t,e){if(!t)return"";if(!e)return t;let n=t+"{";for(const t in e)n+=a(t)+":"+e[t]+";";return n+="}",n}(t,e))}}n("Dom",{style(t,e){return this.put(new Style).rule(t,e)},fontface(t,e,n){return this.put(new Style).font(t,e,n)}}),I(Style,"Style");class TextPath extends Text{constructor(t,e=t){super(E("textPath",t),e)}array(){const t=this.track();return t?t.array():null}plot(t){const e=this.track();let n=null;return e&&(n=e.plot(t)),null==t?n:this}track(){return this.reference("href")}}n({Container:{textPath:q((function(t,e){return t instanceof Text||(t=this.text(t)),t.path(e)}))},Text:{path:q((function(t,e=!0){const n=new TextPath;let i;if(t instanceof Path||(t=this.defs().path(t)),n.attr("href","#"+t,w),e)for(;i=this.node.firstChild;)n.node.appendChild(i);return this.put(n)})),textPath(){return this.findOne("textPath")}},Path:{text:q((function(t){return t instanceof Text||(t=(new Text).addTo(this.parent()).text(t)),t.path(this)})),targets(){return pt("svg textPath").filter((t=>(t.attr("href")||"").includes(this.id())))}}}),TextPath.prototype.MorphArray=fe,I(TextPath,"TextPath");class Use extends Shape{constructor(t,e=t){super(E("use",t),e)}use(t,e){return this.attr("href",(e||"")+"#"+t,w)}}n({Container:{use:q((function(t,e){return this.put(new Use).use(t,e)}))}}),I(Use,"Use");const Le=S;F([Svg,Symbol,Image,Pattern,Marker],i("viewbox")),F([Line,Polyline,Polygon,Path],i("marker")),F(Text,i("Text")),F(Path,i("Path")),F(Defs,i("Defs")),F([Text,Tspan],i("Tspan")),F([Rect,Ellipse,Gradient,Te],i("radius")),F(Ot,i("EventTarget")),F(Dom,i("Dom")),F(Element,i("Element")),F(Shape,i("Shape")),F([Container,Yt],i("Container")),F(Gradient,i("Gradient")),F(Te,i("Runner")),dt.extend([...new Set(e)]),xe([St,st,ct,ut,Nt,$t,fe,ot]),be();var Pe={__proto__:null,Morphable:me,registerMorphableType:xe,makeMorphable:be,TransformBag:ye,ObjectBag:_e,NonMorphable:pe,defaults:Tt,utils:d,namespaces:g,regex:et,SVG:Le,parser:at,find:pt,getWindow:function(){return x.window},registerWindow:b,restoreWindow:O,saveWindow:M,withWindow:function(t,e){M(),b(t,t.document),e(t,t.document),O()},Animator:Oe,Controller:Kt,Ease:Zt,PID:ne,Spring:ee,easing:Qt,Queue:Me,Runner:Te,Timeline:Ce,Array:Nt,Box:ct,Color:st,EventTarget:Ot,Matrix:ut,Number:St,PathArray:fe,Point:ot,PointArray:$t,List:dt,Circle:Circle,ClipPath:ClipPath,Container:Container,Defs:Defs,Dom:Dom,Element:Element,Ellipse:Ellipse,ForeignObject:ze,Fragment:Yt,Gradient:Gradient,G:G,A:A,Image:Image,Line:Line,Marker:Marker,Mask:Mask,Path:Path,Pattern:Pattern,Polygon:Polygon,Polyline:Polyline,Rect:Rect,Shape:Shape,Stop:Stop,Style:Style,Svg:Svg,Symbol:Symbol,Text:Text,TextPath:TextPath,Tspan:Tspan,Use:Use,windowEvents:wt,getEvents:_t,getEventTarget:gt,clearEvents:xt,on:bt,off:vt,dispatch:Mt,root:T,create:N,makeInstance:S,nodeOrNew:E,adopt:j,mockAdopt:function(t=j){D=t},register:I,getClass:z,eid:L,assignNewId:P,extend:F,wrapWithAttrCheck:q};function Fe(t,e){return S(t,e)}return Object.assign(Fe,Pe),Fe}();

/*! svg.pathmorphing.js v0.1.3 MIT*/
;!function(){"use strict";function t(t,r,n,i,o,h,c){for(var l=t.slice(r,n||c),p=i.slice(o,h||c),y=0,x={pos:[0,0],start:[0,0]},f={pos:[0,0],start:[0,0]};;){if(l[y]=s.call(x,l[y]),p[y]=s.call(f,p[y]),l[y][0]!=p[y][0]||"M"==l[y][0]||"A"==l[y][0]&&(l[y][4]!=p[y][4]||l[y][5]!=p[y][5])?(Array.prototype.splice.apply(l,[y,1].concat(a.call(x,l[y]))),Array.prototype.splice.apply(p,[y,1].concat(a.call(f,p[y])))):(l[y]=e.call(x,l[y]),p[y]=e.call(f,p[y])),++y==l.length&&y==p.length)break;y==l.length&&l.push(["C",x.pos[0],x.pos[1],x.pos[0],x.pos[1],x.pos[0],x.pos[1]]),y==p.length&&p.push(["C",f.pos[0],f.pos[1],f.pos[0],f.pos[1],f.pos[0],f.pos[1]])}return{start:l,dest:p}}function s(t){switch(t[0]){case"z":case"Z":t[0]="L",t[1]=this.start[0],t[2]=this.start[1];break;case"H":t[0]="L",t[2]=this.pos[1];break;case"V":t[0]="L",t[2]=t[1],t[1]=this.pos[0];break;case"T":t[0]="Q",t[3]=t[1],t[4]=t[2],t[1]=this.reflection[1],t[2]=this.reflection[0];break;case"S":t[0]="C",t[6]=t[4],t[5]=t[3],t[4]=t[2],t[3]=t[1],t[2]=this.reflection[1],t[1]=this.reflection[0]}return t}function e(t){var s=t.length;return this.pos=[t[s-2],t[s-1]],-1!="SCQT".indexOf(t[0])&&(this.reflection=[2*this.pos[0]-t[s-4],2*this.pos[1]-t[s-3]]),t}function a(t){var s=[t];switch(t[0]){case"M":return this.pos=this.start=[t[1],t[2]],s;case"L":t[5]=t[3]=t[1],t[6]=t[4]=t[2],t[1]=this.pos[0],t[2]=this.pos[1];break;case"Q":t[6]=t[4],t[5]=t[3],t[4]=1*t[4]/3+2*t[2]/3,t[3]=1*t[3]/3+2*t[1]/3,t[2]=1*this.pos[1]/3+2*t[2]/3,t[1]=1*this.pos[0]/3+2*t[1]/3;break;case"A":s=n(this.pos,t),t=s[0]}return t[0]="C",this.pos=[t[5],t[6]],this.reflection=[2*t[5]-t[3],2*t[6]-t[4]],s}function r(t,s){if(!1===s)return!1;for(var e=s,a=t.length;e<a;++e)if("M"==t[e][0])return e;return!1}function n(t,s){var e,a,r,n,i,o,h,c,l,p,y,x,f,u,M,w,S,V,G,g,P,b,d,v,k,A,m=Math.abs(s[1]),C=Math.abs(s[2]),q=s[3]%360,L=s[4],I=s[5],Q=s[6],T=s[7],z=new SVG.Point(t),H=new SVG.Point(Q,T),O=[];if(0===m||0===C||z.x===H.x&&z.y===H.y)return[["C",z.x,z.y,H.x,H.y,H.x,H.y]];for(e=new SVG.Point((z.x-H.x)/2,(z.y-H.y)/2).transform((new SVG.Matrix).rotate(q)),a=e.x*e.x/(m*m)+e.y*e.y/(C*C),a>1&&(a=Math.sqrt(a),m*=a,C*=a),r=(new SVG.Matrix).rotate(q).scale(1/m,1/C).rotate(-q),z=z.transform(r),H=H.transform(r),n=[H.x-z.x,H.y-z.y],o=n[0]*n[0]+n[1]*n[1],i=Math.sqrt(o),n[0]/=i,n[1]/=i,h=o<4?Math.sqrt(1-o/4):0,L===I&&(h*=-1),c=new SVG.Point((H.x+z.x)/2+h*-n[1],(H.y+z.y)/2+h*n[0]),l=new SVG.Point(z.x-c.x,z.y-c.y),p=new SVG.Point(H.x-c.x,H.y-c.y),y=Math.acos(l.x/Math.sqrt(l.x*l.x+l.y*l.y)),l.y<0&&(y*=-1),x=Math.acos(p.x/Math.sqrt(p.x*p.x+p.y*p.y)),p.y<0&&(x*=-1),I&&y>x&&(x+=2*Math.PI),!I&&y<x&&(x-=2*Math.PI),u=Math.ceil(2*Math.abs(y-x)/Math.PI),w=[],S=y,f=(x-y)/u,M=4*Math.tan(f/4)/3,P=0;P<=u;P++)G=Math.cos(S),V=Math.sin(S),g=new SVG.Point(c.x+G,c.y+V),w[P]=[new SVG.Point(g.x+M*V,g.y-M*G),g,new SVG.Point(g.x-M*V,g.y+M*G)],S+=f;for(w[0][0]=w[0][1].clone(),w[w.length-1][2]=w[w.length-1][1].clone(),r=(new SVG.Matrix).rotate(q).scale(m,C).rotate(-q),P=0,b=w.length;P<b;P++)w[P][0]=w[P][0].transform(r),w[P][1]=w[P][1].transform(r),w[P][2]=w[P][2].transform(r);for(P=1,b=w.length;P<b;P++)g=w[P-1][2],d=g.x,v=g.y,g=w[P][0],k=g.x,A=g.y,g=w[P][1],Q=g.x,T=g.y,O.push(["C",d,v,k,A,Q,T]);return O}SVG.extend(SVG.PathArray,{morph:function(s){for(var e=this.value,a=this.parse(s),n=0,i=0,o=!1,h=!1;;){if(!1===n&&!1===i)break;if(o=r(e,!1!==n&&n+1),h=r(a,!1!==i&&i+1),!1===n){var c=new SVG.PathArray(l.start).bbox();n=0==c.height||0==c.width?e.push(e[0])-1:e.push(["M",c.x+c.width/2,c.y+c.height/2])-1}if(!1===i){var c=new SVG.PathArray(l.dest).bbox();i=0==c.height||0==c.width?a.push(a[0])-1:a.push(["M",c.x+c.width/2,c.y+c.height/2])-1}var l=t(e,n,o,a,i,h);e=e.slice(0,n).concat(l.start,!1===o?[]:e.slice(o)),a=a.slice(0,i).concat(l.dest,!1===h?[]:a.slice(h)),n=!1!==o&&n+l.start.length,i=!1!==h&&i+l.dest.length}return this.value=e,this.destination=new SVG.PathArray,this.destination.value=a,this}})}();

/*! svg.easing.js - v2.0.0 - 2016-04-25 */
!function(){var a={quadIn:function(a){return Math.pow(a,2)},quadOut:function(a){return-(Math.pow(a-1,2)-1)},quadInOut:function(a){return(a/=.5)<1?.5*Math.pow(a,2):-.5*((a-=2)*a-2)},cubicIn:function(a){return Math.pow(a,3)},cubicOut:function(a){return Math.pow(a-1,3)+1},cubicInOut:function(a){return(a/=.5)<1?.5*Math.pow(a,3):.5*(Math.pow(a-2,3)+2)},quartIn:function(a){return Math.pow(a,4)},quartOut:function(a){return-(Math.pow(a-1,4)-1)},quartInOut:function(a){return(a/=.5)<1?.5*Math.pow(a,4):-.5*((a-=2)*Math.pow(a,3)-2)},quintIn:function(a){return Math.pow(a,5)},quintOut:function(a){return Math.pow(a-1,5)+1},quintInOut:function(a){return(a/=.5)<1?.5*Math.pow(a,5):.5*(Math.pow(a-2,5)+2)},sineIn:function(a){return-Math.cos(a*(Math.PI/2))+1},sineOut:function(a){return Math.sin(a*(Math.PI/2))},sineInOut:function(a){return-.5*(Math.cos(Math.PI*a)-1)},expoIn:function(a){return 0==a?0:Math.pow(2,10*(a-1))},expoOut:function(a){return 1==a?1:-Math.pow(2,-10*a)+1},expoInOut:function(a){return 0==a?0:1==a?1:(a/=.5)<1?.5*Math.pow(2,10*(a-1)):.5*(-Math.pow(2,-10*--a)+2)},circIn:function(a){return-(Math.sqrt(1-a*a)-1)},circOut:function(a){return Math.sqrt(1-Math.pow(a-1,2))},circInOut:function(a){return(a/=.5)<1?-.5*(Math.sqrt(1-a*a)-1):.5*(Math.sqrt(1-(a-=2)*a)+1)},backIn:function(a){var b=1.70158;return a*a*((b+1)*a-b)},backOut:function(a){a-=1;var b=1.70158;return a*a*((b+1)*a+b)+1},backInOut:function(a){var b=1.70158;return(a/=.5)<1?.5*a*a*(((b*=1.525)+1)*a-b):.5*((a-=2)*a*(((b*=1.525)+1)*a+b)+2)},swingFromTo:function(a){var b=1.70158;return(a/=.5)<1?.5*a*a*(((b*=1.525)+1)*a-b):.5*((a-=2)*a*(((b*=1.525)+1)*a+b)+2)},swingFrom:function(a){var b=1.70158;return a*a*((b+1)*a-b)},swingTo:function(a){var b=1.70158;return(a-=1)*a*((b+1)*a+b)+1},bounce:function(a){var b,c=7.5625,d=2.75;return 1/d>a?b=c*a*a:2/d>a?(a-=1.5/d,b=c*a*a+.75):2.5/d>a?(a-=2.25/d,b=c*a*a+.9375):(a-=2.625/d,b=c*a*a+.984375),b},bounceOut:function(a){return 1/2.75>a?7.5625*a*a:2/2.75>a?7.5625*(a-=1.5/2.75)*a+.75:2.5/2.75>a?7.5625*(a-=2.25/2.75)*a+.9375:7.5625*(a-=2.625/2.75)*a+.984375},elastic:function(a){return a==!!a?a:Math.pow(2,-10*a)*Math.sin(2*(a-.075)*Math.PI/.3)+1}};for(key in a)SVG.easing[key]=a[key]}();