<?php


/**
 * Remove VC Default Templates
 *
 * @return    array
 *
 * @access    private
 * @since     4.0
 *
 */
 
function _ut_remove_default_vc_templates( $data ) {
    
    $data = array();
            
    return $data;
    
}

add_filter( 'vc_load_default_templates', '_ut_remove_default_vc_templates', 10 ); 


/**
 * Theme Default Templates
 *
 * @return    array
 *
 * @access    private
 * @since     4.0
 *
 */
 
function ut_vc_templates() {
        
    $templates = array(
        
        /* Demo 1 - Classic */
        array(
            'name'      => esc_html__( 'Demo 01 - Classic', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section bklyn_section_anchor_id="About" el_name="About Section"][vc_row][vc_column][ut_header style="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="ABOUT BROOKLYN"]We are a creative agency located in <b>Brooklyn, New York.</b><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12"][ut_service_column size="medium" link_font_weight="" delay="true" headline="Planning & Strategy" effect="fadeIn" delay_timer="50" imageicon="1835"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12"][ut_service_column size="medium" link_font_weight="" delay="true" headline="Branding & Design" effect="fadeIn" delay_timer="100" imageicon="1837"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12"][ut_service_column size="medium" link_font_weight="" delay="true" headline="Web Design & Development" effect="fadeIn" delay_timer="150" imageicon="1844"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1569976712302{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/original/wp-content/uploads/2019/10/3.jpg?id=1920) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0, 0, 0, 0.7)"][vc_column][ut_parallax_quote quote_linebreak_tablet="on" quote_linebreak_mobile="on" cite_custom_border="yes" quote_font_source="google" quote_google_fonts="font_family:Raleway%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:700%20bold%20italic%3A700%3Aitalic" quote_font_size="30" quote_letter_spacing="-0.01" quote_ins_font_weight="" cite_font_source="google" cite_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" cite_font_size="12" cite_letter_spacing="0.05" cite_font_weight="" revealfx="on" cite="UNITED THEMES – THEME DEVELOPMENT BROOKLYN" quote_color="#ffffff" cite_color="rgba(255,255,255,0.7)" quote_ins_color="#ffbf00" cite_border_color="rgba(255,255,255,0.1)"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE,<br />
PERFORMANCE LEADS TO <ins>SUCCESS!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" el_name="Team Section"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="ALL-STAR TEAM"]A quickly evolving interactive studio for everything that\'s next with<br />
focus on digital design, <b>marketing and branding.</b>[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="50" animation_duration="2s"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="500" icon_size="18" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="1918" name="Walther White" occupation="FOUNDER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.7)" overlay_color="rgba(0,0,0,0.65)"][/vc_column][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="100" animation_duration="2s"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="500" icon_size="18" social="%5B%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="1919" overlay_color="rgba(0,0,0,0.65)" name="Jamie Brown" occupation="DESIGNER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.7)"][/vc_column][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="150" animation_duration="2s"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="500" icon_size="18" social="%5B%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-steam-square%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="1920" overlay_color="rgba(0,0,0,0.65)" name="Mike Ehrmantraut" occupation="DEVELOPER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.7)"][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1569976721342{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/original/wp-content/uploads/2019/10/2.jpg?id=1919) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0, 0, 0, 0.7)" el_name="Team Achievements"][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="TEAM ACHIEVEMENTS" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.9)"]Find out what makes us an interactive studio you can trust.<br />
<b>We offer individual solutions for different areas.</b>[/ut_header][vc_row_inner equal_height="yes" content_placement="top" gap="40" css=".vc_custom_1569928758485{margin-top: 60px !important;}"][vc_column_inner width="1/4" delay="true" css=".vc_custom_1569938766207{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;}" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="50"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="500" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" counter_font_size="40" to="33800" counter_color="#ffffff" desccolor="#ffbf00" suffix="+"]Brooklyn Users Worldwide[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" delay="true" css=".vc_custom_1569938774598{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;}" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="100"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="500" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" counter_font_size="40" to="42" counter_color="#ffffff" desccolor="#ffbf00" suffix="+"]Professional Websites[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" delay="true" css=".vc_custom_1569938782871{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;}" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="150"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="500" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" counter_font_size="40" to="95" counter_color="#ffffff" desccolor="#ffbf00" suffix="%"]Satisfied Customers[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" delay="true" css=".vc_custom_1569938793609{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;}" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="200"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="500" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" counter_font_size="40" to="1708" counter_color="#ffffff" desccolor="#ffbf00"]5 Star Ratings[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1496877833417{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #ffbf00 !important;}"][vc_column][ut_fancy_link font_source="google" google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20italic%3A600%3Aitalic" letter_spacing="-0.01" url="#section-contact" link_color="#ffffff" line_color="#ffffff" link_hover_color="#ffffff" line_hover_color="#ffffff"]Let’s Talk About Your Project[/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" bklyn_section_anchor_id="Services" css=".vc_custom_1569976756444{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/original/wp-content/uploads/2019/10/1.jpg?id=1918) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0, 0, 0, 0.7)" el_name="Services Section"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="TOP NOTCH SERVICES" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.9)"]We provide the exceptional service we\'d want to experience ourselves!<br />
<b>Let\'s make something awesome together.</b>[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="50"][ut_service_box icon_type="bklynicons" size="medium" link_font_weight="" headline="Marketing" background="rgba(255,255,255,0.1)" headline_color="#ffbf00" text_color="rgba(255,255,255,0.8)" color="#ffffff" imageicon="1899"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="100"][ut_service_box link_font_weight="" headline="Technology" background="rgba(255,255,255,0.1)" headline_color="#ffbf00" text_color="rgba(255,255,255,0.8)" imageicon="1915" color="#ffffff"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column][vc_column width="1/3" delay="true" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-4 vc_col-xs-12" effect="fadeIn" delay_timer="150"][ut_service_box link_font_weight="" headline="Development" background="rgba(255,255,255,0.1)" headline_color="#ffbf00" text_color="rgba(255,255,255,0.8)" imageicon="1906" color="#ffffff"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Works" el_name="Works Section"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="SELECTED WORKS"]We believe our work speaks for itself. Browse our most recent projects below<br />
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_custom_shortcode css=".vc_custom_1496931407672{margin-bottom: 0px !important;}"][ut_showcase id="101" name="Demo-1-Classic-Portfolio"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center bottom" background_attachment="scroll" css=".vc_custom_1569976765141{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/original/wp-content/uploads/2019/10/2.jpg?id=1919) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0, 0, 0, 0.7)" el_name="Get Connected"][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="GET CONNECTED" title_color="#ffffff" lead_color="rgb(255, 255, 255)"]If you like a lot of chocolate on your biscuit<br />
<b>join our Social Network Club.</b>[/ut_header][vc_row_inner css=".vc_custom_1569928809177{margin-top: 80px !important;}"][vc_column_inner width="1/4" delay="true" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="50"][ut_big_icon icon_size="50" slogan_font_weight="500" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-youtube" title="Youtube" slogan="View Exclusive Videos" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="rgba(255,255,255,0.9)" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" delay="true" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="100"][ut_big_icon icon_size="50" slogan_font_weight="500" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="View Exclusive Images" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="rgba(255,255,255,0.9)" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" delay="true" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="150"][ut_big_icon icon_size="50" slogan_font_weight="500" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan="Follow us on Twitter" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="rgba(255,255,255,0.9)" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4" delay="true" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="200"][ut_big_icon icon_size="50" slogan_font_weight="500" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="rgba(255,255,255,0.9)" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Clients" el_name="Clients Section"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="HAPPY CLIENTS"]The comments below are just a sample of the <b>33.000 clients</b> worldwide<br />
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_qtrotator origin_font_weight="500" origin_letter_spacing="0.05" arrow_color="#151515" arrow_color_hover="rgba(21,21,21,0.5)" origin_color="rgba(49,49,49,0.5)"][ut_qt avatar="1918" origin="BROOKLYN CUSTOMER" author="HospitalityDef"]This is really more than a theme – it’s almost an all-in-one ecosystem to build and manage your site.[/ut_qt][ut_qt avatar="1918" origin="BROOKLYN CUSTOMER" author="Livedrone"]Perfect for dummies that want to create their first website, just like me![/ut_qt][ut_qt avatar="1918" origin="BROOKLYN CUSTOMER" author="Kaledonder"]Great looking theme that works well and comes with a lot of great options.[/ut_qt][/ut_qtrotator][/vc_column][/vc_row][vc_row css=".vc_custom_1569930002703{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #ffbf00 !important;}"][vc_column][ut_client_group autoplay="true" carousel="true"][ut_client logo="1918"][ut_client logo="1918"][ut_client logo="1918"][ut_client logo="1918"][ut_client logo="1918"][ut_client logo="1918"][ut_client logo="1918"][/ut_client_group][/vc_column][/vc_row][/vc_section]</p>',

        ),
        array(
            'name'      => esc_html__( 'Demo 1 - Footer (Content Block)', 'ut_shortcodes' ),
            'content' => '[vc_section css=".vc_custom_1570141988515{border-top-width: 10px !important;background-color: #151515 !important;border-top-color: #e9e9e9 !important;border-top-style: solid !important;}" el_id="contact-section"][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header style="pt-style-2" align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" delay="true" title="LET\'S WORK TOGETHER" effect="fadeIn" delay_timer="0" delay_timer_lead="200" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.5)" accent="#ffbf00"]Brooklyn, a truly multipurpose parallax
WordPress theme with more than one face.[/ut_header][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" delay="true" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="400"][ut_custom_heading tag="h3" line_height="100" color="#ffffff" css=".vc_custom_1570141293750{margin-bottom: 5px !important;}"]Studio Brooklyn[/ut_custom_heading][ut_custom_heading tag="p" line_height="150" color="rgba(255, 255, 255, 0.33)"]1404 New York Ave
Brooklyn, NY 11210
USA[/ut_custom_heading][ut_custom_heading tag="p" font_size="12" line_height="125" font_weight="600" link="url:mailto%3Abrooklyn%40wp-brooklyn.com|||" color="rgba(255, 255, 255, 0.7)" hover_color="#ffffff" css=".vc_custom_1570140961982{margin-bottom: 10px !important;}"]brooklyn@wp-brooklyn.com[/ut_custom_heading][ut_custom_heading tag="p" font_size="18" line_height="100" color="rgba(255, 255, 255, 0.5)"]+49 555 123 456[/ut_custom_heading][/vc_column_inner][vc_column_inner width="1/2" delay="true" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12" effect="fadeIn" delay_timer="600"][ut_custom_heading tag="h3" line_height="100" color="#ffffff" css=".vc_custom_1570141300662{margin-bottom: 5px !important;}"]Studio Berlin[/ut_custom_heading][ut_custom_heading tag="p" line_height="150" color="rgba(255, 255, 255, 0.33)"]Musterstr. 44
54123 Berlin
GER[/ut_custom_heading][ut_custom_heading tag="p" font_size="12" line_height="125" font_weight="600" link="url:mailto%3Aberlin%40wp-brooklyn.com|||" color="rgba(255, 255, 255, 0.7)" hover_color="#ffffff" css=".vc_custom_1570140959102{margin-bottom: 10px !important;}"]berlin@wp-brooklyn.com[/ut_custom_heading][ut_custom_heading tag="p" font_size="18" line_height="100" color="rgba(255, 255, 255, 0.5)"]+49 555 123 457[/ut_custom_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" delay="true" el_name="Social Follow Module / Margin bottom 0" effect="fadeIn" delay_timer="800"][vc_column width="1/2"][ut_custom_heading tag="h3" css=".vc_custom_1569624943014{margin-bottom: 0px !important;}" color="#ffffff"]brooklyn.[/ut_custom_heading][ut_custom_heading tag="div" font_size="12" color="rgba(255, 255, 255, 0.33)"]© 2011 – 2019 UNITED THEMES™[/ut_custom_heading][/vc_column][vc_column width="1/2"][ut_social_follow gap="40 Pixel" animate="true" size="18" socials="%5B%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="rgba(255,255,255,0.33)" css=".vc_custom_1569624914082{margin-bottom: 0px !important;}" icon_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]'
        ),
        /* Demo 2 - Extended */
        array(
            'name'      => esc_html__( 'Demo 02 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" bklyn_section_anchor="true" css=".vc_custom_1477932937851{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 0px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="About Brooklyn"][vc_column css=".vc_custom_1477390682192{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1477586581339{padding-top: 0px !important;}"][vc_column_inner css=".vc_custom_1477586586610{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="About Brooklyn" css=".vc_custom_1477949410043{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]We are a creative agency located in <ins>Brooklyn, New York.</ins>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInLeft" delay_timer="200"][ut_service_column shape="round" align="right" headline="APP DEVELOPMENT" icon="fa fa-cloud" color="#ffffff" background="#ff6e00" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInRight" delay_timer="200"][ut_service_column shape="round" headline="UI DESIGN" icon="fa fa-th-large" color="#ffffff" background="#151515" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477921839851{margin-top: 20px !important;}"][vc_column_inner effect="none"][ut_animated_image size="full" align="center" animate_once="yes" css=".vc_custom_1477976848241{margin-bottom: 0px !important;}" effect="zoomIn"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477930732853{margin-top: 120px !important;padding-top: 60px !important;padding-bottom: 60px !important;background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477932362431{padding-top: 0px !important;}"][ut_fancy_link link_color="#e5e5e5" line_color="#666666" url="#contact-section" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" parallax="content-moving" parallax_image="4825" parallax_speed_bg="2.5" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" css=".vc_custom_1477971766656{padding-top: 200px !important;padding-bottom: 200px !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477932895246{padding-top: 0px !important;}"][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes – Theme Development Brooklyn" cite_color="#ffffff" icon="fa fa-quote-left" icon_color="#ffffff" quote_ins_color="#ff6e00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE, PERFORMANCE LEADS TO <ins>SUCCESS</ins>![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477658545595{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="Our Service"][vc_column css=".vc_custom_1477484140481{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415810648{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="Our Services" css=".vc_custom_1477949990979{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <ins>know-how</ins> and <ins>experience</ins> in your <ins>daily business</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" effect="zoomIn"][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column headline="RETINA READY &amp; RESPONSIVE" icon="fa fa-tablet" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="ONE CLICK DEMO INSTALLER" icon="fa fa-download" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="DRAG &amp; DROP PAGE BUILDER" icon="fa fa-object-ungroup" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_section_anchor="true" css=".vc_custom_1477661373779{padding-top: 120px !important;padding-bottom: 0px !important;background-color: #080808 !important;}" bklyn_section_anchor_id="Our Work"][vc_column css=".vc_custom_1477484344871{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415836145{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="OUr Work" css=".vc_custom_1477951558952{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <ins>handmade work</ins> with love for every detail.[/ut_header][ut_custom_shortcode css=".vc_custom_1477491082574{margin-bottom: 0px !important;}"][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477922623762{background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477922635866{padding-top: 0px !important;}"][ut_image_gallery thumbnail_size="full" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818,4820,4819" effect="zoomIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477960456411{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="Clients"][vc_column css=".vc_custom_1477491736456{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="The Clients" css=".vc_custom_1477951778426{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]The comments below are just a sample of the <ins>22.500 clients</ins> worldwide
who transformed their business website with Brooklyn.[/ut_header][ut_qtrotator_2 quote_custom_font="yes" origin_font_weight="normal" name_color="#e5e5e5" origin_color="#ff6e00" quote_color="#666666" arrow_color="#ffffff" arrow_color_hover="#ff6e00" arrow_background_color="#080808" arrow_background_color_hover="#080808" quote_font="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="17px" quote_line_height="27px"][ut_qt_2 author="RON SCHMIDT" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4798"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.

Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 author="JOHN AREUS" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4799"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 author="HENRIK SCHWARZ" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4800"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477663286597{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #080808 !important;}" bklyn_section_anchor_id="Team"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477586544362{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="The Crew" css=".vc_custom_1477951911579{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]We believe in a diverse range of personel to bring <ins>creative skills</ins>,
<ins>thoughts</ins>, and <ins>ideas</ins> to the table.
[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MARCEL M." occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#e5e5e5" ocupation_color="#ff6e00" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-1%2F|||" line_color="#111111" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MATTHIAS N." occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff6e00" name_color="#e5e5e5" description_color="#666666" line_color="#111111" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-2%2F|||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="Andreea B." occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff6e00" name_color="#e5e5e5" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-3%2F|||" line_color="#111111" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477971787364{padding-top: 120px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477586797526{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="normal" title="WE ARE GOOD AT" css=".vc_custom_1477952286209{margin-bottom: 60px !important;}" lead_accent_color="#ff6e00" lead_color="#e5e5e5" title_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a <ins>better web experience</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="95" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="Web Design" info_color="#e5e5e5" color="#ff6e00" background_color="#81d742" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="98" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="HTML / CSS" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="96" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="WORDPRESS DEVELOPMENT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="99" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="LOGO DESIGN" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="97" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="PHP DEVELOPMENT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="100" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="CUSTOMER SUPPORT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477499086415{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #090909 !important;}"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="normal" title="Get Brooklyn Now" css=".vc_custom_1477952895803{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]Get yourself ready for an <ins>awesome experience</ins> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner effect="none"][vc_column_inner effect="none"][vc_icon icon_fontawesome="fa fa-download" color="custom" size="xl" align="center" custom_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_weight="900" text_transform="uppercase" button_text="Buy Now" button_text_color="#000000" button_background="#ffffff" button_text_color_hover="#ffffff" button_background_hover="#ff6e00"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933051608{margin-bottom: 10px !important;}"][ut_header align="left" title="Street View" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Porsche Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818,4819"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" animate_once="yes" css=".vc_custom_1477934139431{padding-right: 30px !important;padding-left: 30px !important;}" effect="fadeIn"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933233245{margin-bottom: 10px !important;}"][ut_header align="left" title="Running is a way of life" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Running for Kids" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_gallery_slider autoplay="true" loop="true" effect_in="fadeIn" effect_out="fadeOut" slides="4817,4816,4818,4819" arrow_color="#252525" arrow_color_hover="#ff6e00" dot_color="#252525" dot_color_hover="#ff6e00"][/vc_column][/vc_row]',

        ),

        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="top" css=".vc_custom_1477934526560{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477926125194{margin-bottom: 10px !important;}"][ut_header align="left" title="Winter Time" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn in Winter" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_animated_image size="full" link_type="image" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477933557094{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1477675051837{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477934630458{margin-bottom: 10px !important;}"][ut_header align="left" lead_accent_font_weight="bold" title="Wake up and smell the coffee" title_color="#252525" lead_accent_color="#252525"]Flexibility starts with a colour! Our integrated colour picker lets you choose your desired one for several different elements to give your <ins>Brooklyn</ins> powered website and individual touch!

The art and technique of arranging type in order to make language visible. With our build in Font Manager you can give your website the final touch.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Wake Up" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="I like Coffee" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477975104137{margin-bottom: 120px !important;padding-top: 200px !important;padding-bottom: 200px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.3)"][vc_column][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" icon="fa fa-quote-left" icon_color="#ffffff" quote_color="#ffffff" cite="Somebody" cite_color="#ffffff"]MORNING HAS BROKEN
AND THE COFFEE HAS SPOKEN[/ut_parallax_quote][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1477934909720{padding-top: 0px !important;}"][vc_custom_heading text="Start each day with a cup of positivity" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477934914183{padding-top: 0px !important;}"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477916391920{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935014472{margin-bottom: 10px !important;}"][ut_header align="left" title="HAPPINESS IS SUN, SAND AND A DRINK IN MY HAND" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2" css=".vc_custom_1477935191889{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477916398261{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935232537{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Take a silly selfie with your friends" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477935236742{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Salt in the air and sand in our hair" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column css=".vc_custom_1477935263955{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935030368{margin-bottom: 10px !important;}"][ut_header align="center" title="Each Demo looks different and can be imported in seconds!" title_color="#252525" css=".vc_custom_1477935035668{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" css=".vc_custom_1477994508471{margin-bottom: 60px !important;}" effect="fadeIn"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How we build this APP" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22App%20Development%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477925906808{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935336020{margin-bottom: 10px !important;}"][ut_header align="left" title="SENNHEISER HD 598" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="OVERVIEW" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Characteristics" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Sennheiser%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818"][ut_media_slider slides="%5B%7B%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F76850650%22%2C%22poster%22%3A%224825%22%7D%5D"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935419748{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need " title_color="#252525" css=".vc_custom_1477935468275{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1477505777253{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663877638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935429458{margin-bottom: 10px !important;}"][ut_header align="left" title="Endless Possibilities" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag & Drop or use shortcodes. It’s up to you!
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1477976012124{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663884237{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935605405{margin-bottom: 10px !important;}"][ut_header align="left" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours & Styles within minutes.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1477976022692{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935536739{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You" title_color="#252525" css=".vc_custom_1477935532710{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How We Work" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2026%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border="true" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_media_slider dots="false" slides="%5B%7B%22title%22%3A%22Slide%201%22%2C%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F10089801%22%2C%22poster%22%3A%224825%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477662215938{margin-bottom: 10px !important;}"][ut_header align="left" title="Hello Brooklyn" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Team Single 1', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Marcel M." title_color="#252525"]Hello, Im Marcel Designer at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="MARCEL M." occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Project Management" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="97" animate_once="yes" info_font_weight="" info="Web Design" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477939841961{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_custom_heading text="my recent work" font_container="tag:h3|text_align:center|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][ut_custom_shortcode css=".vc_custom_1477939724912{margin-bottom: 0px !important;}"][ut_showcase id="4642"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477939326326{margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 2 - Team Single 2', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Matthias N." title_color="#252525"]Hello, Im Matthias Coder at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Matthias N." occupation="Coder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477930077660{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Team Single 3', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Andreea B." title_color="#252525"]Hello, Im Andreea Support Guru at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Andreea B." occupation="Support Guru" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477947493614{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #ff6e00 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        
        /* Demo 3 */
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 1', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Across </b> all Devices" color="#ffffff" background="#00aeef" imageicon="263" effect="zoomIn" delay_timer="100"]Duo ei ornatus disputando. His ei eros deserunt.[/ut_service_column_vertical][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Ultra</b> Responsive Layout" color="#ffffff" background="#ffa2ad" imageicon="324" effect="zoomIn" delay_timer="200"]Qui deleniti dissentiet complectitur ad. Sit eros habeo.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Ready</b> for all Browsers" background="#fecf39" color="#ffffff" imageicon="343" effect="zoomIn" delay_timer="150"]Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column_vertical][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Timeless</b> Unique Design" color="#ffffff" background="#8781bd" imageicon="348" effect="zoomIn" delay_timer="250"]Ex nonumy aperiri sea, has at augue postea.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_video_player video_shadow="on" icon_type="" url="https://vimeo.com/155900013" caption="SPIKE DDB BROOKLYN MADE" poster="32" play_bg_color="#0267c1"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387481789{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="496"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="505"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387519865{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387530000{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="<b>Creating</b> ideas and building
brands that truly matter to people.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" animate_once="yes" image="1285" css=".vc_custom_1497864408798{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387539640{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best friend.
Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Cean Design" color="#00aeef" effect="fadeInUp" delay_timer="50" imageicon="496"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Ultra</b> Responsive Design " color="#ffa2ad" effect="fadeInUp" delay_timer="50" imageicon="502"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Easy</b> to Customize" color="#fecf39" effect="fadeInUp" delay_timer="50" imageicon="500"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeInUp" delay_timer="50" imageicon="505"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>115+</b> Page Templates" color="#8781bd" effect="fadeInUp" delay_timer="100" imageicon="577"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>One Click</b> Installation" color="#ffa2ad" effect="fadeInUp" delay_timer="100" imageicon="584"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>70+</b> Theme Updates" color="#fecf39" effect="fadeInUp" delay_timer="100" imageicon="581"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Power Elite</b> Support" color="#00aeef" effect="fadeInUp" delay_timer="100" imageicon="575"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_qtrotator_2 arrow_color="#393c3e" arrow_color_hover="#71787e" name_color="#393c3e" quote_color="#71787e" origin_color="#393c3e"][ut_qt_2 avatar="186" author="EmCarkh" origin="Brooklyn Customer" imageicon="563"]â€œGenuinely love this theme. So sick of trawling through endless menus and options on other themes. Brooklyn is so intuitive with where all its settings are located and is just a pleasure to use. Also, the sheer number of demos and ability to mix elements from different demos means it works well for so many purposes.â€[/ut_qt_2][ut_qt_2 avatar="187" author="CMPhoto" origin="Brooklyn Customer" imageicon="565"]â€œGreat theme with great flexibility. A lot of ready-to-go demos which can be installed with a single click. Really great support if needed. With most updates, there is a new demo added to the bundle.â€[/ut_qt_2][ut_qt_2 avatar="188" author="CodeBound" origin="Brooklyn Customer" imageicon="560"]â€œAmazing theme â€“ just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them.â€[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498240706039{padding-top: 80px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,195,196,197,198" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row 0=""][vc_column width="1/3"][ut_service_icon_box headline="<b>Ready</b> for all Browsers" imageicon="343" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box headline="<b>Ultra</b> Responsive Layout" imageicon="324" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box headline="<b>Timeless</b> Unique Design" imageicon="348" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387481789{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387519865{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497867331748{padding-bottom: 0px !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best
friend. Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column 0=""][ut_gallery_slider type="carousel" number="4" number_tablet="4" nav="false" hover_caption="on" slides="1300,1349,1351,1350" css=".vc_custom_1497876686586{margin-bottom: 0px !important;}" hover_caption_color="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498240836016{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 3', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row 0=""][vc_column width="1/3"][vc_single_image image="1300" img_size="large"][ut_service_column headline="<b>Ready</b> for all Browsers" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][vc_column width="1/3"][vc_single_image image="1349" img_size="large"][ut_service_column headline="<b>Ultra</b> Responsive Layout" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][vc_column width="1/3"][vc_single_image image="1351" img_size="large"][ut_service_column headline="<b>Timeless</b> Unique Design" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877361169{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877305645{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877415878{background-color: #f7f8fa !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best
friend. Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877399527{border-top-width: 1px !important;border-top-color: #dddddd !important;border-top-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498241105883{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_border_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 4', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497882604910{border-bottom-width: 1px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="right" animate_once="yes" image="1456" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497883176000{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating ideas</b> and building
brands that truly matter to people."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="97" title_text_font="on" title="Creative Thinking"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="90" title_text_font="on" title="Web Design"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="82" title_text_font="on" title="HTML / CSS"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="69" title_text_font="on" title="UI Design"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497882483945{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="1458" effect="fadeIn" css=".vc_custom_1497942327124{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497883485277{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" animate_once="yes" gallery="705,707,706,708,709,710" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497950175762{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Weâ€™ll design experiences,</b>
we do not copy them."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" animate_once="yes" image="1461" css=".vc_custom_1497950034520{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1497883067054{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #393c3e !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,198,197,196,195" delay_timer="50" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498241230650{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" text_color_hover="rgba(255,255,255,0.5)"][vc_custom_heading text="Follow us" font_container="tag:h3|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1497942660135{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 5', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498042120570{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="left" title="About <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_video_player icon_type="" url="https://vimeo.com/155900013" caption="He has a vision and he\'s not afraid to share." poster="1640" play_bg_color="#0267c1"][/vc_column][vc_column width="1/2" background_position="center center" background_attachment="scroll" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" animate_once="yes" delay_animation="true" gallery="678,676,677,674,675" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498042097485{background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="left" title="What We <b>Do.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1635" img_size="large" alignment="center"][ut_service_column size="medium" headline="Getting a look into the morning meeting" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1636" img_size="large" alignment="center"][ut_service_column size="medium" headline="Attitude reflects leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1637" img_size="large" alignment="center"][ut_service_column size="medium" headline="Develop work skills and leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498124042898{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/p-10.jpg?id=1635) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="left" title="Our <b>Services.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498241598859{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Template Installer" imageicon="1338" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498241608357{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Template Builder" imageicon="1341" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498241615894{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Customize Everything" imageicon="1339" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498042689042{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="left" title="Our <b>Projects.</b>
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_showcase_shortcode showcase_id="1614" css=".vc_custom_1498045267629{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498143356175{background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="left" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498241623555{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ![/ut_single_quote][/vc_column][vc_column width="1/3" css=".vc_custom_1498241630405{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="188" title="Awesome Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]Love the whole theme and itâ€™s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/3" css=".vc_custom_1498241638257{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="187" title="Customer Suppor" author="Saraballarin" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]I purchased this theme and let me say I\'m really glad I did! The design is great, the theme is flexible and I\'m having excellent customer support. [/ut_single_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498241445418{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="left" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_align="bklyn-btn-left" button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][vc_row_inner equal_height="yes" content_placement="middle" gap="40" css=".vc_custom_1498123970255{margin-top: 40px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1498241641821{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Any Question at" imageicon="872" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241464201{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="1399 Beverley Rd" imageicon="877" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241471819{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Monday - Saturday" imageicon="348" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]8 am â€“ 8 pm[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241478968{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Send your mail at" imageicon="875" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 6', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="What We <b>Do.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1635" img_size="large" alignment="center"][ut_service_column size="medium" headline="Getting a look into the morning meeting" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12"][vc_single_image image="1636" img_size="large" alignment="center"][ut_service_column size="medium" headline="Attitude reflects leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1637" img_size="large" alignment="center"][ut_service_column size="medium" headline="Develop work skills and leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498124042898{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/p-10.jpg?id=1635) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="Our <b>Services.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" headline="Template Installer" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" icon_bklyn="BklynIcons-Rocket-Launch"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" icon_bklyn="BklynIcons-Computer-Network-2" headline="Template Builder" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" icon_bklyn="BklynIcons-Rotate-2" headline="Customize Everything" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_box][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="Our <b>Projects.</b>
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_showcase_shortcode showcase_id="1849" css=".vc_custom_1498214154072{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498220999278{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="The <b>Team.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="886" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)" description_color="rgba(255,255,255,0.8)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="887" name="Sven Grim" occupation="CTO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="888" name="Richard Cremer" occupation="CHRO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="911" name="Harald Ehrenfeld" occupation="Backend Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)" description_color="rgba(255,255,255,0.8)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="889" name="Regina Schoenen" occupation="Graphic Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="890" name="Ben Schwarz" occupation="Graphic Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242037346{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 7', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="<b>Innovation</b> needs to
be part of <b>your website.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="101" headline="Template Installer" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="343" headline="Template Builder" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="263" headline="Customize Everything" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498228556063{padding-bottom: 0px !important;background-color: #f7f8fa !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="Creative solutions and
results that grow brands."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="1838" css=".vc_custom_1498228038692{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498228521415{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will <b>make</b> you
more <b>proud</b> of your <b>business.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1784" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="1774" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1766" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1784" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="1774" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1766" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242253892{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497391360783{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Achievements of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" caption_font_weight="" to="94" suffix="%" counter_color="#0267c1" icon_bklyn="BklynIcons-Hearts-Empty" color="#393c3e"]<b>Positive</b> Feedback [/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" caption_font_weight="" to="27" counter_color="#0267c1" icon_bklyn="BklynIcons-Computer-Network-2" color="#393c3e"]<b>Demos</b> Released[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" sep="true" caption_font_weight="" to="42000" counter_color="#0267c1" icon_bklyn="BklynIcons-Navigation-1" color="#393c3e"]<b>Happy</b> Buyers[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" sep="true" caption_font_weight="" to="59" prefix="$" counter_color="#0267c1" icon_bklyn="BklynIcons-Financial-Care-2" color="#393c3e"]<b>Average Cost</b> Per Hour[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391445516{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="The History Story of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_icon_tabs][ut_icon_tab icon_source="bklynicons" label="2013" icon_bklyn="BklynIcons-Lens-1" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="wp-image-959 size-full aligncenter" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m4.png" alt="" width="955" height="720" />
<h3><strong>Brooklyn </strong>first release was end in 2013</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues. It va esser tam simplic quam Occidental in fact, it va esser Occidental.[/ut_icon_tab][ut_icon_tab icon_source="bklynicons" label="2015" icon_bklyn="BklynIcons-Office-Chair" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="aligncenter size-large wp-image-956" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m1-1160x720.png" alt="" width="1160" height="720" />
<h3><strong>Among the top 5</strong> best selling themes of all time</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues.[/ut_icon_tab][ut_icon_tab icon_source="bklynicons" label="2017" icon_bklyn="BklynIcons-Hand-cargo" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="aligncenter size-large wp-image-958" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m3-1160x720.png" alt="" width="1160" height="720" />
<h3><strong>Never ending</strong> fight against the whole marketplace</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues.[/ut_icon_tab][/ut_icon_tabs][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391456933{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header title="Transform your website with <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily. [/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_text="Start Now" button_text_color="#ffffff" button_background="#0267c1" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179%3Fref%3DUnitedThemes||target:%20_blank|"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="1285" css=".vc_custom_1497962533544{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391467213{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="The Team of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="886" name="John Brooklyn" occupation="Founder &amp; CEO" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="887" name="Sven Grim" occupation="CTO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="888" name="Richard Cremer" occupation="CHRO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498242362629{padding-bottom: 120px !important;background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="center" title="Awesome Clients using <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_client_group carousel="true" deco_line_color_top="#dddddd" deco_line_color_bottom="#dddddd" arrow_color="#ffffff" arrow_color_hover="#ffffff" arrow_border_color="#0267c1" arrow_border_color_hover="#0267c1" arrow_background="#0267c1" arrow_background_hover="#0267c1"][ut_client logo="673"][ut_client logo="674"][ut_client logo="675"][ut_client logo="676"][ut_client logo="677"][ut_client logo="678"][/ut_client_group][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Services Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497455841382{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="We keep our <b>word.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" title="We are <b>on Time</b>" imageicon="1050" css=".vc_custom_1497460611196{margin-bottom: 20px !important;}"][ut_service_column css=".vc_custom_1497460714875{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" percent="90" title="We are <b>Satisfactory</b>" imageicon="1042" css=".vc_custom_1497460422799{margin-bottom: 20px !important;}"][ut_service_column css=".vc_custom_1497460722219{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" percent="95" title="We are <b>Experienced</b>" css=".vc_custom_1497460625719{margin-bottom: 20px !important;}" imageicon="1051"][ut_service_column css=".vc_custom_1497460732038{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="Our <b>Services.</b> "]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1467781577280{margin-bottom: 40px !important;}"][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="710" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Fresh</b> &amp; Clean Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="708" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>115+</b> Page Templates"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="709" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Ultra</b> Responsive Design "]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="707" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>One Click</b> Installation"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="705" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Easy</b> to Customize"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="706" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>70+</b> Theme Updates"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242542362{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Product Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_single_image image="972" img_size="full" alignment="center"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497479046407{border-top-width: 1px !important;border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958,956,1197" delay_timer="50" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player video_shadow="on" icon_type="" url="https://vimeo.com/155900013" caption="SPIKE DDB BROOKLYN MADE" poster="32" play_bg_color="#0267c1" css=".vc_custom_1497479657429{margin-bottom: 20px !important;}"][vc_custom_heading text="We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily." font_container="tag:p|text_align:left" use_theme_fonts="yes" css=".vc_custom_1497860902896{margin-bottom: 20px !important;}"][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Free Trail Version" button_text_color="#393c3e" button_background="rgba(2,103,193,0)" button_text_color_hover="#0267c1" button_background_hover="rgba(2,103,193,0)" button_border_color_hover="#0267c1" button_border_color="#393c3e"][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Available for:" font_container="tag:div|font_size:10px|text_align:center|line_height:10px" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1497860784352{margin-bottom: 10px !important;}"][ut_social_follow align="center" gap="40 Pixel" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1498243327516{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" shadow="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e" background_color="#ffffff" border_color="#dddddd" inner_border_color="#ffffff"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="30" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#0267c1" button_background="#ffffff" price_font_color="#ffffff" image="970" button_border_color_hover="#ffffff" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#ffffff" background_color="#0267c1" headline_text_color="#ffffff" subheadline_text_color="#ffffff" period_text_color="#ffffff" feature_text_color="#ffffff" inner_border_color="#0267c1"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" shadow="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e" inner_border_color="#0267c1"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243386794{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Product Page 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497962373383{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="In a world of over 1 billion websites, <b>does your website stand out?</b>"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958,956,1197" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="We Create the World" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Available for:" font_container="tag:div|font_size:10px|text_align:center|line_height:10px" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1497860784352{margin-bottom: 10px !important;}"][ut_social_follow align="center" gap="40 Pixel" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="none" delay_timer="200"][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" icon_color_hover="#0267c1" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498243421895{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Pricing Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498243609016{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Team Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960542756{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row animate_once="yes" effect="none"][vc_column][ut_header align="center" title="The founders of <b>Brooklyn.</b>" lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497444454313{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="John Brooklyn" occupation="CEO / Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="886" css=".vc_custom_1497444649659{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="Sven Grim" occupation="CTO / Co Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="887" css=".vc_custom_1497444641563{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="Richard Cremer" occupation="CHRO / Co Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="888" css=".vc_custom_1497444782905{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497960580142{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row animate_once="yes" effect="none"][vc_column][ut_header align="center" title="The team of <b>Brooklyn.</b>" lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row animate_once="yes" effect="none"][vc_column width="1/4"][ut_team_member style="member-style-5" name="Harald Ehrenfeld" occupation="Backend Developer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0267c1" avatar="911" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Patrick Wolf" occupation="Community Manager" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="892" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Regina Schoenen" occupation="Graphic Designer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="889" css=".vc_custom_1497461560963{background-color: #ffffff !important;}" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Eva Richter" occupation="Marketing Experte" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="893" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Ben Schwarz" occupation="Graphic Designer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="890" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Sven Bauer" occupation="Account Manager" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="894" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Christine Becks" occupation="Sales Experte" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="891" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Leo Schmitz" occupation="Assistant" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="895" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243742695{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" effect="none"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Person Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960334020{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Learn more about <b>John.</b>"]Hello, I\'m John CEO &amp; founder at Brooklyn Designs.
[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/2"][ut_team_member align="left" icon_size="20" name="John Brooklyn" avatar="886" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/2"][vc_custom_heading text="John\'s Biography" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="900" info="PHP Coding" color="#0267c1" percentage_bg_color="#0267c1" info_color="#393c3e" percentage_color="#ffffff"][ut_probar_thin width="95" animate_once="yes" info_font_weight="900" info="jQuery Coding" info_color="#393c3e" color="#0267c1" percentage_color="#ffffff" percentage_bg_color="#0267c1"][ut_probar_thin width="98" animate_once="yes" info_font_weight="900" info="Plugin Development" info_color="#393c3e" color="#0267c1" percentage_color="#ffffff" percentage_bg_color="#0267c1"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243865566{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>John.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Partner Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Our Great <b>Partners.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row gap="40" css=".vc_custom_1497434998760{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435233793{background-color: #f7f8fa !important;}"][vc_single_image image="675" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435228695{background-color: #f7f8fa !important;}"][vc_single_image image="673" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435223945{background-color: #f7f8fa !important;}"][vc_single_image image="677" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435218568{background-color: #f7f8fa !important;}"][vc_single_image image="676" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435208349{background-color: #f7f8fa !important;}"][vc_single_image image="674" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435158204{margin-top: 40px !important;}"][vc_column width="1/4" css=".vc_custom_1497435214250{background-color: #f7f8fa !important;}"][vc_single_image image="678" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243964091{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Become a partner of <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Testimonials Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1497883067054{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #393c3e !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,198,197,196,195" delay_timer="50" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498244067978{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Become a customer of <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Video Tutorials Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960426290{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Hi there!</b> I am Brooklyn,
way more than just a standard theme.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 1." url="https://youtu.be/z_8ePTj5ido" poster="705"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 4." url="https://youtu.be/z_8ePTj5ido" poster="708"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 2." url="https://youtu.be/z_8ePTj5ido" poster="706"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 5." url="https://youtu.be/z_8ePTj5ido" poster="709"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 3." url="https://youtu.be/z_8ePTj5ido" poster="707"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 6." url="https://youtu.be/z_8ePTj5ido" poster="710"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498244211676{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498244312933{padding-bottom: 160px !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column width="1/2"][ut_header align="left" title="<b>Drop</b> us a line."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#393c3e" text_color="#393c3e" text_color_hover="#0267c1"][vc_custom_heading text="Follow us" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow gap="40 Pixel" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2"][contact-form-7 id="5" title="Contact Page"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - CTA Section Image BG', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - CTA Section Blue', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498241105883{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_border_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Get in Touch Section Image BG', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" css=".vc_custom_1498243386794{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Responsive Pricing Tables Section', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Ken Tomita', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Ken <b>Tomita.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Ken Tomita" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Startup Stock Photos', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Startup <b>Stock Photos.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498128561470{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_gallery_slider type="carousel" number="4" number_tablet="4" dots="true" caption="on" hover_caption="on" slides="1743,1085,1742,1739" hover_caption_color="#ffffff"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Startup Stock Photos" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Damian Dulisz', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Damian <b>Dulisz.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498128561470{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_gallery_slider type="carousel" number="2" number_tablet="2" dots="true" hover_caption="on" slides="1743,1085,1742,1739" hover_caption_color="#ffffff"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Wilfred Iven', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Wilfred <b>Iven.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498130245047{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" gallery="1774,1085,1739,1742,1743,1766" css=".vc_custom_1498203181334{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Benjamin Child', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Benjamin <b>Child.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Alesia Kazantceva', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Alesia <b>Kazantceva.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption_below="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Negative Space 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Negative <b>Space 2.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption="yes" caption_below="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Negative Space', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Negative <b>Space.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and building
<b>brands</b> that truly matter <b>to people.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption="yes" caption_below="yes" gallery="1774,1739,1743,1766,1742,1085"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Web Design"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][vc_column width="1/3"][ut_progress_circle percent="91" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Web Development"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][vc_column width="1/3"][ut_progress_circle percent="100" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Customer Support"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        /* Demo5 */
        array(
            'name'      => esc_html__( 'Demo 05 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="About"][vc_row][vc_column][ut_header title="Creative Solutions And
Results That Grow Brands"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="3350" css=".vc_custom_1499437093751{margin-bottom: 10px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1499439833942{background-color: #f9f9fa !important;}"][vc_column][ut_header title="Brooklyn Designs Are The
Gasoline To Boost Your Website"]With your purchase you will get all
the demos you can find on this page.[/ut_header][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="2/3"][rev_slider alias="about"][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column_vertical align="left" imageicon="3797" headline="Brooklyn 2017"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column_vertical][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_position="after" icon_animation="yes" link="url:%23|title:More%20Information||" icon_fontawesome="fa fa-chevron-circle-right" link_color="#222222" link_color_hover="#222222" icon_color="#0674ec" icon_color_hover="#0674ec" css=".vc_custom_1499447497957{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: #dddddd !important;border-top-style: solid !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1499467299722{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_header title_color="#ffffff" lead_color="#ffffff" title="We’ll Design Experiences,
We Do Not Copy Them"]Each completed project makes us even more hungry.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Team"][vc_row][vc_column][ut_header title="We Work For Your Success"]We believe in a diverse range of personel to bring
creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="John" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="Dwayne" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="Jeff" occupation="DEVELOPER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1499467259283{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_header title="Our Glorious Achievements" title_color="#ffffff" lead_color="#ffffff"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][vc_row_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Flying-Rocket" to="20" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Themes Released [/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Clock-1" to="40000" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Working Hours[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Mustache-1" to="42758" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Sales[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Office-Desk-2" to="14000" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Community Members[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Services"][vc_row][vc_column][ut_header title="Our Services"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="APP Development" imageicon="3800" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Web Development" imageicon="3796" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="UI Design" imageicon="3801" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="Brand &amp; Identity" imageicon="3799" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Consultancy" imageicon="3798" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Marketing" imageicon="3797" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Work" css=".vc_custom_1499448003957{background-color: #f9f9fa !important;}"][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Our Awesome Work" lead_accent_color="#151515"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="45" css=".vc_custom_1499447992640{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499447952921{padding-bottom: 160px !important;}"][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Get connected" lead_accent_color="#151515"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-facebook" title="Facebook" slogan="JOIN THE CONVERSATION" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-twitter" title="Twitter" slogan="FOLLOW US ON TWITTER" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-behance" title="Behance" slogan="SEE OUR LATEST WORK" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-instagram" title="Instagram" slogan="LATEST IMAGES" icon_hover_color="#222222"][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1499467273702{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_twitter_rotator avatar="on" tweet_font_weight="" tweet_date_font_weight="normal" count="3" tweet_text_color="#ffffff" tweet_link_color="rgba(255,255,255,0.5)" tweet_date_color="#ffffff" tweet_font_size="35px" tweet_link_color_hover="#ffffff" arrow_color_hover="#ffffff" arrow_bg_color="rgba(20,22,24,0.3)" arrow_bg_color_hover="#141618"][/vc_column][/vc_row][vc_row][vc_column][ut_header title="Let\'s Get In Touch"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][contact-form-7 id="32"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 05 - Portfolio Slide-Up Template', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Gira o Mundo" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#222222"][/vc_column][/vc_row][/vc_section]',
        ),

         /* Demo 6 */
        array(
            'name'      => esc_html__( 'Demo 06 - Front Page', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section el_name="What we do" bklyn_section_anchor_id="What we do"][vc_row][vc_column width="1/3"][ut_service_column shape="round" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#FFFFFF" background="#222222" icon="fa fa-rocket" headline="No Limitless" class="add-bottom" width="third" last="false" effect="fadeInUp"] Nemo enim ipsam voluptatem quia ptas sit aspernatur samomo enim ipsam voluptatem. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column shape="round" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#FFFFFF" background="#222222" icon="fa fa-lightbulb-o" headline="Font Awesome Icons" class="add-bottom" width="third" last="false" effect="fadeInUp"] Nemo enim ipsam voluptatem quia ptas sit aspernatur samomo enim ipsam voluptatem. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column shape="round" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#FFFFFF" background="#222222" icon="fa fa-cloud" headline="Responsive Layout" class="add-bottom" width="third" last="true" effect="fadeInUp"] Nemo enim ipsam voluptatem quia ptas sit aspernatur samomo enim ipsam voluptatem. [/ut_service_column][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" bklyn_section_anchor_id="Demo Version"][vc_column width="1/2" css=".vc_custom_1668091881770{background-image: url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo6/wp-content/uploads/2014/01/ut-placeholder.jpg?id=3792) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][vc_column width="1/2" force_padding="on" force_padding_desktop="5" css=".vc_custom_1656675849758{background-color: #f6f6f6 !important;}"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="DEMO VERSION"]We have created all these demo versions in order to show you how powerful the Brooklyn theme is. Brooklyn comes with a quick and easy one click installer. You don\'t have to deal with XML or theme options copy and paste anymore! We hope you like our demos and we are more than happy to welcome you as one of our customers!<br />
[/ut_header][ut_video_player caption_font_weight="bold" url="https://vimeo.com/43054802"][/vc_column][/vc_row][vc_row overflow_visible="true" background_position="center bottom" css=".vc_custom_1656675195482{margin-top: 0px !important;background-image: url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo6/wp-content/uploads/2013/10/philosophy-bg1.jpg?id=3369) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column background_position="center bottom"][ut_parallax_quote quote_linebreak_mobile="on" quote_ins_font_weight="" cite_font_weight="" cite="United Themes – Theme Development Brooklyn"]PASSION LEADS TO DESIGN, <b class="themecolor">DESIGN</b> LEADS TO <b class="themecolor">PERFORMANCE</b>, PERFORMANCE LEADS TO <b class="themecolor">SUCCESS</b>![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" css=".vc_custom_1657273369319{margin-top: 0px !important;}" bklyn_section_anchor_id="More than a theme"][vc_column width="1/2" force_padding="on" force_padding_desktop="5" css=".vc_custom_1656675474021{background-color: #f6f6f6 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="MORE THAN A THEME"]Brooklyn comes with a lot of features like a portfolio management plugin, shortcode plugin, pricing table plugin as well as an advanced theme options panel. After your purchase we deliver free theme support via our support forum.</p>
<p>[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_service_column size="small" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#222222" icon="fa fa-picture-o" headline="Smart Layers" class="add-bottom" width="half" last="false" effect="fadeInUp"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam. [/ut_service_column][ut_service_column size="small" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#222222" icon="fa fa-desktop" headline="Responsive Layout" width="half" last="false" effect="fadeInUp"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column size="small" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#222222" icon="fa fa-camera" headline="High Resolution" class="add-bottom" width="half" last="true" effect="fadeInUp"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][ut_service_column size="small" headline_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" headline_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_font_size="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" content_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" link_font_weight="" color="#222222" icon="fa fa-globe" headline="Translation Ready" width="half" last="true" effect="fadeInUp"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" force_padding="on" force_padding_desktop="5" css=".vc_custom_1668091898417{background-image: url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo6/wp-content/uploads/2014/01/ut-placeholder.jpg?id=3792) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][/vc_section][vc_section el_name="Team" bklyn_section_anchor_id="Team"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="CREATED BY EXPERTS"]We believe in a diverse range of talent and personality brings creative skills and ideas to the web.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member ocupation_font_weight="normal" line_width="1" social="%5B%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Gitub%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22title%22%3A%22Dribble%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-xing%22%2C%22title%22%3A%22Xing%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="Rolf" occupation="Designer" ocupation_color="#fda527" icon_color="#dddddd" icon_color_hover="#fda527" line_color="#dddddd"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member ocupation_font_weight="normal" line_width="1" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="Tom" occupation="Founder" ocupation_color="#fda527" icon_color="#dddddd" icon_color_hover="#fda527" line_color="#dddddd"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member ocupation_font_weight="normal" line_width="1" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22title%22%3A%22Dribble%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="Mike" occupation="Designer" ocupation_color="#fda527" icon_color="#dddddd" icon_color_hover="#fda527" line_color="#dddddd"][/ut_team_member][/vc_column][/vc_row][vc_row full_height="50vh" bklyn_overlay="true" bklyn_overlay_pattern="true" parallax="content-moving" css=".vc_custom_1668091938386{background-image: url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo6/wp-content/uploads/2014/01/image-placerholder-slider.jpg?id=3791) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0, 0, 0, 0.3)"][vc_column][ut_parallax_quote quote_linebreak_mobile="on" quotation_marks="no" quote_font_size="60" quote_ins_font_weight="" cite_font_weight="" revealfx="on" quote_color="#ffffff" revealfx_color="#fda527"]FOCUS DESIGN[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section el_name="Service" bklyn_section_anchor_id="Service"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="OUR SERVICE"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-desktop" headline="Responsive Layout" width="third" last="false" class="add-bottom" effect="fadeInUp"] This theme looks great on any screen size or device. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-cogs" headline="Theme Options" width="third" last="false" class="add-bottom" effect="fadeInUp"] Clearly arranged built-in options panel. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-globe" headline="Localization Support" width="third" last="true" class="add-bottom" effect="fadeInUp"] Translate the theme into the language of your choice. [/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-comments" headline="Fast &amp; Friendly Support" width="third" last="false" class="add-bottom" effect="fadeInUp"] With your purchase you get free lifetime support. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-cloud-upload" headline="Logo Upload" width="third" last="false" class="add-bottom" effect="fadeInUp"] Choose and upload your own custom logo image. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-th" headline="Columns Shortcodes" width="third" last="true" class="add-bottom" effect="fadeInUp"] Easily create multi-column layouts in your content. [/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-picture-o" headline="Section Backgrounds" width="third" last="false" class="add-bottom" effect="fadeInUp"] Set a custom background for individual project sections. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-picture-o" headline="Section Backgrounds" width="third" last="false" class="add-bottom" effect="fadeInUp"] Set a custom background for individual project sections. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column color="#FDA527" icon="fa-thumbs-o-up" headline="Browser Compatibility" width="third" last="true" class="add-bottom" effect="fadeInUp"] United Themes themes are tested in all modern browsers. [/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1657270561459{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" el_name="OUR PRICE" bklyn_section_anchor_id="Our Price"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="OUR PRICE"][/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" image="3792" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_border_color_hover="#393c3e" price_font_color="#393c3e" button_background="#fda527"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table media_type="video" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#fda527" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_text_color_hover="#393c3e" video="https://vimeo.com/22884674"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#fda527" image="3792" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#fda527" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#fda527" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" font_weight="" price_font_size="60" price_font_weight="" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#fda527" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#fda527" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section el_name="OUR WORK" bklyn_section_anchor_id="Our Work"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="OUR WORK"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column css=".vc_custom_1657269667031{margin-bottom: 0px !important;}"][ut_showcase_shortcode showcase_id="45" css=".vc_custom_1657269694564{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1657272248469{margin-top: 0px !important;background-color: #fda527 !important;}" bklyn_section_anchor_id="Testimonials"][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&desktop_large=40&desktop_small=global&tablet=global&mobile=global" line_height="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title_letter_spacing="desktop_large=global&desktop_small=global&tablet=global&mobile=global" title="TESTIMONIALS" title_color="#ffffff"][/ut_header][ut_qtrotator origin_font_weight="" name_color="#ffffff" quote_color="#ffffff" origin_color="#ffffff" arrow_color="rgba(255,255,255,0.8)" arrow_color_hover="#ffffff" arrow_background_color="rgba(0,0,0,0)" arrow_background_color_hover="rgba(0,0,0,0)"][ut_qt author="lizmyers" avatar="3793"]This is one of the best WP themes ever! FUN to implement too. Thank so much for a truely AWESOME THEME! Keep up the good work.[/ut_qt][ut_qt author="lizmyers" avatar="3793"]This is one of the best WP themes ever! FUN to implement too. Thank so much for a truely AWESOME THEME! Keep up the good work.[/ut_qt][/ut_qtrotator][/vc_column][/vc_row][/vc_section]</p>
',

        ),
        
         /* Demo 7 */
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row][vc_column][ut_header title="We\'re Brooklyn Studio"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="278" link="|||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="279"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="280"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498576913558{padding-top: 80px !important;padding-bottom: 40px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-1.jpg?id=233) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="capitalize" caption_font_weight="" to="3" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Co-Worker[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="75" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Projects Delivered[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="30" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Satisfied Clients[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="7" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"] Winning Design Awards[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="682"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="682"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="682" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498698348768{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498689468207{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Beautiful Handmade Watch Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Beautiful Handmade Watch Design"]I believe my work speaks for itself. Browse my most recent projects below
and enjoy my handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_image_gallery thumbnail_size="full" gap="40" gallery="413,414,415"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page App', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row equal_height="yes" content_placement="middle" hide_on_mobile="true"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="615" effect="fadeInUp" css=".vc_custom_1498688135225{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2"][ut_header align="left" title="We\'re Brooklyn Studio" font_size="40px"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Get in touch with us" button_link="url:%23contact-section||target:%20_blank|" button_text_color="#252525" button_background="#ffffff" button_text_color_hover="#ff3f00" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#ff3f00"][/vc_column][/vc_row][vc_row hide_on_desktop="true" hide_on_tablet="true"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="615" effect="fadeInUp"][/vc_column][vc_column width="1/2"][ut_header align="left" title="We\'re Brooklyn Studio"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Get in touch with us" button_link="url:%23contact-section||target:%20_blank|" button_text_color="#252525" button_background="#ffffff" button_text_color_hover="#ff3f00" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#ff3f00"][/vc_column][/vc_row][vc_row css=".vc_custom_1498685512018{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="588" link="|||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="589" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="590" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498698522157{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498689855594{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page Orange Style', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about" css=".vc_custom_1498690902010{background-color: #ff3f00 !important;}"][vc_row][vc_column][ut_header title="We\'re Brooklyn Studio" title_color="#ffffff" lead_color="#ffffff" font_size="50px"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="588" link="|||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="589" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="590" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498701333383{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498690660030{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Become Legend with Brooklyn', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498684861282{padding-bottom: 0px !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="570" css=".vc_custom_1498684302697{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2"][ut_header align="left" title="Become Legend
with Brooklyn"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily. [/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Download Brooklyn" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179%3Fref%3DUnitedThemes||target:%20_blank|" button_text_color="#ff3f00" button_background="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#252525"][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][vc_row css=".vc_custom_1498684036134{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="567" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="568" headline="Mobile Apps" link="url:%23|title:Learn%20More||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="569" headline="Design" link="url:%23|title:Learn%20More||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1498684454560{margin-top: 0px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="4" caption="yes" animate_once="yes" gallery="680,681,682,679" effect="zoomIn" css=".vc_custom_1498697985788{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Friends Make The World A Better Place', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Friends Make The
World A Better Place"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption="yes" caption_content="plus" caption_below="yes" gallery="682,681,680,679" caption_below_color="#252525"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Tablet Smartcover Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Tablet Smartcover Design"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Step 1" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Step 2" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption="yes" gallery="289,290,291" caption_color="#ffffff" caption_background="rgba(255,63,0,0.9)"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Step 3" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Finally" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_image_gallery thumbnail_size="full" caption_below="yes" gallery="287" caption_below_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
                
        /* Demo 8 - Extended */
        array(
            'name'      => esc_html__( 'Demo 08 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" bklyn_section_anchor="true" css=".vc_custom_1477967744445{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 0px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="About Brooklyn"][vc_column css=".vc_custom_1477390682192{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1477586581339{padding-top: 0px !important;}"][vc_column_inner css=".vc_custom_1477586586610{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="About Brooklyn" css=".vc_custom_1477970312956{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We are a creative agency located in <ins>Brooklyn, New York.</ins>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInLeft" delay_timer="200"][ut_service_column shape="round" align="right" headline="APP DEVELOPMENT" icon="fa fa-cloud" color="#ffffff" background="#0cb4ce" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInRight" delay_timer="200"][ut_service_column shape="round" headline="UI DESIGN" icon="fa fa-th-large" color="#ffffff" background="#151515" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477921839851{margin-top: 20px !important;}"][vc_column_inner effect="none"][ut_animated_image size="full" align="center" animate_once="yes" css=".vc_custom_1477999764728{margin-bottom: 0px !important;}" effect="none"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477971171664{margin-top: 0px !important;padding-top: 60px !important;padding-bottom: 60px !important;background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477932362431{padding-top: 0px !important;}"][ut_fancy_link link_color="#e5e5e5" line_color="#666666" url="#contact-section" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" parallax="content-moving" parallax_image="4879" parallax_speed_bg="2.5" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" css=".vc_custom_1477999920085{padding-top: 200px !important;padding-bottom: 200px !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477932895246{padding-top: 0px !important;}"][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes – Theme Development Brooklyn" cite_color="#ffffff" icon="fa fa-quote-left" icon_color="#ffffff" quote_ins_color="#0cb4ce"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE, PERFORMANCE LEADS TO <ins>SUCCESS</ins>![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477967893503{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #f9f9f9 !important;}" bklyn_section_anchor_id="Our Service"][vc_column css=".vc_custom_1477484140481{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415810648{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Our Services" css=".vc_custom_1477970318772{margin-bottom: 60px !important;}" lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <ins>know-how</ins> and <ins>experience</ins> in your <ins>daily business</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" effect="zoomIn"][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column headline="RETINA READY &amp; RESPONSIVE" icon="fa fa-tablet" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="ONE CLICK DEMO INSTALLER" icon="fa fa-download" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="DRAG &amp; DROP PAGE BUILDER" icon="fa fa-object-ungroup" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_section_anchor="true" css=".vc_custom_1477969135279{padding-top: 120px !important;padding-bottom: 0px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="Our Work"][vc_column css=".vc_custom_1477484344871{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415836145{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="OUr Work" css=".vc_custom_1477970325105{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <ins>handmade work</ins> with love for every detail.[/ut_header][ut_custom_shortcode css=".vc_custom_1477491082574{margin-bottom: 0px !important;}"][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477969388979{background-color: #ffffff !important;}"][vc_column_inner css=".vc_custom_1477922635866{padding-top: 0px !important;}"][ut_image_gallery thumbnail_size="full" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="4881,4879,4880,4867,4866" effect="zoomIn" css=".vc_custom_1477999799622{padding-top: 20px !important;padding-bottom: 20px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477969397873{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #f9f9f9 !important;}" bklyn_section_anchor_id="Clients"][vc_column css=".vc_custom_1477491736456{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="The Clients" css=".vc_custom_1477970331638{margin-bottom: 60px !important;}" lead_accent_color="#252525"]The comments below are just a sample of the <ins>22.500 clients</ins> worldwide
who transformed their business website with Brooklyn.[/ut_header][ut_qtrotator_2 quote_custom_font="yes" origin_font_weight="normal" name_color="#252525" origin_color="#0cb4ce" quote_color="#666666" arrow_color="#252525" arrow_color_hover="#0cb4ce" quote_font="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="17px" quote_line_height="27px"][ut_qt_2 author="RON SCHMIDT" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4798"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.

Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 author="JOHN AREUS" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4799"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 author="HENRIK SCHWARZ" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4800"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477969403164{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="Team"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477586544362{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="The Crew" css=".vc_custom_1477970335684{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We believe in a diverse range of personel to bring <ins>creative skills</ins>,
<ins>thoughts</ins>, and <ins>ideas</ins> to the table.
[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MARCEL M." occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-1%2F|||" line_color="#efefef" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MATTHIAS N." occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0cb4ce" name_color="#252525" description_color="#666666" line_color="#efefef" icon_color="#252525" icon_color_hover="#0cb4ce" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-2%2F|||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="Andreea B." occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0cb4ce" name_color="#252525" icon_color="#252525" icon_color_hover="#0cb4ce" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-3%2F|||" line_color="#efefef" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477999870917{padding-top: 120px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477586797526{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="bold" title="WE ARE GOOD AT" css=".vc_custom_1477970341131{margin-bottom: 60px !important;}" lead_accent_color="#0cb4ce" lead_color="#e5e5e5" title_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a <ins>better web experience</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="95" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="Web Design" info_color="#e5e5e5" color="#0cb4ce" background_color="#81d742" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="98" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="HTML / CSS" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="96" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="WORDPRESS DEVELOPMENT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="99" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="LOGO DESIGN" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="97" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="PHP DEVELOPMENT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="100" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="CUSTOMER SUPPORT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477969841499{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #ffffff !important;}"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Get Brooklyn Now" css=".vc_custom_1477970345989{margin-bottom: 60px !important;}" lead_accent_color="#252525"]Get yourself ready for an <ins>awesome experience</ins> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner effect="none"][vc_column_inner effect="none"][vc_icon icon_fontawesome="fa fa-download" color="custom" size="xl" align="center" custom_color="#bbbbbb"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_weight="900" text_transform="uppercase" button_text="Buy Now" button_text_color="#ffffff" button_background="#252525" button_text_color_hover="#ffffff" button_background_hover="#0cb4ce"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933051608{margin-bottom: 10px !important;}"][ut_header align="left" title="Street View" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Porsche Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4881,4879,4880,4866"][/vc_column][/vc_row]',

        ),        
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" animate_once="yes" css=".vc_custom_1477934139431{padding-right: 30px !important;padding-left: 30px !important;}" effect="fadeIn"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933233245{margin-bottom: 10px !important;}"][ut_header align="left" title="Running is a way of life" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Running for Kids" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_gallery_slider autoplay="true" loop="true" effect_in="fadeIn" effect_out="fadeOut" slides="4881,4879,4880,4866" arrow_color="#252525" arrow_color_hover="#ff6e00" dot_color="#252525" dot_color_hover="#ff6e00"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="top" css=".vc_custom_1477934526560{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477926125194{margin-bottom: 10px !important;}"][ut_header align="left" title="Winter Time" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn in Winter" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_animated_image size="full" link_type="image" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477933557094{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4879,4880"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1477675051837{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477934630458{margin-bottom: 10px !important;}"][ut_header align="left" lead_accent_font_weight="bold" title="Wake up and smell the coffee" title_color="#252525" lead_accent_color="#252525"]Flexibility starts with a colour! Our integrated colour picker lets you choose your desired one for several different elements to give your <ins>Brooklyn</ins> powered website and individual touch!

The art and technique of arranging type in order to make language visible. With our build in Font Manager you can give your website the final touch.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Wake Up" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="I like Coffee" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1478000757055{margin-bottom: 120px !important;padding-top: 200px !important;padding-bottom: 200px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.3)"][vc_column][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" icon="fa fa-quote-left" icon_color="#ffffff" quote_color="#ffffff" cite="Somebody" cite_color="#ffffff"]MORNING HAS BROKEN
AND THE COFFEE HAS SPOKEN[/ut_parallax_quote][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1477934909720{padding-top: 0px !important;}"][vc_custom_heading text="Start each day with a cup of positivity" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477934914183{padding-top: 0px !important;}"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477916391920{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935014472{margin-bottom: 10px !important;}"][ut_header align="left" title="HAPPINESS IS SUN, SAND AND A DRINK IN MY HAND" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2" css=".vc_custom_1477935191889{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477916398261{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935232537{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Take a silly selfie with your friends" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477935236742{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Salt in the air and sand in our hair" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column css=".vc_custom_1477935263955{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935030368{margin-bottom: 10px !important;}"][ut_header align="center" title="Each Demo looks different and can be imported in seconds!" title_color="#252525" css=".vc_custom_1477935035668{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" css=".vc_custom_1478000870163{margin-bottom: 60px !important;}" effect="fadeIn"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How we build this APP" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22App%20Development%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477925906808{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935336020{margin-bottom: 10px !important;}"][ut_header align="left" title="SENNHEISER HD 598" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="OVERVIEW" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Characteristics" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Sennheiser%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="4879,4880,4881"][ut_media_slider dots="false" slides="%5B%7B%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F76850650%22%2C%22poster%22%3A%224879%22%7D%5D"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935419748{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need " title_color="#252525" css=".vc_custom_1477935468275{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1477505777253{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663877638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935429458{margin-bottom: 10px !important;}"][ut_header align="left" title="Endless Possibilities" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag &amp; Drop or use shortcodes. It’s up to you!
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1478001052594{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663884237{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935605405{margin-bottom: 10px !important;}"][ut_header align="left" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours &amp; Styles within minutes.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1478001063529{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935536739{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You" title_color="#252525" css=".vc_custom_1477935532710{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How We Work" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2026%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border="true" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_media_slider dots="false" slides="%5B%7B%22title%22%3A%22Slide%201%22%2C%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F10089801%22%2C%22poster%22%3A%224879%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477662215938{margin-bottom: 10px !important;}"][ut_header align="left" title="Hello Brooklyn" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 1', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Marcel M." title_color="#252525"]Hello, Im Marcel Designer at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="MARCEL M." occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Project Management" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="97" animate_once="yes" info_font_weight="" info="Web Design" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477939841961{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_custom_heading text="my recent work" font_container="tag:h3|text_align:center|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][ut_custom_shortcode css=".vc_custom_1477939724912{margin-bottom: 0px !important;}"][ut_showcase id="4642"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477970707524{margin-bottom: 0px !important;background-color: #0cb4ce !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 2', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Matthias N." title_color="#252525"]Hello, Im Matthias Coder at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Matthias N." occupation="Coder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477930077660{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 3', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Andreea B." title_color="#252525"]Hello, Im Andreea Support Guru at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Andreea B." occupation="Support Guru" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#0cb4ce"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477970587402{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #0cb4ce !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),

		/* Demo 10 */
		array(
			'name'      => esc_html__( 'Demo 10 - Front Page', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section el_name="About" bklyn_section_anchor_id="About"][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Creative Digital Agency<br />
Since 1897"]We have created a awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1668433508208{margin-top: 0px !important;}"][vc_column width="1/3"][ut_service_icon_box color="#202c44" hovercolor="#852c48" icon="fa fa-adjust" headline="Unlimited Style Options" width="third" effect="zoomIn"] Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box color="#202c44" hovercolor="#852c48" icon="fa fa-trophy" headline="Lifetime Updates" width="third" effect="zoomIn"] Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box color="#202c44" hovercolor="#852c48" icon="fa fa-tasks" headline="Customer Support" width="third" last="true" effect="zoomIn"] Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_icon_box][/vc_column][/vc_row][vc_row full_height="50vh" bklyn_overlay="true" parallax="content-moving" background_position="center top" css=".vc_custom_1668438591950{background: #202c44 url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo10/wp-content/uploads/2022/11/section_counter.jpg?id=5012);background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(32, 44, 68, 0.5)"][vc_column width="1/4" offset="vc_col-md-3 vc_col-sm-6 vc_col-xs-6"][ut_number_counter icon_type="fontawesome" counter_prefix_font_weight="" counter_suffix_font_weight="" to="512" icon="fa fa-coffee" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Cups of Coffee[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-md-3 vc_col-sm-6 vc_col-xs-6"][ut_number_counter icon_type="fontawesome" counter_prefix_font_weight="" counter_suffix_font_weight="" to="1250" icon="fa fa-users" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Clients Worked With[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-md-3 vc_col-sm-6 vc_col-xs-6"][ut_number_counter icon_type="fontawesome" counter_prefix_font_weight="" counter_suffix_font_weight="" to="75" icon="fa fa-clock-o" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Completed Projects[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-md-3 vc_col-sm-6 vc_col-xs-6"][ut_number_counter icon_type="fontawesome" counter_prefix_font_weight="" counter_suffix_font_weight="" to="4" icon="fa fa-trophy" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Winning Awards[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section el_name="Service" bklyn_section_anchor_id="Service"][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Our Service"]We believe in a diverse range of talent and personality brings creative skills and ideas to the web.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1668433527520{margin-top: 0px !important;}"][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-cog" headline="Shortcodes" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585179587{margin-bottom: 20px !important;}"] Can make website design much easier and with our shortcode manager you can now create them even faster. Choose your desired shortcode and the manager will insert it for you.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-code" headline="Clean Code" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585183586{margin-bottom: 20px !important;}"] Brooklyn has been built with the latest submission requirements based on the WordPres Codex, everything is working as intended. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-archive" headline="Dummy Content" margin_bottom="20" width="third" effect="fadeInUp" last="true" css=".vc_custom_1656585187622{margin-bottom: 20px !important;}"] Brooklyn contains our unique One Click Demo Importer for a quick and easy setup. No need to deal with XML files![/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-columns" headline="One-Page or Multi-Page" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585202266{margin-bottom: 20px !important;}"] Brooklyn is mainly a one page theme, but you can easily turn it into a multi page WordPress theme and guess what? It only costs you $40 bucks! Updates and support included!.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-picture-o" headline="Parallax Sections" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585206148{margin-bottom: 20px !important;}"] You can create as many sections as you like, with or without paralaxx, it\'s up to you! BROOKLYN does not limit your imagination,see our 8 demos.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-road" headline="Section Backgrounds" margin_bottom="20" width="third" effect="fadeInUp" last="true" css=".vc_custom_1656585210174{margin-bottom: 20px !important;}"] Brooklyn gives you the freedom to style each section individually. Easily change colors, images, content, fonts, margins and much more without the need to touch a single line of code.[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-text-width" headline="Section Header" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585214469{margin-bottom: 20px !important;}"] Brooklyn provides 7 different header styles out of the box. With the help of the built in section settings, you can easily style each section header individually.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-sitemap" headline="Portfolio" margin_bottom="20" width="third" effect="fadeInUp" last="false" css=".vc_custom_1656585218101{margin-bottom: 20px !important;}"] Present your work to the crowd, with our portfolio management you can easily create your own showcase so that everyone is able to find and see your work on the web! [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#852c48" icon="fa fa-comments-o" headline="Support" margin_bottom="20" width="third" effect="fadeInUp" last="true" css=".vc_custom_1656585222214{margin-bottom: 20px !important;}"] We consider support as important as our theme development. If you need help, get all of your questions answered quickly with exclusive access to our dedicated support forum. We are delivering support from Monday to Friday. [/ut_service_column][/vc_column][/vc_row][vc_row css=".vc_custom_1656587955739{padding-bottom: 0px !important;background-color: #f6f8fa !important;}"][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Core Features"]We have created a awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1668433544171{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #f6f8fa !important;}"][vc_column width="1/2" hide_on_mobile="true"][ut_animated_image image="4808" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=".vc_custom_1656485622476{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2"][ut_service_column shape="round" headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#ffffff" background="#202c44" icon="fa fa-desktop" headline="10 Unique Premade Demos" margin_bottom="20" width="full" effect="slideInRight" last="false" css=".vc_custom_1656584475441{margin-bottom: 20px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore. [/ut_service_column][ut_service_column shape="round" headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#ffffff" background="#202c44" icon="fa fa-rocket" headline="Continuing Professional Development" margin_bottom="20" width="full" effect="slideInRight" last="false" css=".vc_custom_1656584491456{margin-bottom: 20px !important;}"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore.[/ut_service_column][ut_service_column shape="round" headline_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" headline_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" content_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" link_font_weight="" color="#ffffff" background="#202c44" icon="fa fa-comments-o" headline="Customer Service Professional" margin_bottom="20" width="full" effect="slideInRight" last="false" css=".vc_custom_1656584505648{margin-bottom: 20px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore. [/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section el_name="Work" bklyn_section_anchor_id="Work"][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1656587301193{margin-top: 0px !important;padding-top: 0px !important;padding-bottom: 0px !important;background-color: #202c44 !important;}"][vc_column][ut_showcase_shortcode showcase_id="45" css=".vc_custom_1656426815249{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1656587273239{margin-top: 0px !important;background-color: #202c44 !important;}"][vc_column][ut_parallax_quote quote_linebreak_mobile="on" quote_font_source="google" quote_google_fonts="font_family:Cardo%3Aregular%2Citalic%2C700|font_style:400%20regular%3A400%3Anormal" quote_ins_font_weight="" cite_font_weight="" quote_color="#ffffff"]THE MOST FEATURE RICH WORDPRESS THEME ON THE MARKET TODAY![/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section el_name="Team" bklyn_section_anchor_id="Team"][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Team"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1668433591570{margin-top: 0px !important;}"][vc_column width="1/4"][ut_team_member style="member-style-5" ocupation_font_weight="normal" name="Frank Underwood" occupation="Lead Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Faebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="4972"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" ocupation_font_weight="normal" name="Norman Bates" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Faebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="4974"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" ocupation_font_weight="normal" name="George Underwood" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Faebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="4978"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" ocupation_font_weight="normal" name="We\'re hiring" occupation="Join the club!" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Faebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="5026"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" background_position="center top" css=".vc_custom_1668438633822{padding-bottom: 0px !important;background: #202c44 url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo10/wp-content/uploads/2014/04/daniel-lincoln-BQkcHZgfjT4-unsplash.jpg?id=5004);}" bklyn_overlay_color="rgba(32, 44, 68, 0.5)"][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="THE ONE AND ONLY WORDPRESS THEME YOU’LL EVER HAVE TO BUY!" title_color="#ffffff"][/ut_header][ut_animated_image image="4836" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="center" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=".vc_custom_1656427362505{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section el_name="Customers" bklyn_section_anchor_id="Customers" css=".vc_custom_1668433813186{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="70" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Happy Customers"]Over 44,000 extremely satisfied customers![/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1668433616829{margin-top: 0px !important;}"][vc_column width="1/2"][ut_single_quote style="style-2" rating="five" effect="fadeInUp" author_font_weight="normal" company_font_weight="normal" author="Mr.X" company="Brooklyn Customer" title="Design Quality" avatar="4562" margin_bottom="20" width="half" last="false" css=".vc_custom_1656933372260{margin-bottom: 20px !important;}" date="12th Feb 2013"] As a graphic designer, I love Brooklyn for its flexibility. and with Nevada as a supplement I give United Theme 10 points! [/ut_single_quote][/vc_column][vc_column width="1/2"][ut_single_quote style="style-2" rating="five" effect="fadeInUp" author_font_weight="normal" company_font_weight="normal" author="Mr.X" company="Brooklyn Customer" title="Flawless Theme" avatar="4560" date="17th March 2015" margin_bottom="20" width="half" last="true" css=".vc_custom_1656933346312{margin-bottom: 20px !important;}"] This is basically a FLAWLESS THEME. Demo\'s are amazing and SUPER easy to incorporate. 10/10/ A+++ Please keep up the excellent quality work!! [/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_single_quote style="style-2" rating="five" effect="fadeInUp" author_font_weight="normal" company_font_weight="normal" author="Mr.X" company="Brooklyn Customer" title="Customer Support" avatar="4559" date="20th March 2014" margin_bottom="20" width="half" last="false" css=".vc_custom_1656933352467{margin-bottom: 20px !important;}"] Awesome theme and a great support team that works hard to correct an improve th theme ! [/ut_single_quote][/vc_column][vc_column width="1/2"][ut_single_quote style="style-2" rating="five" effect="fadeInUp" author_font_weight="normal" company_font_weight="normal" author="Mr.X" company="Brooklyn Customer" title="Still No.1" avatar="4561" date="25th March 2014" margin_bottom="20" width="half" last="true" css=".vc_custom_1656933307459{margin-bottom: 20px !important;}"] No. 1 template out of nearly 20 I\'ve ever purchased. [/ut_single_quote][/vc_column][/vc_row][vc_row automatic_spacing_suppress_fill="on" css=".vc_custom_1668434778298{background-color: #f6f8fa !important;}"][vc_column][ut_client_group columns="4" logo_opacity_hover="0.6" prev_next_buttons="true" carousel="true" css=".vc_custom_1668433923403{margin-top: 40px !important;}"][ut_client url="url:%23|||" logo="4774"][ut_client url="url:%23|||" logo="4774"][ut_client url="url:%23|||" logo="4774"][ut_client url="url:%23|||" logo="4774"][ut_client url="url:%23|||" logo="4774"][/ut_client_group][/vc_column][/vc_row][/vc_section]</p> '
		),

		/* Demo 11 */
		array(
			'name'      => esc_html__( 'Demo 11 - Front Page', 'ut_shortcodes' ),
			'content'	=> ''
		),




		/* Demo 13 */
		array(
			'name'      => esc_html__( 'Demo 13 - Front Page (without Hero)', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section el_name="Welcome Section"][vc_row][vc_column width="7/12"][ut_header title="Amanda Hawk"]Creative artist from Brooklyn, NY.[/ut_header][vc_column_text]We have created a awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.</p>
<p>Install full website styling with a single click for a better user experience and an easier setup overall, simply add your own content and images. No coding required, that’s a promise![/vc_column_text][ut_animated_image size="full" image="2975" css=".vc_custom_1525300583848{margin-bottom: 40px !important;}"][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_align="right" button_particle="yes" button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="50" font_weight="normal" text_transform="capitalize" button_text="Learn more about me" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo13%2Fabout%2F|||" button_text_color="#ffffff" button_background="#151515" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:15px;padding-right:50px;padding-bottom:15px;padding-left:50px" button_icon="fa fa-long-arrow-right"][/vc_column][vc_column width="5/12"][ut_animated_image size="full" align="center" caption_below="yes" caption_below_font_weight="200" image="3261" effect="fadeIn" caption_below_color="#151515"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_effect="true" bklyn_overlay_effect_randomize_opacity="true" bklyn_overlay_effect_opacity_animate="true" bklyn_overlay_effect_connect_particles="false" bklyn_overlay_effect_mouse_interaction="false" bklyn_overlay_effect_activate_boundaries="false" bklyn_overlay_effect_moving_direction="left" css=".vc_custom_1525388618100{background-color: #fafafa !important;}" bklyn_overlay_effect_particle_color="rgba(0,0,0,0.3)" el_name="What I Do Section"][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="bklynicons" align="left" icon_margin_bottom="60" headline="photography" icon_bklyn="BklynIcons-Lens-1" color="rgba(0, 0, 0, 0.1)" text_color="rgba(0,0,0,0.6)"]Goat parmesan fondue. Cheese on toast goat who moved my cheese the big cheese cauliflower cheese.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="bklynicons" align="left" icon_margin_bottom="60" headline="artwork" icon_bklyn="BklynIcons-Ruler-Tool" color="rgba(0, 0, 0, 0.1)" text_color="rgba(0,0,0,0.6)"]Goat parmesan fondue. Cheese on toast goat who moved my cheese the big cheese cauliflower cheese.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="bklynicons" align="left" icon_margin_bottom="60" headline="creative painting" icon_bklyn="BklynIcons-Blend-Tool" color="rgba(0, 0, 0, 0.1)" text_color="rgba(0,0,0,0.6)"]Goat parmesan fondue. Cheese on toast goat who moved my cheese the big cheese cauliflower cheese.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section el_name="Portfolio Section"][vc_row][vc_column][ut_header title="My Projects"]Creative artist from Brooklyn, NY.[/ut_header][/vc_column][/vc_row][vc_row el_name="Place your Showcase Shortcode here"][vc_column][ut_showcase_shortcode showcase_id="2501" css=".vc_custom_1525365956780{margin-bottom: 20px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_effect="true" bklyn_overlay_effect_randomize_opacity="true" bklyn_overlay_effect_opacity_animate="true" bklyn_overlay_effect_connect_particles="false" bklyn_overlay_effect_mouse_interaction="false" bklyn_overlay_effect_activate_boundaries="false" bklyn_overlay_effect_moving_direction="right" css=".vc_custom_1525388670714{background-color: #fafafa !important;}" bklyn_overlay_effect_particle_color="rgba(0,0,0,0.3)" el_name="Counter Section"][vc_row][vc_column width="1/3"][ut_number_counter icon_spacing="60" speed="1000" caption_font_weight="300" caption_font_size="14" caption_margin_top="15" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:100%20light%20regular%3A100%3Anormal" to="869" icon_bklyn="BklynIcons-Saturn" color="rgba(0, 0, 0, 0.1)" desccolor="rgba(0, 0, 0, 0.6)" counter_color="#151515"]clients worldwide[/ut_number_counter][/vc_column][vc_column width="1/3"][ut_number_counter icon_spacing="60" sep="true" speed="1000" caption_font_weight="300" caption_font_size="14" caption_margin_top="15" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:100%20light%20regular%3A100%3Anormal" to="1560" icon_bklyn="BklynIcons-Office-Desk-2" color="rgba(0, 0, 0, 0.1)" desccolor="rgba(0, 0, 0, 0.6)" counter_color="#151515"]jobs done[/ut_number_counter][/vc_column][vc_column width="1/3"][ut_number_counter icon_spacing="60" sep="true" speed="1000" caption_font_weight="300" caption_font_size="14" caption_margin_top="15" counter_font_source="google" counter_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:100%20light%20regular%3A100%3Anormal" to="488" icon_bklyn="BklynIcons-Flying-Rocket" color="rgba(0, 0, 0, 0.1)" desccolor="rgba(0, 0, 0, 0.6)" counter_color="#151515"]flight hours[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section el_name="Video Section"][vc_row equal_height="yes" content_placement="middle"][vc_column width="7/12"][ut_video_player caption_font_weight="normal" maxwidth="97" video_shadow="on" play_icon_size="large" icon_pulsate="on" icon_pulsate_amount_simple="2" icon_pulsate_intensity="20" url="https://www.youtube.com/watch?v=TXQT1JKCQPo" poster="3262" overlay_color="rgba(0, 0, 0, 0.1)" play_color="#151515" play_bg_color="#ffffff" pulse_color="#ffffff" shadow_color="rgba(0,0,0,0.1)"][/vc_column][vc_column width="5/12"][ut_header title="You Deserve a Stunning Website"]We have created a awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_align="right" button_particle="yes" button_particle_effect="register" button_particle_effect_direction="bottom" button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="50" font_weight="normal" text_transform="capitalize" button_text="Hire Me" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo13%2Fhire-me%2F|||" button_text_color="#ffffff" button_background="#151515" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:15px;padding-right:40px;padding-bottom:15px;padding-left:40px" button_icon="fa fa-long-arrow-right"][/vc_column][/vc_row][/vc_section][vc_section el_name="Brands Section"][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" image_opacity="65" lazy="true" loader="true" delay_animation="true" gallery="3262,3263,3264,3265,3266,3267,3268,3270,3271,3272" effect="fadeIn" loader_color="rgba(0,0,0,0.1)"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_effect="true" bklyn_overlay_effect_randomize_opacity="true" bklyn_overlay_effect_opacity_animate="true" bklyn_overlay_effect_connect_particles="false" bklyn_overlay_effect_mouse_interaction="false" bklyn_overlay_effect_activate_boundaries="false" bklyn_overlay_effect_moving_direction="top-right" background_position="center center" section_separator_top="true" section_separator_svg_top="triple_wave_1" section_separator_top_height="15" css=".vc_custom_1525388700694{padding-top: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo13/wp-content/uploads/2018/05/daniel-von-appen-276283-unsplash-1.jpg?id=3155) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(60deg, rgba(0, 0, 0, 0.2) 0%, transparent 100%)" section_separator_top_color_1="rgba(255,255,255,0.15)" section_separator_top_color_2="rgba(255,255,255,0.3)" section_separator_top_color_3="#ffffff" bklyn_overlay_effect_particle_color="#ffffff" el_name="Social Section"][vc_row][vc_column][ut_animated_image size="full" align="center" image="2864" css=".vc_custom_1525329745670{margin-bottom: 20px !important;}"][ut_header align="center" title_font_source="google" title_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:200%20light%20regular%3A200%3Anormal" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.8)"]We have created a awesome theme that will help designers,<br />
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon icon="fa fa-behance" title="Behance" slogan="View Exclusive Designs" icon_color="#ffffff" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_background="rgba(21,21,21,0.2)" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-instagram" title="Instagram" slogan="Latest Images " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][/vc_row][/vc_section]</p>'
		),
		
		array(
			'name'      => esc_html__( 'Demo 13 - About Page', 'ut_shortcodes' ),
			'content'	=> '[vc_section el_name="My Experience Section"][vc_row equal_height="yes" content_placement="bottom"][vc_column width="1/2"][ut_header title="My Experience"]We have created a awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.

Install full website styling with a single click for a better user experience and an easier setup overall, simply add your own content and images. No coding required, that’s a promise!
[/ut_header][/vc_column][vc_column width="1/2"][ut_custom_heading tag="h3" font_weight="300"]My Skills[/ut_custom_heading][ut_probar size="small" width="67" border_radius="15" info_font_size="14" info_font_weight="300" info="Adobe Illustrator" css=".vc_custom_1525386765722{margin-bottom: 20px !important;}" background_color="rgba(0, 0, 0, 0.1)"][ut_probar size="small" width="88" border_radius="15" info_font_size="14" info_font_weight="300" info="Adobe Photoshop" css=".vc_custom_1525386784276{margin-bottom: 20px !important;}" background_color="rgba(0, 0, 0, 0.1)"][ut_probar size="small" width="38" border_radius="15" info_font_size="14" info_font_weight="300" info="Sketch" background_color="rgba(0, 0, 0, 0.1)"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text css=".vc_custom_1525387157042{border-top-width: 1px !important;padding-top: 40px !important;border-top-color: rgba(0,0,0,0.1) !important;border-top-style: solid !important;}"]<strong>Self Employed</strong> | Amanda Hawk
<strong>City</strong> | Brooklyn, New York
<strong>Designer</strong> | 2011 - Present

Leverage agile frameworks to provide a robust synopsis for high level overviews. Iterative approaches to corporate strategy foster collaborative thinking to further the overall value proposition. Organically grow the holistic world view of disruptive innovation via workplace diversity and empowerment.

Bring to the table win-win survival strategies to ensure proactive domination. At the end of the day, going forward, a new normal that has evolved from generation X is on the runway heading towards a streamlined cloud solution. User generated content in real-time will have multiple touchpoints for offshoring.

Capitalize on low hanging fruit to identify a ballpark value added activity to beta test. Override the digital divide with additional clickthroughs from DevOps. Nanotechnology immersion along the information highway will close the loop on focusing solely on the bottom line.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text css=".vc_custom_1525387219586{border-top-width: 1px !important;padding-top: 40px !important;border-top-color: rgba(0,0,0,0.1) !important;border-top-style: solid !important;}"]<strong>Employed</strong> | Prager &amp; Co.
<strong>City</strong> | Los Angeles, California
<strong>Designer</strong> | 2001 - 2011

Podcasting operational change management inside of workflows to establish a framework. Taking seamless key performance indicators offline to maximise the long tail. Keeping your eye on the ball while performing a deep dive on the start-up mentality to derive convergence on cross-platform integration.

Collaboratively administrate empowered markets via plug-and-play networks. Dynamically procrastinate B2C users after installed base benefits. Dramatically visualize customer directed convergence without revolutionary ROI.

Efficiently unleash cross-media information without cross-media value. Quickly maximize timely deliverables for real-time schemas. Dramatically maintain clicks-and-mortar solutions without functional solutions.[/vc_column_text][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_effect="true" bklyn_overlay_effect_randomize_opacity="true" bklyn_overlay_effect_opacity_animate="true" bklyn_overlay_effect_connect_particles="false" bklyn_overlay_effect_mouse_interaction="false" bklyn_overlay_effect_activate_boundaries="false" bklyn_overlay_effect_moving_direction="top-right" background_position="center center" section_separator_top="true" section_separator_svg_top="triple_wave_1" section_separator_top_height="15" css=".vc_custom_1525386214022{padding-top: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo13/wp-content/uploads/2018/05/daniel-von-appen-276283-unsplash-1.jpg?id=3155) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(60deg, rgba(0, 0, 0, 0.2) 0%, transparent 100%)" section_separator_top_color_1="rgba(255,255,255,0.15)" section_separator_top_color_2="rgba(255,255,255,0.3)" section_separator_top_color_3="#ffffff" bklyn_overlay_effect_particle_color="#ffffff" el_name="Social Section"][vc_row][vc_column][ut_animated_image size="full" align="center" image="2864" css=".vc_custom_1525329745670{margin-bottom: 20px !important;}"][ut_header align="center" title_font_source="google" title_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:200%20light%20regular%3A200%3Anormal" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.8)"]We have created a awesome theme that will help designers,
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon icon="fa fa-behance" title="Behance" slogan="View Exclusive Designs" icon_color="#ffffff" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_background="rgba(21,21,21,0.2)" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-instagram" title="Instagram" slogan="Latest Images " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][/vc_row][/vc_section]'
		),
		
		array(
			'name'      => esc_html__( 'Demo 13 - About Page (Content Block)', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section section_separator_bottom="true" section_separator_svg_bottom="triple_wave_1" section_separator_bottom_height="22" section_separator_bottom_color_1="rgba(255,255,255,0.15)" section_separator_bottom_color_2="rgba(255,255,255,0.3)" section_separator_bottom_color_3="#ffffff" css=".vc_custom_1525386312550{padding-top: 0px !important;padding-bottom: 0px !important;}" el_name="Hero as Content Block"][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column width="7/12" css=".vc_custom_1525367892900{padding-top: 160px !important;padding-right: 12vw !important;padding-bottom: 40px !important;padding-left: 12vw !important;background-color: #473bb1 !important;}"][ut_header title="Hello! I\'m Amanda,<br />
Creative Artist<br />
from Brooklyn." title_color="#ffffff" lead_color="#ffffff"]We have created a awesome theme that will help designers, developers and<br />
companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner][ut_social_follow size="18" social_description="Follow Amanda" socials="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" css=".vc_custom_1525308118350{border-top-width: 1px !important;padding-top: 40px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.3)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="5/12" background_position="center center" css=".vc_custom_1525393673760{padding-top: 240px !important;padding-bottom: 240px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo13/wp-content/uploads/2018/05/replace-portrait.jpg?id=3261) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row][/vc_section]</p>'
		),
		
		array(
			'name'      => esc_html__( 'Demo 13 - Portfolio Page', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section bklyn_overlay="true"][vc_row][vc_column width="5/12"][ut_header align="left" title_source="page"]Install full website styling with a single click for a better user experience and an easier setup overall, simply add your own content and images. No coding required, that’s a promise![/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details detail_spacing="5" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Andrews%20%26%20Andrews%22%7D%2C%7B%22title%22%3A%22Year%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22Job%3A%22%2C%22description%22%3A%22Artworks%22%7D%5D" title_color="rgba(0,0,0,0.3)" description_color="#151515"][ut_social_share_bar border="true" border_color="rgba(0,0,0,0.15)" share_text_color="rgba(0,0,0,0.3)" icon_color="rgba(0,0,0,0.15)" icon_color_hover="#333333"][/vc_column][vc_column width="7/12"][ut_animated_image size="full" align="center" hover="yes" caption_font_weight="200" image="3149" effect="fadeIn" caption_color="#151515" caption_background="rgba(255,255,255,0.9)" css=".vc_custom_1525366746936{margin-bottom: 5px !important;}" caption_font_size="16px"][ut_image_gallery thumbnail_size="large" grid="3" gap="5" lightbox_size="full_hd" caption="yes" lazy="true" loader="true" delay_animation="true" caption_font_weight="300" gallery="3157,3158,3164,3162,3167,3163" caption_font_size="12px" caption_color="#151515" caption_background="rgba(255,255,255,0.9)" effect="fadeIn" loader_color="rgba(0,0,0,0.1)"][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_align="right" button_particle="yes" button_particle_effect="upload" button_size="bklyn-btn-normal" button_fluid="yes" button_border_radius="50" font_weight="normal" text_transform="capitalize" button_text="Hire Me" button_text_color="#ffffff" button_background="#151515" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:15px;padding-right:50px;padding-bottom:15px;padding-left:50px" button_icon="fa fa-long-arrow-right" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo13%2Fhire-me%2F|||"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_effect="true" bklyn_overlay_effect_randomize_opacity="true" bklyn_overlay_effect_opacity_animate="true" bklyn_overlay_effect_connect_particles="false" bklyn_overlay_effect_mouse_interaction="false" bklyn_overlay_effect_activate_boundaries="false" bklyn_overlay_effect_moving_direction="top-right" background_position="center center" section_separator_top="true" section_separator_svg_top="triple_wave_1" section_separator_top_height="15" css=".vc_custom_1525379687990{padding-top: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo13/wp-content/uploads/2018/05/daniel-von-appen-276283-unsplash-1.jpg?id=3155) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(60deg, rgba(0, 0, 0, 0.2) 0%, transparent 100%)" section_separator_top_color_1="rgba(255,255,255,0.15)" section_separator_top_color_2="rgba(255,255,255,0.3)" section_separator_top_color_3="#ffffff" bklyn_overlay_effect_particle_color="#ffffff"][vc_row][vc_column][ut_animated_image size="full" align="center" image="2864" css=".vc_custom_1525329745670{margin-bottom: 20px !important;}"][ut_header align="center" title_font_source="google" title_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:200%20light%20regular%3A200%3Anormal" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.8)"]We have created a awesome theme that will help designers,<br />
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon icon="fa fa-behance" title="Behance" slogan="View Exclusive Designs" icon_color="#ffffff" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_background="rgba(21,21,21,0.2)" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-instagram" title="Instagram" slogan="Latest Images " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][vc_column width="1/4"][ut_big_icon icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation " icon_color="#ffffff" icon_background="rgba(21,21,21,0.2)" title_color="#ffffff" slogan_color="rgba(255,255,255,0.8)" link="url:%23|||" icon_hover_color="#ffffff" icon_hover_background="rgba(21,21,21,0.3)"][/vc_column][/vc_row][/vc_section]</p>'
		),
		
		/* Demo 14 */
		array(
			'name'      => esc_html__( 'Demo 14 - Front Page', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section el_name="First Section"][vc_row][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6"][ut_custom_heading tag="h6" align="center" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523886252176{margin-bottom: 10px !important;}"]Guided outdoor adventure tours in Brooklyn[/ut_custom_heading][ut_header title="Great Outdoor Adventure"]Brooklyn\'s mountains, lakes, rivers and forests offer the opportunity to indulge in a vast range of outdoor pursuits.[/ut_header][ut_btn button_effect="winona" button_size="bklyn-btn-small" button_custom_border="yes" button_border_width="2" button_text="Discover Brooklyn" button_text_color="#474b54" button_background="transparent" button_border_color="#8e7364" spacing="padding-top:15px;padding-right:40px;padding-bottom:15px;padding-left:40px" button_link="url:%23|||"][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_animated_image size="full" align="center" image="3068"][ut_service_column_vertical headline="Backpacking"]A long trail with a little bit of history.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_animated_image size="full" align="center" image="3067"][ut_service_column_vertical headline="Camping "] A beautiful campground with a unique history.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_animated_image size="full" align="center" image="3069"][ut_service_column_vertical headline="Day Hiking"]Things to bring along on your adventure.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_animated_image size="full" align="center" image="3139"][ut_service_column_vertical headline="Paddling"]Finding solitude in Algonquin Provincial Park.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section hide_on_tablet="true" hide_on_mobile="true" el_name="3 Split Sections for Desktop Variant"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1523985402486{padding-top: 240px !important;padding-right: 240px !important;padding-bottom: 240px !important;padding-left: 240px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo14/wp-content/uploads/2018/04/blog-hero.jpg?id=3512) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][/vc_column][vc_column width="1/2" css=".vc_custom_1523830926168{padding-top: 120px !important;padding-right: 120px !important;padding-bottom: 80px !important;padding-left: 120px !important;background-color: #f4ebd9 !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523890945132{margin-bottom: 10px !important;}"]488 square miles[/ut_custom_heading][ut_header align="left" title="Explore Brooklyn"]Rugged and vast, Brooklyn is a road-tripper\'s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>
<p>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1523889723682{margin-top: 0px !important;}" el_name="Margin Top 0px"][vc_column width="1/2" css=".vc_custom_1523830750568{padding-top: 120px !important;padding-right: 120px !important;padding-bottom: 80px !important;padding-left: 120px !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523890971668{margin-bottom: 10px !important;}"]7 wild rivers[/ut_custom_heading][ut_header align="left" title="Road Trip Brooklyn"]Rugged and vast, Brooklyn is a road-tripper’s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][ut_probar size="small" width="10" info_font_size="22" info="Climbing" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][ut_probar size="small" width="25" info_font_size="22" info="Paddling" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][ut_probar size="small" width="65" info_font_size="22" info="Hiking" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][/vc_column][vc_column width="1/2" css=".vc_custom_1523985410798{padding-top: 240px !important;padding-right: 240px !important;padding-bottom: 240px !important;padding-left: 240px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo14/wp-content/uploads/2018/04/blog-hero.jpg?id=3512) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1523889741012{margin-top: 0px !important;margin-bottom: 0px !important;}" el_name="Margin Top and Bottom 0px"][vc_column width="1/2" css=".vc_custom_1523985420228{padding-top: 240px !important;padding-right: 240px !important;padding-bottom: 240px !important;padding-left: 240px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo14/wp-content/uploads/2018/04/blog-hero.jpg?id=3512) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][/vc_column][vc_column width="1/2" css=".vc_custom_1523830779744{padding-top: 120px !important;padding-right: 120px !important;padding-bottom: 80px !important;padding-left: 120px !important;background-color: #f4ebd9 !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523891005556{margin-bottom: 10px !important;}"]10 different trails[/ut_custom_heading][ut_header align="left" title="Great Brooklyn Mountains"]Rugged and vast, Brooklyn is a road-tripper\'s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][ut_image_gallery thumbnail_size="medium" grid="4" gap="5" lightbox_size="full" caption="yes" lazy="true" loader="true" delay_animation="true" caption_letter_spacing="1" gallery="3691,3690,3689,3688" loader_color="#8e7364" delay_timer="0" effect="fadeIn" caption_font_size="14px" caption_background="rgba(45,45,42,0.9)" caption_color="#f4ebd9"][/vc_column][/vc_row][/vc_section][vc_section hide_on_desktop="true" el_name="3 Split Sections for Mobile and Tablet"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_animated_image size="full" align="center" image="3512" css=".vc_custom_1523985434022{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1523889773468{margin-top: 0px !important;}" el_name="Margin Top 0px"][vc_column css=".vc_custom_1523831884128{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #f4ebd9 !important;}"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523890945132{margin-bottom: 10px !important;}"]488 square miles[/ut_custom_heading][ut_header align="left" title="Explore Brooklyn"]Rugged and vast, Brooklyn is a road-tripper\'s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>
<p>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1523889781770{margin-top: 0px !important;}" el_name="Margin Top 0px"][vc_column][ut_animated_image size="full" align="center" image="3512"][/vc_column][/vc_row][vc_row][vc_column][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523890971668{margin-bottom: 10px !important;}"]7 wild rivers[/ut_custom_heading][ut_header align="left" title="Road Trip Brooklyn"]Rugged and vast, Brooklyn is a road-tripper’s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][ut_probar size="small" info_font_size="22" info="nicht vergessen" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][ut_probar size="small" info_font_size="22" info="nicht vergessen" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][ut_probar size="small" info_font_size="22" info="nicht vergessen" color="#8e7364" background_color="#f4ebd9" info_color="#474b54" percentage_color="#ffffff"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_animated_image size="full" align="center" image="3512" css=".vc_custom_1523985451422{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1523889813810{margin-top: 0px !important;margin-bottom: 0px !important;}" el_name="Margin Top and Bottom 0px"][vc_column css=".vc_custom_1523913140166{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #f4ebd9 !important;}"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523891005556{margin-bottom: 10px !important;}"]10 different trails[/ut_custom_heading][ut_header align="left" title="Great Brooklyn Mountain"]Rugged and vast, Brooklyn is a road-tripper\'s dream. Driving gives you the freedom to travel at your own pace – pull over and take in the scenery along the way or break up the journey with hiking and kayaking.[/ut_header][ut_image_gallery thumbnail_size="large" grid="4" gap="5" lightbox_size="full" caption="yes" lazy="true" loader="true" delay_animation="true" caption_letter_spacing="1" gallery="3691,3690,3689,3688" loader_color="#8e7364" delay_timer="0" effect="fadeIn" caption_font_size="14px" caption_background="rgba(45,45,42,0.9)" caption_color="#f4ebd9"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1523835205580{padding-top: 120px !important;}" el_name="Great Brooklyn Stories"][vc_row][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6"][ut_custom_heading tag="h6" align="center" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523835754974{margin-bottom: 10px !important;}"]Popular stories[/ut_custom_heading][ut_header title="Great Brooklyn Stories"]Brooklyn\'s mountains, lakes, rivers and forests offer the opportunity to indulge in a vast range of outdoor pursuits.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1523980147212{margin-top: 0px !important;}" el_name="Margin Top 0px"][vc_column][ut_grid_blog hide_meta_categories="on" hide_meta_footer="on" disable_shadow="on" disable_border="on" disable_content_padding="on" button_effect="winona" button_size="bklyn-btn-small" button_custom_border="yes" button_border_width="2" button_text="Read all Stories" button_text_color="#474b54" button_background="transparent" button_text_color_hover="#474b54" button_background_hover="transparent" button_border_color="#8e7364" button_border_color_hover="#8e7364" spacing="padding-top:15px;padding-right:40px;padding-bottom:15px;padding-left:40px"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1523985508570{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo14/wp-content/uploads/2018/04/blog-hero.jpg?id=3512) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_name="Full Width Image Section" bklyn_overlay_color="linear-gradient(to top, #ffffff 0%, rgba(255, 255, 255, 0.5) 100%)"][vc_row][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6"][ut_custom_heading tag="h6" align="center" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" css=".vc_custom_1523888154620{margin-bottom: 10px !important;}" color="#8e7364"] There\'s an amazing planet out there [/ut_custom_heading][ut_header font_size="100" line_height="100" title="Great Brooklyn Adventure"]Brooklyn\'s mountains, lakes, rivers and forests offer the opportunity to indulge in a vast range of outdoor pursuits.[/ut_header][ut_btn button_effect="winona" button_size="bklyn-btn-small" button_custom_border="yes" button_border_width="2" button_text="Discover Brooklyn" button_text_color="#474b54" button_background="transparent" button_border_color="#8e7364" spacing="padding-top:15px;padding-right:40px;padding-bottom:15px;padding-left:40px" button_link="url:%23|||" button_text_color_hover="#474b54" button_background_hover="transparent"][/vc_column][/vc_row][/vc_section][vc_section el_name="Counter Module"][vc_row css=".vc_custom_1523889870062{padding-top: 0px !important;background-color: #ffffff !important;}" el_name="Padding Top 0px"][vc_column width="1/3"][ut_number_counter speed="1000" caption_font_size="24" counter_font_source="google" counter_font_size="66" to="10" counter_color="#8e7364" desccolor="#474b54"]Trails[/ut_number_counter][/vc_column][vc_column width="1/3"][ut_number_counter speed="1000" caption_font_size="24" counter_font_source="google" counter_font_size="66" to="7" counter_color="#8e7364" desccolor="#474b54"]Wild Rivers[/ut_number_counter][/vc_column][vc_column width="1/3"][ut_number_counter speed="1000" caption_font_size="24" counter_font_source="google" counter_font_size="66" to="488" counter_color="#8e7364" desccolor="#474b54"]Square Miles[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1523977749258{background-color: #f4ebd9 !important;}" el_name="Video Section"][vc_row equal_height="yes" content_placement="middle"][vc_column width="5/12" offset="vc_col-lg-5 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_custom_heading tag="h6" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523891091214{margin-bottom: 10px !important;}"]Guided outdoor video[/ut_custom_heading][ut_header align="left" title="Great Brooklyn Adventure"]Brooklyn\'s mountains, lakes, rivers and forests offer the opportunity to indulge in a vast range of outdoor pursuits.[/ut_header][ut_btn button_effect="winona" button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_custom_border="yes" button_border_width="2" button_text="Discover Brooklyn" button_text_color="#474b54" button_background="transparent" button_border_color="#8e7364" spacing="padding-top:15px;padding-right:40px;padding-bottom:15px;padding-left:40px" button_link="url:%23|||"][/vc_column][vc_column width="7/12" offset="vc_col-lg-7 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption_position="bottom" align="center" video_border="on" border_width="2" play_icon_style="solid" play_icon_size="large" url="https://www.youtube.com/watch?v=8Z1eMy2FoX4" poster="3691" border_color="#8e7364" play_color="#8e7364" play_bg_color="#f4ebd9" caption_color="#f4ebd9"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" background_position="center top" el_name="What People are Saying" css=".vc_custom_1523985529428{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo14/wp-content/uploads/2018/04/blog-hero.jpg?id=3512) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(to bottom, #ffffff 0%, rgba(255, 255, 255, 0.5) 100%)"][vc_row][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6"][ut_custom_heading tag="h6" align="center" font_source="google" google_fonts="font_family:Kalam%3A300%2Cregular%2C700|font_style:400%20regular%3A400%3Anormal" font_size="22" color="#8e7364" css=".vc_custom_1523835858432{margin-bottom: 10px !important;}"]About Brooklyn Adventure[/ut_custom_heading][ut_header title="What People are Saying"]Brooklyn\'s mountains, lakes, rivers and forests offer the opportunity to indulge in a vast range of outdoor pursuits.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1523980172480{margin-top: 0px !important;}" el_name="Margin Top 0px"][vc_column][ut_qtrotator][ut_qt avatar="3691" author="Sven Bach"]The Canol Heritage Trail is a interesting area which has the best of everything, wildlife, history, remoteness and adventure.[/ut_qt][ut_qt avatar="3691" author="Peter Lustig"]We loved this trip! It was well organized, spectacular, gorgeous, fun + active.[/ut_qt][/ut_qtrotator][/vc_column][/vc_row][/vc_section]</p>'
		),
		
		/* Demo 17 */
		array(
			'name'      => esc_html__( 'Demo 17 - Front Page (without Hero)', 'ut_shortcodes' ),
			'content'	=> '<p>[vc_section el_name="Who We Are" bklyn_section_anchor_id="Who We Are"][vc_row][vc_column width="5/12"][ut_animated_image image="207"][ut_header align="left" title="Who We Are"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et.[/ut_header][ut_custom_heading tag="div" font_source="google" google_fonts="font_family:Nothing%20You%20Could%20Do%3Aregular|font_style:400%20regular%3A400%3Anormal" font_size="30" color="#333333"]John Brooklyn[/ut_custom_heading][/vc_column][vc_column width="7/12"][ut_animated_image size="full" align="center" image="267"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_animated_image size="large" image="267"][ut_service_column headline="Comfortable"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_animated_image size="large" image="267"][ut_service_column headline="Professional"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_animated_image size="large" image="267"][ut_service_column headline="Precise"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1526854038290{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo17/wp-content/uploads/2016/06/hai-phung-247271-unsplash.jpg?id=246) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.35)"][vc_column][ut_header style="pt-style-2" align="left" title="In Your Words" accent="#c29e75" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.75)"]You matter, and what you think matters to us.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section el_name="Services" bklyn_section_anchor_id="Services"][vc_row][vc_column][ut_header align="left" title="Our Services"]Our special services for you.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" imageicon="179" headline="Gentleman\'s Haircut"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" imageicon="174" headline="Beard Trim & Shave"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" imageicon="178" headline="Royal Shave"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" imageicon="175" headline="Back Wax"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="Haircut with Fade" imageicon="173"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" imageicon="176" headline="Hair Wash"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1526854029623{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo17/wp-content/uploads/2016/06/hai-phung-247271-unsplash.jpg?id=246) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.35)"][vc_column][ut_header style="pt-style-2" align="left" title="Everything You Need" accent="#c29e75" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.75)"]We do it all, and we do it well.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section el_name="Prices" bklyn_section_anchor_id="Prices"][vc_row][vc_column][ut_header align="left" title="Our Prices"]First cut free for kids.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_menu_card_shortcode menu_id="71"][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" image="267"][/vc_column][/vc_row][vc_row][vc_column][ut_menu_card_shortcode menu_id="90"][/vc_column][/vc_row][vc_row bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1526854021337{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo17/wp-content/uploads/2016/06/hai-phung-247271-unsplash.jpg?id=246) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.35)"][vc_column][ut_header style="pt-style-2" align="left" title="It’s Not Our Barber Shop, It’s Yours!<br />
" title_color="#ffffff" lead_color="rgba(255, 255, 255, 0.75)" accent="#c29e75"]We love our shop and so will you.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section el_name="Location / Padding Bottom 0px" css=".vc_custom_1526836137660{padding-bottom: 0px !important;background-color: #262626 !important;}" bklyn_section_anchor_id="Location "][vc_row][vc_column][ut_animated_image size="large" align="center" image="234"][/vc_column][/vc_row][vc_row css=".vc_custom_1526852897598{padding-bottom: 80px !important;}" el_name="Padding bottom 80px"][vc_column width="1/2"][ut_service_column align="right" headline="Address" headline_color="#c29e75"]1399 Beverley Rd,<br />
Brooklyn, NY 11218<br />
718.123.456-BARBER[/ut_service_column][/vc_column][vc_column width="1/2"][ut_service_column headline="Hours" headline_color="#c29e75"]Monday - Saturday<br />
11am – 9pm<br />
Sunday Closed<br />
[/ut_service_column][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1526834265083{margin-bottom: 0px !important;padding-bottom: 0px !important;}" el_name="Google Map / Padding and Margin bottom 0"][vc_column][ut_google_maps theme="shadesofgray" zoom="14" zoomcontrol="off" maptypecontrol="off" streetviewcontrol="off" fullscreencontrol="off" api_key="AIzaSyDbgU23qHOOJGWA1H858_GO162YNJf0NQA" css=".vc_custom_1526852238595{margin-bottom: 0px !important;}" marker="256"]Brooklyn, New York[/ut_google_maps][/vc_column][/vc_row][/vc_section]</p>
'
		),		
		
		
        /* Demo 20 - Construction */
        array(
            'name'      => esc_html__( 'Demo 20 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1657003667382{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column width="1/3" force_padding="on" force_padding_desktop="5" css=".vc_custom_1657003544376{background-color: #f1c40f !important;}"][ut_service_icon_box icon="fa fa-bluetooth" headline="Building" css=".vc_custom_1657003524100{margin-bottom: 0px !important;}" headline_color="#0a0d1b" text_color="#322803" imageicon="268" color="#0a0d1b" hovercolor="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][vc_column width="1/3" force_padding="on" force_padding_desktop="5" css=".vc_custom_1657003602802{background-color: #0a0d1b !important;}"][ut_service_icon_box icon="fa fa-shopping-basket" headline="Renovation" css=".vc_custom_1657003565194{margin-bottom: 0px !important;}" headline_color="#f1c40f" text_color="#ffffff" imageicon="276" color="#f1c40f" hovercolor="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][vc_column width="1/3" force_padding="on" force_padding_desktop="5" css=".vc_custom_1657003609557{background-color: #f1c40f !important;}"][ut_service_icon_box icon_color="#ffffff" headline="Demolition" css=".vc_custom_1657003577395{margin-bottom: 0px !important;}" imageicon="278" color="#0a0d1b" hovercolor="#0a0d1b" headline_color="#0a0d1b" text_color="#322803"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1657003715380{padding-top: 120px !important;padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header style="pt-style-2" align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="24px" title="Build Your House With Us!"]Building energy efficient, comfortable and affordable homes for America\'s families is at the heart of what we do at Brooklyn Construction.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
<div class="wpb_text_column wpb_content_element ">
<div class="wpb_wrapper">

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

</div>
</div>
[/vc_column_text][vc_custom_heading text="Karl Hoffmann" font_container="tag:h3|font_size:18px|text_align:left" google_fonts="font_family:Yellowtail%3Aregular|font_style:400%20regular%3A400%3Anormal" text_transform="capitalize" css=".vc_custom_1467774325360{margin-bottom: 10px !important;}"][vc_column_text]<small><strong>Karl Hoffmann</strong>
Founder of Brooklyn Homes</small>[/vc_column_text][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-calculator" headline="Concept Stage" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-clock-o" headline="Building Agreement" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-book" headline="Contract Signing" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-building-o" headline="Construction" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image image="2798" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="center" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=".vc_custom_1668413458115{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section][vc_row css=".vc_custom_1656921759323{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #0a0d1b !important;}"][vc_column][ut_header style="pt-style-2" align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Our Latest Projects" title_color="#ffffff" lead_color="#999999" accent="#f1c40f"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1656921666963{margin-top: 0px !important;}"][vc_column][ut_showcase_shortcode showcase_id="139" css=".vc_custom_1656921837227{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1656921828275{margin-top: 0px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #0a0d1b !important;}"][vc_column][ut_cta button_size="bklyn-btn-small" button_align="bklyn-btn-right" button_border_width="2" button_custom_border="true" headline="View All Projects" headline_color="#f1c40f" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn%2Fprojects%2F|||" button_custom_font="true" text_color="#ffffff" button_text="All Projects" button_border_color="#ffffff" button_border_color_hover="#ffffff" button_text_color="#ffffff" button_text_color_hover="#0a0d1b" button_font="font_family:ABeeZee%3Aregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1657004482529{margin-bottom: 0px !important;}" button_background_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_cta][/vc_column][/vc_row][/vc_section][vc_section][vc_row css=".vc_custom_1467823085426{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1467822966158{padding-top: 0px !important;}"][ut_header style="pt-style-2" align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="What our customers say" css=".vc_custom_1467851100514{padding-top: 0px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" author_font_weight="normal" company_font_weight="normal" author="Mr. Smith" company="Smith &amp; Sons" title="Feature Availability" date="2016 / May / 12" avatar="2798"]As a graphic designer, I love Brooklyn for its flexibility and with Nevada as a supplement I give United Theme 10 points![/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" author_font_weight="normal" company_font_weight="normal" author="Mr. Smith" company="Smith &amp; Sons" title="Design Quality" date="2016 / Juli / 4" avatar="2798"]This is basically a FLAWLESS THEME. Demos are amazing and SUPER easy to incorporate. 10/10/ A+++ Please keep up the excellent quality work!![/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section][vc_row css=".vc_custom_1656922651312{margin-bottom: 0px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #0a0d1b !important;}"][vc_column css=".vc_custom_1467421758161{padding-top: 0px !important;}"][ut_cta button_size="bklyn-btn-mini" button_align="bklyn-btn-right" button_border_width="2" button_custom_border="true" headline="Our Services" headline_color="#f1c40f" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn%2Fservices%2F|||" button_custom_font="true" text_color="#ffffff" button_text="Services" button_border_color="#ffffff" button_border_color_hover="#ffffff" button_text_color="#ffffff" button_text_color_hover="#0a0d1b" button_font="font_family:ABeeZee%3Aregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1467851385245{margin-bottom: 0px !important;}" button_background_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_cta][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" bklyn_overlay="true" bklyn_overlay_pattern="true" parallax="content-moving" parallax_image="2799" css=".vc_custom_1668152214476{background-image: url(https://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo20/wp-content/uploads/2016/07/ut-placeholder.jpg?id=2800) !important;}" bklyn_overlay_color="rgba(10,13,27,0.7)"][vc_column][ut_header style="pt-style-2" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="font-size-unit=px&amp;desktop_large=70&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="We Build Your Dream Home!" title_color="#ffffff" accent="#f1c40f"][/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column css=".vc_custom_1467727608044{padding-top: 0px !important;}"][ut_header style="pt-style-2" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Use Our Advantages" css=".vc_custom_1467851093528{padding-top: 0px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Save Energy[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Construction and equipment[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Worry-free service[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Our Clients" color="custom" accent_color="#ededed" css=".vc_custom_1467852666460{margin-bottom: 0px !important;}"][vc_row_inner][vc_column_inner][ut_client_group carousel="true" deco_line_color="#ffffff"][ut_client logo="2755"][ut_client logo="2755"][ut_client logo="2755"][ut_client logo="2755"][ut_client logo="2755"][ut_client logo="2755"][/ut_client_group][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Abouts Us', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row css=".vc_custom_1467568839237{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][vc_custom_heading text="Karl Hoffmann" font_container="tag:h3|font_size:18px|text_align:left" google_fonts="font_family:Yellowtail%3Aregular|font_style:400%20regular%3A400%3Anormal" text_transform="none"][/vc_column][vc_column width="1/2"][ut_animated_image image="2798" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="right" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="yes" caption_below_transform="" caption_below_font_weight="normal" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="#999999" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][/vc_column][/vc_row][vc_row css=".vc_custom_1467568839237{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_animated_image image="2798" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][/vc_column][vc_column width="1/2"][ut_header style="pt-style-2" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="desktop_large=24&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="German Roots and Quality since 1870"]German virtues brought to success.[/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467568839237{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_header style="pt-style-2" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="desktop_large=24&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title_letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" title="Our Philosophy"]A family business since 1870.[/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_animated_image image="2798" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image image="1050" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="center" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][/vc_column][/vc_row][/vc_section]',

        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1657013188173{padding-bottom: 0px !important;}"][vc_row css=".vc_custom_1467823960306{margin-bottom: 60px !important;}"][vc_column width="1/2"][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Company Information[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][vc_column_text]
<ul>
 	<li>1399 Beverley Rd, Brooklyn, NY 11218</li>
 	<li>547-589-663-BKLYN</li>
 	<li>info@bklyn-construction.com</li>
</ul>
[/vc_column_text][/vc_column][vc_column width="1/2"][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Send Us A Message[/ut_custom_heading][ut_c7_shortcode form_id="2811" form_skin="dark"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_google_maps theme="lightmonochrome" maptypecontrol="off" streetviewcontrol="off" fullscreencontrol="off" css=".vc_custom_1657013648852{margin-bottom: 0px !important;}"]1399 Beverley Rd, Brooklyn, NY 11218, USA[/ut_google_maps][/vc_column][/vc_row][/vc_section]',
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row css=".vc_custom_1467781577280{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Design and Plans[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Groundworks and Contract Brickwork[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]New Builds[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781584262{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Alterations[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Extensions[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Electrical &amp; Plumbing[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781600019{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Plastering[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Kitchens[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Bathrooms[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781607831{margin-bottom: 80px !important;}"][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Painting &amp; Decorating[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Steelwork[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image image="" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Hard Landscaping[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][/vc_section]',
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Team Member', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header style="pt-style-2" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="30px" title="Team Member Style 1"][/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Base Layout" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467783739808{margin-bottom: 40px !important;}"][vc_column width="1/4"][ut_team_member align="left" name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row css=".vc_custom_1467788799558{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][vc_text_separator title="Text Align Center" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1467789037399{margin-bottom: 40px !important;}"][vc_column][vc_text_separator title="Without Description" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1467788987858{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][vc_text_separator title="Without Description &amp; Social Icons" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Custom Sizes &amp; Colors" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467789310167{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_team_member align="left" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467916949182{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #2c3e50 !important;}" name_color="#f1c40f" ocupation_color="#fafafa" description_color="#fafafa" line_color="#34495e" icon_color_hover="#fafafa"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467916953409{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #0c2032 !important;}" name_color="#bdc3c7" ocupation_color="#f1c40f" description_color="#bdc3c7" line_color="#1b3147" icon_color="#ffffff" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row css=".vc_custom_1467789274461{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][ut_header style="pt-style-2" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Team Member Style 2"][/ut_header][vc_row_inner][vc_column_inner][vc_text_separator title="Base Layout" color="custom" accent_color="#ededed"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" line_color="#ededed" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" line_color="#ededed" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" line_color="#fafafa" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Custom Layouts" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467786238954{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_team_member style="member-style-2" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467916974674{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ecf0f1 !important;}" icon_color="#dadada" line_color="#fafafa" icon_color_hover="#2c3e50"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member style="member-style-2" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467916979619{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #2c3e50 !important;}" name_color="#f1c40f" ocupation_color="#fafafa" description_color="#fafafa" line_color="#34495e" icon_color_hover="#fafafa"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member style="member-style-2" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row css=".vc_custom_1467789691859{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][ut_header style="pt-style-2" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Team Member Style 3"][/ut_header][vc_row_inner][vc_column_inner][vc_text_separator title="Custom Hover Styles" color="custom" accent_color="#ededed"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" name_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467916995634{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #f1c40f !important;}" name_color="#f1c40f" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f" overlay_color="#ffffff" icon_color="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" name_color="#0a0d1b" ocupation_color="#ffffff" overlay_color="#f1c40f" icon_color="#0a0d1b" icon_color_hover="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Team Member Style 4"][/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Text Alignment Bottom" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467667458182{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_team_member style="member-style-4" name="Max Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" name_color="#0a0d1b" overlay_color="rgba(255,255,255,0.9)" ocupation_color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/2"][ut_team_member style="member-style-4" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467917009408{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ededed !important;}" name_color="#f1c40f" ocupation_color="#fafafa" icon_color_hover="#fafafa" overlay_color="rgba(52,73,94,0.7)"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][/vc_section]'
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Project Details Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_animated_image image="3004" size="full" custom_width="" custom_height="" custom_crop="on" image_opacity="100" image_border_radius="0" align="left" align_tablet="inherit" align_mobile="center" link_type="none" lightbox_size="hd" link="" lightbox_iframe="" hide_image_title="yes" hover="no" caption_style="" caption_content="caption" custom_caption="" custom_caption_small="" caption_transform="" caption_font_weight="" caption_letter_spacing="0" caption_font_size="" caption_line_height="" caption_color="" caption_background="" caption_below="no" caption_below_transform="" caption_below_font_weight="bold" caption_below_letter_spacing="0" caption_below_font_size="" caption_below_line_height="" caption_below_color="" image_offset="no" image_zoom="yes" shadow="no" shadow_canvas_color="" shadow_color="" revealfx="off" revealfx_color="" revealfx_direction="lr" revealfx_delay="0" revealfx_duration="750" glitch_transparent="off" glitch_effect="none" glitch_effect_transparent="none" permanent_glitch="on" accent_1="" accent_2="" accent_3="" rotation="0" rotation_tablet_change="off" rotation_tablet="0" rotation_mobile_change="off" rotation_mobile="0" effect="" animation_duration="" animate_once="yes" animate_tablet="false" animate_mobile="false" delay="false" delay_timer="" class="" cursor_skin="inherit" css=""][/vc_column][/vc_row][vc_row css=".vc_custom_1467836668565{margin-bottom: 80px !important;}"][vc_column width="1/6"][ut_image_gallery thumbnail_size="large" gap="20" gallery="2944,2943,2942"][/vc_column][vc_column width="1/2"][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Project Description[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="2/6"][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Project Details[/ut_custom_heading][ut_fancy_list values="%5B%7B%22title%22%3A%22%3Cstrong%3EClient%3A%3C%2Fstrong%3E%20United%20Buildings%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3ELocation%3A%3C%2Fstrong%3E%20Germany%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EProject%20Begin%3A%3C%2Fstrong%3E%20March%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EProject%20End%3A%3C%2Fstrong%3E%20Juni%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EArchitect%3A%3C%2Fstrong%3E%20Mr.%20Smith%22%2C%22is_link%22%3A%22true%22%7D%5D" css=".vc_custom_1467837162554{padding: 20px !important;background-color: #fafafa !important;}"][ut_custom_heading tag="h3" font_size="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" line_height="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global" letter_spacing="desktop_large=global&amp;desktop_small=global&amp;tablet=global&amp;mobile=global"]Project Management[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][vc_icon icon_fontawesome="fa fa-file-pdf-o" color="custom" background_style="rounded" background_color="custom" size="lg" align="center" link="url:%23|title:Download%20Brochure|target:%20_blank|" custom_color="#fafafa" custom_background_color="#f1c40f" css=".vc_custom_1657015103226{margin-bottom: 20px !important;}"][vc_column_text]
<h3 style="text-align: center;">Download Brochure</h3>
[/vc_column_text][/vc_column][/vc_row][/vc_section]',
        ),

        /* Demo 21 - Creative Agency */
        array(
            'name'      => esc_html__( 'Demo 21 - Home Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" css=".vc_custom_1470172161287{margin-bottom: 80px !important;padding-top: 40px !important;padding-right: 60px !important;padding-bottom: 40px !important;padding-left: 60px !important;background-color: #f9f9f9 !important;}"][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Who We Are" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469498927805{margin-bottom: 10px !important;}"][ut_header title="Your experts around modern design."]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][vc_column width="2/3" offset="vc_col-lg-8 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184344232{margin-bottom: 40px !important;}"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184354503{margin-bottom: 40px !important;}"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-cloud" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="UX/UI DESIGN" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184358920{margin-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1470017013870{margin-bottom: 80px !important;}"][vc_column width="2/3" offset="vc_col-lg-offset-0"][vc_custom_heading text="Brooklyn Demo #21" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469498940817{margin-bottom: 10px !important;}"][ut_header title="We create awesome websites."]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.

Each demo looks different and can be imported in seconds![/ut_header][/vc_column][vc_column width="1/3"][ut_animated_image size="large" align="center" animate_once="yes" image="515" effect="fadeIn"][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="our finest designs" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469551995320{margin-bottom: 10px !important;}"][ut_header align="center" title="Our works."]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1469590804944{margin-bottom: 80px !important;}"][vc_column][ut_custom_shortcode][ut_showcase id="99"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Our Clients" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469591935773{margin-bottom: 10px !important;}"][ut_header align="center" title="You are in good company!"]Over 37.000 extremely satisfied customers![/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" background_position="center center" background_attachment="scroll" css=".vc_custom_1470260095639{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 80px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ut_qtrotator effect_in="fadeIn" effect_out="fadeOut" arrow_color="#333333" arrow_color_hover="#f5ab35" quote_color="#333333" name_color="#333333"][ut_qt avatar="236" author="Fmenossi"]Easy to install, work exatelly as expected.
Best theme I ever had.[/ut_qt][ut_qt avatar="237" author="Illagraphics"]This theme is perfect for the project I’m working on.
Its flexible and easy to use.[/ut_qt][ut_qt avatar="240" author="Slidus"]Great theme and customer support!
Purchased this theme more than once. [/ut_qt][/ut_qtrotator][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1469410901052{background-color: #f9f9f9 !important;}"][vc_column][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="264,263,262,259,268" effect="fadeIn"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1469828450302{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Every Day We Fight!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469750459988{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][ut_header title="Our history."]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="1.) OUR RESPONSIBILITY"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="2.) OUR APPROACH"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="3.) OUR MISSION"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1469751518111{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="PAUL" avatar="236" occupation="Founder" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="KARL" avatar="237" occupation="Distribution" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TOM" avatar="238" occupation="Engineering" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="SANDRA" avatar="240" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner][vc_custom_heading text="We are brooklyn!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469751560802{margin-bottom: 10px !important;}"][ut_header title="Our famous team."]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="DIRK" avatar="245" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TARUN" avatar="243" occupation="Handy-Man" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1469828604740{margin-bottom: 80px !important;}"][vc_column][ut_parallax_quote quotation_marks="no" icon_border_radius="50" quote_font_source="websafe" quote_websafe_fonts="helvetica" quote_font_size="14" quote_line_height="50" quote_letter_spacing="10" quote_font_weight="bold" cite_font_source="websafe" cite_websafe_fonts="helvetica" cite_font_size="13" cite_font_weight="bold" cite_text_transform="uppercase" cite="United Themes" icon="fa fa-quote-left" icon_color="#ffffff" icon_background_color="#333333" quote_color="#333333" cite_color="#cccccc" css=".vc_custom_1469835516230{padding-top: 120px !important;padding-right: 40px !important;padding-bottom: 80px !important;padding-left: 40px !important;background-image: url() !important;background-position: 0 0 !important;background-repeat: repeat !important;}"]PASSION LEADS TO DESIGN,
DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO SUCCESS![/ut_parallax_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1469829147655{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Our awesome partner!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470091907220{margin-bottom: 10px !important;}"][ut_header align="center" title="Our partner."]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="263,262,259,264,267,268" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Get in touch with us!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes"][ut_header align="global" title="Drop us a line."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_custom_shortcode][contact-form-7 id="334" title="contact"][/ut_custom_shortcode][/vc_column][vc_column width="1/2"][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-map-marker" color="#ffffff" background="#333333" headline="VISIT US"]1399 Beverley Rd
Brooklyn, NY 11218[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-envelope-o" color="#ffffff" background="#333333" headline="MAIL US"]contact@yourdomain.com[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-phone" color="#ffffff" background="#333333" headline="CALL US"]1-8456-563-BKLYN[/ut_service_column_vertical][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Main Portfolio Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_custom_heading text="Page without hero" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470107160400{margin-bottom: 10px !important;}"][ut_header align="center" title="Portfolio"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_custom_shortcode][ut_showcase id="2842"][/ut_custom_shortcode][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1470010711683{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="New demos each month!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470010945729{margin-bottom: 10px !important;}"][ut_header align="center" title="No run of the mill."]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-desktop" headline="VISUAL COMPOSER" color="#dddddd"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-clock-o" headline="1 CLICK DEMO IMPORTER" color="#f5ab35" hovercolor="#dddddd"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-code" headline="FULLY CUSTOMIZABLE" color="#dddddd" hovercolor="#dddddd"]All parts of Brooklyn can be customized. From header to footer and everything what’s in between.[/ut_service_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470012345255{margin-bottom: 120px !important;padding-top: 120px !important;padding-bottom: 40px !important;background: #f9f9f9 url() !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column width="1/2" css=".vc_custom_1469807293290{padding-top: 120px !important;padding-bottom: 80px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="What we offer!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469806797798{margin-bottom: 10px !important;}"][ut_header title="Our services."]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-desktop" headline="NEW DEMOS EACH MONTH" color="#333333" imageicon="306"]We release each month new demos for our beloved Brooklyn![/ut_service_column][/vc_column_inner][/vc_row_inner][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-life-ring" headline="LIFETIME UPDATES" color="#333333"]Brooklyn received continues updates, new features and new Demos. Since release we published around 50 updates![/ut_service_column][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-balance-scale" headline="OUR PROMISE" color="#333333"]We’re here to make products that work! It’s a tall order, but we wouldn’t want to do anything else.[/ut_service_column][/vc_column][vc_column width="1/2" css=".vc_custom_1470012243922{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" image="832" effect="fadeInRight"][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="what are you waiting for?" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469814729146{margin-bottom: 10px !important;}"][ut_header align="center" title="Our offer for you."]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="continuous improvements" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="New Demos" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="unlimited possibilities" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="Power Elite Support" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="You are in good company!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470009882749{margin-bottom: 10px !important;}"][ut_header align="center" title="Customers voice."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CUSTOMIZABILITY" author="Fmenossi" avatar="236" company="Brooklyn Customer" deco_line_color="#efefef"]Easy to install, work exatelly as expected. Best theme I ever had.[/ut_single_quote][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="FLEXIBILITY" author="Illagraphics" avatar="238" company="Brooklyn Customer" deco_line_color="#efefef"]This theme is perfect for the project I’m working on. Its flexible and easy to use.[/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CODE QUALITY" author="JRole" avatar="237" company="Brooklyn Customer" deco_line_color="#efefef"]It’s just so easy to use &amp; get fantastic results with very little knowledge.[/ut_single_quote][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CUSTOMER SUPPORT" author="Slidus" avatar="240" company="Brooklyn Customer" deco_line_color="#efefef"]Great theme and customer support! Purchased this theme more than once. [/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column width="2/3"][ut_image_gallery thumbnail_size="full" gap="40" animate_once="yes" delay_animation="true" gallery="1101,1102,1103" effect="fadeIn"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Single Portfolio Style 1" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717353210{margin-bottom: 10px !important;}"][ut_header title="Disc &amp; Cover Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/ut_header][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text_font_weight="bold" share_text="SHARE:" border="true" border_color="#efefef" icon_color="#999999" icon_color_hover="#f5ab35" share_text_color="#333333"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 2" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717493127{margin-bottom: 10px !important;}"][ut_header title="Frame Decoration"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Interiors%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="557" effect="fadeIn"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="607,609,608,610" effect="fadeIn"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/6"][vc_custom_heading text="Single Portfolio Style 3" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717524368{margin-bottom: 10px !important;}"][ut_header title=" Jacks Hot Cup"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Jacks%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="4/6"][ut_image_gallery thumbnail_size="large" grid="3" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" effect="bounceInDown" gallery="662,661,666,665,664,659,658,660"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470153837638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470153127186{margin-bottom: 10px !important;}"][ut_header title="Brooklyn is perfect for your presentation."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="2824" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" css=".vc_custom_1470162702299{margin-bottom: 0px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #222222 !important;}"][vc_column][vc_custom_heading text="Brooklyn 4 is here!" font_container="tag:h6|font_size:15px|text_align:center|color:%23f5ab35" use_theme_fonts="yes" css=".vc_custom_1470159454271{margin-bottom: 10px !important;}"][ut_header align="center" title="Present your web
with brooklyn." title_color="#ffffff" lead_color="#999999" css=".vc_custom_1470188000328{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_gallery_slider lightbox="no" dots="false" effect_in="zoomIn" effect_out="zoomOut" slides="2839,2838,2841,2837,2840" arrow_color="#f5ab35" arrow_color_hover="#ffffff" arrow_background_color="rgba(0,0,0,0.1)" dot_color="#ffffff" dot_color_hover="#f5ab35"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470161590478{margin-bottom: 80px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #28272c !important;}"][vc_column][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470162512428{margin-bottom: 10px !important;}"][ut_header align="center" title="Black watch." title_color="#f5ab35" css=".vc_custom_1470162797977{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_image_gallery thumbnail_size="large" lightbox="no" grid="3" gap="40" delay_animation="true" gallery="2831,2829,2830" effect="zoomIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="2833" effect="zoomIn"][/vc_column][vc_column width="1/2"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Black%20Watch%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%20%22%2C%22description%22%3A%22Watch%20Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="bottom"][vc_column width="2/3"][vc_custom_heading text="Single Portfolio Style 5" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469730525127{margin-bottom: 10px !important;}"][ut_header title="Brads"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brads%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="zoomIn" gallery="721,713,720,708,722,710"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1469758135477{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469757988023{margin-bottom: 10px !important;}"][ut_header title="Berlin"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="785" effect="fadeIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1469758138604{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="786" effect="fadeIn" delay_timer="400"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469758000521{margin-bottom: 10px !important;}"][ut_header title="Orange room."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469758024808{margin-bottom: 10px !important;}"][ut_header title="Orange is king."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="787" effect="fadeIn" delay_timer="600"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 7" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469760101545{margin-bottom: 10px !important;}"][ut_header title="We design a unique multipurpose website."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="792" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" equal_height="yes"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="websafe" quote_websafe_fonts="helvetica" quote_font_size="15" quote_line_height="50" quote_letter_spacing="10" quote_font_weight="bold" quote_text_transform="uppercase" cite_font_source="websafe" cite_websafe_fonts="helvetica" cite_font_size="13" cite_font_weight="bold" cite_text_transform="uppercase" cite="Brooklyn Customer" icon="fa fa-quote-left" icon_color="#333333" quote_color="#333333" cite_color="#cccccc"]I’m really enjoying this theme, very easy to use, the markups makes a lot of sense, and the design is on point. Great!!![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="794" effect="zoomIn"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 7" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469760105388{margin-bottom: 10px !important;}"][ut_header title="Thank you!"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border="true" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="flipInX" gallery="1026,1027,1028,1029,1030,1031"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][vc_custom_heading text="Single Portfolio Style 8" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469856555909{margin-bottom: 10px !important;}"][ut_header title="John Street"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22John%20Street%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22August%201%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 9', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 9" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469889884692{margin-bottom: 10px !important;}"][ut_header title="Relaxation Room"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd
gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 10', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717576836{margin-bottom: 10px !important;}"][ut_header title="Brooklyn Magazine"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="5/6"][ut_gallery_slider slides="2698,2697,2695,2696"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/6"][ut_image_gallery thumbnail_size="medium" gap="40" animate_once="yes" delay_animation="true" gallery="2697,2698,2701" effect="zoomIn"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Magazine%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 11', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][ut_gallery_slider dots="false" effect_in="bounceIn" effect_out="bounceOut" slides="2728,2729,2730,2731" arrow_color="#333333" arrow_color_hover="#f5ab35"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Single Portfolio Style 11" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470073522937{margin-bottom: 10px !important;}"][ut_header title="Top Brand"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Top%20Brand%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 12', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="2743,2744,2745,2746" effect="flipInX"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 12" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470074826957{margin-bottom: 10px !important;}"][ut_header title="Drawing"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22United%20Themes%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),

        /* Demo 22 */
        array(
            'name'      => esc_html__( 'Demo 22 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1476104711538{padding-top: 80px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="UNITED THEMES" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604014105{margin-bottom: 10px !important;}"][ut_header title="We Build The Web"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" background_position="right bottom" background_attachment="scroll" hide_bg_medium="true" hide_bg_tablet="true" hide_bg_mobile="true" css=".vc_custom_1476470891749{margin-bottom: 0px !important;padding-bottom: 80px !important;background-image: url() !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column width="1/2" css=".vc_custom_1476107837958{padding-top: 0px !important;}" offset="vc_col-lg-9 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner delay="true" effect="fadeIn" delay_timer="400"][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116764585{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104561072{margin-bottom: 12px !important;}"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104785496{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104569877{margin-bottom: 12px !important;}"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104781755{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116773553{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="800"][vc_icon type="linecons" icon_linecons="vc_li vc_li-paperplane" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104579879{margin-bottom: 12px !important;}"][vc_custom_heading text="INNOVATIVE ADMIN PANEL" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104789871{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116777601{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="1000"][vc_icon type="linecons" icon_linecons="vc_li vc_li-cloud" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104587733{margin-bottom: 12px !important;}"][vc_custom_heading text="UX/UI DESIGN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104793595{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1475623482050{margin-bottom: 120px !important;padding-top: 80px !important;background-color: #1b1d1f !important;}"][vc_column offset="vc_col-lg-offset-0"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_hidden-md vc_hidden-sm vc_hidden-xs" effect="none"][ut_animated_image size="full" animate_once="yes" image="3847" css=".vc_custom_1476284926296{margin-bottom: 0px !important;}" effect="fadeInUp" animation_duration="2s"][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12" css=".vc_custom_1476284933348{margin-bottom: 80px !important;}" effect="fadeInDown" delay_timer="400" animation_duration="2s"][vc_custom_heading text="INTUITIVE &amp; SMART" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" css=".vc_custom_1475623291736{margin-bottom: 10px !important;}"][ut_header title="Works On All Platforms" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475623431748{padding-top: 0px !important;}"][vc_custom_heading text="OUR AWESOME PROJECTS" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604521054{margin-bottom: 10px !important;}"][ut_header align="center" title="The Work We Love"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1475676795342{margin-bottom: 10px !important;}"][vc_column][ut_custom_shortcode][ut_showcase id="99"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476116094336{margin-bottom: 120px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="ADVANTAGES" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" css=".vc_custom_1476116201603{margin-bottom: 10px !important;}"][ut_header align="left" title="How We Work" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672351420{margin-bottom: 12px !important;}"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118410016{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][vc_icon type="linecons" icon_linecons="vc_li vc_li-fire" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672341829{margin-bottom: 12px !important;}"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118415192{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="800"][vc_icon type="linecons" icon_linecons="vc_li vc_li-world" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672362854{margin-bottom: 12px !important;}"][vc_custom_heading text="GLOBAL BRANDING" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118420766{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1000"][vc_icon type="linecons" icon_linecons="vc_li vc_li-bubble" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672372435{margin-bottom: 12px !important;}"][vc_custom_heading text="CUSTOMER SUPPORT" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118426195{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1200"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672383286{margin-bottom: 12px !important;}"][vc_custom_heading text="WEB HOSTING" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118432445{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-diamond" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672392703{margin-bottom: 12px !important;}"][vc_custom_heading text="UI DESIGN" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118442472{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column animate_once="yes" delay="true" css=".vc_custom_1476120589381{padding-top: 0px !important;}" effect="fadeIn" delay_timer="200"][vc_custom_heading text="OUR CLIENTS SAID" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604769727{margin-bottom: 10px !important;}"][ut_header align="center" title="You Are In Good Company"]Over 38.000 extremely satisfied customers![/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475710080770{margin-bottom: 80px !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column animate_once="yes" delay="true" css=".vc_custom_1476120606769{padding-top: 0px !important;}" effect="fadeIn" delay_timer="400"][ut_qtrotator_2 rotator_custom_font="yes" arrow_color="#333333" arrow_color_hover="#0070c9" name_color="#333333"][ut_qt_2 avatar="3401" author="John Areus" origin="Brooklyn User" imageicon="3888"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 avatar="3400" author="Ron Schmidt" origin="Brooklyn User" imageicon="3889"]“Im really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.
Really looking forward to the upcoming demos, United Themes, you guys do a great job!"
[/ut_qt_2][ut_qt_2 avatar="3416" author="Henrik Schwarz" origin="Brooklyn User" imageicon="3890"]"The one and only Wordpress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!"[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476114044954{background-color: #1b1d1f !important;}"][vc_column css=".vc_custom_1476114133218{padding-top: 60px !important;padding-bottom: 20px !important;}"][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="3473,3474,3475,3476,3477" effect="fadeIn" delay_timer="300"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1476558889993{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="scroll" animate_once="yes" delay="true" css=".vc_custom_1476558979511{padding-top: 240px !important;padding-bottom: 240px !important;background-image: url() !important;}" effect="fadeIn" delay_timer="400" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_custom_heading text="EASY AND FAST INSTALLATION" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604810469{margin-bottom: 10px !important;}"][ut_header align="center" title="So Intuitive, So Easy!" title_color="#ffffff" lead_color="#ffffff"]Join the Brooklyn family with over 22k Member![/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="500" text_transform="uppercase" letter_spacing="2" button_text="Purchase" button_text_color="#ffffff" button_background="#0070c9" button_text_color_hover="#333333" button_background_hover="#ffffff" css=".vc_custom_1475663210672{padding-bottom: 50px !important;}" spacing="padding-bottom:8px"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1469828450302{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="We Are Brooklyn" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475665116476{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][ut_header title="Our History"]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="1.) OUR RESPONSIBILITY"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="2.) OUR APPROACH"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="3.) OUR MISSION"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1469751518111{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="PAUL" avatar="3415" occupation="Founder" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="KARL" avatar="3416" occupation="Distribution" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TOM" avatar="3417" occupation="Engineering" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="SANDRA" avatar="3418" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner][vc_custom_heading text="Our Famous Team" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475774092100{margin-bottom: 10px !important;}"][ut_header title="The Crew"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="DIRK" avatar="3419" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TARUN" avatar="3420" occupation="Handy-Man" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1475765580529{margin-bottom: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="The Mission" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475773811114{margin-bottom: 10px !important;}"][ut_header align="left" title="Our Responsibility" title_color="#ffffff" lead_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475762719202{margin-bottom: 120px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Pixel Perfect" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475774174205{margin-bottom: 10px !important;}"][ut_header align="center" title="Our Approach" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="75" counter_color="#777777" desccolor="#444444" icon="fa fa-cubes" color="#444444"]Finished Projects[/ut_count_up][/vc_column_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="420" counter_color="#777777" desccolor="#444444" icon="fa fa-heart" color="#444444"]Happy Clients[/ut_count_up][/vc_column_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="24" counter_color="#777777" desccolor="#444444" icon="fa fa-umbrella" color="#444444"] Employee[/ut_count_up][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1475774771233{margin-bottom: 40px !important;}"][vc_column css=".vc_custom_1475533703277{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Proud to work with" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475764964452{margin-bottom: 10px !important;}"][ut_header align="left" title="Our Clients" css=".vc_custom_1475773552406{margin-bottom: 0px !important;}"]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][vc_column_inner width="1/2"][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="3544,3545,3546,3547,3548,3549" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476311658513{padding-top: 240px !important;padding-bottom: 240px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_column css=".vc_custom_1476122867830{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1476122824274{padding-top: 0px !important;}"][vc_custom_heading text="New demos each month" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476311542034{margin-bottom: 10px !important;}"][ut_header align="center" title="Join The Brooklyn Family" title_color="#ffffff" lead_color="#fafafa"]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="600" text_transform="capitalize" letter_spacing="2" button_text="Join Now" button_background="#ffffff" button_text_color="#333333" button_text_color_hover="#0070c9" button_background_hover="#ffffff" spacing="padding-bottom:8px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1470010711683{margin-bottom: 80px !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="New demos each month" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475677655713{margin-bottom: 10px !important;}"][ut_header align="center" title="No Run Of The Mill"]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][ut_service_icon_box animate_once="yes" icon="fa fa-desktop" headline="VISUAL COMPOSER" color="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff" hovercolor="#0070c9"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_service_icon_box icon="fa fa-clock-o" headline="1 CLICK DEMO IMPORTER" color="#0070c9" hovercolor="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="800"][ut_service_icon_box animate_once="yes" icon="fa fa-code" headline="FULLY CUSTOMIZABLE" color="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff" hovercolor="#0070c9"]All parts of Brooklyn can be customized. From header to footer and everything what’s in between.[/ut_service_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1476308404797{margin-bottom: 120px !important;background-color: #1b1d1f !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column width="1/2" css=".vc_custom_1475791604048{padding-top: 120px !important;padding-bottom: 80px !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="What we offer" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475766265963{margin-bottom: 10px !important;}"][ut_header title="Our Services" title_color="#ffffff" lead_color="#777777"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][ut_service_column animate_once="yes" icon="fa fa-desktop" headline="NEW DEMOS EACH MONTH" imageicon="306" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]We release each month new demos for our beloved Brooklyn![/ut_service_column][ut_service_column animate_once="yes" icon="fa fa-life-ring" headline="LIFETIME UPDATES" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]Brooklyn received continues updates, new features and new Demos. Since release we published around 50 updates![/ut_service_column][ut_service_column animate_once="yes" icon="fa fa-balance-scale" headline="OUR PROMISE" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]We’re here to make products that work! It’s a tall order, but we wouldn’t want to do anything else.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476309760169{padding-top: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" offset="vc_hidden-md vc_hidden-sm vc_hidden-xs" effect="fadeIn" delay_timer="400" animation_duration="4s"][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" delay_timer="200" effect="fadeIn"][vc_custom_heading text="what are you waiting for?" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475677673459{margin-bottom: 10px !important;}"][ut_header align="center" title="Our Offer For You"]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="continuous improvements" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="New Demos" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="unlimited possibilities" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="Power Elite Support" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475534176834{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #fafafa !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="You are in good company" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475679941920{margin-bottom: 10px !important;}"][ut_header align="center" title="Customers Voice"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_single_quote activate_rating="no" animate_once="yes" title="CUSTOMIZABILITY" author="Fmenossi" avatar="3415" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]Easy to install, work exatelly as expected. Best theme I ever had.[/ut_single_quote][ut_single_quote activate_rating="no" animate_once="yes" title="FLEXIBILITY" author="Illagraphics" avatar="3417" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]This theme is perfect for the project I’m working on. Its flexible and easy to use.[/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_single_quote activate_rating="no" animate_once="yes" title="CODE QUALITY" author="JRole" avatar="3416" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]It’s just so easy to use &amp; get fantastic results with very little knowledge.[/ut_single_quote][ut_single_quote activate_rating="no" animate_once="yes" title="CUSTOMER SUPPORT" author="Slidus" avatar="3418" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]Great theme and customer support! Purchased this theme more than once. [/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Crew Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_custom_heading text="We Love Web Design" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header title="Our Awesome Crew"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1476554285042{margin-bottom: 80px !important;}"][vc_column width="1/4"][ut_team_member align="left" name="HELMUT BROOKLYN" occupation="CEO " values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4223"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="HANS GLUECK" occupation="DESIGNER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4220"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="FRANK BROOKLYN" occupation="THE SON" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4217"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="ROBERT WOLFF" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4227"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="MAX BROOKLYN" occupation="THE BROTHER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4222"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="TITUS CRONOS" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4221"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="HELM BROOKLYN" occupation="THE NEPHEW" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4218"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="SAN RICHTER" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4219"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476554328358{margin-bottom: 0px !important;background-color: #0070c9 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Crew Detail Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1476554328358{margin-bottom: 0px !important;background-color: #0070c9 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][vc_row css=".vc_custom_1476555192549{margin-top: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header title="Helmut Brooklyn"]Hello, Im Helmut Brooklyn CEO at Brooklyn Designs.
[/ut_header][vc_column_text]<img class="alignleft size-medium wp-image-4223" src="" alt="team8" width="300" height="200" />Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="95" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="HTML" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="90" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="CSS" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="97" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="DESIGN" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="CONCEPT" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1475795383144{margin-bottom: 120px !important;background-color: #0070c9 !important;}"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475795445815{padding-top: 0px !important;}"][vc_custom_heading text="Get in touch with us" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="global" title="Contact"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ut_custom_shortcode][contact-form-7 id="334" title="contact"][/ut_custom_shortcode][/vc_column][vc_column width="1/3"][vc_custom_heading font_container="tag:h3|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]

I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

[/vc_column_text][vc_custom_heading font_container="tag:h3|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]

I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" border_color="#efefef" share_text_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column width="2/3"][ut_image_gallery thumbnail_size="large" gap="40" animate_once="yes" delay_animation="true" gallery="3349,3350,3352" effect="fadeIn"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711398804{margin-bottom: 10px !important;}"][ut_header title="Disc &amp; Cover Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/ut_header][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text_font_weight="bold" share_text="SHARE:" border="true" border_color="#efefef" icon_color="#999999" share_text_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711432773{margin-bottom: 10px !important;}"][ut_header title="Frame Decoration"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Interiors%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="3353" effect="fadeIn"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="3355,3357,3356,3354" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/6"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476140988444{margin-bottom: 10px !important;}"][ut_header title=" Jacks Hot Cup"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Jacks%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="4/6"][ut_image_gallery thumbnail_size="large" grid="3" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" effect="bounceInDown" gallery="3388,3390,3391,3392,3393,3394,3395,3396,3397"][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" image="3962" effect="fadeInUp" css=".vc_custom_1476273463358{margin-bottom: 0px !important;}"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470153837638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138631245{margin-bottom: 10px !important;}"][ut_header title="Right When You Need It"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="3369" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" css=".vc_custom_1476138622067{margin-bottom: 0px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138638508{margin-bottom: 10px !important;}"][ut_header align="center" title="Brilliantly Scratch-Resistant" title_color="#ffffff" lead_color="#777777" css=".vc_custom_1476138992142{margin-bottom: 40px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_gallery_slider lightbox="no" dots="false" effect_in="zoomIn" effect_out="zoomOut" slides="3372,3371,3374,3370,3373" arrow_color="#e5e5e5" arrow_color_hover="#ffffff" arrow_background_color="rgba(0,0,0,0.1)" dot_color="#ffffff" dot_color_hover="#3b66ac"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1476138814263{margin-bottom: 80px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #26292c !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138855159{margin-bottom: 10px !important;}"][ut_header align="center" title="Black Watch" title_color="#ffffff" css=".vc_custom_1476138999318{margin-bottom: 40px !important;}" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_image_gallery thumbnail_size="large" lightbox="no" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="3378,3376,3377" effect="zoomIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="3379" effect="zoomIn"][/vc_column][vc_column width="1/2"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Black%20Watch%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%20%22%2C%22description%22%3A%22Watch%20Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][vc_column_text]
<div class="lead">

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>
[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" icon_color="#999999" border_color="#efefef" share_text_color="#333333"][/vc_column][/vc_row]',
        ),        
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1476136718992{background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column width="2/3"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711499290{margin-bottom: 10px !important;}"][ut_header title="Brads"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brads%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="zoomIn" gallery="3926,3931,3932,3929,3927,3928" delay_timer="200"][ut_animated_image size="large" align="center" animate_once="yes" image="3910" effect="fadeIn"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476560602179{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561516207{padding-right: 40px !important;}" effect="zoomIn" delay_timer="600" animation_duration="2s"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560703936{margin-bottom: 10px !important;}"][ut_header title="Digital Watch"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561509214{margin-right: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476560558228{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561564919{margin-left: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561670190{padding-left: 40px !important;}" effect="zoomIn" animation_duration="2s" delay_timer="600"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560732454{margin-bottom: 10px !important;}"][ut_header title="Different Colors"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476561332610{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561678524{padding-right: 40px !important;}" effect="zoomIn" animation_duration="2s" delay_timer="600"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560727304{margin-bottom: 10px !important;}"][ut_header title="Ready for Duty"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561628825{margin-right: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][/vc_row]',            
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1475579619696{margin-bottom: 40px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272896179{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need "]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1475504692691{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3414" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3413" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475504672545{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272901735{margin-bottom: 10px !important;}"][ut_header align="left" title="Monitor Your Health"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1475587778598{margin-bottom: 120px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475504672545{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272906667{margin-bottom: 10px !important;}"][ut_header align="left" title="Stay Connected"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1476191129158{margin-bottom: 120px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272911456{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.[/ut_header][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3369" effect="zoomIn" css=".vc_custom_1475588265603{margin-bottom: 80px !important;}"][ut_social_share_bar share_text="SHARE:" share_text_color="#333333" icon_color="#999999" border="true" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="flipInX" gallery="3933,3936,3937,3938,3939,3940" delay_timer="200"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom"][vc_column width="2/3"][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476141522288{margin-bottom: 10px !important;}"][ut_header title="The Bklyn Guys"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22The%20Bklyn%20Guys%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22August%201%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Website%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fthemeforest.unitedthemes.com%252Fwpversions%252Fbrooklyn%252Fdemo15%252F%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333" description_link_color="#333333" description_link_hover_color="#0070c9"][/vc_column][/vc_row][vc_row full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1476201302319{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 9', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1475627812758{margin-bottom: 80px !important;}"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 9" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475627858252{margin-bottom: 10px !important;}"][ut_header title="Relaxing Car Drive"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd
gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="top" css=".vc_custom_1476560333625{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column bklyn_overlay="true" background_position="center bottom" css=".vc_custom_1476561334357{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" equal_height="yes" css=".vc_custom_1476560454124{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476561275197{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes"][vc_column bklyn_overlay="true" background_position="center center" css=".vc_custom_1476560868819{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476560983976{padding-top: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_row_inner animate_once="yes" effect="zoomIn" css=".vc_custom_1476405069540{padding-top: 0px !important;}"][vc_column_inner][vc_custom_heading text="EASY AND FAST INSTALLATION" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="center" title="So Intuitive, So Easy!" title_color="#ffffff" lead_color="#ffffff"]Join the Brooklyn family with over 22k Member![/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="500" text_transform="uppercase" letter_spacing="2" button_text="Purchase" button_text_color="#ffffff" button_text_color_hover="#333333" button_background="#0070c9" spacing="padding-bottom:8px" button_background_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 10', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 10" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476139325076{margin-bottom: 10px !important;}"][ut_header title="Brooklyn Interior"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="5/6"][ut_gallery_slider dots="false" slides="3385,3386,3384"][ut_social_share_bar share_text="SHARE:" border="true" icon_color="#999999" border_color="#efefef" share_text_color="#333333"][/vc_column][vc_column width="1/6"][ut_image_gallery thumbnail_size="medium" gap="40" animate_once="yes" delay_animation="true" gallery="3387,3386,3385" effect="zoomIn"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Magazine%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 11', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][ut_gallery_slider dots="false" effect_in="fadeIn" effect_out="fadeOut" slides="3363,3361,3360,3362" arrow_color="#333333" arrow_color_hover="#333333"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Portfolio Style 11" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711353151{margin-bottom: 10px !important;}"][ut_header title="Top Brand"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Top%20Brand%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#3b3d40"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#3b3d40" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 12', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="top"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" gallery="3950,3951,3952,3953,3954" effect="flipInX"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 12" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476256618888{margin-bottom: 10px !important;}"][ut_header title="Drawing"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr.
[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22United%20Themes%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        
        
        
        /* Demo 23 */
        array(
            'name'      => esc_html__( 'Demo 23 - Front Page', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section el_name="First Section"][vc_row effect="none"][vc_column][ut_header style="global" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="About Brooklyn." lead_accent_color="#333333" effect="none"]We\'re a creative agency located in <ins>Brooklyn, New York.</ins><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="Planning &amp; Strategy" icon_bklyn="BklynIcons-Office-Desk-2" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="Branding &amp; Design" icon_bklyn="BklynIcons-Blend-Tool" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="Web Design &amp; Development" icon_bklyn="BklynIcons-Computer-Network-2" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="APP Design &amp; Development" icon_bklyn="BklynIcons-Screen-Rotation" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="Online Marketing" icon_bklyn="BklynIcons-Pie-Chart-1" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" effect="none"][ut_service_column icon_type="bklynicons" headline="Maintenance &amp; Support" icon_bklyn="BklynIcons-Cloud-Database" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" delay="true" css=".vc_custom_1527947031500{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/11/contact-hero.jpg?id=6041) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.5)" effect="none" delay_timer="100"][vc_column css=".vc_custom_1527947040929{padding-top: 0px !important;}" effect="none"][ut_parallax_quote quotation_marks="no" icon_border_radius="19" cite_custom_border="yes" cite_border_width="2" quote_font_source="google" quote_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" quote_font_size="80" quote_line_height="80" quote_letter_spacing="-0.05" quote_text_transform="uppercase" cite_font_source="google" cite_google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" cite_font_size="12" cite_letter_spacing="0.05" revealfx="on" cite="2013 UNITED THEMES™" quote_color="#ffffff" cite_color="#ffffff" cite_border_color="rgba(255,255,255,0.3)" revealfx_color="#141618"]Passion leads to success[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section el_name="Team Section"][vc_row delay="true" effect="none"][vc_column][ut_header style="global" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="The Developer." lead_accent_color="#333333" effect="none" delay_timer="50" delay_timer_lead="100"]We believe in a diverse range of personel to bring creative skills,<br />
thoughts, and ideas to the table.<br />
[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/3" delay="true" effect="none" delay_timer="150"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="John Brooklyn" avatar="8056" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#333333" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-1%2F|||" line_color="#efefef" ocupation_color="#999999" icon_color_hover="rgba(51,51,51,0.5)" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3" delay="true" effect="none" delay_timer="200"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Dwayne Smith" avatar="8056" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#999999" line_color="#efefef" icon_color="#333333" icon_color_hover="rgba(51,51,51,0.5)" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-2%2F|||" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3" delay="true" effect="none" delay_timer="250"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Ruben Lorenz" avatar="8056" occupation="SUPPORT GURU" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#999999" icon_color="#333333" icon_color_hover="rgba(51,51,51,0.5)" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-3%2F|||" line_color="#efefef" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527729513163{background-color: #fafafa !important;}" el_name="Service Section"][vc_row][vc_column][ut_header style="global" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="Our Services." lead_accent_color="#333333" effect="none" delay_timer="50" delay_timer_lead="100"]We realize that your competition is always just a click away and creating a professional,<br />
informative and easy-to-use website, on your budget, is our main goal.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" animate_once="no" delay="true" effect="none" image="6141" delay_timer="200"][/vc_column][/vc_row][vc_row animate_once="no" delay="true" effect="none" delay_timer="200"][vc_column width="1/3"][ut_service_column icon_type="bklynicons" headline="Custom Website Design" effect="none" icon_bklyn="BklynIcons-Monitor-1" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="bklynicons" headline="E-Commerce" effect="none" headline_margin_bottom="10px" icon_bklyn="BklynIcons-Box-1"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="bklynicons" headline="Social Media Marketing" effect="none" icon_bklyn="BklynIcons-Increasing-Chart-1" headline_margin_bottom="10px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row css=".vc_custom_1527947536253{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #151515 !important;}"][vc_column effect="none"][ut_fancy_link font_weight="" letter_spacing="-0.01" link_color="#ffffff" line_color="rgba(255,255,255,0)" url="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/contact/" line_hover_color="rgba(255,255,255,0.01)" link_hover_color="rgba(255,255,255,0.7)"]Let’s Talk About Your Project[/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section el_name="Portfolio Section"][vc_row effect="fadeIn"][vc_column][ut_header style="global" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="Our Work." lead_accent_color="#333333" effect="none" delay_timer="50" delay_timer_lead="100"]We believe our work speaks for itself. Browse our most recent projects below<br />
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_custom_shortcode][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column][/vc_row][/vc_section][vc_section el_name="Client Section"][vc_row effect="none"][vc_column][ut_header align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="Growing Clients." lead_accent_color="#333333" effect="none" delay_timer="50" delay_timer_lead="100"]The comments below are just a sample of the 30.000 clients worldwide<br />
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column][ut_qtrotator_2 quote_custom_font="yes" origin_font_weight="600" delay="true" arrow_color="#151515" arrow_color_hover="rgba(21,21,21,0.5)" quote_font="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" quote_color="#666666" origin_color="#999999" effect="none" delay_timer="150" quote_font_size="16px"][ut_qt_2 avatar="8056" author="John Areus" origin="BROOKLYN CUSTOMER"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 avatar="8056" author="Ron Schmidt" origin="BROOKLYN CUSTOMER"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point. Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 avatar="8056" author="Henrik Schwarz" origin="BROOKLYN CUSTOMER"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="custom" grid="5" gap="20" external_link="yes" image_opacity="70" animate="false" gallery="8056,8057,8058,8059,8060" css=".vc_custom_1537539999440{border-top-width: 2px !important;padding-top: 40px !important;border-top-color: #efefef !important;border-top-style: solid !important;}" thumbnail_custom_width="100px" thumbnail_custom_height="36px"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1537296121459{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/fuse-brussels-273772-unsplash.jpg?id=7060) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(to top, #ffffff 25%, transparent 100%)"][vc_row][vc_column][ut_header style="global" align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" delay="true" title="Get Connected." css=".vc_custom_1537295473680{margin-bottom: 60px !important;}" effect="none" delay_timer="50" delay_timer_lead="100"]We welcome you to contact us for more information<br />
about any of our products or services.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon icon_size="50" title_text_transform="capitalize" slogan_font_weight="600" slogan_letter_spacing="0.06" slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_color="#ffffff" title_color="#333333" icon_hover_color="#ffffff" slogan_color="#999999" link="url:%23|||" icon_background="#833ab4" icon_hover_background="#333333"][/vc_column][vc_column width="1/4"][ut_big_icon icon_size="50" title_text_transform="capitalize" slogan_font_weight="600" slogan_letter_spacing="0.06" slogan_text_transform="uppercase" icon="fa fa-youtube" title="YouTube" slogan="View Exclusive Videos" icon_color="#ffffff" title_color="#333333" icon_hover_color="#ffffff" slogan_color="#999999" link="url:%23|||" icon_background="#ff0000" icon_hover_background="#333333"][/vc_column][vc_column width="1/4"][ut_big_icon icon_size="50" title_text_transform="capitalize" slogan_font_weight="600" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan="Follow us on Twitter" icon_color="#ffffff" title_color="#333333" slogan_color="#999999" icon_hover_color="#ffffff" link="url:%23|||" icon_background="#1da1f2" icon_hover_background="#333333"][/vc_column][vc_column width="1/4"][ut_big_icon icon_size="50" title_text_transform="capitalize" slogan_font_weight="600" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_color="#ffffff" title_color="#333333" icon_hover_color="#ffffff" slogan_color="#999999" link="url:%23|||" icon_background="#3b5998" icon_hover_background="#333333"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        array(
            'name'      => esc_html__( 'Demo 23 -  Work Page 1 (needs Portfolio Shortcode)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Selected Works."]We believe your website should be as unique as you are.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1478303894729{margin-bottom: -1px !important;}"][vc_column][ut_showcase_shortcode showcase_id="4642"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="top"][vc_column width="1/3"][ut_custom_heading tag="h2"]Fantastic projects from<br />
mobile to desktop.[/ut_custom_heading][/vc_column][vc_column width="1/3"][ut_number_counter caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" to="99" suffix="%" counter_color="#333333" desccolor="#999999"]Pixel Perfect[/ut_number_counter][/vc_column][vc_column width="1/3"][ut_custom_heading tag="div" color="#999999"]Brooklyn’s roots are founded in groundbreaking design and it continues to push the boundaries of what is possible with great design and WordPress. [/ut_custom_heading][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="custom" grid="5" gap="40" lightbox="no" image_opacity="70" delay_animation="true" gallery="8060,8059,8058,8057,8056" effect="zoomIn" thumbnail_custom_width="100px" thumbnail_custom_height="36px"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" background_position="center center" section_separator_bottom="true" section_separator_svg_bottom="diagonal" section_separator_bottom_height_px="80" section_separator_bottom_height_unit="px" css=".vc_custom_1537236916508{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/dan-freeman-401296-unsplash.jpg?id=6992) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgb(41, 72, 255) 100%)" section_separator_bottom_color_1="#141618"][vc_row background_position="center center" background_attachment="fixed" css=".vc_custom_1526518180721{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column effect="fadeIn"][ut_header align="global" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" title="Get Connected." css=".vc_custom_1537236431585{margin-bottom: 60px !important;}" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information<br />
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="600" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan="Follow us on Twitter" icon_color="#ffffff" title_color="#ffffff" slogan_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="600" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="600" slogan_letter_spacing="0.05" slogan_text_transform="uppercase" icon="fa fa-youtube" title="YouTube" slogan="View Exclusive Videos" icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff" link="url:%23|||"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="600" slogan_letter_spacing="0.06" slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff" link="url:%23|||"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - About Page 1', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title="WE\'RE CREATIVE." lead_accent_color="#333333"]We\'re a creative agency located in <b>Brooklyn, New York.</b><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row el_name="Progress Bars"][vc_column width="1/2" offset="vc_col-lg-offset-3 vc_col-lg-6"][ut_probar size="small" width="94" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="Web Development" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" info_color="#333333" css=".vc_custom_1537225957434{margin-bottom: 20px !important;}"][ut_probar size="small" width="85" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="UI/UX Design" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" info_color="#333333" css=".vc_custom_1537225972267{margin-bottom: 20px !important;}"][ut_probar size="small" width="90" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="App Development" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" info_color="#333333"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1526479281480{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="What We Do."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-display" headline="Web Design &amp; Development" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-software-paintroller" headline="Branding &amp; Design" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-ecommerce-diamond" headline="Consulting" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-lightbulb" headline="E-Commerce" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-target" headline="Online Marketing" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-headset" headline="Maintenance &amp; Support" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row][vc_column][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Start Project" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color="#ffffff" button_background="#2948ff" button_text_color_hover="#ffffff" button_background_hover="#333333" button_link="url:%23|||"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527369956491{padding-top: 0px !important;padding-bottom: 0px !important;}" el_name="Padding top / bottom 0"][vc_row full_width="stretch_row_content_no_spaces" el_name="Modules margin bottom 0"][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8060" name="John Brooklyn" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" css=".vc_custom_1537540336990{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8058" name="Dwayne Smith" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" css=".vc_custom_1537540344281{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8057" name="Ruben Lorenz" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" css=".vc_custom_1537540351517{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8057" name="Billy Bob" occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" css=".vc_custom_1537540359241{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - About Page 2', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1537226996658{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="BROOKLYN<br />
WEB AGENCY." lead_accent_color="#333333"]We\'re a creative agency located in <b>Brooklyn, New York.</b><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle" el_name="Equal height / middle"][vc_column width="1/2" effect="fadeIn"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" title="Our Mission." lead_accent_color="#333333" css=".vc_custom_1537226330472{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Learn More" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color="#ffffff" button_background="#2948ff" button_text_color_hover="#ffffff" button_background_hover="#333333"][/vc_column][vc_column width="1/2"][ut_animated_image size="full" align="center" image="6711"][/vc_column][/vc_row][/vc_section][vc_section el_name="Padding top / bottom 0" css=".vc_custom_1527529509344{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="The Developer."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8057" name="John Brooklyn" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8057" name="Dwayne Smith" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8057" name="Ruben Lorenz" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="17" avatar="8057" name="Billy Bob" occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="What We Do."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-display" headline="Web Development" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-software-paintroller" headline="Branding" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-ecommerce-diamond" headline="Consulting" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-lightbulb" headline="Brand &amp; Identity" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-target" headline="Marketing" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-headset" headline="Premium Support" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1537234926234{padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/09/work-hero-2.jpg?id=7596) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)"][vc_row][vc_column add_box_shadow="true" css=".vc_custom_1537226450442{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;border-radius: 15px !important;}" shadow_color="rgba(0,0,0,0.1)" offset="vc_col-lg-offset-2 vc_col-lg-8"][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Get Started." title_color="#ffffff" lead_color="#ffffff" css=".vc_custom_1537226433652{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_size="16" button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Let’s Get Started" button_link="url:%23|||" button_text_color="#ffffff" button_background="#2948ff" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#333333" button_background_hover="#ffffff"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - About Page 3', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="WHAT WE DO." lead_accent_color="#333333"]We\'re a creative agency located in <b>Brooklyn, New York.</b><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-display" headline="Web Development" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-software-paintroller" headline="Branding" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-ecommerce-diamond" headline="Consulting" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-lightbulb" headline="Brand & Identity" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-target" headline="Marketing" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="30" icon_linea="icon-basic-headset" headline="Premium Support" headline_margin_bottom="10px"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1537229254449{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/11/contact-hero.jpg?id=6041) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Our Achievements." title_color="#ffffff" lead_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1527696556921{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;border-radius: 15px !important;}"][ut_number_counter icon_font_size="45" icon_spacing="20" caption_text_transform="uppercase" caption_font_weight="600" caption_font_size="14" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" counter_font_size="45" to="88" counter_color="#ffffff" desccolor="rgba(255, 255, 255, 0.8)" icon_bklyn="BklynIcons-Cup-2" color="#ffffff"]Awards Won[/ut_number_counter][/vc_column][vc_column width="1/3" css=".vc_custom_1527696618355{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;border-radius: 15px !important;}"][ut_number_counter icon_font_size="45" icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="600" caption_font_size="14" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" counter_font_size="45" to="30000" counter_color="#ffffff" sep_sign="." desccolor="rgba(255, 255, 255, 0.8)" icon_bklyn="BklynIcons-Lamp-2" color="#ffffff"]Satisfied Clients[/ut_number_counter][/vc_column][vc_column width="1/3" css=".vc_custom_1527696626146{background-color: rgba(255, 255, 255, 0.1) !important;*background-color: rgba(255,255, 255, 0.1) !important;border-radius: 15px !important;}"][ut_number_counter icon_font_size="45" icon_spacing="20" caption_text_transform="uppercase" caption_font_weight="600" caption_font_size="14" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" counter_font_size="45" to="100" counter_color="#ffffff" desccolor="rgba(255, 255, 255, 0.8)" icon_bklyn="BklynIcons-Delivery" color="#ffffff"]Free Updates[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section el_name="Padding top / bottom 0"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="The Team."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member occupation_spacing_bottom="10" style="member-style-2" avatar_size="200" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="John Brooklyn" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="8058" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member occupation_spacing_bottom="10" style="member-style-2" avatar_size="200" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Dwayne Smith" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="8057" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member occupation_spacing_bottom="10" style="member-style-2" avatar_size="200" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Ruben Lorenz" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="8057" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1537228253254{padding-top: 160px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/09/selfmade-hero-brooklyn.jpg?id=7484) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="transparent"][vc_row el_name="Padding top 80 / bottom 40"][vc_column add_box_shadow="true" css=".vc_custom_1527611876895{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #ffffff !important;border-radius: 15px !important;}" shadow_color="rgba(0,0,0,0.1)"][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Get Started."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn_group align="center"][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_size="16" button_size="bklyn-btn-normal" button_border_radius="50" button_custom_border="yes" button_border_width="2" font_family="inherit" font_weight="600" text_transform="uppercase" letter_spacing="0.05" button_text="Gest Started" button_link="url:%23|||" button_text_color="#ffffff" button_background="#2948ff" button_border_color="#2948ff" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" button_border_color_hover="#333333"][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_size="16" button_size="bklyn-btn-normal" button_border_radius="50" button_custom_border="yes" button_border_width="2" font_family="inherit" font_weight="600" text_transform="uppercase" letter_spacing="0.05" button_text="Learn More" button_link="url:%23|||" button_text_color="#333333" button_background="#ffffff" button_border_color="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333"][/ut_btn_group][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Contact Page 1 (needs Contact Form)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="CONTACT US." lead_accent_color="#333333"]We welcome you to <b>contact us</b> for more<br />
information about any of our products or services.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_c7_shortcode form_id="5"][/vc_column][vc_column width="1/2"][ut_service_column_vertical icon_type="lineaicons" shape="round" headline="Call us" css=".vc_custom_1537311997731{margin-bottom: 60px !important;}" icon_linea="icon-basic-headset" svg_color="#ffffff" headline_margin_bottom="10px"]1-8456-563-BKLYN[/ut_service_column_vertical][ut_service_column_vertical icon_type="lineaicons" shape="round" headline="Mail us" css=".vc_custom_1537312006789{margin-bottom: 60px !important;}" icon_linea="icon-basic-mail-multiple" svg_color="#ffffff" headline_margin_bottom="10px"]contact@email.com[/ut_service_column_vertical][ut_service_column_vertical icon_type="lineaicons" shape="round" headline="Visit us" css=".vc_custom_1537312012417{margin-bottom: 60px !important;}" icon_linea="icon-basic-signs" svg_color="#ffffff" headline_margin_bottom="10px"]1399 Beverley Rd<br />
Brooklyn, NY 11218[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Contact Page 2 (needs Contact Form & Google Maps API)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="DROP US A LINE." lead_accent_color="#333333"]We welcome you to <b>contact us</b> for more<br />
information about any of our products or services.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="5/12"][ut_c7_shortcode form_id="5"][/vc_column][vc_column width="7/12"][ut_google_maps theme="ultralight" zoom="14" map_height="25" map_height_tablet="50" map_height_mobile="50" marker="7140"]Brooklyn, NY[/ut_google_maps][vc_row_inner equal_height="yes" content_placement="bottom" css=".vc_custom_1527719519696{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_custom_heading tag="h3" css=".vc_custom_1537312328057{margin-bottom: 10px !important;}"]Web Agency Brooklyn[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][ut_custom_heading tag="h3" css=".vc_custom_1537312320467{margin-bottom: 10px !important;}"]Address[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Contact Page 3 (needs Contact Form & Google Maps API)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="DROP US A LINE." lead_accent_color="#333333"]We welcome you to <b>contact us</b> for more<br />
information about any of our products or services.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="5/12"][ut_c7_shortcode form_id="5"][/vc_column][vc_column width="7/12"][ut_google_maps theme="ultralight" zoom="14" map_height="25" map_height_tablet="50" map_height_mobile="50" marker="7140"]Brooklyn, NY[/ut_google_maps][vc_row_inner equal_height="yes" content_placement="bottom" css=".vc_custom_1527719519696{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_custom_heading tag="h3" css=".vc_custom_1537312328057{margin-bottom: 10px !important;}"]Web Agency Brooklyn[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][ut_custom_heading tag="h3" css=".vc_custom_1537312320467{margin-bottom: 10px !important;}"]Address[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (Cap Mock-Up)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Cap Mock-Up"]Advanced, easy to edit mockup. It contains everything you need to create a realistic look of your project.<br />
Guarantees the a good look for bright and dark designs and perfect fit to the shape.<br />
Easy to navigate, well described layers, friendly help file.[/ut_header][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_image_gallery thumbnail_size="large" grid="2" caption="yes" caption_content="plus" delay_animation="true" caption_font_weight="" gallery="5409,5411" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" effect="fadeInUp"][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Endless Possibilities"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag &amp; Drop or use shortcodes. It’s up to you!<br />
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1527345449341{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/p5-1-2.jpg?id=5405) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours &amp; Styles within minutes.<br />
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1496785493080{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/p5-3-1.jpg?id=5407) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Thank You" css=".vc_custom_1494726690801{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers,<br />
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_custom_heading tag="h3"]Overview[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>
<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Clients%20Name%22%7D%2C%7B%22title%22%3A%22YEAR%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Prokect%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" description_color="#999999"][/vc_column_inner][vc_column_inner width="1/2"][ut_image_gallery thumbnail_size="medium" grid="2" caption="yes" delay_animation="true" caption_font_weight="" gallery="5408,5407,5406,5405" effect="zoomIn" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#333333" icon_color="#999999" border_color="#efefef" icon_color_hover="#333333"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (Juice Smoothie)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Psd Juice Smoothie<br />
Bottle Mockup"]This is a set of psd smoothie juice bottle mockup to let you display<br />
any kind of juice, smoothie or milk based product designs. [/ut_header][/vc_column][/vc_row][vc_row effect="fadeIn"][vc_column][vc_row_inner][vc_column_inner][ut_gallery_slider autoplay="true" hover_color_opacity="0" effect_in="fadeIn" effect_out="fadeOut" slides="6349,6350,6351" hover_color="transparent" arrow_color="#ffffff" arrow_background_color="#2948ff" max_icon_color="#ffffff" max_icon_bg_color="#2948ff"][/vc_column_inner][vc_column_inner offset="vc_col-lg-12"][ut_image_gallery thumbnail_size="medium" grid="3" gap="40" caption="yes" delay_animation="true" caption_font_weight="" gallery="6351,6350,6349" effect="fadeIn" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" delay_timer="50"][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Clients%20Name%22%7D%2C%7B%22title%22%3A%22YEAR%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" description_color="#999999"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_custom_heading tag="h3"]Features[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][ut_custom_heading tag="h3"]Four Plastic Container[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#999999" border_color="#efefef" icon_color_hover="#333333"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (Logos & Badges)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527373654013{background-color: #fafafa !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Trendy Vintage<br />
Logos &amp; Badges"]16 Logos, badges and insignias ready to use, fully editable.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption="yes" delay_animation="true" caption_font_weight="" gallery="6237,6238,6239,6240,6241,6236" effect="fadeInUp" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" delay_timer="50"][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Clients%20Name%22%7D%2C%7B%22title%22%3A%22YEAR%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" description_color="#999999"][ut_social_share_bar align="center" share_text="SHARE:" icon_color="#999999" icon_color_hover="#333333"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (iPad Air 2)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column width="1/2"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Psd iPad Air 2 Smart Cover"]This is a great way to offer a sneak peak or teaser of a tablet design project.[/ut_header][vc_row_inner css=".vc_custom_1527343197186{margin-top: 0px !important;}"][vc_column_inner][ut_custom_heading tag="h3"]Overview[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
<p>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>
<p>Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1527343341357{margin-top: 0px !important;}"][vc_column_inner][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Clients%20Name%22%7D%2C%7B%22title%22%3A%22YEAR%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" description_color="#999999"][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#999999" border_color="#efefef" icon_color_hover="#333333"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" gap="40" caption="yes" delay_animation="true" caption_font_weight="" gallery="6310,6311,6312" effect="fadeInUp" delay_timer="50" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (iPhone X Dock)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="5/12" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Stunning mockup of an iPhone X &amp; dock."]Smart object drag &amp; drop features make this product easy to use.[/ut_header][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#333333" icon_color="#999999" border_color="#efefef" icon_color_hover="#333333"][/vc_column][vc_column width="7/12" css=".vc_custom_1496752703814{padding-top: 0px !important;}"][ut_animated_image size="full" align="center" image="6335" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" lightbox_size="full_hd" caption="yes" caption_content="plus" delay_animation="true" caption_font_weight="" gallery="6340,6341,6339" effect="zoomIn" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" delay_timer="50"][/vc_column][/vc_row][vc_row][vc_column][ut_custom_heading tag="h3"]Overview[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22Compatibility%22%2C%22description%22%3A%22Photoshop%20%2F%20Sketch%22%7D%2C%7B%22title%22%3A%22Size%22%2C%22description%22%3A%22111.2%20MB%22%7D%2C%7B%22title%22%3A%22Files%22%2C%22description%22%3A%221%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%5D" description_color="#999999"][/vc_column_inner][vc_column_inner width="1/2"][ut_social_share_bar align="right" share_text="SHARE:" share_text_color="#333333" icon_color="#999999" icon_color_hover="#333333"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Item Page (iPhone X Mockups)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="iPhone X Mockups"]30 Fully editable iPhone X Mockups designed in Photoshop.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Clients%20Name%22%7D%2C%7B%22title%22%3A%22YEAR%3A%22%2C%22description%22%3A%222018%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" description_color="#999999"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" gap="40" caption="yes" delay_animation="true" caption_font_weight="" gallery="6331,6330,6329" effect="fadeInUp" delay_timer="50" caption_color="#ffffff" caption_background="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)"][/vc_column][/vc_row][vc_row][vc_column][ut_custom_heading tag="h3"]Overview[/ut_custom_heading][vc_row_inner css=".vc_custom_1527351537597{margin-top: 0px !important;}"][vc_column_inner width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#999999" border_color="#efefef" icon_color_hover="#333333"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Service Page 1', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="WHAT WE DO BEST." lead_accent_color="#333333"]Our quality standards apply also in terms of service,<br />
technical expertise and advice. [/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="What We Do Best."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="25" headline="Web Development" icon_linea="icon-basic-display"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="25" headline="Creative Design" icon_linea="icon-basic-lightbulb"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_type="lineaicons" icon_margin_bottom="25" headline="Customer Service" icon_linea="icon-basic-headset"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527697618094{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Choose Your Plan."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="bold" letter_spacing="0.05" price_font_size="50" features="%5B%7B%22feature%22%3A%22%3Cb%3E1%3C%2Fb%3E%20Free%20Domain(s)%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E1GB%3C%2Fb%3E%20Storage%20Space%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E1%3C%2Fb%3E%20My%20SQL%20Database%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E10GB%3C%2Fb%3E%20Monthly%20Bandwidth%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E50%3C%2Fb%3E%20Email%20Accounts%22%7D%5D" headline="Starter" price="29" currency="$" period="per month" button_text="Buy Now" button_link="url:%23|||" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" price_font_color="#333333" image="7059"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="bold" letter_spacing="0.05" price_font_size="50" features="%5B%7B%22feature%22%3A%22%3Cb%3E25%3C%2Fb%3E%20Free%20Domain(s)%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E25GB%3C%2Fb%3E%20Storage%20Space%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E25%3C%2Fb%3E%20My%20SQL%20Database%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E250GB%3C%2Fb%3E%20Monthly%20Bandwidth%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E250%3C%2Fb%3E%20Email%20Accounts%22%7D%5D" headline="Professional" price="49" currency="$" period="per month" button_text="Buy Now" button_link="url:%23|||" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" price_font_color="#333333" image="7058"][/vc_column][vc_column width="1/3"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="bold" letter_spacing="0.05" price_font_size="50" features="%5B%7B%22feature%22%3A%22%3Cb%3EUnlimited%3C%2Fb%3E%20Domain(s)%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EUnlimited%20GB%3C%2Fb%3E%20Storage%20Space%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EUnlimited%3C%2Fb%3E%20My%20SQL%20Database%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EUnlimited%20GB%3C%2Fb%3E%20Monthly%20Bandwidth%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EUnlimited%3C%2Fb%3E%20Email%20Accounts%22%7D%5D" headline="Enterprise" price="89" currency="$" period="per month" button_text="Buy Now" button_link="url:%23|||" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" price_font_color="#333333" image="7060"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="What They Said."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_single_quote style="style-2" title_spacing="20" rating="5" author_spacing="5" company_spacing="5" author_font_weight="600" author_letter_spacing="-0.01" company_font_weight="600" company_letter_spacing="0.05" avatar="8057" title="Customer Support" author="Dori84" company="BROOKLYN USER" author_color="#333333" company_color="#999999" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box.[/ut_single_quote][/vc_column][vc_column width="1/3"][ut_single_quote style="style-2" title_spacing="20" rating="5" author_spacing="5" company_spacing="5" author_font_weight="600" author_letter_spacing="-0.01" company_font_weight="600" company_letter_spacing="0.05" avatar="8056" title="Customizability" author="Arppa43" company="BROOKLYN USER" company_color="#999999" rating_color="#fec42d" author_color="#333333"]Simply perfect. The Brooklyn theme has a great variety of customization and is fairly easy to work on even with limited/non-existent knowledge on coding.[/ut_single_quote][/vc_column][vc_column width="1/3"][ut_single_quote style="style-2" title_spacing="20" rating="5" author_spacing="5" company_spacing="5" author_font_weight="600" author_letter_spacing="-0.01" company_font_weight="600" company_letter_spacing="0.05" avatar="8057" title="Design Quality" author="DerMoki" company="BROOKLYN USER" author_color="#333333" rating_color="#fec42d" company_color="#999999"]This is the best Theme I have ever used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content![/ut_single_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" parallax="content-moving" css=".vc_custom_1527698911718{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/dan-freeman-401296-unsplash.jpg?id=6992) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="30.000 Users Worldwide." title_color="#ffffff" lead_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="custom" grid="5" lightbox="no" lazy="false" delay_animation="true" gallery="8060,8059,8058,8057,8056" thumbnail_custom_width="200" thumbnail_custom_height="85" delay_timer="50" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Let\'s Work Together." lead_accent_color="#333333"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Get Started" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_link="url:%23|||"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Service Page 2', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527692296082{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1537291793884{padding-top: 120px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="75" title="Brand &amp; Identity." lead_accent_color="#333333" css=".vc_custom_1537291370938{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Learn More" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff"][/vc_column][vc_column width="1/2" bklyn_overlay="true" css=".vc_custom_1537291800376{padding-top: 340px !important;padding-right: 20px !important;padding-bottom: 340px !important;padding-left: 20px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/nik-macmillan-280300-unsplash.jpg?id=6699) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" counter_font_size="100" to="99" suffix="%" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff" css=".vc_custom_1537291737404{margin-bottom: 0px !important;}"]Custom Text[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527692784884{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #fafafa !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" distortion="on" distortion_ease="Power2.easeOut" early_distortion_effect="on" bklyn_overlay="true" css=".vc_custom_1537541205201{padding-top: 340px !important;padding-right: 20px !important;padding-bottom: 340px !important;padding-left: 20px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/rawpixel-196509-unsplash.jpg?id=6755) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)" background_distortion_1="6755" background_distortion_2="6992"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" counter_font_size="100" to="88" suffix="%" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff" css=".vc_custom_1537291676746{margin-bottom: 0px !important;}"]Custom Text[/ut_number_counter][/vc_column][vc_column width="1/2" css=".vc_custom_1537291832142{padding-top: 120px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="75" title="Web Development." lead_accent_color="#333333" css=".vc_custom_1527697349466{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][ut_btn button_add_icon="yes" button_icon_type="fontawesome" button_icon_size="16" button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Learn More" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527692296082{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1537291836991{padding-top: 120px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="75" title="Social Media." lead_accent_color="#333333" css=".vc_custom_1537291378664{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Learn More" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff"][/vc_column][vc_column width="1/2" bklyn_overlay="true" css=".vc_custom_1537291841325{padding-top: 340px !important;padding-right: 20px !important;padding-bottom: 340px !important;padding-left: 20px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/05/rawpixel-552390-unsplash.jpg?id=6718) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20, 22, 24, 0.65)"][ut_number_counter sep="true" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" counter_font_size="100" to="100" suffix="%" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff" css=".vc_custom_1537291724458{margin-bottom: 0px !important;}"]Custom Text[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1537231549260{background-color: linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%) !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="50" title="Let\'s Work Together." lead_accent_color="#ffffff" title_color="#ffffff" lead_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.<br />
[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" button_custom_border="yes" button_border_width="2" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Start a Project" button_background_hover="transparent" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_text_color="#333333" button_background="#ffffff" button_link="url:%23|||" button_border_color="#ffffff" button_border_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        
        array(
            'name'      => esc_html__( 'Demo 23 - Service Page 3', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="99" font_size="100" line_height="100" title_letter_spacing="-0.04" title="10 YEARS EXPERIENCE." lead_accent_color="#333333"]Our quality standards apply also in<br />
terms of service, technical expertise and advice. [/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row effect="fadeIn"][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Retina Ready &amp; Responsive" icon_linea="icon-basic-picture-multiple"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="One Click Demo Installer" icon_linea="icon-basic-download"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Drag &amp; Drop Page Builder" icon_linea="icon-basic-mouse"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row effect="fadeIn"][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="40+ Demos" icon_linea="icon-software-layers2"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Unlimited Design Options" icon_linea="icon-basic-gear"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Easy Hero Management" icon_linea="icon-basic-display"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row effect="fadeIn"][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="250+ Predefined Page Layouts" icon_linea="icon-basic-sheet-multiple"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Amazing Customer Support" icon_linea="icon-basic-headset"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column icon_type="lineaicons" size="medium" headline="Free Content Updates" icon_linea="icon-basic-lightbulb"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1537541494672{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2018/09/2.jpg?id=8057) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" effect="fadeIn"][vc_column][ut_qtrotator_2 arrow_color="#ffffff" name_color="#ffffff" quote_color="#ffffff" origin_color="#ffffff" arrow_color_hover="rgba(255,255,255,0.7)"][ut_qt_2 author="Ron Schmidt" origin="Brooklyn Customer"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point. Really looking forward to the upcoming demos, United Themes, you guys do a great job!”<br />
[/ut_qt_2][ut_qt_2 author="John Areus" origin="Brooklyn Customer"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”<br />
[/ut_qt_2][ut_qt_2 author="Henrik Schwarz" origin="Brooklyn Customer"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”<br />
[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_width="50" title="Get Started."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Start a Project" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Page 1', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="ALL-STAR-TEAM." lead_accent_color="#333333"]We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527692878977{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" effect="fadeIn"][vc_column width="1/2" css=".vc_custom_1537366179868{padding-top: 120px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="John Brooklyn" lead_accent_color="#151515" css=".vc_custom_1537376515700{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="About Me" button_text_color="#ffffff" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.7em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" button_link="url:%23|||"][ut_social_follow align="center" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][vc_column width="1/2" distortion="on" distortion_effect="8" distortion_ease="Power2.easeOut" early_distortion_effect="on" background_position="center center" css=".vc_custom_1537541835319{padding-top: 340px !important;padding-right: 20px !important;padding-bottom: 340px !important;padding-left: 20px !important;}" background_distortion_1="8056" background_distortion_2="8057"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527693142573{padding-top: 0px !important;padding-bottom: 0px !important;background-color: #fafafa !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" effect="fadeIn"][vc_column width="1/2" distortion="on" distortion_effect="8" distortion_ease="Power2.easeOut" early_distortion_effect="on" background_position="center top" css=".vc_custom_1537541851953{padding-top: 340px !important;padding-right: 20px !important;padding-bottom: 340px !important;padding-left: 20px !important;}" background_distortion_1="8056" background_distortion_2="8056"][/vc_column][vc_column width="1/2" css=".vc_custom_1537366227158{padding-top: 120px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Dwayne Smith" lead_accent_color="#151515" css=".vc_custom_1537376556103{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="About Me" button_text_color="#ffffff" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.7em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" button_link="url:%23|||"][ut_social_follow align="center" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="20" avatar="8057" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="John Brooklyn" occupation="FOUNDER" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999" avatar_alternate="8057"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="20" avatar="8056" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="Ruben Lorenz" occupation="CODER" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="20" avatar="8057" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="Billy Bob" occupation="SUPPORT" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527512165230{background-color: #Fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Let\'s Work Together." lead_accent_color="#151515" css=".vc_custom_1537376529844{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br />
eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Get Started" button_text_color="#ffffff" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_text_color_hover="#ffffff" button_background_hover="#333333" button_link="url:%23|||"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Page 2', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="ALL-STAR-TEAM." lead_accent_color="#333333"]We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row effect="fadeIn"][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="John Brooklyn" occupation="FOUNDER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8056" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-1%2F|||" avatar_alternate="8057"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Dwayne Smith" occupation="DESIGNER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8057" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-2%2F|||" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Ruben Lorenz" occupation="CODER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8057" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-3%2F|||" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Billy Bob" occupation="SUPPORT" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8056" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-1%2F|||" avatar_alternate="8057"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row effect="fadeIn"][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Billy Bob" occupation="SUPPORT" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8056" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-1%2F|||" avatar_alternate="8057"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Ruben Lorenz" occupation="CODER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8057" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-3%2F|||" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Dwayne Smith" occupation="DESIGNER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8057" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-2%2F|||" avatar_alternate="8056"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member swap_avatar="on" occupation_spacing_bottom="10" align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="John Brooklyn" occupation="FOUNDER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" avatar="8056" ocupation_color="#999999" icon_color_hover="#999999" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo23%2Fteam-single-page-1%2F|||" avatar_alternate="8057"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section][vc_row css=".vc_custom_1527686648513{background-color: #fafafa !important;}"][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Start your project with us." lead_accent_color="#151515" css=".vc_custom_1537376938071{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,             sed diam nonumy<br />eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Get Started" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em" button_link="url:%23|||"][/vc_column][/vc_row][vc_row css=".vc_custom_1537378303137{margin-bottom: 0px !important;background-color: linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%) !important;}" effect="none"][vc_column width="1/4" effect="fadeIn" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Call Now" headline_margin_bottom="0px" icon_linea="icon-basic-headset" svg_color="#ffffff"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" effect="fadeIn" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="1399 Beverly Rd" headline_margin_bottom="0px" icon_linea="icon-basic-signs" svg_color="#ffffff"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" effect="fadeIn" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Mon - Sat" headline_margin_bottom="0px" icon_linea="icon-basic-clock" svg_color="#ffffff"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" effect="fadeIn" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Mail Us" headline_margin_bottom="0px" icon_linea="icon-basic-mail-multiple" svg_color="#ffffff"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]</p',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Page 3', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section css=".vc_custom_1527694031773{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" font_size="100" line_height="100" title_letter_spacing="-0.04" title="WE CREATE AMAZING &<br />
BEAUTIFUL WEBSITES." lead_accent_color="#333333"]We\'re a creative agency located in <b>Brooklyn, New York.</b><br />
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1537378768428{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" css=".vc_custom_1527517366664{margin-bottom: 0px !important;padding-top: 0px !important;padding-bottom: 0px !important;}" effect="fadeIn"][vc_column width="1/2" css=".vc_custom_1496792500773{padding-top: 0px !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8057" name="John Brooklyn" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twiiter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" css=".vc_custom_1537542345545{margin-bottom: 0px !important;}" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1527516184302{margin-bottom: 0px !important;}"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8057" name="Dwayne Smith" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twiiter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" css=".vc_custom_1537542352778{margin-bottom: 0px !important;}" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1527516263954{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8057" name="Ruben Lorenz" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twiiter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" css=".vc_custom_1537542359671{margin-bottom: 0px !important;}" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column_inner][vc_column_inner width="1/2"][ut_person_module name_font_weight="" ocupation_letter_spacing="0.05" ocupation_font_weight="600" icon_size="18" avatar="8057" name="Billy Bob" occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22BE%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twiiter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" css=".vc_custom_1537542366899{margin-bottom: 0px !important;}" name_color="#ffffff" name_decoration_line_color="rgba(255,255,255,0.8)" overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" ocupation_color="#ffffff" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" bklyn_overlay="true" css=".vc_custom_1537378654190{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/social-bg.jpg?id=5447) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="linear-gradient(to bottom, rgba(57, 106, 252, 0.9) 0%, rgba(41, 72, 255, 0.9) 100%)" effect="none" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header align="center" title_linebreak_mobile="on" lead_linebreak_mobile="on" lead_accent_font_weight="bold" title="A New Era Begins." lead_accent_color="#ffffff" css=".vc_custom_1494690190031{padding-top: 40px !important;}" title_color="#ffffff" lead_color="#ffffff"]We believe our work speaks for itself. Browse our most recent projects<br /> and enjoy our <ins>handmade work</ins> with love for every detail.[/ut_header][ut_animated_image size="medium" align="center" image="5608"][ut_custom_heading tag="h5" align="center" color="#ffffff"]Team Brooklyn[/ut_custom_heading][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" delay_animation="true" gallery="8057,8056,8058,8059,8060" effect="zoomIn"][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 1 (needs Portfolio Shortcode)', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row][vc_column][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="John Brooklyn"]Hello, I\'m John designer at Brooklyn Designs.<br />
[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_team_member align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="20" name="John Brooklyn" avatar="8057" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999"][/ut_team_member][/vc_column][vc_column width="1/2"][ut_custom_heading tag="p" font_source="google" google_fonts="font_family:Poppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" font_size="30" letter_spacing="-0.05" color="#333333"]Biography[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>
<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" info="PHP Coding" info_color="#333333" color="#333333" percentage_color="#ffffff" percentage_bg_color="#333333"][ut_probar_thin width="95" animate_once="yes" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" info="jQuery Coding" info_color="#333333" color="#333333" percentage_color="#ffffff" percentage_bg_color="#333333"][ut_probar_thin width="98" animate_once="yes" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" info="Plugin Development" info_color="#333333" color="#333333" percentage_color="#ffffff" percentage_bg_color="#333333"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527529259645{padding-bottom: 0px !important;}" el_name="Padding top 0"][vc_row full_width="stretch_row_content_no_spaces" el_name="Margin top and bottom 0" css=".vc_custom_1527529290498{margin-top: 0px !important;}"][vc_column][ut_showcase_shortcode showcase_id="4642" css=".vc_custom_1527529227486{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1537244327456{margin-top: 0px !important;margin-bottom: 0px !important;background-color: linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%) !important;}" el_name="Margin 0"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Call Now" headline_margin_bottom="0px" icon_linea="icon-basic-headset" svg_color="#ffffff"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="1399 Beverly Rd" headline_margin_bottom="0px" icon_linea="icon-basic-signs" svg_color="#ffffff"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Mon - Sat" headline_margin_bottom="0px" icon_linea="icon-basic-clock" svg_color="#ffffff"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-3 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#ffffff" text_color="#ffffff" headline="Mail Us" headline_margin_bottom="0px" icon_linea="icon-basic-mail-multiple" svg_color="#ffffff"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 2', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="John Brooklyn"]Hello, I\'m John designer at Brooklyn Designs.<br />
[/ut_header][ut_custom_heading tag="h3"]Bio[/ut_custom_heading][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et.[/vc_column_text][ut_probar size="small" width="92" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="Leadership" info_color="#333333" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" percentage_color="#ffffff" css=".vc_custom_1537389181562{margin-bottom: 20px !important;}"][ut_probar size="small" width="96" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="UI Design" info_color="#333333" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" percentage_color="#ffffff" css=".vc_custom_1537389190508{margin-bottom: 20px !important;}"][ut_probar size="small" width="88" border_radius="15" info_font_size="12" info_font_weight="600" info_letter_spacing="0.05" info_text_transform="uppercase" percentage_font_weight="" info="HTML / CSS" info_color="#333333" color="linear-gradient(to bottom, rgb(57, 106, 252) 0%, rgb(41, 72, 255) 100%)" background_color="rgba(41, 106, 245, 0.1)" percentage_color="#ffffff"][/vc_column][vc_column width="1/2"][ut_animated_image size="full" align="center" image="8057"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1527689099649{background-color: #fafafa !important;}"][vc_row][vc_column][ut_header title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Let\'s Work Together." css=".vc_custom_1537389572890{margin-bottom: 25px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy<br /> eirmod tempor invidunt ut labore et dolore magna aliquyam.[/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="600" letter_spacing="0.05" button_text="Get Started" button_link="url:%23|||" button_text_color_hover="#ffffff" button_background_hover="#333333" spacing="padding-top:0.8em;padding-right:2.5em;padding-bottom:0.8em;padding-left:2.5em"][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline="Call Now" headline_margin_bottom="0px" icon_linea="icon-basic-headset"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline="1399 Beverly Rd" headline_margin_bottom="0px" icon_linea="icon-basic-signs"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline="Mon - Sat" headline_margin_bottom="0px" icon_linea="icon-basic-clock"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline="Mail Us" headline_margin_bottom="0px" icon_linea="icon-basic-mail-multiple"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 3', 'ut_shortcodes' ),
            'content'   => '<p>[vc_section][vc_row gap="40"][vc_column width="2/3"][ut_header align="left" title_linebreak_mobile="on" lead_linebreak_mobile="on" title="Dwayne Smith"]Hello, I\'m Dwayne coder at Brooklyn Designs.<br />
[/ut_header][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>
<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][vc_row_inner][vc_column_inner width="1/3"][ut_number_counter counter_align="left" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" to="97" suffix="%" counter_color="#333333" desccolor="#999999"]HTML / CSS[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter counter_align="left" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" to="88" suffix="%" counter_color="#333333" desccolor="#999999"]PHP Coding[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter counter_align="left" caption_text_transform="uppercase" caption_font_weight="600" caption_letter_spacing="0.05" counter_font_source="google" counter_google_fonts="font_family:Montserrat%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:800%20bold%20regular%3A800%3Anormal" to="93" suffix="%" counter_color="#333333" desccolor="#999999"]JQuery[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" css=".vc_custom_1537246294600{padding-top: 20px !important;padding-right: 20px !important;padding-left: 20px !important;background-color: #fafafa !important;}"][ut_team_member align="left" ocupation_font_weight="600" ocupation_letter_spacing="0.05" icon_size="18" name="Dwayne Smith" avatar="8057" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#333333" icon_color_hover="#999999" ocupation_color="#999999" css=".vc_custom_1537542613419{margin-bottom: 20px !important;}"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section][vc_row css=".vc_custom_1496795184792{margin-bottom: 0px !important;background-color: #f9f9f9 !important;}"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#333333" headline="Call Now" headline_margin_bottom="0px" icon_linea="icon-basic-headset" svg_color="#333333"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#333333" headline="1399 Beverly Rd" headline_margin_bottom="0px" icon_linea="icon-basic-signs" svg_color="#333333"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#333333" headline="Mon - Sat" headline_margin_bottom="0px" icon_linea="icon-basic-clock" svg_color="#333333"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column icon_type="lineaicons" size="medium" headline_color="#333333" headline="Mail Us" headline_margin_bottom="0px" icon_linea="icon-basic-mail-multiple" svg_color="#333333"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]</p>',
        ),
        
                
        /* Demo 24 */
        array(
            'name'      => esc_html__( 'Demo 24 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2"][ut_animated_image size="large" image="118"][/vc_column][vc_column width="1/2"][ut_custom_heading tag="h6" font_size="17" color="#ff1654"]John Brooklyn[/ut_custom_heading][ut_header align="left" title="I\'m John, designer and photographer at United Themes. "]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on Twitter and Facebook. I collect inspirations on Pinterest and save all my pics at Instagram.[/ut_header][ut_custom_heading tag="h6" font_size="17" color="#ff1654"]What I love[/ut_custom_heading][vc_row_inner css=".vc_custom_1523371544800{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_fancy_list list_font_size="12" values="%5B%7B%22title%22%3A%22Family%20Stuff%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Web%20Design%22%7D%2C%7B%22title%22%3A%22Photography%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%20Bicycle%22%2C%22is_link%22%3A%22true%22%7D%5D" text_color="#151515"][/vc_column_inner][vc_column_inner width="1/2"][ut_fancy_list list_font_size="12" values="%5B%7B%22title%22%3A%22Good%20Food%22%7D%2C%7B%22title%22%3A%22Cold%20Beer%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Classic%20Music%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Old%20Culture%22%2C%22is_link%22%3A%22true%22%7D%5D" text_color="#151515"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-facebook" title="Facebook" slogan="Give me a like on Facebook" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515" icon_color="#151515" link="url:%23||target:%20_blank|"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#151515" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515" link="url:%23||target:%20_blank|"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-instagram" title="Instagram" slogan="See my latest photos on Instagram" icon_color="#151515" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515" link="url:%23||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',
        ),
        		
        array(
            'name'      => esc_html__( 'Demo 24 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row bklyn_overlay="true" css=".vc_custom_1494613900368{padding-top: 120px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/demo24/wp-content/uploads/2017/05/contact-image.jpg?id=164) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-facebook" title="Facebook" slogan="Give me a like on Facebook" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff" icon_color="#ffffff" link="url:%23||target:%20_blank|"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff" link="url:%23||target:%20_blank|"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-instagram" title="Instgram" slogan="See my latest photos on Instagram" icon_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff" link="url:%23||target:%20_blank|"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_header title="Get in touch
with John Brooklyn."]We have created an awesome theme that will help designers,
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][vc_column width="1/2"][ut_custom_heading tag="h6" font_size="17" color="#ff1654"]Write John[/ut_custom_heading][contact-form-7 id="15"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 24 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header font_size="50" title="Hi, I\'m John, John Brooklyn designer and photographer at United Themes."]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="large" grid="5" gap="5" caption="yes" lazy="true" loader="true" delay_animation="true" caption_transform="uppercase" gallery="27,26,25,24,23,22,21,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,76" effect="fadeInUp" delay_timer="100" loader_color="#151515"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 24 - Private Gallery', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" lazy="true" loader="true" delay_animation="true" caption_transform="uppercase" gallery="26,27,59,71,70,61,49,50,62,76,63,51,52,64,73,72,60,48,25,57,69,68,56,24,23,55,67,66,54,22,21,53" delay_timer="100" effect="zoomIn" caption_color="#ffffff" caption_background="rgba(255,22,84,0.9)" loader_color="#ff1654"][/vc_column][/vc_row][/vc_section]',
        ),
        
        
        /* Demo 25 */
        array(
            'name'      => esc_html__( 'Demo 25 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][ut_header align="left" title="What We Do..." title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Nature Photography" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Adventure Photography" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="20" caption="yes" animate_once="yes" delay_animation="true" gallery="74,78,36,82" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content"][vc_column][ut_header align="left" title="Let\'s Start Our Journey..." title_color="#252525"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/2"][vc_custom_heading text="Tell us your story" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][contact-form-7 id="134"][vc_empty_space height="20px"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" animate_once="yes" delay_animation="true" gallery="36,78,67,68,69,76,70,71,72,73,74,75,77,79,80,81,82,83,84,85" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Private Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="large" grid="5" gap="20" caption="yes" animate_once="yes" delay_animation="true" gallery="86,85,73,74,36,72,84,83,71,70,82,81,69,68,80,67,79,78,76,75" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 26 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1496316007823{background-color: #111314 !important;}" bklyn_section_anchor_id="about"][vc_row hide_on_tablet="true" hide_on_mobile="true" animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="I\'m a creative freelancer located in Brooklyn, New York. I’ve won a ton of awards and have been featured in all of the magazines." title_color="#ffffff"][/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true" animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="I\'m a creative freelancer located in Brooklyn, New York. I’ve won a ton of awards and have been featured in all of the magazines." title_color="#ffffff" font_size="25px"][/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][ut_service_column shape="round" headline="MOBILE DESIGN" imageicon="123" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][ut_service_column shape="round" headline="WEB DESIGN" imageicon="126" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][ut_service_column shape="round" headline="PHOTOGRAPHY" imageicon="278" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496316230426{padding-bottom: 0px !important;}"][vc_row hide_on_tablet="true" hide_on_mobile="true" effect="none" css=".vc_custom_1496425752192{background-color: #ff3f00 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50" offset="vc_hidden-md vc_hidden-sm vc_hidden-xs"][ut_header style="global" align="global" title="Browse my most recent projects below and enjoy my handmade work with love for every detail." title_color="#ffffff"][/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true" effect="none" css=".vc_custom_1496425756570{background-color: #ff3f00 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header style="global" align="global" title="Browse my most recent projects below and enjoy my handmade work with love for every detail." title_color="#ffffff" font_size="25px"][/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1496418932119{margin-top: 0px !important;}" bklyn_section_anchor_id="portfolio"][vc_column][ut_custom_shortcode css=".vc_custom_1496315950159{margin-bottom: 0px !important;}"][ut_showcase id="138" name="Demo 26 – Showcase"][/ut_custom_shortcode][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496421318519{background-color: #ff3f00 !important;}" bklyn_section_anchor_id="Contact"][vc_row hide_on_tablet="true" hide_on_mobile="true"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header align="left" title="I welcome you to contact me for more information about any of my products or services." title_color="#ffffff" lead_accent_color="#ffffff"][/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="#ffffff" text_color_hover="#ffffff"][vc_custom_heading text="FOLLOW ME ON" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1496417267509{margin-bottom: 40px !important;}"][ut_social_follow gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header align="left" title="I welcome you to contact me for more information about any of my products or services." title_color="#ffffff" lead_accent_color="#ffffff" font_size="25px"][/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="#ffffff" text_color_hover="#ffffff"][vc_custom_heading text="FOLLOW ME ON" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1496417267509{margin-bottom: 40px !important;}"][ut_social_follow gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',
        ),
        
        /* Demo 27 */
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post All The Trimmings', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Get the full audio experience without disturbing the neighbors. Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189385801{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/gabriel-beaudry-253369.jpg?id=2185) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="35" cite_font_size="18" quote_color="#ffffff" cite="Some Guy" cite_color="#ffffff"]These headphones are absolutely brilliant. Amazing sound quality that I had never experience through headphone until I bought these.[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Whats in the box?</h2>
<strong>Not only are the HD 598 aesthetically pleasing to the eyes but they also provide impeccable sound quality and unrivalled comfort. These beige-coloured, open, circumaural headphones come with high-gloss burl wood parts and matching earpads for a sophisiticated, premium finish.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" gallery="2185,2184,2182"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Become Legend', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189606256{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service1.jpg?id=3076) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" cite_font_size="18" quote_color="#ffffff" cite_color="#ffffff"]BECOME LEGEND[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>What is about Part 2?</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1496161873814{padding-top: 40px !important;padding-bottom: 40px !important;}"][vc_column][ut_gallery_slider type="carousel" number="4" hover_caption="on" slides="2185,2184,2182,2894"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Minimalistic Interior', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Minimalist interior design is one of the architectural centerpieces of the 20th century. Spare and streamlined while still being inviting, minimalism is charming in almost any space.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189818538{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service2.jpg?id=3077) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="35" quote_text_transform="capitalize" cite_font_size="18" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes™" cite_color="#ffffff"]Passion Leads to Design, Design Leads to Performance,
Performance Leads to success![/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Things to make you go OOH</h2>
[caption id="attachment_2894" align="alignleft" width="300"]<img class="wp-image-2894 size-medium" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/7-300x300.jpg" alt="" width="300" height="300" /> We <i class="fa fa-heart"></i> Brooklyn[/caption]

<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" gallery="2185,2184,2182,2894"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Music Is The Key', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496162923926{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/music-key.jpg?id=3787) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" quote_text_transform="uppercase" cite_font_size="18" quote_color="#ffffff" cite_color="#ffffff"]We Love Music[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Our last night!</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" gallery="3791,3792,3793,3794"][vc_column_text]When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>What is your favorite song?</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Organic Food', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Organic food has become very popular. But navigating the maze of organic food labels, benefits, and claims can be confusing.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][ut_image_gallery thumbnail_size="medium" grid="5" caption="yes" animate_once="yes" delay_animation="true" gallery="2037,2038,2039,2041,2043,2044,2045,2046,2047,2048,2058,2057,2056,2055,2059" effect="fadeIn"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Organic vs. Non-Organic</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_gallery_slider type="carousel" number="2" number_tablet="2" caption="on" slides="2068,2067,2069,2070"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),        
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Beautiful Minimalist', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="BEAUTIFUL MINIMALIST" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22May%2029%2C%202017%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="5" caption="yes" delay_animation="true" gallery="2900,3078,3077,3076,2901,2898,2480,2894,2897,3829" delay_timer="150" effect="fadeIn"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column][ut_social_share_bar border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Custom Cap', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="CAP MOCK-UP"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_image_gallery thumbnail_size="large" grid="2" caption="yes" animate_once="yes" delay_animation="true" gallery="3078,3077" delay_timer="100" effect="fadeInUp"][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="ENDLESS POSSIBILITIES"]Create One-Page or Multi-Page websites <b>easily</b> by using the
Visual Composer per <b>Drag &amp; Drop</b> or use shortcodes. It’s up to you![/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" caption="yes" animate_once="yes" delay_animation="true" gallery="3078" delay_timer="100" effect="fadeInUp"][/vc_column][/vc_row][/vc_section][vc_section][vc_row content_placement="middle" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="INTUITIVE ADMIN PANEL" title_color="#252525"]You don’t need to touch a single line of code,
<b>perfect</b> for people <b>without</b> any <b>coding knowledge.</b>
[/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column][ut_image_gallery thumbnail_size="large" caption="yes" animate="false" gallery="3077"][/vc_column][/vc_row][vc_row full_height="yes" background_position="center center" background_attachment="scroll" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1496189986184{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service1.jpg?id=3076) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#ffbf00" text_color_hover="#ffbf00"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="#ffbf00"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Disc & Cover Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][vc_custom_heading text="WHAT WE DID" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1496096150343{margin-bottom: 10px !important;}"][ut_header title="DISC &amp; COVER DESIGN"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption="yes" animate_once="yes" delay_animation="true" gallery="3149,3148,3150" effect="fadeIn" caption_color="#151515" caption_background="rgba(255,191,0,0.8)" delay_timer="150"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_custom_shortcode][/ut_custom_shortcode][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="250"][vc_column][ut_social_share_bar share_text_font_weight="bold" border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section][vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1496096081298{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio My Awesome Bike', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="MY AWESOME BIKE" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="about"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header align="center" title="ABOUT BROOKLYN"]We’re a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495489285314{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-1.jpg?id=2514) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)" effect="none"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" quote_text_transform="uppercase" cite_font_size="14" cite_text_transform="uppercase" cite="United Themes – Development Brooklyn" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO <ins>SUCCESS!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Team"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="BROOKLYN\'S CREW"]We believe in a diverse range of personel to bring <b>creative skills,
thoughts,</b> and <b>ideas</b> to the table.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="JOHN" avatar="3855" occupation="DEVELOPER / <b>DESIGNER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="DWAYNE" avatar="3855" occupation="DEVELOPER / <b>CODER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-youtube%22%2C%22title%22%3A%22YouTube%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22Email%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="BRUCE" avatar="3855" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22title%22%3A%22Vimeo%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="NICK" avatar="3855" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495963738985{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/section-archievements-1.jpg?id=2529) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_column_inner][ut_header style="global" align="center" title="OUR ARCHIEVEMENTS" title_color="#ffffff" lead_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Office-Desk-2" to="3000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="h"]Working Hours[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Rocket-Launch" to="40000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="+"]Customers Worldwide[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Mustache-1" to="17" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="."]Design Awards[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1495994782208{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="250"][ut_fancy_link link_color="#ffffff" line_color="#ffffff" link_hover_color="#ffbf00" line_hover_color="#ffbf00" url="#contact-section"] Drop us a line [/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Services"][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496187665145{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/1.jpg?id=3855) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_tablet="true" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="OUR SERVICES" title_color="#ffffff" lead_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE INSTALLER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Download" headline_margin_bottom="20px"]Brooklyn has made the Theme Installer popular on the market![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE BUILDER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Computer-Network-2" headline_margin_bottom="20px"]Web design without any coding and right at your fingertips![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="CUSTOMIZE EVERYTHING" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Lens-1" headline_margin_bottom="20px"]From header to footer and everything what’s in between.[/ut_service_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="work"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="OUR WORK"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column][ut_custom_shortcode css=".vc_custom_1496080035830{margin-bottom: 0px !important;}"][ut_showcase id="1637" name="Demo 1 – Front Page"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496080103092{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-2.jpg?id=2515) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="GET CONNECTED" title_color="#ffffff" lead_color="#ffffff"]Get yourself ready for an <b>awesome experience</b> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan=" Follow us on Twitter " icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-behance" title="Behance" slogan="See our latest works" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="clients"][vc_row][vc_column][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header style="global" align="center" title="OUR CLIENTS"]The comments below are just a sample of the <b>25.500</b> clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column_inner][/vc_row_inner][ut_qtrotator_2 effect="fadeInUp" quote_custom_font="yes" animate_once="yes" delay="true" effect_in="slideInLeft" effect_out="slideOutRight" arrow_color="#151515" arrow_color_hover="#ffbf00" quote_color="#777777" origin_color="#151515" quote_font="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="16px" quote_line_height="32px" name_color="#151515" logo_color="#151515" delay_timer="100" css=".vc_custom_1496096940850{margin-top: 40px !important;}"][ut_qt_2 avatar="3855" author="CUSTOMER" origin="LAS VEGAS, NV" icon_bklyn="BklynIcons-Rocket-Launch"]"Genuinely love this theme. So sick of trawling through endless menus and options on other themes. Brooklyn is so intuitive with where all its settings are located and is just a pleasure to use. Also, the sheer number of demos and ability to mix elements from different demos means it works well for so many purposes."[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="HOUSTON, TX" icon_bklyn="BklynIcons-Diamond"]“Beautiful Theme! Awesome built-in features with some great built in Plug-ins! A well designed and well thought out Dashboard! 100/100 Would recommend!”[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="BROOKLYN, NY" icon_bklyn="BklynIcons-Angry-Birds"]"Amazing theme – just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them."[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="MIAMI, FL" icon_bklyn="BklynIcons-Stormtrooper-2"]“Great theme with great flexibility. A lot of ready-to-go demos which can be installed with a single click. Really great support if needed. With most updates, there is a new demo added to the bundle.”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row css=".vc_custom_1495890143958{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="3862,3863,3864,3865,3866" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',

        ),
        array(
            'name'      => esc_html__( 'Demo 27 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column delay="true" effect="none"][vc_custom_heading text="WHO WE ARE..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495860887765{margin-bottom: 10px !important;}"][ut_header title="DESIGNERS, THINKERS
&amp; COLLABORATORS" title_accent_color="#ffbf00"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create<b> websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="50"][ut_team_member align="left" ocupation_font_size="large" name="JOHN BROOKLYN" social="%5B%7B%7D%5D" occupation="CEO & Founder" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow John" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="100"][ut_team_member align="left" ocupation_font_size="large" name="DWAYNE RUSSEL" social="%5B%7B%7D%5D" occupation="CTO & Company Partner" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Dwayne" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="150"][ut_team_member align="left" ocupation_font_size="large" name="BRUCE AMIREZ" social="%5B%7B%7D%5D" occupation="Marketing Expert" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Bruce" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-steam%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="200"][ut_team_member align="left" ocupation_font_size="large" name="NICK BRONSEN" social="%5B%7B%7D%5D" occupation="Hardcore Coder" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Nick" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="about" css=".vc_custom_1495863114914{background-color: #453c32 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column delay="true" effect="none"][vc_custom_heading text="...OUR CLIENTS" font_container="tag:h3|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1495862877280{margin-bottom: 10px !important;}"][ut_header title="WE HAVE WORKED FOR" title_color="#ffbf00" lead_color="#ffffff"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create<b> websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="3869,3870,3871,3872,3866,3865,3864,3863,3861,3862" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" css=".vc_custom_1496070576598{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="...WHAT WE DO" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495647312055{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="CREATING THE WEB"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="DEVELOPER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495662896183{margin-bottom: 10px !important;}"][ut_header align="center" title="I\'M JOHN <ins>BROOKLYN</ins>"]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on
<a href="http://www.yourdomain.com">Twitter</a> and <a href="http://www.yourdomain.com">Facebook.</a> I collect inspirations on <a href="http://www.yourdomain.com">Pinterest</a> and save all my pics at <a href="http://www.yourdomain.com">Instagram.</a>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="WHO I AM?" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]<strong>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</strong>

A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to[/vc_column_text][ut_btn button_align="bklyn-btn-left" button_text="Download My CV" button_text_color="#ffffff" button_background="#151515"][/vc_column][vc_column width="1/2"][vc_custom_heading text="EXPERT IN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="Dreameaver" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="62" animate_once="yes" info_font_weight="" info="Illustrator" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="83" animate_once="yes" info_font_weight="" info="Photoshop" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column][vc_custom_heading text="YOU CAN FOLLOW ME ON" font_container="tag:h6|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22colors%22%3A%22global%22%7D%5D" social_description="Follow John"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" css=".vc_custom_1496072947116{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/quote-section.jpg?id=2837) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_row animate_once="yes" delay="true" effect="zoomIn" delay_timer="50"][vc_column effect="none"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_text_transform="uppercase" cite_font_source="google" cite_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" cite_font_size="20" cite_font_weight="bold" cite_text_transform="uppercase" cite="Steve Jobs" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]Design is not just what it looks like and feels like.
Design is <ins>how it works.</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1495875536005{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="...DESIGNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495646924824{margin-bottom: 10px !important;}"][ut_header align="center" title="MY SKILLS"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" title="CREATIVE THINKING" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="90" percent_font_weight="bold" title_text_font="on" title="WEB DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="82" percent_font_weight="bold" title_text_font="on" title="HTML / CSS" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="69" percent_font_weight="bold" title_text_font="on" title="UI DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page CV Section', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="DEVELOPER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495662896183{margin-bottom: 10px !important;}"][ut_header align="center" title="I\'M JOHN <ins>BROOKLYN</ins>"]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on
<a href="http://www.yourdomain.com">Twitter</a> and <a href="http://www.yourdomain.com">Facebook.</a> I collect inspirations on <a href="http://www.yourdomain.com">Pinterest</a> and save all my pics at <a href="http://www.yourdomain.com">Instagram.</a>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="WHO I AM?" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]<strong>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</strong>

A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to[/vc_column_text][ut_btn button_align="bklyn-btn-left" button_text="Download My CV" button_text_color="#ffffff" button_background="#151515"][/vc_column][vc_column width="1/2"][vc_custom_heading text="EXPERT IN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="Dreameaver" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="62" animate_once="yes" info_font_weight="" info="Illustrator" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="83" animate_once="yes" info_font_weight="" info="Photoshop" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column][vc_custom_heading text="YOU CAN FOLLOW ME ON" font_container="tag:h6|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22colors%22%3A%22global%22%7D%5D" social_description="Follow John"][/vc_column][/vc_row][/vc_section]',                
        ),        
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page My Skills Section', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1495875536005{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="...DESIGNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495646924824{margin-bottom: 10px !important;}"][ut_header align="center" title="MY SKILLS"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" title="CREATIVE THINKING" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="90" percent_font_weight="bold" title_text_font="on" title="WEB DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="82" percent_font_weight="bold" title_text_font="on" title="HTML / CSS" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="69" percent_font_weight="bold" title_text_font="on" title="UI DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page Quote Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" css=".vc_custom_1496199043571{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_row animate_once="yes" delay="true" effect="zoomIn" delay_timer="50"][vc_column effect="none"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_text_transform="uppercase" cite_font_source="google" cite_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" cite_font_size="20" cite_font_weight="bold" cite_text_transform="uppercase" cite="Steve Jobs" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]Design is not just what it looks like and feels like.
Design is <ins>how it works.</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Product Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][vc_custom_heading text="WHAT YOU GET" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495727108289{margin-bottom: 10px !important;}"][ut_header align="center" lead_accent_font_weight="bold" title="OUR AWESOME PRODUCT" lead_accent_color="#151515"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="3876" css=".vc_custom_1496188844815{border-bottom-width: 1px !important;padding-bottom: 80px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" effect="fadeIn" delay_timer="100"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3091" headline="TEMPLATE INSTALLER"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3093" headline="TEMPLATE BUILDER"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3094" headline="CUSTOMIZE EVERYTHING"]All parts of Brooklyn can be customized! From header to footer and everything what’s in between![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1495866667621{padding-bottom: 0px !important;background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="OUR PRODUCT" font_container="tag:h3|text_align:center" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495736828639{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" lead_accent_font_weight="bold" title="BECOME LEGEND"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column imageicon="3097" headline="TEMPLATE INSTALLER" text_color="#151515"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column imageicon="3098" headline="TEMPLATE BUILDER" text_color="#151515"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column imageicon="3099" headline="CUSTOMIZE EVERYTHING" text_color="#151515"]All parts of Brooklyn can be customized! From header to footer and everything what’s in between![/ut_service_column][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column css=".vc_custom_1495734252301{padding-top: 0px !important;}"][ut_gallery_slider type="carousel" number="4" number_tablet="2" hover_caption="on" slides="2182,2184,2185,2515,2514,2480" arrow_color="#ffffff" arrow_color_hover="#ffffff" arrow_background_color="#151515" arrow_background_color_hover="#151515" css=".vc_custom_1496188549642{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496071339643{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22